<?php
/////////////////////////////////////////////////////////////////////////////
// FQ - Correos multiples                                                  //
// Copyright (C) 2004-2005                                                 //
// http://www.brutalidadtotal.com                                          //
// FQ es un componente para Mambo 4.5.                                     // 
// Este componente permite enviar correos a usuarios registrados en        //
// diferentes grupos. Puede enviar correos en formato HTML o solo texto.   //
// Este componente es un programa gratis; usted puede redistribuirlo y/o   //
// modificarlo bajo terminos de Licencia GNU.                              //
//----------------------------------------------------------------------   //
// $Id: admin.fq.php,v 1.0 2004/12/23 17:00:12                             //
/////////////////////////////////////////////////////////////////////////////

defined( '_VALID_MOS' ) or die( 'El acceso directo no esta permitido a esta pagina.' );

require_once( $mosConfig_absolute_path . "/administrator/components/com_fq/admin.fq.html.php" );
require_once( $mosConfig_absolute_path . "/administrator/components/com_fq/classes/class.phpmailer.php" );
require_once( $mosConfig_absolute_path . "/administrator/components/com_fq/classes/class.smtp.php" );
require_once( $mosConfig_absolute_path . "/administrator/components/com_fq/classes/class.letters.php" );
require_once( $mosConfig_absolute_path . "/administrator/components/com_fq/classes/class.templates.php" );
require_once( $mosConfig_absolute_path . "/administrator/components/com_fq/classes/class.subscribers.php" );
require_once( $mosConfig_absolute_path . "/administrator/components/com_fq/classes/class.mailing.php" );
require_once( $mosConfig_absolute_path . "/administrator/components/com_fq/classes/class.statistics.php" );
require_once( $mosConfig_absolute_path . "/administrator/components/com_fq/classes/class.dbclasses.php" );
require_once( $mosConfig_absolute_path . "/components/com_fq/languages/class.translator.php" );

$letter = new letters();
$subscribers = new subscribers();
$mailing = new mailing();
$statistics = new statistics();
$templates = new templates();
$HTML_newsletter = new HTML_newsletter();
$lang = new translator();

require($mosConfig_absolute_path . '/administrator/components/com_fq/configuration.php');

$item = mosGetParam( $_REQUEST, 'act', '' );
$option = mosGetParam( $_REQUEST, 'option', '' );
$action = mosGetParam( $_REQUEST, 'task', '' );
$listid = mosGetParam( $_REQUEST, 'listid', '' );

switch ($item) {
	case "letter":
	  showLetters($action);
	  break;
	case "subscribers":
	  showSubscribers($listid, $action);
	  break;
	case "mailing":
	  showMailing($action);
	  break;
	case "stats":
	  showStats($action);
	  break;
	case "templates":
	  showTemplates($action);
	  break;
	case "settings":
	  showConfiguration($action);
	  break;
	default:
	  showLetters($action);
	  break;
}

function showLetters($action){
	global $option, $letter;
	$cid = mosGetParam( $_REQUEST, 'cid', 0 );
	
	switch ($action) {
		case 'edit':
		  $letter->editLetter($cid[0]);
		  break;
		case 'new':
		  $letter->editLetter(0);
		  break;
		case 'save':
		  $letter->saveList();
		  break;
		case 'remove':
		  $letter->deleteList($cid);
		  break;
		case "publish":
		   $letter->changegrup( $cid, 1, $option );
		  break;
	    case "unpublish":
		   $letter->changegrup( $cid, 0, $option );
		  break;  
		default:
		  $letter->showLetterOverview();
		  break;
	}
}

function showSubscribers($listid=0, $action){
	global $option, $subscribers, $letter;
	$cids = mosGetParam( $_REQUEST, 'cids', 0 );
	$cid = mosGetParam( $_REQUEST, 'cid', 0 );
	
		switch ($action) {
			case 'edit':
			  $subscribers->editSubscriber($cids[0]);
			  break;
			case 'new':
			  $subscribers->editSubscriber(0);
			  break;
			case 'save':
			  $subscribers->saveSubscriber($listid, $subscriber_name='', $subscriber_email='', $mambo=0);
			  break;
			case 'remove':
			  $subscribers->deleteSubscribers($id);
			  break;
		    case "publish":
		   $subscribers->changeConfirm( $id, 1, $option );
		      break;
	       case "unpublish":
		   $subscribers->changeConfirm( $id, 0, $option );
		      break;  
			case 'export':
			  $subscribers->doExport($listid);
			  break;
			case 'import':
			  $subscribers->importSubscribers($listid, $ban=0);
			  break;
			default:
			  $subscribers->showSubscriberOverview($listid);
			  break;
		}
	}

function showMailing($action){
	global $option, $letter, $mailing;
	$start = mosGetParam( $_REQUEST, 'start', '0' );
	$cid = mosGetParam( $_REQUEST, 'cid', 0 );
	$listid = mosGetParam( $_REQUEST, 'listid', '0' );
	$totaltime = mosGetParam( $_REQUEST, 'totaltime', 0 );
	$html_sent = mosGetParam( $_REQUEST, 'html_sent', '0' );
	$text_sent = mosGetParam( $_REQUEST, 'text_sent', 0 );
	
		switch ($action) {
		    case 'edit':
		      $mailing->editMailing($cid[0]);
		      break;
		    case 'new':
		      $mailing->editMailing($cid[0]);
		      break;
			case 'save':
			  $mailing->saveMailing($cid);
			  break;
			case 'remove':
			  $mailing->deleteFromArchive($cid);
			  break;  
			case 'cancel':
			  mosRedirect( "index2.php?option=com_fq&act=mailing" );
			  break;  
			case 'preview':
			  $mailing->previewMailing($cid[0], 1);
			  break;  
			case 'enviar':
			  $mailing->previewMailing($cid[0], 0);
			  break;  
			case 'publish':
			  $mailing->sendMailing($listid, $cid[0], $tot, $start);
			  break;
			case 'back':
			  $mailing->back();
			  break;
			default:
			  $mailing->showMailingOverview();
			  break;
		}
}

function showStats($action){
	global $option, $statistics;
	$cid = mosGetParam( $_REQUEST, 'cid', 0 );

  	switch ($action) {
		case 'remove':
		  $statistics->deleteStats($cid);
  		break;
  		default:
  		  $statistics->showStats();
  		break;
  	}
}

function showTemplates($action){
	global $option, $templates;
	$cid = mosGetParam( $_REQUEST, 'cid', 0 );
	
	switch ($action) {
	    case 'edit_source':
		  $templates->editTemplateSource($cid[0]);
		  break;
	    case 'save_source':
		  $templates->saveTemplateSource();
		  break;
	    case 'preview':
		  $templates->preview($cid[0]);
		  break;
		case 'cancel':
		  mosRedirect( "index2.php?option=com_fq&act=templates" );//
		  break;    
		default:
		  $templates->showTemplatesOverview();
		  break;
	}
}

function showConfiguration($action){
	global $option, $newsletterConfig, $HTML_newsletter, $my, $lang;
	if($my->gid != 25){
	  echo '<font class="error">' . $lang->translate("config_access_error") . '</font>';
	  exit;
	}
	
	$mailMethod = array(
		mosHTML::makeOption( "mail", 'mail' ),
		mosHTML::makeOption( "sendmail", 'sendmail' ),
		mosHTML::makeOption( "smtp", 'smtp' )
	);
	$refresh = array(
		mosHTML::makeOption( "0", '0' ),
		mosHTML::makeOption( "1", '1' ),
		mosHTML::makeOption( "2", '2' ),
		mosHTML::makeOption( "3", '3' ),
		mosHTML::makeOption( "4", '4' ),
		mosHTML::makeOption( "5", '5' ),
		mosHTML::makeOption( "6", '6' ),
		mosHTML::makeOption( "7", '7' ),
		mosHTML::makeOption( "8", '8' ),
		mosHTML::makeOption( "9", '9' )
	);
	$lists['config[\'emailmethod\']'] = mosHTML::selectList( $mailMethod, 'config[\'emailmethod\']', 'class="inputbox" size="1"', 'value', 'text', $newsletterConfig['emailmethod'] );
	$lists['config[\'smtp_auth_required\']'] = mosHTML::yesnoSelectList( 'config[\'smtp_auth_required\']', 'class="inputbox" size="1"',	$newsletterConfig['smtp_auth_required'] );
	$lists['config[\'enable_statistics\']'] = mosHTML::yesnoSelectList( 'config[\'enable_statistics\']', 'class="inputbox" size="1"',	$newsletterConfig['enable_statistics'] );
	$lists['config[\'statistics_per_subscriber\']'] = mosHTML::yesnoSelectList( 'config[\'statistics_per_subscriber\']', 'class="inputbox" size="1"',	$newsletterConfig['statistics_per_subscriber'] );
	$lists['config[\'send_data\']'] = mosHTML::yesnoSelectList( 'config[\'send_data\']', 'class="inputbox" size="1"',	$newsletterConfig['send_data'] );
	$lists['config[\'savetoserver\']'] = mosHTML::yesnoSelectList( 'config[\'savetoserver\']', 'class="inputbox" size="1"',	$newsletterConfig['savetoserver'] );
	$lists['config[\'refresh\']'] = mosHTML::selectList( $refresh, 'config[\'refresh\']', 'class="inputbox" size="1"', 'value', 'text', $newsletterConfig['refresh'] );
	$lists['config[\'name_required\']'] = mosHTML::yesnoSelectList( 'config[\'name_required\']', 'class="inputbox" size="1"',	$newsletterConfig['name_required'] );
	$lists['config[\'embedded_images\']'] = mosHTML::yesnoSelectList( 'config[\'embedded_images\']', 'class="inputbox" size="1"',	$newsletterConfig['embedded_images'] );
	
	switch ($action){
		case 'save':
		  $HTML_newsletter->saveConfig($_POST);
		  break;
		case 'cancel':
  		  mosRedirect( "index2.php?option=com_fq" );
  		  break;  
		default:
		  $HTML_newsletter->editConfig($newsletterConfig, $lists);
		  break;
	}
}
?>