<?php
/*********************************************
* alphacontent - Mambo/Joomla! Component     *
* Copyright (C) 2005-2006 by  Bernard Gilly  *
* Homepage   : www.visualclinic.fr           *
* Version    : 2.2                           *
* License    : GNU/GPL                       *
*********************************************/

/** ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

// load the html drawing class
require_once( $mainframe->getPath( 'front_html', 'alphacontent' ) );
require( $mosConfig_absolute_path.'/administrator/components/com_alphacontent/alphacontent_config.php' );

// Get the right language if it exists
if (file_exists($mosConfig_absolute_path."/administrator/components/com_alphacontent/language/".$mosConfig_lang.".php")){
     include_once($mosConfig_absolute_path."/administrator/components/com_alphacontent/language/".$mosConfig_lang.".php");
     }else{
     include_once($mosConfig_absolute_path."/administrator/components/com_alphacontent/language/english.php");
     }
	 
$alpha = mosGetParam( $_REQUEST, 'alpha', 'all' );
$section = mosGetParam( $_REQUEST, 'section', 'all' );
$cat = mosGetParam( $_REQUEST, 'cat', 'all' );

$config = new alphaConfig;

switch ( $task ) {
	default:		
		viewSearchAlpha( $alpha, $section, $cat );
		break;
}

function viewSearchAlpha( $alpha, $section, $cat ) {
	global $mainframe, $mosConfig_absolute_path, $mosConfig_lang;
	global $Itemid, $database, $my, $mosConfig_offset;
	global $mosConfig_list_limit, $_VERSION, $config;
		
	// try to find search component's Itemid
	$query = "SELECT id"
		. "\n FROM #__menu"
		. "\n WHERE type = 'components'"
		. "\n AND published = 1"
		. "\n AND link = 'index.php?option=com_alphacontent'"
		;
	$database->setQuery( $query );
	$_Itemid = $database->loadResult();

	if ($_Itemid != "") {
		$Itemid = $_Itemid;
	}	
	
	// Parameters
	$menu = new mosMenu( $database );
	$menu->load( $Itemid );
	$params = new mosParameters( $menu->params );
	$params->def( 'page_title', 0 );
	$params->def( 'header', $menu->name );
	$params->def( 'back_button', $mainframe->getCfg( 'back_button' ));
	

	// check version of product for compatibily Mambo/Joomla!
	if ( $_VERSION->PRODUCT == 'Joomla!' ){	
		$nullDate = $database->getNullDate();
		$now = _CURRENT_SERVER_TIME;
	}elseif( $_VERSION->PRODUCT == 'Mambo' ){
		$nullDate = "0000-00-00 00:00:00";
		$now = date( 'Y-m-d H:i:s', time()+$mosConfig_offset*60*60 );
	}
	
	// get settings
	$showletters = $config->showletters;
	$stylealpha = $config->stylealpha;
	$numspace = $config->numspace;
	$catid = trim($config->select_category_ID);
	$secid = trim($config->select_section_ID);
	$content_typecontent = intval($config->content_type);
	$content_zone = $config->content_zone;
	$include_archived = $config->include_archived;
	$showcategories = $config->showcategories;
	$nbcolums = $config->nbcolums;
	$title_static = $config->title_static;
	$title_frontpage = $config->title_frontpage;
	$sortcat = $config->sortcat;	
	$sortitemrundefault = (( $config->defaultsortoptionrun !='' ) ? $config->defaultsortoptionrun : '5' );	
	$ac_default_list_limit = intval($config->ac_default_list_limit);
	
	$limit = trim( mosGetParam( $_REQUEST, 'limit', $ac_default_list_limit ) );
	$limitstart = trim( mosGetParam( $_REQUEST, 'limitstart', 0 ) );	
	$sortitems = trim( mosGetParam( $_REQUEST, 'sort', $sortitemrundefault ) );
	
	switch( $sortitems ){
		case '1':
			$sort = 'a.title ASC';
			break;
		case '2':
			$sort = 'a.title DESC';
			break;
		case '3':
			$sort = 'a.introtext ASC';
			break;
		case '4':
			$sort = 'a.introtext DESC';
			break;	
		case '5':
			$sort = 'a.created DESC';
			break;
		case '6':
			$sort = 'a.created ASC';	
			break;
		case '7':
			$sort = 'a.modified DESC';		
			break;
		case '8':
			$sort = 'a.modified ASC';
			break;
		case '9':
			$sort = 'a.hits DESC';
			break;
		case '10':
			$sort = 'a.hits ASC';	
			break;
		case '11':
			$sort = 'rating DESC';	
			break;
		case '12':
			$sort = 'rating ASC';	
			break;
		case '13':
			$sort = 'CONCAT( a.created_by_alias, s.name) ASC';	
			break;
		case '14':
			$sort = 'CONCAT( a.created_by_alias, s.name) DESC';	
			break;
		default:
			$sort = 'a.created DESC';
			break;
	}
	
	// Index A - Z		
	switch ( $content_zone ) {		
		case "0": //title
			$where = "WHERE a.title REGEXP '^([".$alpha."]| [".$alpha."])'";
			$order = $sort.", a.title ASC";
			break;
		case "1": //introtext			
			$where = "WHERE a.introtext REGEXP '^([".$alpha."]|<p>[".$alpha."]|<p>{mosimage}[".$alpha."]|{mosimage}[".$alpha."]|<br>[".$alpha."]|<br/>[".$alpha."]|<br />[".$alpha."])'";
			$order = $sort.", a.introtext ASC";
			break;
	}		
	
	// Sections & Categories
	if( $alpha=='all' && $section=='all' && $cat=='all' ){
				$where = "WHERE a.sectionid >= '0'";
	}elseif( $alpha=='all' && $section!='all' && $cat=='all' ){
				$where = "WHERE a.sectionid = '".$section."'";
	}elseif( $alpha=='all' && $section!='all' && $cat!='all' ){
				$where = "WHERE a.sectionid = '".$section."' AND a.catid = '".$cat."'";
	}
	
	// state		
	$state = "AND a.state = '1'";	
	if ( $include_archived=='1' ){ 
		$state = "AND (a.state = '1' OR a.state = '-1')"; 
	}	
	
	// content type
	if ( $content_typecontent=='0' ){
		if ( $secid == '' && $catid =='' ){
			$wheresection = "AND a.sectionid > '0'";			 
		}elseif( $secid != '' && $catid =='' ){
			$wheresection = "AND a.sectionid IN (".$secid.")";		
		}elseif( $secid == '' && $catid !='' ){
			$wheresection = "AND a.sectionid > '0' AND a.catid IN (".$catid.")";		
		}elseif( $secid != '' && $catid !='' ){
			$wheresection = "AND a.sectionid IN (".$secid.") AND a.catid IN (".$catid.")";		
		}
	}

	// select between Content Items, Static Content or both
	switch ( $content_typecontent ) {	
		case "0":  
			$query = "SELECT a.title AS title,"
			. "\n a.created AS created,"
			//. "\n CONCAT(a.introtext, a.fulltext) AS text,"
			. "\n a.introtext AS text,"
			. "\n CONCAT_WS( '/', u.title, b.title ) AS section,"
			. "\n CONCAT( 'index.php?option=com_content&task=view&id=', a.id ) AS href,"
			. "\n '2' AS browsernav"
			. "\n FROM #__content AS a"
			. "\n INNER JOIN #__categories AS b ON b.id=a.catid AND b.access <= '$my->gid'"
			. "\n LEFT JOIN #__sections AS u ON u.id = a.sectionid"
			. "\n $where"
			. "\n $wheresection"
			. "\n $state"
			. "\n AND a.access <= '$my->gid'"
			. "\n AND u.published = '1'"
			. "\n AND b.published = '1'"
			. "\n AND ( publish_up = '$nullDate' OR publish_up <= '$now' )"
			. "\n AND ( publish_down = '$nullDate' OR publish_down >= '$now' )";
			$database->setQuery( $query );
			$list = $database->loadObjectList();								
			break;	

		case "1": 
			$query = "SELECT a.title AS title,"
			. "\n a.created AS created,"
			//. "\n CONCAT(a.introtext, a.fulltext) AS text,"
			. "\n a.introtext AS text,"
			. "\n '"._ALPHACONTENT_NOCATEGORY."' AS section,"
			. "\n CONCAT( 'index.php?option=com_content&task=view&id=', a.id ) AS href,"
			. "\n '2' AS browsernav"
			. "\n FROM #__content AS a"
			. "\n $where"
			. "\n AND a.sectionid = '0'"
			. "\n $state"
			. "\n AND a.access <= '$my->gid'"
			. "\n AND ( publish_up = '$nullDate' OR publish_up <= '$now' )"
			. "\n AND ( publish_down = '$nullDate' OR publish_down >= '$now' )";
			$database->setQuery( $query );
			$list = $database->loadObjectList();
			break;
	
		case "2": 
			$query = "SELECT a.title AS title,"
			. "\n a.created AS created,"
			//. "\n CONCAT(a.introtext, a.fulltext) AS text,"
			. "\n a.introtext AS text,"
			. "\n CONCAT( 'index.php?option=com_content&task=view&id=', a.id ) AS href,"
			. "\n '2' AS browsernav,"
			. "\n a.state AS state"
			. "\n FROM #__content AS a"
			. "\n $where"
			. "\n $state"
			. "\n AND a.access <= '$my->gid'"
			. "\n AND ( publish_up = '$nullDate' OR publish_up <= '$now' )"
			. "\n AND ( publish_down = '$nullDate' OR publish_down >= '$now' )"
			//. "\n ORDER BY $order";
			;
			$database->setQuery( $query );
			$list = $database->loadObjectList();	
			break;	
	}	
	
	// html output
	$total 		= count( $list );
	if ( $total >= 0 ) {
	// html output
		require_once( $GLOBALS['mosConfig_absolute_path'] . '/includes/pageNavigation.php' );
		$pageNav = new mosPageNav( $total, $limitstart, $limit );
		
		// select between Content Items, Static Content or both
		switch ( $content_typecontent ) {
			case "0":  
				$query = "SELECT a.id AS id, a.title AS title,"
				. "\n a.created AS created, a.created_by_alias,"
				//. "\n CONCAT(a.introtext, a.fulltext) AS text,"
				. "\n a.introtext AS text,"
				. "\n CONCAT_WS( '/', u.title, b.title ) AS section,"
				. "\n CONCAT( 'index.php?option=com_content&task=view&id=', a.id ) AS href,"
				. "\n '2' AS browsernav,"
				. "\n a.images AS images,"
				. "\n a.state AS state,"
				. "\n a.hits AS hits,"
				. "\n ROUND(v.rating_sum/v.rating_count) AS rating, v.rating_count, s.name AS author"
				. "\n FROM #__content AS a"
				. "\n INNER JOIN #__categories AS b ON b.id=a.catid AND b.access <= '$my->gid'"
				. "\n LEFT JOIN #__sections AS u ON u.id = a.sectionid"
				. "\n LEFT JOIN #__content_rating AS v ON a.id = v.content_id"
				. "\n LEFT JOIN #__users AS s ON s.id = a.created_by"
				. "\n $where"
				. "\n $wheresection"
				. "\n $state"
				. "\n AND a.access <= '$my->gid'"
				. "\n AND u.published = '1'"
				. "\n AND b.published = '1'"
				. "\n AND ( publish_up = '$nullDate' OR publish_up <= '$now' )"
				. "\n AND ( publish_down = '$nullDate' OR publish_down >= '$now' )"
				. "\n ORDER BY $order"
				. "\nLIMIT $pageNav->limitstart, $pageNav->limit";
			
				$database->setQuery( $query );
				$rows = $database->loadObjectList();
				break;	

			case "1": 
				$query = "SELECT a.id AS id, a.title AS title,"
				. "\n a.created AS created, a.created_by_alias,"
				//. "\n CONCAT(a.introtext, a.fulltext) AS text,"
				. "\n a.introtext AS text,"
				. "\n '"._ALPHACONTENT_NOCATEGORY."' AS section,"
				. "\n CONCAT( 'index.php?option=com_content&task=view&id=', a.id ) AS href,"
				. "\n '2' AS browsernav,"
				. "\n a.images AS images,"
				. "\n a.state AS state,"
				. "\n a.hits AS hits,"
				. "\n ROUND(v.rating_sum/v.rating_count) AS rating, v.rating_count, s.name AS author"
				. "\n FROM #__content AS a"
				. "\n LEFT JOIN #__content_rating AS v ON a.id = v.content_id"
				. "\n LEFT JOIN #__users AS s ON s.id = a.created_by"
				. "\n $where"
				. "\n AND a.sectionid = '0'"
				. "\n $state"
				. "\n AND a.access <= '$my->gid'"
				. "\n AND ( publish_up = '$nullDate' OR publish_up <= '$now' )"
				. "\n AND ( publish_down = '$nullDate' OR publish_down >= '$now' )"
				. "\n ORDER BY $order"
				. "\nLIMIT $pageNav->limitstart, $pageNav->limit";
			
				$database->setQuery( $query );
				$rows = $database->loadObjectList();	
				break;
		
			case "2": 
				$query = "SELECT a.id AS id, a.title AS title,"
				. "\n a.created AS created, a.created_by_alias,"
				//. "\n CONCAT(a.introtext, a.fulltext) AS text,"
				. "\n a.introtext AS text,"
				. "\n CONCAT( 'index.php?option=com_content&task=view&id=', a.id ) AS href,"
				. "\n '2' AS browsernav,"
				. "\n a.images AS images,"
				. "\n a.state AS state,"
				. "\n a.sectionid AS section,"
				. "\n a.catid AS category,"
				. "\n a.hits AS hits,"
				. "\n ROUND(v.rating_sum/v.rating_count) AS rating, v.rating_count, s.name AS author"
				. "\n FROM #__content AS a"
				. "\n LEFT JOIN #__content_rating AS v ON a.id = v.content_id"
				. "\n LEFT JOIN #__users AS s ON s.id = a.created_by"
				. "\n $where"
				. "\n $state"
				. "\n AND a.access <= '$my->gid'"
				. "\n AND ( publish_up = '$nullDate' OR publish_up <= '$now' )"
				. "\n AND ( publish_down = '$nullDate' OR publish_down >= '$now' )"
				. "\n ORDER BY $order"
				. "\nLIMIT $pageNav->limitstart, $pageNav->limit";
	
				$database->setQuery( $query );
				$rows = $database->loadObjectList();	
				break;	
		}		
		HTML_ALPHA_FRONTEND::display( $rows, $pageNav, $limitstart, $limit, $total, $alpha, $content_typecontent, $section, $cat, $sortitems, $params );
	}

}

// Do not deleted : copyright
// If you want to withdraw the legal mention of this copyright, please contact the author for convention
// e-mail: contact@visualclinic.fr

$copyStart = 2005; 
$copyNow = date('Y');  
if ($copyStart == $copyNow) { 
	$copySite = $copyStart;
} else {
	$copySite = $copyStart."-".$copyNow ;
} 
?>
<!-- IMPORTANT ! DO NOT DELETE THE COPYRIGHT -->
<!-- If you want to remove (hide) the legal mention of this copyright notice, please contact the author -->
<!-- e-mail : contact@visualclinic.fr -->
<table width="100%" border="0" cellpadding="0" cellspacing="0">
  <tr>
    <td class="small"><div align="center"><br>
		<a href="http://www.visualclinic.fr" target="_blank">AlphaContent <?php echo _ALPHACONTENT_NUM_VERSION; ?> </a> &copy; <?php echo $copySite ; ?> by Bernard Gilly - <a href="http://www.visualclinic.fr" target="_blank">visualclinic.fr</a><br>
		</div>
	</td>
  </tr>
</table>