<?php
/*
package    : VirtueUpload
version    : 1.0.0 STABLE
author     : Tobias Kuhn - eaxs.de
Homepage   : http://www.eaxs.de
copyright  : Copyright (C) 2006 Tobias Kuhn - eaxs.de
license    : http://www.gnu.org/copyleft/gpl.html

* VirtueUpload is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
*/

defined( '_VALID_MOS' ) or die( 'Restricted access' );

require_once( $mainframe->getPath( 'front_html', 'com_virtueupload' ) );
require_once( $mosConfig_absolute_path.'/administrator/components/com_virtueupload/admin.virtueupload.cfg.php' );
require_once( $mosConfig_absolute_path.'/administrator/components/com_virtueupload/language/'.VU_CFG_LANGUAGE );

switch ( strtolower( $task ) ) {

  default:
    show_form();
    break;

  case 'start_upload':
    validate_upload();
    break;

}

/*==============================================================================
* Author    : Tobias Kuhn
* Function  : show_form
* Parameter : -
* Return    : HTML form
==============================================================================*/
function show_form() {

  $user_level = getUserlevel ();
  if (VU_CFG_UPLOADENABLED == '1' AND ($user_level >= VU_CFG_ACCESSLEVEL)) {
    $curr_page = mosGetParam( $_REQUEST, 'page');

    if ($curr_page == '' OR ($curr_page == 'account.index')) {
      $vu = new html_virtueupload ();
      echo $vu->show_form();
    }
  }
}
/*==============================================================================
* Author    : Tobias Kuhn
* Function  : validate_upload
* Parameter : -
* Return    : do_upload() or go back with an error
==============================================================================*/
function validate_upload() {
  global $mosConfig_absolute_path, $mosConfig_live_site;

  if ($_SERVER['REQUEST_METHOD'] != 'POST' ) {
	echo _NOT_AUTH;
	return;
  }

  $tmp_file      = $_FILES['file']['tmp_name'];
  $file_name     = $_FILES['file']['name'];
  $file_size     = $_FILES['file']['size'];

  $ext_types     = stripslashes(VU_CFG_EXTENSIONS);
  $get_extArray  = explode("|",$ext_types);
  $ext_tmp       = explode(".", $file_name);
  $ext           = ".".$ext_tmp[(count($ext_tmp)-1)];

  $path          = getPath();
  $curr_page     = $mosConfig_live_site."/".$path;

  if($tmp_file == '') {
     mosRedirect($curr_page."&msg=1");
     exit;
  }
  if (file_exists(VU_CFG_UPLOADROOT."/".$file_name)) {
    if (VU_CFG_FILERENAME == '1') {
      $file_name = time()."-renamed-".$_FILES['file']['name'];
    }
    else {
      mosRedirect($curr_page."&msg=2");
      exit;
    }
  }
  if (in_array($ext, $get_extArray)) {
      mosRedirect($curr_page."&msg=3");
      exit;
  }
  if ($file_size >= VU_CFG_MAXSIZE) {
      mosRedirect($curr_page."&msg=4");
      exit;
  }
  if ($_POST['order_id'] == 'none') {
      mosRedirect($curr_page."&msg=7");
      exit;
  }
  if (!file_exists($mosConfig_absolute_path."/".VU_CFG_UPLOADROOT)){
      mkdir ($mosConfig_absolute_path."/".VU_CFG_UPLOADROOT, 0777);
      chmod ($mosConfig_absolute_path."/".VU_CFG_UPLOADROOT, 0777);
  }
  do_upload ($tmp_file, $file_name);
}
/*==============================================================================
* Author    : Tobias Kuhn
* Function  : do_upload
* Parameter : temporary file, filename
* Return    : -
==============================================================================*/
function do_upload (&$tmp_file, &$file_name) {
  global $mosConfig_absolute_path;
  move_uploaded_file($tmp_file, $mosConfig_absolute_path."/".VU_CFG_UPLOADROOT."/".$file_name);

  log_upload ($file_name);
}
/*==============================================================================
* Author    : Tobias Kuhn
* Function  : log_upload
* Parameter : filename
* Return    : -
==============================================================================*/
function log_upload ($file_name) {
  global $mosConfig_absolute_path, $mosConfig_live_site, $database, $my;

  if ($my->id != '0') {
    $query = "SELECT name"
           . "\n FROM #__users"
           . "\n WHERE id = $my->id";
           $database->setQuery($query);
           $database->query();
           $me = $database->loadResult();
  }
  else {
    $me = VULANG_LOG_UNKNOWN;
  }
  if (file_exists($mosConfig_absolute_path."/".VU_CFG_UPLOADROOT."/".$file_name)) {
    $now       = date( 'Y-m-d H:i:s' );
    $cdate     = time();
    $ip        = $_SERVER['REMOTE_ADDR'];
    $file_link = VU_CFG_UPLOADROOT;
    $comment   = mosGetParam($_POST, 'comment');
    $session   = mosGetParam($_POST,'session_id');
    $order_id  = mosGetParam($_POST,'order_id');
    $file_size = round($_FILES['file']['size']/1024);
    $path      = getPath();
    $curr_page = $mosConfig_live_site."/".$path;

    $query = "INSERT INTO #__virtueuploads"
           . "\n (file_name, file_size, upload_by, order_id, ip, session_id, link, comment, date, cdate)"
           . "\n VALUES ("
           . "\n '$file_name', '$file_size', '$me', '$order_id', '$ip', '$session', '$file_link', '$comment', '$now', '$cdate')";
           $database->setQuery($query);
           $database->query();

    if (VU_CFG_BANUSER > 0) {
        $query = "SELECT COUNT(*)"
               . "\n FROM #__virtueuploads"
               . "\n WHERE upload_by = 'Unknown'"
               . "\n AND ip = '$ip'"
               . "\n AND session_id = '$session'";
               $database->setQuery( $query );
	           $total = $database->loadResult();

      if ($total >= VU_CFG_BANUSER) {
          $query = "INSERT INTO #__virtueuploads_ban"
                 . "\n (name, ip, session_id, date)"
                 . "\n VALUES ("
                 . "\n '$me', '$ip', '$session', '$now')";
                 $database->setQuery($query);
                 $database->query();
      }
    }

    if (VU_CFG_ADMINMAIL != '' ) {
      $message  = VULANG_MAIL_MAILMSG."\n\n";
      $message .= VULANG_LOG_FILENAME." : ".$file_name."\n";
      $message .= VULANG_LOG_UPLOADBY." : ".$me."\n";
      $message .= VULANG_LOG_ORDERID." : "."0 \n";
      $message .= VULANG_LOG_DATE." : ".$now."\n";
      $message .= VULANG_MAIL_LINK." : ".$mosConfig_live_site."/".CFG_VMUPL_UPLOADROOT."/".$file_name;

      mosMail( VU_CFG_ADMINMAIL, VULANG_MAIL_MAILFROMNAME , VU_CFG_ADMINMAIL, VULANG_MAIL_MAILSUBJECT, $message );
    }
    mosRedirect($curr_page."&msg=5");
  }
  else {
    mosRedirect($curr_page."&msg=6");
  }
}
/*==============================================================================
* Author    : Tobias Kuhn
* Function  : getPath
* Parameter : -
* Return    : url string
==============================================================================*/
function getPath () {
  $pop = mosGetParam( $_REQUEST, 'pop', null);
  $flypage = mosGetParam( $_REQUEST, 'flypage', null);
  $product_id = mosgetparam($_REQUEST, "product_id", null);
  $category_id = mosgetparam($_REQUEST, "category_id", null);
  $Itemid = mosgetparam($_REQUEST, "Itemid", null);
  $page   = mosgetparam($_REQUEST, "page", null);

  $curr_path = "index.php?option=com_virtueupload&amp;Itemid=".$Itemid;

  if ( $pop != null ) {
    $curr_path = "index2.php?option=com_virtueupload&pop=1";
  }
  if ( $product_id != null ) {
    $curr_path = "index.php?page=shop.product_details&flypage=".$flypage."&product_id=".$product_id."&category_id=".$category_id."&option=com_virtuemart&Itemid=".$Itemid;
  }
  if ( $page == 'account.index' ) {
    $curr_path = "index.php?page=account.index&option=com_virtuemart&Itemid=".$Itemid;
  }

  return $curr_path;
}
/*==============================================================================
* Author    : Tobias Kuhn
* Function  : getUserlevel
* Parameter : -
* Return    : shopper group_ip
==============================================================================*/
function getUserlevel () {
  global $database, $my;

  $query = "SELECT shopper_group_id"
         . "\n FROM #__vm_shopper_vendor_xref"
         . "\n WHERE user_id = $my->id";
         $database->setQuery($query);

  return $database->loadResult();
}
/*==============================================================================
* Author    : Tobias Kuhn
* Function  : getMyorders
* Parameter : -
* Return    : shopper group_ip
==============================================================================*/
function getMyorders () {
  global $database, $my;

  $query = "SELECT order_id"
          . "\n FROM #__vm_orders"
          . "\n WHERE user_id = $my->id";
          $database->setQuery($query);
          $rows = $database->loadObjectList();

  return $rows;
}
/*==============================================================================
* Author    : Tobias Kuhn
* Function  : getTemplate
* Parameter : -
* Return    : HTML template
==============================================================================*/
function getTemplate ($option) {

  $pop = mosGetParam( $_REQUEST, 'pop', null);
  $product_id = mosgetparam($_REQUEST, "product_id", null);
  $page   = mosgetparam($_REQUEST, "page", null);

  if ($pop != '') {
    $template = "pop.vu";
  }
  if ($product_id != '') {
    $template = "fly.vu";
  }
  if ($page == 'account.index') {
    $template = "account.vu";
  }
  if ($option == 'com_virtueupload') {
    $template = "account.vu";
  }
  return $template;
}


?>
