<?php

// ensure this file is being included by a parent file
defined('_VALID_MOS') or die('Direct Access to this location is not allowed.');

require_once ($mosConfig_absolute_path."/administrator/components/com_booklibrary/admin.booklibrary.class.ws.php");
require_once ($mosConfig_absolute_path."/administrator/components/com_booklibrary/admin.booklibrary.class.others.php");

/**
* Booklibrary Import Export Class
* Handles the import and export of data from the booklibrary.
* @package Booklibrary
* @copyright 2005 Gerd Saurer http://booklibrary.mamboforge.net
* @license http://www.gnu.org/copyleft/gpl.html GNU Public License
* @version $Revision: 1.0 $
*/
class HTML_booklibrary {


function showRequestLendBooks($option, & $lend_requests, & $pageNav) {
		global $my;
?>
		<form action="index2.php" method="post" name="adminForm">
		<table cellpadding="4" cellspacing="0" border="0" width="100%">
		<tr>
			<td width="100%" class="sectionname"><img src="images/mos_gel.png" width="70" height="67" align="middle" >
				<?php echo _BOOKLIBRARY_ADMIN_REQUEST_LEND; ?>
			</td>
		</tr>
		</table>

		<table cellpadding="4" cellspacing="0" border="1" width="100%" class="adminlist">
			<tr>
				<th width="20">
					<input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count( $lend_requests ); ?>);" />
				</th>
				<th width="30px">#</th>
				<th class="title" width="10%" nowrap="nowrap"><?php echo _BOOKLIBRARY_LABEL_LEND_FROM;?></th>
				<th class="title" width="10%" nowrap="nowrap"><?php echo _BOOKLIBRARY_LABEL_LEND_UNTIL;?></th>
				<th class="title" width="5%" nowrap="nowrap"><?php echo _BOOKLIBRARY_LABEL_BOOKID;?></th>
				<th class="title" width="10%" nowrap="nowrap"><?php echo _BOOKLIBRARY_LABEL_ISBN;?></th>
				<th class="title" width="15%" nowrap="nowrap"><?php echo _BOOKLIBRARY_LABEL_TITLE;?></th>
				<th class="title" width="15%" nowrap="nowrap"><?php echo _BOOKLIBRARY_LABEL_LEND_USER;?></th>
				<th class="title" width="15%" nowrap="nowrap"><?php echo _BOOKLIBRARY_LABEL_LEND_EMAIL;?></th>
				<th class="title" width="20%" nowrap="nowrap"><?php echo _BOOKLIBRARY_LABEL_LEND_ADRES;?></th>

			</tr>
<?php


		for ($i = 0, $n = count($lend_requests); $i < $n; $i ++) {
			$row = & $lend_requests[$i];
?>
			<tr class="row<?php echo $i % 2; ?>">
				<td width="20">
<?php				if ($row->fk_lendid != 0) { ?>
								&nbsp;
<?php
					} else {
						echo mosHTML::idBox( $i, $row->id, ($row->fk_lendid != 0), 'bid' );					
					}
?>
				</td>
				<td><?php echo $row->id; ?></td>
				<td>
					<?php echo $row->lend_from; ?>
				</td>
				<td>
					<?php echo $row->lend_until; ?>
				</td>
				<td><?php echo $row->fk_bookid; ?></td>
				<td>
					<?php echo $row->isbn; ?>
				</td>
				<td>
					<?php echo $row->title; ?>
				</td>
				<td>					
					<?php echo $row->user_name; ?>
				</td>
				<td>
					<a href=mailto:"<?php echo $row->user_email; ?>">
						<?php echo $row->user_email; ?>
					</a>
				</td>
				<td>
					<?php echo $row->user_mailing; ?>
				</td>
			</tr>
		<?php
		}		
		echo $pageNav->getListFooter();
?>
		</table>
		<input type="hidden" name="option" value="<?php echo $option;?>" />
		<input type="hidden" name="task" value="lend_requests" />
		<input type="hidden" name="boxchecked" value="0" />
		</form>
<?php


}




	/**
	 * @todo reorder doesn't work
	 */
	function showBooks($option, & $rows_book, & $clist, & $lendlist, & $publist, & $search, & $pageNav) {
		global $my;
?>
		<form action="index2.php" method="post" name="adminForm">
		<table cellpadding="4" cellspacing="0" border="0" width="100%">
			<tr >
				<td width="100%" class="sectionname"><img src="images/mos_gel.png" width="70" height="67" align="middle" >
				<?php echo _BOOKLIBRARY_SHOW;?>
				</td>
			</tr>
		</table>
		<table cellpadding="4" cellspacing="0" border="1" width="100%" class="adminlist">
			<td>
				<?php echo _BOOKLIBRARY_SHOW_SEARCH;?>
			</td>
			<td>
				<input type="text" name="search" value="<?php echo $search;?>" class="inputbox" onChange="document.adminForm.submit();" />
			</td>
			<td>
				<?php echo $publist;?>
			</td>
			<td>
				<?php echo $lendlist;?>
			</td>	
			<td width="right">
				<?php echo $clist;?>
			</td>
		</tr>
		</table>

		<table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminlist">
			<tr>
				<th width="20">
					<input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count( $rows_book ); ?>);" />
				</th>
				<th width="30px">#</th>
				<th class="title" width="5%" nowrap="nowrap"><?php echo _BOOKLIBRARY_LABEL_BOOKID;?></th>
				<th class="title" width="12%" nowrap="nowrap"><?php echo _BOOKLIBRARY_LABEL_ISBN;?></th>
				<th class="title" width="27%" nowrap="nowrap"><?php echo _BOOKLIBRARY_LABEL_TITLE;?></th>
				<th class="title" width="5%" nowrap="nowrap" colspan="2" align="middle"><?php echo _BOOKLIBRARY_LABEL_LINE;?></th>
				<th class="title" width="10%" nowrap="nowrap"><?php echo _BOOKLIBRARY_LABEL_FETCH_INFO;?></th>
				<th class="title" width="16%" nowrap="nowrap"><?php echo _BOOKLIBRARY_LABEL_CATEGORY;?></th>
				<th class="title" width="10%" nowrap="nowrap"><?php echo _BOOKLIBRARY_LABEL_LEND;?></th>
				<th class="title" width="5%" nowrap="nowrap"><?php echo _BOOKLIBRARY_LABEL_HITS;?></th>
				<!--<th class="title" nowrap="nowrap">Info</th>-->
				<th class="title" width="5%" nowrap="nowrap"><?php echo _BOOKLIBRARY_LABEL_PUBLIC;?></th>
				<th class="title" width="5%" nowrap="nowrap"><?php echo _BOOKLIBRARY_LABEL_CONTROL;?></th>
			</tr>
<?php


		for ($i = 0, $n = count($rows_book); $i < $n; $i ++) {
			$row = & $rows_book[$i];
?>
			<tr class="row<?php echo $i % 2; ?>">
				<td width="20" align="left">
					<?php		if ($row->checked_out && $row->checked_out != $my->id) { ?>
						&nbsp;
<?php
								} else {
									echo mosHTML::idBox( $i, $row->id, ($row->checked_out && $row->checked_out != $my->id ), 'bid' );					
								}
?>
				</td>
				<td ><?php echo $row->id; ?></td>
				<td><?php echo $row->bookid; ?></td>
				<td align="left">
					<a href="#edit" onclick="return listItemTask('cb<?php echo $i;?>','edit')">
						<?php echo $row->isbn; ?>
					</a>
				</td>
				<td align="left">
					<a href="#edit" onClick="return listItemTask('cb<?php echo $i;?>','edit')">
						<?php echo $row->title; ?>
					</a>
				</td>
				<td>				
					<?php echo $pageNav->orderUpIcon( $i, ($row->catid == @$rows_book[$i-1]->catid), "bookorderup" ); ?>
				</td>
      			<td>
					<?php echo $pageNav->orderDownIcon( $i, $n, ($row->catid == @$rows_book[$i+1]->catid), "bookorderdown" ); ?>
				</td>
				<td align="left">
					<?php echo mosBooklibraryWS :: getWsNameById($row->informationFrom);?>
				</td>								
				<td align="left"><?php echo $row->category; ?></td>
				<td >
<?php

if ($row->lend_from == null) {
?>
					<a href="javascript: void(0);" onclick="return listItemTask('cb<?php echo $i;?>','lend')">
						<img src='./components/com_booklibrary/images/lend_f2.png' align='middle' width='15' high='15' border='0' alt='Lend out' />
						</br>
					</a>
<?php


} else {
?>
					<a href="javascript: void(0);" onclick="return listItemTask('cb<?php echo $i;?>','lend_return')">
						<img src='./components/com_booklibrary/images/lend_return_f2.png' align='middle' width='15' high='15' border='0' alt='Return book' />
						</br>
						<?php echo substr($row->lend_from, 0, 10); ?>
					</a>
<?php
}
?>
				</td>
				<td ><?php echo $row->hits; ?></td>
				<!--
				<td>
					<a href="javascript: void(0);" onclick="return listItemTask('cb<?php echo $i;?>','show_info')">
						<img src='./components/com_booklibrary/images/info.png' align='middle' width='15' high='15' border='0' alt='Show Info' />
					</a>
				</td>
				-->
<?php

$task = $row->published ? 'unpblish' : 'publish';
$alt = $row->published ? 'Unpublish' : 'Publish';
$img = $row->published ? 'tick.png' : 'publish_x.png';
?>
			  <td width="5%" align="center">
			  	<a href="javascript: void(0);" onclick="return listItemTask('cb<?php echo $i;?>','<?php echo $task;?>')">
			  		<img src="images/<?php echo $img;?>" width="12" height="12" border="0" alt="<?php echo $alt;?>" />
			  	</a>
			  </td>
<?php


if ($row->checked_out) {
?>
				<td align="center"><?php echo $row->editor; ?></td>
<?php		} else { ?>
				<td align="center">&nbsp;</td>
<?php


}
}
echo $pageNav->getListFooter();
?>
		</table>
		<input type="hidden" name="option" value="<?php echo $option;?>" />
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />
		</form>
<?php


}

/**
* Writes the edit form for new and existing record
*
* A new record is defined when <var>$row</var> is passed witht the <var>id</var>
* property set to 0.
* @param mosBookLibrary The book object
* @param string The html for the categories select list
* @param string The html for the ordering select list
*/
function editBook($option, & $row, & $clist, & $wslist, & $langlist, & $rating, & $delete_ebook, & $reviews) {
	global $booklibrary_configuration;
?>

		<script language="javascript" type="text/javascript">
		function submitbutton(pressbutton) {
			var form = document.adminForm;
			if (pressbutton == 'save') {
				if (form.isbn.value == '') {
               		alert( "<?php echo _BOOKLIBRARY_ADMIN_INFOTEXT_JS_EDIT_ISBN_CHECK; ?>" );
               		return;
               	} else if (form.catid.value == '0') {
					alert( "<?php echo _BOOKLIBRARY_ADMIN_INFOTEXT_JS_EDIT_CATEGORY; ?>");
					return;
          		} else {
               		submitform( pressbutton );
               	}
			} else {
               	submitform( pressbutton );
            }
      }
	</script>


		<form action="index2.php" method="post" name="adminForm" id="adminForm" enctype="multipart/form-data">
		<table cellpadding="4" cellspacing="1" border="0" width="100%" class="adminform">
		<tr>
			<td width="15%" align="right">
				<strong><?php echo _BOOKLIBRARY_LABEL_BOOKID;?>:</strong>
			</td>
			<td width="85%" align="left">
				<input class="inputbox" type="text" name="bookid" size="20" maxlength="20" value="<?php echo $row->bookid;?>" />
			</td>
		</tr>
		<tr>
			<td width="20%" align="right">
				<strong><?php echo _BOOKLIBRARY_LABEL_ISBN;?>:</strong>
			</td>
			<td align="left">
				<input class="inputbox" type="text" name="isbn" size="20" maxlength="20" value="<?php echo $row->isbn;?>" />				
			</td>
		</tr>
		<tr>
			<td valign="top" align="right">
				<strong><?php echo _BOOKLIBRARY_LABEL_LANGUAGE;?>:</strong>
			</td>
			<td align="left">
				<?php echo $langlist; ?>
			</td>
		</tr>
		<tr>
			<td valign="top" align="right">
				<strong><?php echo _BOOKLIBRARY_LABEL_CATEGORY;?>:</strong>
			</td>
			<td align="left">
				<?php echo $clist; ?>
			</td>
		</tr>
		<tr>
			<td valign="top" align="right">
				<strong><?php echo _BOOKLIBRARY_LABEL_FETCH_INFO;?>:</strong>
			</td>
			<td align="left">
				<?php echo $wslist; ?>
				&nbsp;&nbsp;&nbsp;<img src="../components/com_booklibrary/images/amazon/com-logo.gif" alt="amazon.com" border="0"/>
			 </td>
		</tr>
		<tr>
			<td valign="top" align="right">
				<strong><?php echo _BOOKLIBRARY_LABEL_COMMENT;?>:</strong>
			</td>
			<td align="left">
				<?php
					editorArea( 'editor1',  $row->comment , 'comment', 500, 250, '70', '10' ) ;
				?>
				<!--<textarea name="comment" id="comment" cols="50" rows="25" style="width:800;height:200;"><?php echo $row->comment;?></textarea>-->
			</td>
		</tr>
		<?php if ($booklibrary_configuration['ebooks']['allow']){
			?>	
		<tr>
			<td valign="top" align="right">
				<strong><?php echo _BOOKLIBRARY_LABEL_EBOOK_UPLOAD;?>:</strong>
			</td>
			<td align="left">
				<input class="inputbox" type="file" name="ebook_file" value="" size="50" maxlength="250"/>
			</td>
		</tr>		
		<?php
		}
		if (count($row->ebookURL) > 1){
		?>
		<tr>
			<td valign="top" align="right">
				<strong><?php echo _BOOKLIBRARY_LABEL_EBOOK_ACTUAL;?>:</strong>
			</td>
			<td align="left">
				<a href="<?php echo $row->ebookURL; ?>">
					<?php echo $row->ebookURL; ?>
				</a>
			</td>
		</tr>
		<tr>
			<td valign="top" align="right">
				<strong><?php echo _BOOKLIBRARY_LABEL_EBOOK_DELETE;?>:</strong>
			</td>
			<td align="left">
				<?php echo $delete_ebook; ?>
			</td>
		</tr>
		<?php
		}
		?>		
		<tr>
			<td colspan="2">			  					
  				<hr width="100%" size="2">
			</td>
		</tr>
		<tr>
			<td valign="top" align="right">
				&nbsp;
			</td>
			<td align="left">
				<?php echo _BOOKLIBRARY_ADMIN_TEXT_WSINFO_TEXT1;?>
				<strong>
				<?php echo _BOOKLIBRARY_LABEL_FETCH_INFO;?>
				->
				<?php echo _BOOKLIBRARY_WS_NO;?>
				</strong>
			</td>
		</tr>	
		<tr>
			<td valign="top" align="right">
				<strong><?php echo _BOOKLIBRARY_LABEL_TITLE;?>:</strong>
			</td>
			<td align="left">
				<input class="inputbox" type="text" name="title" size="80" value="<?php echo $row->title;?>" />
			</td>
		</tr>
		<tr>
			<td valign="top" align="right">
				<strong><?php echo _BOOKLIBRARY_LABEL_AUTHORS;?>:</strong>
			</td>
			<td align="left">
				<input class="inputbox" type="text" name="authors" size="80" value="<?php echo $row->authors;?>" />
			</td>
		</tr>
		<tr>
			<td valign="top" align="right">
				<strong><?php echo _BOOKLIBRARY_LABEL_MANUFACTURER;?>:</strong>
			</td>
			<td align="left">
				<input class="inputbox" type="text" name="manufacturer" size="80" value="<?php echo $row->manufacturer;?>" />
			</td>
		</tr>
		<tr>
			<td valign="top" align="right">
				<strong><?php echo _BOOKLIBRARY_LABEL_PUB_DATE;?>:</strong>
			</td>
			<td align="left">
				<input class="inputbox" type="text" name="release_Date" size="30" value="<?php echo $row->release_Date;?>" />				
			</td>
		</tr>
		<tr>
			<td valign="top" align="right">
				<strong><?php echo _BOOKLIBRARY_LABEL_PRICE;?>:</strong>
			</td>
			<td align="left">
				<input class="inputbox" type="text" name="price" size="15" value="<?php echo $row->price;?>" />
			</td>
		</tr>
		<tr>
			<td valign="top" align="right">
				<strong><?php echo _BOOKLIBRARY_LABEL_EDITION;?>:</strong>
			</td>
			<td align="left">
				<input class="inputbox" type="text" name="edition" size="45" value="<?php echo $row->edition;?>" />
			</td>
		</tr>
		<tr>
			<td valign="top" align="right">
				<strong><?php echo _BOOKLIBRARY_LABEL_RATING;?>:</strong>
			</td>
			<td align="left">
				<?php echo $rating; ?>
			</td>				
		</tr>
		<tr>
			<td valign="top" align="right">
				<strong><?php echo _BOOKLIBRARY_LABEL_PICTURE_URL;?>:</strong>
			</td>
			<td align="left">
				<input class="inputbox" type="text" name="imageURL" size="80" value="<?php echo $row->imageURL;?>" />
			</td>
		</tr>
		<tr>
			<td valign="top" align="right">
				<strong><?php echo _BOOKLIBRARY_LABEL_PICTURE_URL_UPLOAD;?>:</strong>
			</td>
			<td align="left">
				<input class="inputbox" type="file" name="picture_file" value="" size="50" maxlength="250">
				<br/><?php echo _BOOKLIBRARY_LABEL_PICTURE_URL_DESC;?>
			</td>
		</tr>
		<tr>
			<td valign="top" align="right">
				<strong><?php echo _BOOKLIBRARY_LABEL_URL;?>:</strong>
			</td>
			<td align="left">
				<input class="inputbox" type="text" name="URL" size="80" value="<?php echo $row->URL;?>" />
			</td>
		</tr>
		<tr>
			<td colspan=2>
				&nbsp;
			</td>
		</tr>
		</table>
		<input type="hidden" name="id" value="<?php echo $row->id; ?>" />
		<input type="hidden" name="option" value="<?php echo $option;?>" />
		<input type="hidden" name="task" value="" />				
		</form>
		<?php


}

function showInfoRefetchBoosks($option, & $result, & $wslist) {
	global $my;
?>
	<form action="index2.php" method="post" name="adminForm">
	<table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminlist">
	
	<td valign="top" align="right">
			<tr>
			<td colspan="6">
			<strong><?php echo _BOOKLIBRARY_LABEL_INFO_FETCH;?></strong>
			<?php echo $wslist; ?>
				&nbsp;&nbsp;&nbsp;<img src="../components/com_booklibrary/images/amazon/com-logo.gif" alt="amazon.com" border="0">
			 </td>
			</tr>
	
			<tr>
				<th class="title" width="20">
					<?php echo _BOOKLIBRARY_LABEL_INFO_REFETCH;?>
					<!--<input type="checkbox" name="toggle" value="" checked="checked" onclick="checkAll(<?php echo count( $rows ); ?>);" />-->
				</th>
				<th class="title" width="30px">#</th>		
				<th class="title" width="15%" nowrap="nowrap"><?php echo _BOOKLIBRARY_LABEL_BOOKID;?></th>
				<th class="title" width="30%" nowrap="nowrap"><?php echo _BOOKLIBRARY_LABEL_ISBN;?></th>
				<th class="title" width="30%" nowrap="nowrap"><?php echo _BOOKLIBRARY_LABEL_RESULT;?></th>
			</tr>
<?php


	$i = 0;
	while ($i < count($result)) {
		$row = & $result[$i];
?>
			<tr class="row<?php echo $i % 2; ?>">
				<td>
				<?php


		if ($row[3] != "OK") {
			echo "<input type='checkbox' id='cb'".$i."' name='bid[]' value='".$row[0]."' onclick='isChecked(this.checked);' />";
		} else {
			echo "&nbsp";
		}
?>
				</td>
				<td>
					<?php echo $row[0] ?>
				</td>
				<td>
					<?php echo $row[1] ?>
				</td>
				<td>
					<?php echo $row[2] ?>
				</td>
				<td>
					<?php echo $row[3] ?>
				</td>				
			</tr>
			
<?php		$i ++; } ?>

		<input type="hidden" name="option" value="<?php echo $option;?>" />
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />
	</table>
	</form>
<?php


	}

	function refetchBoosks($option, & $rows, & $wslist) {
		global $my;
?>
	<form action="index2.php" method="post" name="adminForm">
	<table cellpadding="4" cellspacing="0" border="0" width="100%">
		<tr>
			<td width="100%" class="sectionname">
				<?php echo _BOOKLIBRARY_REFETCH; ?>
			</td>
		</tr>		
		</tr>
			<td align="left">
				&nbsp;
			</td>
		</tr>
		</table>
	<table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminlist">
	
	<td valign="top" align="right">
			<tr>
			<td colspan="6">
			<strong><?php echo _BOOKLIBRARY_LABEL_INFO_FETCH;?></strong>
			<?php echo $wslist; ?>
				&nbsp;&nbsp;&nbsp;<img src="../components/com_booklibrary/images/amazon/com-logo.gif" alt="amazon.com" border="0">
			 </td>
			</tr>
	
			<tr>
				<th class="title" width="20">
					<input type="checkbox" name="toggle" value="" checked="checked" onclick="checkAll(<?php echo count( $rows ); ?>);" />
				</th>
				<th class="title" width="30px">#</th>		
				<th class="title" width="15%" nowrap="nowrap"><?php echo _BOOKLIBRARY_LABEL_BOOKID;?></th>
				<th class="title" width="30%" nowrap="nowrap"><?php echo _BOOKLIBRARY_LABEL_ISBN;?></th>
				<th class="title" width="30%" nowrap="nowrap"><?php echo _BOOKLIBRARY_LABEL_TITLE;?></th>
				<th class="title" width="25%" nowrap="nowrap"><?php echo _BOOKLIBRARY_LABEL_FETCHED_FROM;?></th>
			</tr>
<?php


		$i = 0;
		while ($i < count($rows)) {
			$row = & $rows[$i];
?>
			<tr class="row<?php echo $i % 2; ?>">
				<td>
					<input type="checkbox" checked="checked" id="cb<?php echo $i;?>" name="bid[]" value="<?php echo $row->id; ?>" onclick="isChecked(this.checked);" />
				</td>
				<td>
					<?php echo $row->id ?>
				</td>
				<td>
					<?php echo $row->bookid ?>
				</td>
				<td>
					<?php echo $row->isbn ?>
				</td>
				<td>
					<?php echo $row->title ?>
				</td>
				<td>
					<?php


			echo mosBooklibraryWS :: getWsNameById($row->informationFrom);
?>
				</td>
			</tr>
			
<?php		$i ++; } ?>

		<input type="hidden" name="option" value="<?php echo $option;?>" />
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="1" />
	</table>
	</form>
<?php


		}
		/**
		 * @todo javascript doesn't work 
		 */
		function showImportExportBooks($params, $option) {
			global $my, $mosConfig_live_site;
?>
	<div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>
    <script language="Javascript" src="<?php echo $mosConfig_live_site;?>/includes/js/overlib_mini.js"></script>
	
	<script language="javascript" type="text/javascript">
     function submitbutton(pressbutton) {
			var form = document.adminForm;
			if (pressbutton == 'import') {
				if (form.import_type.value == '0') {
               		alert("<?PHP echo _BOOKLIBRARY_SHOW_IMPEXP_ERR1; ?>" );
               		return;
               	} else if (form.import_catid.value == '0') {
					alert("<?PHP echo _BOOKLIBRARY_SHOW_IMPEXP_ERR2; ?>");
					return;
				} else if (form.import_file.value == ''){
          			alert("<?PHP echo _BOOKLIBRARY_SHOW_IMPEXP_ERR3; ?>");
          			return;
          		} else {
               		submitform( pressbutton );
               	}
			} else if (pressbutton == 'export') {
               if (form.export_type.value == '0') {
               		alert("<?PHP echo _BOOKLIBRARY_SHOW_IMPEXP_ERR4; ?>");
               	} else {
               		submitform( pressbutton );
               	}
            } else {
               	submitform( pressbutton );
            }
      }
      </script>
	
	
	<table border="0" class="adminheading" cellpadding="0" cellspacing="0" width="100%">
      <tr valign="middle">
        <th class="config"><?PHP echo _BOOKLIBRARY_ADMIN_IMPEXP; ?></th>
        <td align="right"></td>
      </tr>
      </table>
	
	<form action="index2.php" method="post" name="adminForm" enctype="multipart/form-data">
<?php
	$tabs = new mosTabs(0);
		      
	  $tabs->startPane("impexPane");

      $tabs->startTab(_BOOKLIBRARY_ADMIN_IMP, "impexPane");
?>
      <table class="adminform">
      <tr>
         <td width="185"><?php echo _BOOKLIBRARY_SHOW_IMPEXP_LABEL_IMPORT_TYP; ?>:</td> <!-- Typ importu -->
         <td width="20"><?php echo mosToolTip(_BOOKLIBRARY_ADMIN_SHOW_IMPEXP_LABEL_IMPORT_TYP_TT_HEAD, _BOOKLIBRARY_ADMIN_SHOW_IMPEXP_LABEL_IMPORT_TYP ); ?></td>
         <td><?php echo $params['import']['type']; ?></td>
      </tr>
      <tr>
         <td width="185"><?php echo _BOOKLIBRARY_SHOW_IMPEXP_LABEL_IMPORT_CATEGORY; ?>:</td> <!-- Kategoria -->
         <td width="20"><?php echo mosToolTip( _BOOKLIBRARY_ADMIN_SHOW_IMPEXP_LABEL_IMPORT_CAT_TT_HEAD, _BOOKLIBRARY_ADMIN_SHOW_IMPEXP_LABEL_IMPORT_CAT ); ?></td>
         <td><?php echo $params['import']['category']; ?></td>         
      </tr>      

      <tr>
         <td width="185"><?php echo _BOOKLIBRARY_SHOW_IMPEXP_LABEL_IMPORT_FILE; ?>:</td>   <!-- Plik do importu -->      
         <td width="20"><?php echo mosToolTip( _BOOKLIBRARY_ADMIN_SHOW_IMPEXP_LABEL_IMPORT_FILE_TT_HEAD, _BOOKLIBRARY_ADMIN_SHOW_IMPEXP_LABEL_IMPORT_FILE ); ?></td>
         <td><input class="inputbox" type="file" name="import_file" value="" size="50" maxlength="250"></td>         
      </tr>
      <tr>
         <td width="185">&nbsp;</td>
         <td width="20">&nbsp;</td>
         <td><?php echo _BOOKLIBRARY_SHOW_IMPEXP_FORMAT; ?></td>
      </tr>
      </table>
<?php
      $tabs->endTab();

     $tabs->startTab(_BOOKLIBRARY_ADMIN_EXP, "impexPane");
?>
      <table class="adminform">
      <tr>
         <td width="185"><?php echo _BOOKLIBRARY_SHOW_IMPEXP_LABEL_EXPORT_TYP; ?>:</td>
         <td width="20"><?php echo mosToolTip( _BOOKLIBRARY_ADMIN_SHOW_IMPEXP_LABEL_EXPORT_TYP_TT_HEAD, _BOOKLIBRARY_ADMIN_SHOW_IMPEXP_LABEL_EXPORT_TYP ); ?></td>
         <td><?php echo $params['export']['type']; ?></td>
      </tr>
      <tr>
         <td width="185"><?php echo _BOOKLIBRARY_SHOW_IMPEXP_LABEL_EXPORT_CATEGORY; ?>:</td>
         <td width=&quot;20"><?php echo mosToolTip( _BOOKLIBRARY_ADMIN_SHOW_IMPEXP_LABEL_EXPORT_CAT_TT_HEAD, _BOOKLIBRARY_ADMIN_SHOW_IMPEXP_LABEL_EXPORT_CAT ); ?></td>
         <td><?php echo $params['export']['category']; ?></td>         
      </tr>
      </table>
<?php
      $tabs->endTab();
      $tabs->endPane();
?>

		<input type="hidden" name="option" value="<?php echo $option;?>" />
		<input type="hidden" name="task" value="" />
	</form>
<?php


		}

		function showLendBooks($option, & $rows, & $userlist, $type) {
			global $my, $mosConfig_live_site;
?>

		<link rel="stylesheet" type="text/css" media="all" href="../includes/js/calendar/calendar-mos.css" title="green" />
		<!-- import the calendar script -->
		<script type="text/javascript" src="../includes/js/calendar/calendar.js"></script>
		<!-- import the language module -->
		<script type="text/javascript" src="../includes/js/calendar/lang/calendar-pl.js"></script>
		<script language="javascript" src="js/dhtml.js"></script>
		<div id="overDiv" style="position:absolute; visibility:hidden; z-index:1000;"></div>
		<script language="Javascript" src="../includes/js/overlib_mini.js"></script>

		
		<form action="index2.php" method="post" name="adminForm" id="adminForm">
		<table cellpadding="4" cellspacing="0" border="0" width="100%">
		<tr>
			<td width="100%" class="sectionname">
<?php
			if ($type == "lend") {
				echo _BOOKLIBRARY_SHOW_LEND_BOOKS;
			} else
				if ($type == "lend_return") {
					echo _BOOKLIBRARY_SHOW_LEND_RETURN;
				} else {
					echo "&nbsp;";
				}
?>
			</td>
		</tr>		
		</tr>
			<td align="left">
				&nbsp;
			</td>
		</tr>
		</table>
	
<?php
			if ($type == "lend") {
?>
				<table cellpadding="4" cellspacing="0" border="0" width="100%">
		
				</tr>
					<td align="left" nowrap="nowrap">
						<?php echo _BOOKLIBRARY_LABEL_LEND_TO .':'; ?>
					</td>
					<td align="left" nowrap="nowrap">
						<?php echo $userlist; ?>
					</td>
					<td align="left" nowrap="nowrap">
						<?php echo _BOOKLIBRARY_LABEL_LEND_USER .':'; ?>
					</td>
					<td align="left" width="30%" nowrap="nowrap">
						<input type="text" name="user_name" class="inputbox" />
					</td>	
					<td width="1000%">
						&nbsp;
					</td>				
				</tr>
				</tr>
					<td align="left">
						&nbsp;
					</td>
					<td align="left">
						&nbsp;
					</td>
					<td align="left" nowrap="nowrap">
						<?php echo _BOOKLIBRARY_LABEL_LEND_EMAIL .':'; ?>
					</td>
					<td align="left" nowrap="nowrap">
						<input type="text" name="user_email" class="inputbox" />
					</td>
					<td width="30%">
						&nbsp;
					</td>						
				</tr>
				</tr>
					<td align="left" nowrap="nowrap">
						<?php echo _BOOKLIBRARY_LABEL_LEND_TIME .':'; ?>
					</td>
					<td align="left" nowrap="nowrap">
						<input class="inputbox" type="text" name="lend_until" id="lend_until" size="12" maxlength="10" value="<?php echo date("Y-m-d"); ?>" />
                		<input type="reset" class="button" value="..." onclick="return showCalendar('lend_until', 'y-mm-dd');" />
					</td>
					<td colspan="3">
						&nbsp;
					</td>		
				</tr>
						</tr>
					<td align="left">
						&nbsp;
					</td>
				</tr>
				</table>
<?php
			} else {
?>
		&nbsp;
<?php
			}
?>

		<table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminlist">
			<tr>
				<th width="20">
					<input type="checkbox" checked="checked" name="toggle" value="" onclick="checkAll(<?php echo count( $rows ); ?>);" />
				</th>
				
				<th width="30px">#</th>
				<th class="title" width="5%" nowrap="nowrap"><?php echo _BOOKLIBRARY_LABEL_BOOKID; ?></th>
				<th class="title" width="15%" nowrap="nowrap"><?php echo _BOOKLIBRARY_LABEL_ISBN; ?></th>
				<th class="title" width="25%" nowrap="nowrap"><?php echo _BOOKLIBRARY_LABEL_TITLE; ?></th>
				<th class="title" width="15%" nowrap="nowrap"><?php echo _BOOKLIBRARY_LABEL_LEND_FROM; ?></th>
				<th width="20%" align="left" nowrap="nowrap"><?php echo _BOOKLIBRARY_LABEL_LEND_UNTIL; ?></th>
				<th class="title" width="15%" nowrap="nowrap"><?php echo _BOOKLIBRARY_LABEL_LEND_TO; ?></th>				
			</tr>
<?php


			for ($i = 0, $n = count($rows); $i < $n; $i ++) {
				$row = & $rows[$i];
?>
			<tr class=row"<?php echo $i % 2; ?>">
				<td width="20">
<?php
				//error for this row lend was caled even if the book is already lend out
				if ($row->lend_from != null && $type == "lend") {
?>
					&nbsp;
<?php
				//lend was called for a correct book
				} else if ($row->lend_from == null && $type == "lend") {
?>
					<input type="checkbox" checked="checked" id="cb<?php echo $i;?>" name="bid[]" value="<?php echo $row->id; ?>" onclick="isChecked(this.checked);" />
<?php
				//lend return was called on a book which was not lend out
				} else if ($row->lend_from == null && $type == "lend_return") {
?>
					&nbsp;
<?php
				//lend return was called correct
				} else if ($row->lend_from != null && $type == "lend_return") {
?>
					<input type="checkbox" checked="checked" id="cb<?php echo $i;?>" name="bid[]" value="<?php echo $row->lendid; ?>" onclick="isChecked(this.checked);" />
<?php
				} else {
?>
				&nbsp;
<?php
				}
?>

				</td>
				<td><?php echo $row->id; ?></td>
				<td><?php echo $row->bookid; ?></td>
				<td align="left"><?php echo $row->isbn; ?></td>
				<td align="left"><?php echo $row->title; ?></td>
				<td><?php echo $row->lend_from; ?></td>
				<td><?php echo $row->lend_until ?></td>	
				<td align="left">			
<?php
				if ($row->fk_userid == null) {
					echo $row->user_name;
					echo "&nbsp;";
					echo "<a href='mailto:".$row->user_email."'>";
					echo $row->user_email;
					echo "</a>";
				} else {
					echo $row->name;
					echo "&nbsp;";
					echo "<a href='mailto:".$row->user_email."'>";
					echo $row->email;
					echo "</a>";

				}
?>
				</td>


<?php	 } ?>
		</table>
		<input type="hidden" name="option" value="<?php echo $option;?>" />
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="1" />
		<input type="hidden" name="save" value="1" />
		</form>
<?php


			}

   function showConfiguration($lists, $option ) {
      global $mosConfig_live_site, $act, $task;

      $tabs = new mosTabs(0);
?>

      <div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>
      <script language="Javascript" src="<?php echo $mosConfig_live_site;?>/includes/js/overlib_mini.js"></script>


      <table border="0" class="adminheading" cellpadding="0" cellspacing="0" width="100%">
      <tr valign="middle">
        <th class="config"><?PHP echo _BOOKLIBRARY_ADMIN_CONFIG; ?></th>
        <td align="right"></td>
      </tr>
      </table>



      <form action="index2.php" method="post" name="adminForm" id="adminForm">

<?php
      $tabs->startPane("configPane");

      $tabs->startTab(_BOOKLIBRARY_ADMIN_CONFIG_FRONTEND, "configPane");
?>
      <table class="adminform">
      <tr>
         <td width="185"><?php echo _BOOKLIBRARY_ADMIN_CONFIG_REVIEWS_SHOW; ?>:</td>
         <td width="20"><?php echo mosToolTip( _BOOKLIBRARY_ADMIN_CONFIG_REVIEWS_SHOW_TT_BODY, _BOOKLIBRARY_ADMIN_CONFIG_REVIEWS_SHOW_TT_HEAD ); ?></td>
         <td><?php echo $lists['reviews']['show']; ?></td>
      <!--</tr>
      <tr>-->
         <td width="185"><?php echo _BOOKLIBRARY_ADMIN_CONFIG_REVIEWS_REGISTRATIONLEVEL; ?>:</td>         
         <td width="20"><?php echo mosToolTip( _BOOKLIBRARY_ADMIN_CONFIG_REVIEWS_REGISTRATIONLEVEL_TT_BODY, _BOOKLIBRARY_ADMIN_CONFIG_REVIEWS_REGISTRATIONLEVEL_TT_HEAD ); ?></td>
         <td><?php echo $lists['reviews']['registrationlevel']; ?></td>         
      </tr>
      <tr>
      	<td colspan="6">
      		<hr>
      	</td>
      </tr>
      <tr>
         <td width="185"><?php echo _BOOKLIBRARY_ADMIN_CONFIG_LENDSTATUS_SHOW; ?>:</td>
         <td width="20"><?php echo mosToolTip( _BOOKLIBRARY_ADMIN_CONFIG_LENDSTATUS_SHOW_TT_BODY, _BOOKLIBRARY_ADMIN_CONFIG_LENDSTATUS_SHOW_TT_HEAD ); ?></td>
         <td><?php echo $lists['lendstatus']['show']; ?></td>
      <!--</tr>
      <tr>-->
         <td width="185"><?php echo _BOOKLIBRARY_ADMIN_CONFIG_LENDREQUEST_REGISTRATIONLEVEL; ?>:</td>
         <td width="20"><?php echo mosToolTip( _BOOKLIBRARY_ADMIN_CONFIG_LENDREQUEST_REGISTRATIONLEVEL_TT_BODY, _BOOKLIBRARY_ADMIN_CONFIG_LENDREQUEST_REGISTRATIONLEVEL_TT_HEAD ); ?></td>
         <td><?php echo $lists['lendrequest']['registrationlevel']; ?></td>         
      </tr>      
      <tr>
      	<td colspan="6">
      		<hr>
      	</td>
      </tr>
      <tr>
         <td width="185"><?php echo _BOOKLIBRARY_ADMIN_CONFIG_EBOOKS_SHOW; ?>:</td>
         <td width="20"><?php echo mosToolTip( _BOOKLIBRARY_ADMIN_CONFIG_EBOOKS_SHOW_TT_BODY, _BOOKLIBRARY_ADMIN_CONFIG_EBOOKS_SHOW_TT_HEAD ); ?></td>
         <td><?php echo $lists['ebooks']['show']; ?></td>
         <td colspan="3"></td>
      </tr>
      <tr>
      	<td colspan="6">
      		<hr>
      	</td>
      </tr>
      <tr>
         <td width="185"><?php echo _BOOKLIBRARY_ADMIN_CONFIG_PRICE_SHOW; ?>:</td>
         <td width="20"><?php echo mosToolTip( _BOOKLIBRARY_ADMIN_CONFIG_PRICE_SHOW_TT_BODY, _BOOKLIBRARY_ADMIN_CONFIG_PRICE_SHOW_TT_HEAD ); ?></td>
         <td><?php echo $lists['price']['show']; ?></td>
      	 <td colspan="3"></td>
      </tr>
      </table>
<?php
      $tabs->endTab();

      $tabs->startTab(_BOOKLIBRARY_ADMIN_CONFIG_BACKEND,"configPane");
?>
	<table class="adminform">
		<tr>
        	<td width="185"><?php echo _BOOKLIBRARY_ADMIN_CONFIG_IMAGES_DOWNLOAD; ?>:</td>
			<td width="20"><?php echo mosToolTip( _BOOKLIBRARY_ADMIN_CONFIG_IMAGES_DOWNLOAD_TT_BODY, _BOOKLIBRARY_ADMIN_CONFIG_IMAGES_DOWNLOAD_TT_HEAD ); ?></td>
			<td><?php echo $lists['fetchImages']['boolean']; ?></td>
      </tr>
       <tr>
         <td width="185"><?php echo _BOOKLIBRARY_ADMIN_CONFIG_IMAGES_DOWNLOAD_LOCATION; ?>:</td>
         <td width="20"><?php echo mosToolTip( _BOOKLIBRARY_ADMIN_CONFIG_IMAGES_DOWNLOAD_LOCATION_TT_BODY, _BOOKLIBRARY_ADMIN_CONFIG_IMAGES_DOWNLOAD_LOCATION_TT_HEAD ); ?></td>
         <td><?php echo $lists['fetchImages']['location']; ?></td>
      </tr>
      <tr>
      	<td colspan="3">
      		<hr>
      	</td>
      </tr>
      <tr>
         <td width="185"><?php echo _BOOKLIBRARY_ADMIN_CONFIG_EBOOKS_DOWNLOAD; ?>:</td>
         <td width="20"><?php echo mosToolTip( _BOOKLIBRARY_ADMIN_CONFIG_EBOOKS_DOWNLOAD_TT_BODY, _BOOKLIBRARY_ADMIN_CONFIG_EBOOKS_DOWNLOAD_TT_HEAD ); ?></td>
         <td><?php echo $lists['ebooks']['allow']; ?></td>
      </tr>
      <tr>
         <td width="185"><?php echo _BOOKLIBRARY_ADMIN_CONFIG_EBOOKS_DOWNLOAD_LOCATION; ?>:</td>
         <td width="20"><?php echo mosToolTip( _BOOKLIBRARY_ADMIN_CONFIG_EBOOKS_DOWNLOAD_LOCATION_TT_BODY, _BOOKLIBRARY_ADMIN_CONFIG_EBOOKS_DOWNLOAD_LOCATION_TT_HEAD ); ?></td>
         <td><?php echo $lists['ebooks']['location']; ?></td>
      </tr>
      <tr>
      	<td colspan="3">
      		<hr>
      	</td>
      </tr>
      <tr>
         <td width="185"><?php echo _BOOKLIBRARY_ADMIN_CONFIG_WS_AMAZON_TAG; ?>:</td>
         <td width="20"><?php echo mosToolTip( _BOOKLIBRARY_ADMIN_CONFIG_WS_AMAZON_TAG_TT_BODY, _BOOKLIBRARY_ADMIN_CONFIG_WS_AMAZON_TAG_TT_HEAD ); ?></td>
         <td><?php echo $lists['ws']['amazon']['tag']; ?></td>
      </tr>
      <tr>
      	<td colspan="3">
      		<hr>
      	</td>
      </tr>
      <tr>
         <td width="185"><?php echo _BOOKLIBRARY_ADMIN_CONFIG_EDITBOOK_CHECK_ISBN; ?>:</td>
         <td width="20"><?php echo mosToolTip( _BOOKLIBRARY_ADMIN_CONFIG_EDITBOOK_CHECK_ISBN_TT_BODY, _BOOKLIBRARY_ADMIN_CONFIG_EDITBOOK_CHECK_ISBN_TT_HEAD ); ?></td>
         <td><?php echo $lists['editbook']['check']['isbn']; ?></td>
      </tr>     
      
      
      </table>
<?php
      $tabs->endTab();
      
      $tabs->startTab(_BOOKLIBRARY_ADMIN_CONFIG_WS,"configPane");
?>
      <table class="adminform">
      <tr>
         <td width="185"><?php echo _BOOKLIBRARY_ADMIN_CONFIG_WS_HOST; ?>:</td>
         <td width="20"><?php echo mosToolTip( _BOOKLIBRARY_ADMIN_CONFIG_WS_HOST_TT_BODY, _BOOKLIBRARY_ADMIN_CONFIG_WS_HOST_TT_HEAD ); ?></td>
         <td><?php echo $lists['proxy']['host']; ?></td>
      </tr>
      <tr>
         <td width="185"><?php echo _BOOKLIBRARY_ADMIN_CONFIG_WS_PORT; ?>:</td>
         <td width="20"><?php echo mosToolTip( _BOOKLIBRARY_ADMIN_CONFIG_WS_PORT_TT_BODY, _BOOKLIBRARY_ADMIN_CONFIG_WS_PORT_TT_HEAD ); ?></td>
         <td><?php echo $lists['proxy']['port']; ?></td>
      </tr>
      <tr>
         <td width="185"><?php echo _BOOKLIBRARY_ADMIN_CONFIG_WS_USER; ?>:</td>
         <td width="20"><?php echo mosToolTip( _BOOKLIBRARY_ADMIN_CONFIG_WS_USER_TT_BODY, _BOOKLIBRARY_ADMIN_CONFIG_WS_USER_TT_HEAD ); ?></td>
         <td><?php echo $lists['proxy']['user']; ?></td>
      </tr>
      <tr>
         <td width="185"><?php echo _BOOKLIBRARY_ADMIN_CONFIG_WS_PWD; ?>:</td>
         <td width="20"><?php echo mosToolTip( _BOOKLIBRARY_ADMIN_CONFIG_WS_PWD_TT_BODY, _BOOKLIBRARY_ADMIN_CONFIG_WS_PWD_TT_HEAD ); ?></td>
         <td><?php echo $lists['proxy']['pwd']; ?></td>         
      </tr>
      </table>
<?php
      $tabs->endTab();
      
      $tabs->endPane();
?>
        <input type="hidden" name="option" value="<?php echo $option; ?>">
        <input type="hidden" name="task" value="config_save">
      </form>

<?php

    }



   function about() {
      global $mosConfig_live_site ;

      $tabs = new mosTabs(0);
?>

      <div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>
      <script language="Javascript" src="<?php echo $mosConfig_live_site;?>/includes/js/overlib_mini.js"></script>


      <table border="0" class="adminheading" cellpadding="0" cellspacing="0" width="100%">
      <tr valign="middle">
        <th class="config"><?PHP echo _BOOKLIBRARY_ADMIN_ABOUT; ?></th>
        <td align="right"></td>
      </tr>
      </table>



      <form action="index2.php" method="post" name="adminForm" id="adminForm">

<?php
      $tabs->startPane("aboutPane");

      $tabs->startTab(_BOOKLIBRARY_ADMIN_ABOUT_ABOUT, "display-page");
?>
      <table class="adminform">
	      <tr>
	        <td width="80%">
				<h3><?PHP echo _BOOKLIBRARY__HTML_ABOUT; ?></h3>
				<?PHP echo _BOOKLIBRARY__HTML_ABOUT_INTRO; ?>
			</td>
	         <td width="20%">
	         	<img src="../components/com_booklibrary/images/book.gif" align="right" />
	         </td>	         
	      </tr>
      </table>
<?php
      $tabs->endTab();

      $tabs->startTab(_BOOKLIBRARY_ADMIN_ABOUT_RELEASENOTE, "display-page");

	require($mosConfig_live_site . "/administrator/components/com_booklibrary/doc/releasenote.php");

      $tabs->endTab();
      
      
      $tabs->endPane();
?>
        <input type="hidden" name="option" value="<?php echo $option; ?>">
      </form>

<?php

    }

	function showImportResult($table, $option){
	?>
		<form action="index2.php" method="post" name="adminForm" id="adminForm">
			<table cellpadding='4' cellspacing='0' border='1' width='100%'>
				<tr>
	    			<td>#</td>
	    			<td><?php echo _BOOKLIBRARY_LABEL_BOOKID;?></td>
	    			<td><?php echo _BOOKLIBRARY_LABEL_ISBN;?></td>
	    			<td><?php echo _BOOKLIBRARY_LABEL_TITLE;?></td>
	    			<td><?php echo _BOOKLIBRARY_LABEL_AUTHORS;?></td>
	    			<td><?php echo _BOOKLIBRARY_LABEL_LANGUAGE;?></td>
	    			<td><?php echo _BOOKLIBRARY_LABEL_STATUS;?></td>
	    		</tr>
			<?php foreach ($table as $entry){
			?>
				<tr>
	    			<td><?php echo $entry[0]; ?></td>
	    			<td><?php echo $entry[1]; ?></td>
	    			<td><?php echo $entry[2]; ?></td>
	    			<td><?php echo $entry[3]; ?></td>
	    			<td><?php echo $entry[4]; ?></td>
	    			<td><?php echo $entry[5]; ?></td>
	    			<td><?php echo $entry[6]; ?></td>
	    		</tr>
			<?php
			}
			?>
				</table>
				<input type="hidden" name="option" value="<?php echo $option;?>" />
				<input type="hidden" name="task" value="cancel" />
			</form>	
<?php	
	}

	function showExportResult($InformationArray, $option){
	?>
	<form action="index2.php" method="post" name="adminForm" id="adminForm">
 	
	  <div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>
      <script language="Javascript" src="<?php echo $mosConfig_live_site;?>/includes/js/overlib_mini.js"></script>

     <table border="0" class="adminheading" cellpadding="0" cellspacing="0" width="100%">
      <tr valign="middle">
        <th class="config"><?php echo _BOOKLIBRARY_SHOW_IMPEXP_RESULT;?></th>
        <td align="right"></td>
      </tr>
      </table>
	
		<?php echo _BOOKLIBRARY_SHOW_IMPEXP_RESULT_DOWNLOAD;?>  </br>
		<a href="<?php echo $InformationArray['urlBase'] . $InformationArray['out_file']; ?>" target="blank"><?php echo $InformationArray['urlBase'] . $InformationArray['out_file']; ?></a>
  		</br>
  		<?php echo _BOOKLIBRARY_SHOW_IMPEXP_RESULT_REMEBER;?>  </br>  
			<input type="hidden" name="option" value="<?php echo $option;?>" />
			<input type="hidden" name="task" value="cancel" />
		</form>	
<?php	
	}


}
?>