<?php

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );
/**
* Booklibrary Lend Class
* Holds all Information about a lend entry
* @package Booklibrary
* @copyright 2005 Gerd Saurer http://booklibrary.mamboforge.net
* @license http://www.gnu.org/copyleft/gpl.html GNU Public License
* @version $Revision: 1.0 $
*/
class mosBooklibrary_review extends mosDBTable {
	/** @var int Primary key */
	var $id = null;
	/** @var int the book id this lend is assosiated with*/
	var $fk_bookid=null;	
	/** @var int the user id of the user who lend this book can also be null if $user_name is set*/
	var $fk_userid=null;
	/** @var datetime adding this review*/
	var $date=null;
	/** @var the comment to this */
	var $comment=null;
	/** @var titel */
	var $title= null;
	/** @var rating */
	var $rating= 0;
	/** @var boolean */
	var $checked_out=null;
	/** @var time */
	var $checked_out_time=null;
	
	/**
	* @param database A database connector object
	*/
	function mosBookLibrary_review( &$db ) {
		$this->mosDBTable( '#__booklibrary_review', 'id', $db );
	}
	
	/**
	 * @return array - name: The sting of the User the book is lend to - email: The email adress of the user
	 */
	function getReviewFrom(){
		$retVal['name'] = null;
		$retVal['email'] = null;
		if($this->fk_userid != null && $this->fk_userid != 0){
			$this->_db->setQuery( "SELECT name, email from #__users where id=$this->fk_userid");
			$help = $this->_db->loadRow();
			$retVal['name'] = $help[0];
			$retVal['email'] = $help[1];
		}
		else{
			$retVal['name'] = _BOOKLIBRARY_LABEL_ANONYMUS;
			$retVal['email'] = null;
		}
		return $retVal;
	}
	
	function toXML(& $xmlDoc){
		
		//create and append name element 
		$retVal = & $xmlDoc->createElement("review"); 
		
		$fk_userid = & $xmlDoc->createElement("fk_userid");
		$fk_userid->appendChild($xmlDoc->createTextNode($this->fk_userid));
		$retVal->appendChild(& $fk_userid);
		
		$rating = & $xmlDoc->createElement("rating");
		$rating->appendChild($xmlDoc->createTextNode($this->rating));
		$retVal->appendChild(& $fk_userid);

		$title = & $xmlDoc->createElement("title");
		$title->appendChild($xmlDoc->createCDATASection($this->title));
		$retVal->appendChild(& $title);

		$comment = & $xmlDoc->createElement("comment");
		$comment->appendChild($xmlDoc->createCDATASection($this->comment));
		$retVal->appendChild(& $comment);		
		
		return $retVal;
	}
}
?>