<?php
/**
 * OpenSEF for Joomla!
 * @copyright (c) 2005 The OpenSEF Project (www.opensef.org)
 * @copyright (c) 2004-2005 Xaneon Development (www.xaneon.com)
 * @license GPL http://www.gnu.org/copyleft/gpl.html
 *
 * TODO
 *
 */

/** Ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct access to this location is not allowed.' );

require_once( $mainframe->getPath( 'class' ) );
require_once( 'sef.functions.php' );
require_once( 'core/sef.security.php' );
require_once( 'core/sef.resolver.php' );
require_once( 'core/sef.rewriter.php' );
require_once( 'core/sef.mapper.php' );
require_once( 'includes/sef.backend.php' );

$sefReservedNames = array(
  'CHANGELOG',
  'INSTALL',
  'LICENSE',
  'administrator',
  'cache',
  'components',
  'configuration.php',
  'editor',
  'globals.php',
  'help',
  'htaccess.txt',
  'images',
  'includes',
  'index.php',
  'index2.php',
  'installation',
  'language',
  'mainbody.php',
  'mambots',
  'media',
  'modules',
  'offline.php',
  'pathway.php',
  'robots.txt',
  'templates',
);

/*
 * TODO
 */
class mosSEFAdmin extends xclBackendAdmin {

  /*
   * TODO
   */
  function do_config_save() {
    $this->storeComponentAliases( null );
    parent::do_config_save();
  }

  /*
   * TODO
   */
  function config( &$row ) {
  	global $mosConfig_absolute_path;
    $sites = $this->getSiteList();
    $langs 		= array();
    
    if ($handle = opendir( $mosConfig_absolute_path . '/administrator/components/com_sef/language/' )) {
		$i=0;
		while (false !== ($file = readdir( $handle ))) {
			if (!strcasecmp(substr($file,-4),".ini") && $file != "." && $file != ".." ) {
				$langs[] = mosHTML::makeOption( substr($file,0,-4) );
			}
		}
	}
	// sort list of languages
	sort( $langs );
	reset( $langs );
    
	$titles = array(
      'title' => _T( 'TITLE' ),
      'title_alias' => _T( 'TITLE_ALIAS' ),
    );
    $titles2 = array(
      'title' => _T( 'TITLE' ),
      'name' => _T( 'NAME' ),
    );
    $paths = array(
      'full' => '/Section/Category/Title',
      'section' => '/Section/Title',
      'category' => '/Category/Title',
      //'pathway' => '/Pathway/Title', // TODO
    );
    $validation = array(
      '0' => 'None',      // No checking so anything goes; Joomla! default
      '1' => 'Normal',    // Alias lookup, begins with /content, begins with /component
      '2' => 'Strict',    // Alias lookup, content item exists, begins with /component
      '3' => 'Lockdown',  // Alias lookup only
    );
    
    $section = 'CONFIG';

    // Slight hack.
    $enabled_field = xclHTML::yesNoSelect  ( $this->tpl, $section, 'enabled' );
    if (empty( $row->enabled ))
      $enabled_field->help = '<span style="color:red">' . $enabled_field->help . '</span>';

    $form = array(
      _T( 'BASIC' ) => array(
        _T( 'BASIC_SETTINGS' ) => array(
          $enabled_field,
          xclHTML::selectLangs  ( $this->tpl, $section, 'backend_language', $langs, $this->config->backend_language ),
          xclHTML::yesNoSelect  ( $this->tpl, $section, 'backend_sidebar' ),
          xclHTML::yesNoSelect  ( $this->tpl, $section, 'backend_autoupdates' ),
        ),
      ),
      _T( 'SEF' ) => array(
        _T( 'SEF_ENCODING' ) => array(
          xclHTML::yesNoSelect  ( $this->tpl, $section, 'encode_lowercase' ),
          xclHTML::textbox      ( $this->tpl, $section, 'encode_page_suffix', 10 ),
          xclHTML::textbox      ( $this->tpl, $section, 'encode_space_char', 5 ),
          xclHTML::textbox      ( $this->tpl, $section, 'encode_strip_chars', 20 ),
        ),
        _T( 'CONTENT_URLS' ) => array(
          xclHTML::select       ( $this->tpl, $section, 'content_path_type', $paths ),
          xclHTML::select       ( $this->tpl, $section, 'section_title_field', $titles2 ),
          xclHTML::select       ( $this->tpl, $section, 'category_title_field', $titles2 ),
          xclHTML::select       ( $this->tpl, $section, 'content_title_field', $titles ),
          xclHTML::textbox      ( $this->tpl, $section, 'content_page_format', 10 ),
        ),
        _T( 'URL_VALIDATION' ) => array(
          xclHTML::select       ( $this->tpl, $section, 'validate_level', $validation ),
          xclHTML::textbox      ( $this->tpl, $section, 'validate_404_url', 20 ),
        ),
      ),
       _T( 'LANGCHAR' ) => array(
        _T( 'CHARREPLACE' ) => array(
          xclHTML::textarea      ( $this->tpl, $section, 'spec_chars_d', 5, 50 ),
               
        ),
         _T( 'CHARREPLACEWITH' ) => array(
            xclHTML::textarea      ( $this->tpl, $section, 'spec_chars', 5, 50 ),
         
        ),
      ),
       _T( 'COREALIAS' ) => array(
        _T( 'CORECOMPONENTS' ) => array(
          xclHTML::textbox2      ( $this->tpl, $section, 'alias_contact','use_alias_contact', 20 ),
          xclHTML::textbox2      ( $this->tpl, $section, 'alias_newsfeeds','use_alias_newsfeeds', 20 ),
          xclHTML::textbox2      ( $this->tpl, $section, 'alias_links','use_alias_links', 20 ),
          xclHTML::textbox2      ( $this->tpl, $section, 'alias_wrapper','use_alias_wrapper', 20 ),
        ),
      ),
       _T( 'COMPONENTS' ) => array(
        _T( 'COMPONENT_LINKS' ) => 'form_components',
      ),
      _T( 'FEATURES' ) => array(
        _T( 'FEATURES' ) => array(
          xclHTML::yesNoSelect  ( $this->tpl, $section, 'use_multisite' ),
          xclHTML::yesNoSelect  ( $this->tpl, $section, 'use_automap' ),
          xclHTML::yesNoSelect  ( $this->tpl, $section, 'use_automap_redirect' ),
          xclHTML::yesNoSelect  ( $this->tpl, $section, 'use_sef_ext' ),
          xclHTML::yesNoSelect  ( $this->tpl, $section, 'use_canonical_urls' ),
          xclHTML::yesNoSelect  ( $this->tpl, $section, 'use_absolute_urls' ),
          xclHTML::yesNoSelect  ( $this->tpl, $section, 'use_session_fix' ),
          xclHTML::yesNoSelect  ( $this->tpl, $section, 'record_unmapped_urls' ),
          xclHTML::yesNoSelect  ( $this->tpl, $section, 'record_invalid_urls' ),
          xclHTML::yesNoSelect  ( $this->tpl, $section, 'record_hits' ),
        ),
      ),
      _T( 'ADVANCED' ) => array(
        _T( 'ADVANCED_SETTINGS' ) => array(
          xclHTML::rangeSelect  ( $this->tpl, $section, 'max_recursion', 0, 3 ),
        ),
        _T( 'DEBUG_OPTIONS' ) => array(
          xclHTML::yesNoSelect  ( $this->tpl, $section, 'debug' ),
          xclHTML::textbox      ( $this->tpl, $section, 'debug_for_ip', 20 ),
        ),
        //_T( 'CACHING' ) => array(),
      ),
    );

    $site =& new mosSEFSite( $this->db, -1 );
    $this->tpl->assign( 'site', $site );
    $this->tpl->assign( 'mapper',
      sefLoadAutoMapper( $this->db, $this->config, $site ) );
    $this->tpl->assign( 'menus', $this->getMenuComponents() );
    $this->tpl->assign( 'form', $form );
    $this->tpl->assign( 'title', 'Edit Configuration' );
    $this->tpl->assign( 'bold', true );
    $this->tpl->assign( 'icon', 'config' );
  }

  /*
   * TODO
   */
  function mosSEFAdmin() {
    $config =& new mosSEFConfig( $GLOBALS['database'], true );
    $GLOBALS['sefConfig'] =& $config;
    $tables = array(
      'sites'   => '#__sef_site',
      'aliases' => '#__sef',
    );
    $classes = array(
      'sites'   => 'mosSEFSite',
      'aliases' => 'mosSEFAlias',
    );
    $this->xclBackendAdmin( $config, $tables, $classes );
  }

  /*
   * TODO
   */
  function header() {
    $query = "SELECT * FROM #__survey WHERE published = '1'" .
      "\nORDER BY created DESC, title ASC";
    $this->db->setQuery( $query ); 
    /*$sites = $this->db->loadObjectList();
    $sites = xclCastObjectList( $sites, "mosSurvey" );
    $this->tpl->assign( "sites", $sites );*/
    parent::header();
  }

  /*
   * TODO
   */
  function do_postinstall() {
    $this->do_about();
  }

  /*
   * TODO
   */
  function do_about() {
    $this->tpl->assign( 'links', array(
      _T( 'FAQ_LONG' ) => 'http://www.open-sef.org/documentation/faq/',
      _T( 'USER_MANUAL' ) => 'http://www.open-sef.org/documentation/index.html',
      _T( 'SUPPORT_FORUM' ) => 'http://www.open-sef.org/forum/',
      _T( 'LATEST_VERSION' ) => 'http://www.open-sef.org/downloads.html',
      _T( 'DEVELOPMENT_SITE' ) => 'http://forge.joomla.org/sf/projects/opensef',
    ));
    parent::do_about();
  }

  /*
   * TODO
   */
  function view_sites( &$view ) {
    $view->title = _T( 'SITES' );
    $view->icon = 'categories';
    $view->orderBy[] = 'host ASC';
    $view->orderBy[] = 'base_url ASC';
    $view->search = $this->db->getEscaped( trim( strtolower(
      $this->mainframe->getUserStateFromRequest( "search{$this->option}", "search", null ) ) ) );
    if ($view->search != "") {
      $view->wheres[] = "(title LIKE '%$view->search%'" .
        " OR host LIKE '%$view->search%'" .
        " OR base_url LIKE '%$view->search%')";
    }
  }

  /*
   * TODO
   */
  function view_aliases( &$view ) {
    $view->title = _T( 'FRIENDLY_URLS' );
    $view->icon = 'browser';
    $view->orderBy = array( "site_id DESC", "external ASC", "direction DESC" );
    $view->sites = $this->getSiteList();
    $view->site_id = $this->db->getEscaped(
      $this->mainframe->getUserStateFromRequest( "site_id{$this->option}", "site_id", null ) );
    if ($view->site_id != '') {
      $view->wheres[] = "(site_id = '$view->site_id')";
    }
    $view->filters = array(
      ''          => '(' . _T( 'ALL' ) . ')',
      'published' => '(' . _T( 'PUBLISHED' ) . ')',
      'invalid'   => '(' . _T( 'INVALID' ) . ')',
      'unmapped'  => '(' . _T( 'UNMAPPED' ) . ')',
      'redirects' => '(' . _T( 'REDIRECTS' ) . ')',
    );
    $view->filter = $this->db->getEscaped(
      $this->mainframe->getUserStateFromRequest( "filter{$this->option}", "filter", null ) );
    if ($view->filter != '') {
      switch ($view->filter) {
        case 'published':
          $view->wheres[] = "(valid = '1' AND published = '1')";
          break;
        case 'invalid':
          $view->wheres[] = "(valid = '0')";
          break;
        case 'unmapped':
          $view->wheres[] = "(valid = '1' AND published = '0')";
          break;
        case 'content':
          $view->wheres[] = "(internal LIKE '%com_content%')";
          break;
        case 'redirects':
          $view->wheres[] = "(internal LIKE 'http%://%')";
          break;
        /*case 'top10':
          $view->limitstart = 0;
          $view->limit = 10;
          $view->orderBy = array_merge( array( 'hits DESC' ), $view->orderBy );
          break;*/
      }
    }
    $view->search = $this->db->getEscaped( trim( strtolower(
      $this->mainframe->getUserStateFromRequest( "search{$this->option}", "search", null ) ) ) );
    if ($view->search != "") {
      $filter = "(external LIKE '%$view->search%'" .
        " OR internal LIKE '%$view->search%'";
      if (sefIsJoomlaSEF( $view->search ))
        $filter .= " OR internal LIKE '%" . sefRewriteFromJoomlaSEF( $view->search ) . "%'";
      $filter .= " OR notes LIKE '%$view->search%')";
      $view->wheres[] = $filter;
    }
  }

  /*
   * TODO
   */
  function do_sites() {
    switch ($this->task) {
      case 'publish':
      case 'unpublish':
        $this->update( 'published', ($this->task == 'publish'), false );
        return $this->redirect();
      case 'setpublished':
      case 'setaccess':
      case 'setoffline':
        $field = substr( $this->task, strlen( 'set' ) );
        $value = max( min( intval( $this->taskParam ), 2 ), 0 );
        $this->update( $field, $value, false );
        return $this->redirect();
      case 'save':
        if (!empty( $_POST['id'] ))
          $this->storeComponentAliases( $_POST['id'] );
        // fall through to default handler
      default:
        return $this->_default();
    }
  }

  /*
   * TODO
   */
  function do_aliases() {
    switch ($this->task) {
      case 'publish':
      case 'unpublish':
        $this->update( 'published', ($this->task == 'publish'), false );
        return $this->redirect();
      case 'setpublished':
      case 'setvalid':
      case 'setstop':
        $field = substr( $this->task, strlen( 'set' ) );
        $value = max( min( intval( $this->taskParam ), 1 ), 0 );
        $this->update( $field, $value, false );
        return $this->redirect();
      default:
        return $this->_default();
    }
  }

  /*
   * TODO
   */
  function form_sites( &$row ) {
    $accessLevels = array(
      0 => _T( 'PUBLIC' ),
      1 => _T( 'REGISTERED' ),
      2 => _T( 'SPECIAL' ),
    );
    $errorReporting = array(
      null => _T( 'USE_GLOBAL' ),
      -1 => 'System Default',
      0 => 'None',
      7 => 'Simple',
      2047 => 'Maximum',
    );
    $langs = array_merge(
      array( null => _T( 'USE_GLOBAL' ) ),
      xclGetLangTitles( true ) );

    $section = 'SITE';
    $fields1 = array(
      xclHTML::textbox      ( $this->tpl, $section, 'host' ),
      xclHTML::textbox      ( $this->tpl, $section, 'base_url' ),
      xclHTML::textbox      ( $this->tpl, $section, 'title' ),
      xclHTML::yesNoSelect  ( $this->tpl, $section, 'published' ),
      xclHTML::select       ( $this->tpl, $section, 'access', $accessLevels ),
    );
    $fields2 = array(
      xclHTML::textbox      ( $this->tpl, $section, 'sitename' ),
      xclHTML::select       ( $this->tpl, $section, 'lang', $langs ),
      xclHTML::rangeSelect  ( $this->tpl, $section, 'offset', -24, 24, true ),
      xclHTML::textbox      ( $this->tpl, $section, 'locale', 20 ),
      null,
      xclHTML::yesNoSelect  ( $this->tpl, $section, 'offline', true ),
      xclHTML::yesNoSelect  ( $this->tpl, $section, 'debug', true ),
      xclHTML::select       ( $this->tpl, $section, 'error_reporting', $errorReporting ),
      null,
      xclHTML::textarea     ( $this->tpl, $section, 'metadesc' ),
      xclHTML::textarea     ( $this->tpl, $section, 'metakeys' ),
    );

    $form = array(
      _T( 'DETAILS' ) => array( _T( 'DETAILS' ) => &$fields1 ),
      _T( 'OVERRIDES' ) => array( _T( 'OVERRIDES' ) => &$fields2 ),
    );
    if (!empty( $row->id ))
      $form[_T( 'COMPONENTS' )] = 'form_components';

    $valids = array(
      'host' => 'Please fill in the Domain Name.',
      'base_url' => 'Please fill in the Base URL.',
      'title' => 'Please fill in the Title.',
    );

    $this->tpl->assign( 'site', $row );
    $this->tpl->assign( 'mapper',
      sefLoadAutoMapper( $this->db, $this->config, $row ) );
    $this->tpl->assign( 'menus', $this->getMenuComponents() );
    $this->tpl->assign( 'form', $form );
    $this->tpl->assign( 'validation', $valids );
    $title = $this->tpl->data->title;
    $this->tpl->assign( 'title', !$this->tpl->id ? 'New Site' :
      (empty( $title ) ? 'Edit Site' : "Edit Site '{$title}'") );
  }

  /*
   * TODO
   */
  function form_aliases( &$row ) {
    $sites = $this->getSiteList();
    $directions = array(
      null => '(Both)',
      'i' => 'Incoming',
      'o' => 'Outgoing',
    );

    $section = 'ALIAS';
    $fields = array(
      xclHTML::select       ( $this->tpl, $section, 'site_id', $sites ),
      null,
      xclHTML::textbox      ( $this->tpl, $section, 'external' ),
      xclHTML::textbox      ( $this->tpl, $section, 'internal' ),
      null,
      xclHTML::yesNoSelect  ( $this->tpl, $section, 'published' ),
      null,
      xclHTML::textarea     ( $this->tpl, $section, 'notes' ),
    );
    $fields2 = array(
      xclHTML::select       ( $this->tpl, $section, 'direction', $directions ),
      null,
      xclHTML::yesNoSelect  ( $this->tpl, $section, 'valid' ),
      xclHTML::yesNoSelect  ( $this->tpl, $section, 'stop' ),
      null,
    );

    $form = array(
      _T( 'DETAILS' ) => array( _T( 'DETAILS' ) => &$fields ),
      _T( 'ADVANCED' ) => array( _T( 'ADVANCED' ) => &$fields2 ),
    );

    $valids = array(
      'external' => 'Please fill in the Friendly URL.',
      'internal' => 'Please fill in the Internal URL.',
    );

    $this->tpl->assign( 'form', $form );
    $this->tpl->assign( 'validation', $valids );
    $title = $this->tpl->data->external;
    $this->tpl->assign( 'title', !$this->tpl->id ? 'New Friendly URL' :
      (empty( $external ) ? 'Edit Friendly URL' : "Edit Friendly URL '{$external}'") );
  }

  /*
   * TODO
   */
  function do_tools( $show = 'setup' ) {
    $this->tpl->assign( 'xml', $this->xml );
    $this->tpl->assign( 'config', $this->config );
    $this->tpl->assign( 'show', mosGetParam( $_REQUEST, 'show', $show ) );
    $this->display( 'tools' );
  }

  /*
   * TODO
   */
  function do_tools_debug() {

    $debug_url = mosGetParam( $_REQUEST, 'debug_url', '' );
    $direction = mosGetParam( $_REQUEST, 'debug_direction', 'incoming' );

    $url = @parse_url( $debug_url );

    if ($url === false || !is_array( $url )
        || @$url['scheme'] != 'http'
        || @$url['host'] == '') {
      $this->tpl->assign( 'debug_result', false );
      $this->tpl->assign( 'debug_log',
        array( '--- Unable to parse URL: ' . $debug_url ) );
      $this->do_tools();
      return;
    }

    $host = $url['host'];
    $url = (!isset( $url['path'] ) ? '' :
      $url['path'] . (isset( $url['query'] ) ? '?' . $url['query'] : '')); //qs

    if (!empty( $this->config->use_multisite ))
      $site =& mosSEFSite::lookup( $host, $url );
    if (!isset( $site ))
      $site =& mosSEFSite::getDefault();

    if ($direction == 'incoming') {

      $className = 'sefAutoMapper';
      $autoMapper =& new $className( $database, $this->config, $site );  
      $autoMapper->setDebug( true );
      $className = 'sefResolver';
      $resolver =& new $className( $database, $this->config, $site );
      $resolver->setDebug( true );
      $resolver->setAutoMapper( $autoMapper );

      // TODO: add debug parameters for recursion control.
      $result = $resolver->resolve( $url );
      $this->tpl->assign( 'debug_result', $result );
      $this->tpl->assign( 'debug_log', $resolver->getLog() );

    }
    else { // $direction == 'outgoing'

      // TODO: simulating outgoing rewriting.

    }

    $this->do_tools();
  }

  /*
   * TODO
   */
  function do_tools_import() {
    $title = 'Importing Data...';
    $success = true;
    $log = array();

    $source = mosGetParam( $_REQUEST, 'import_source', null );

    switch ($source) {
      case 'alias':
        $sites = (mosGetParam( $_REQUEST, 'import_sites', '0' ) == '1');
        $preserve = (mosGetParam( $_REQUEST, 'import_preserve', '0' ) == '1');
        $remove = (mosGetParam( $_REQUEST, 'import_remove', '0' ) == '1');
        $query = "SELECT DISTINCT language FROM #__alias " .
          "WHERE language IS NOT NULL AND language != '' ORDER BY language ASC";
        $this->db->setQuery( $query );
        $rows = @$this->db->loadObjectList();
        if (!is_array( $rows )) {
          $success = false;
          $log[] = "<span style='color:red'>ERROR: Couldn't locate data table ('mos_alias') for Xaneon Alias Manager 1.0.3.</span>";
        }
        else {
          if ($sites && count( $rows ) > 0) {
            $defsite =& new mosSEFSite( $this->db, -1 );
            $sites = array();
            foreach ($rows as $oldlang) {
              $lang = $oldlang->language;
              $langTitle = xclGetLangTitle( $lang );
              $row =& new mosSEFSite( $this->db );
              $row->title = $langTitle;
              $row->published = '1';
              $row->host = $defsite->host;
              $row->base_url = $defsite->base_url;
              $row->lang = $row->locale = $lang;
              if (!@$row->store()) {
                $log[] = "Creating site for language '$lang' failed, there probably already exists a site (duplicate keys).";
              }
              else {
                $id = $this->db->insertid();
                $sites[$lang] = (!empty( $id ) ? $id : null);
                $log[] = "Created site for language '$lang' ($langTitle).";
              }
            }
          }
          else {
            $sites = array();
          }
          $query = "SELECT * FROM #__alias ORDER BY id ASC";
          $this->db->setQuery( $query );
          $rows = $this->db->loadObjectList();
          $row_count = 0;
          foreach ($rows as $oldrow) {
            $row_count++;
            $site_id = (!empty( $sites[$oldrow->language] ) ? $sites[$oldrow->language] : null);
            $id = ($preserve ? $oldrow->id : null);
            $row =& new mosSEFAlias( $this->db, $id );
            $row->id = $id;
            if (is_null( $id )) {
              $row->site_id = $site_id;
              $row->direction = null;
              $row->valid = '1';
              $row->stop = '0';
              $row->catid = null;
              $row->hits = 0;
              $row->notes = 'Imported from Alias Manager 1.0.3';
            }
            if (sefIsJoomlaSEF( $oldrow->target ))
              $oldrow->target = sefRewriteFromJoomlaSEF( $oldrow->target );
            if (@$oldrow->target[0] == '/')
              $oldrow->target = substr( $oldrow->target, 1 );
            $row->internal = $oldrow->target;
            $row->external = $oldrow->url;
            $row->published = !empty( $oldrow->published ) ? '1' : '0';
            if (!@$row->check() || !@$row->store()) {
              $log[] = "Importing '$row->external' => '$row->internal'... FAILED!";
            }
            else {
              $log[] = "Importing '$row->external' => '$row->internal'... OK";
            }
          }
          $log[] = "Successfully imported $row_count rows in total.";
        }
        if ($remove) {
          $this->db->setQuery( 'DROP TABLE #__alias' );
          $this->db->query();
          $log[] = 'Removed old data table.';
        }
        break;
        
      default:
        $success = false;
        $log[] = "This feature is still under construction.";
    }

    $this->tpl->assign( 'title', $title );
    $this->tpl->assign( 'success', $success );
    $this->tpl->assign( 'log', $log );
    $this->display( 'action' );
  }

  /*
   * TODO
   */
  function do_tools_export() {
    $title = 'Exporting Data...';
    $success = true;
    $log = array();

    require_once( 'sef.export.php' );

    $format = mosGetParam( $_REQUEST, 'export_format', null );
    $tables = array(
      '#__sef_site' => _T( 'SITES' ),
      '#__sef' => _T( 'FRIENDLY_URLS' ),
      '#__opensef_config' => _T( 'CONFIGURATION' ),
    );
    $tableFilter = mosGetParam( $_REQUEST, 'export_table', null );
    if (!empty( $tableFilter ) && $tableFilter != '') {
      foreach (array_keys( $tables ) as $table) {
        if (!ereg( "^#__$tableFilter", $table ))
          unset( $tables[$table] );
      }
    }

    switch ($format) {
      case 'sql':
        $export =& new xclExportSQL( $this->db );
        if (!$export->open()) {
          $success = false;
          $log[] = "Failed to open file " . $export->getFilePath();
        }
        else {
          $export->writeText( _T( 'APP_NAME' ) . ' ' . $this->version . ' (opensef.org)' );
          $export->writeText( 'Export of database ' . $GLOBALS['mosConfig_db'] );
          $export->writeText( date( "Y-m-d H:i:s" ) );
          $tablePrefix = $export->getTablePrefix();
          foreach ($tables as $table => $tableTitle) {
            if ($table == '#__opensef_config') {
              $export->addFilter( "(scope = '{$this->option}')" );
              $export->setSortField( 'name' );
            }
            else {
              $export->clearFilters();
              $export->setSortField( null );
            }
            $table = str_replace( '#__', $tablePrefix, $table );
            $rowCount = $export->exportTable( $table, $tableTitle );
            $log[] = 'Exporting ' . strtolower( $tableTitle ) . ' from table ' . $table .
              ' => ' . $rowCount . ' records exported.';
          }
          $log[] = '<p><a target="_blank" href="' . $export->getURL() . '">[ Download Results ]</a>';
          $export->close();
        }
        break;
      default:
        $success = false;
        $log[] = "This feature is still under construction.";
    }

    $this->tpl->assign( 'title', $title );
    $this->tpl->assign( 'success', $success );
    $this->tpl->assign( 'log', $log );
    $this->display( 'action' );
  }

  /*
   * TODO
   */
  function do_tools_feedback() {
  	GLOBAL $_VERSION;
    $title = 'Sending Feedback...';
    $success = true;
    $log = array();

    // TODO: why is stripslashes necessary here, why doesn't mosGetParam do it?
    $from = stripslashes( mosGetParam( $_REQUEST, 'feedback_from', null ) );
    $type = mosGetParam( $_REQUEST, 'feedback_type', null );
    $body = stripslashes( mosGetParam( $_REQUEST, 'feedback_body', null ) );

    if (empty( $from ) || empty( $type ) || empty( $body )) {
      $success = false;
      $log[] = "Missing information, please go back and check the form.";
    }
    else {
      $types = array( // These will remain in English on purpose
        'feedback'  => 'Feedback',
        'feature'   => 'Feature Suggestion',
        'bugreport' => 'Bug Report',
      );
      if (true) {
        $div = str_repeat( '-', 72 ) . "\n";
        // TODO: perhaps would be useful to add information also on
        // PHP safe mode, MySQL version, and HTTP user agent??
        // Definitely need to add core/SEF ext info...
       	$version = $_VERSION->PRODUCT .' '. $_VERSION->RELEASE .'.'. $_VERSION->DEV_LEVEL;
        $infos = array(
          'Component'     => _T( 'APP_NAME' ) . ' ' . $this->version,
          'Site URL'      => $this->JoomlaSite,
          'Joomla! Version' => $version,
          'PHP Version'   => phpversion(),
          'Web Server'    => $_SERVER['SERVER_SOFTWARE'],
          'Language'      => $GLOBALS['mosConfig_lang'],
          'Locale'        => $GLOBALS['mosConfig_locale'],
          'SEF Enabled'   => $GLOBALS['mosConfig_sef'] == '1' ? 'Yes' : 'No',
        );
        $info = '';
        foreach ($infos as $title => $text)
          $info .= $title . ': ' . $text . "\n";
      }
      else {
        $info = 'The customer chose not to include any technical details.';
      }
      $body .= "\n\n" . $div . $info . $div;
      $subject = _T( 'APP_NAME' ) . ' ' . $types[$type] . ' from ' . $from;
      $fromName = trim( $GLOBALS['mosConfig_fromname'] );
      $to = 'info@open-sef.org';
      $success = (mosMail( $from, $fromName, $to, $subject, $body ) ? true : false);
      if (!$success) {
        $title = "Error Sending Feedback";
        $log[] = '<span style="color:red; font-weight:bold;">Unable to send e-mail, please check your Joomla! settings.</span>';
        $log[] = '';
      }
      else {
        $title = "Feedback Sent Successfully";
      }
      $log[] = '<b>' . "From:" . '</b> ' . $from;
      $log[] = '<b>' . "To:" . '</b> ' . $to;
      $log[] = '<b>' . "Subject:" . '</b> ' . $subject;
      $log[] = '';
      $log[] = str_replace( "\n", "<br />", $body );
    }

    $this->tpl->assign( 'title', $title );
    $this->tpl->assign( 'success', $success );
    $this->tpl->assign( 'log', $log );
    $this->tpl->assign( 'backLink', true );
    $this->display( 'action' );
  }

  /*
   * TODO
   */
  function getSiteList() {
    $query = 'SELECT id, title, host, base_url FROM ' .
      $this->tables['sites'];
    $this->db->setQuery( $query );
    $rows = $this->db->loadObjectList();
    $sites = array(
      null => '(' . _T('ALL') . ')',
      -1 => '(' . _T('DEFAULT_ONLY') . ')',
    );
    if (is_array( $rows ) && count( $rows ) > 0) {
      foreach ($rows as $row) {
        $sites[$row->id] = $row->title;
      }
    }
    return $sites;
  }

  /*
   * TODO
   */
  function getMenuComponents() {
    $query = "SELECT m.* FROM #__menu AS m" .
      "\nWHERE type = 'components'" .
      "\nAND published <> -2" .
      "\nAND link !='index.php?option=com_wrapper'" .
      "\nAND link !='index.php?option=com_weblinks'" .
      "\nAND link !='index.php?option=com_contact'" .
      "\nAND link !='index.php?option=com_newsfeeds'" .
      "\nORDER BY menutype ASC, componentid ASC, ordering ASC, name ASC";
    $this->db->setQuery( $query );
    $rows = $this->db->loadObjectList();
    // Establish the hierarchy of the menu
    $children = array();
    // First pass - collect children
    foreach ($rows as $row) {
      $pt = $row->parent;
      $list = @$children[$pt] ? $children[$pt] : array();
      array_push( $list, $row ); 
      $children[$pt] = $list;
    }
    // Second pass - get an indent list of the items
    return mosTreeRecurse( 0, '', array(), $children );
  }

  /*
   * TODO
   */
  function storeComponentAliases( $site_id ) {
    if (isset( $_POST['_alias'] ) && is_array( $_POST['_alias'] )) {

      // Delete any existing component aliases for this site
      $query = "DELETE FROM #__sef_component" .
        "\nWHERE site_id " . ($site_id ? "= '{$site_id}'" : 'IS NULL');
      $this->db->setQuery( $query );
      $result = $this->db->query();

      // If there were any component aliases defined, re-insert
      // them into the component table
      if (isset( $_POST['_component'] )) {
        $components = $_POST['_component'];
        $aliases = $_POST['_alias'];
        foreach ($components as $component => $mappings) {
          foreach ($mappings as $menuid => $enabled) {
            $alias = $aliases[$component][$menuid];
            if ($enabled == '1' && $alias) {
              $row =& new mosSEFComponent( $this->db );
              $row->site_id = $site_id;
              $row->menu_id = $menuid;
              $row->component = $component;
              $row->alias = $alias;
              $row->ordering = 0;
              $row->published = '1';
              $row->store();
            }
          }
        }
        unset( $_POST['_alias'] );
        unset( $_POST['_component'] );
      }

    }
  }

}

$admin =& new mosSEFAdmin();
$admin->output();

?>