<?php
/////////////////////////////////////////////////////////////////////////////
// FQ - Correos multiples                                                  //
// Copyright (C) 2004-2005                                                 //
// http://www.brutalidadtotal.com                                          //
// FQ es un componente para Mambo 4.5.                                     // 
// Este componente permite enviar correos a usuarios registrados en        //
// diferentes grupos. Puede enviar correos en formato HTML o solo TEXTO.   //
// Este componente es un programa gratis; usted puede redistribuirlo y/o   //
// modificarlo bajo terminos de Licencia GNU.                              //
//----------------------------------------------------------------------   //
// $Id: class.subscribers.php,v 1.0 2004/12/23 17:00:12                    //
/////////////////////////////////////////////////////////////////////////////

defined( '_VALID_MOS' ) or die( 'El acceso directo no esta permitido a esta pagina.' );

class subscribers{
  function getSubscribers($id, $confirmed = '', $start = '', $limit = '', $ordering = 'id', $sort = 'ASC', $search = ''){
    global $database;
      if ($id==0) {
		$query = "SELECT list_id, subscriber_id AS id, subscriber_name AS name, subscriber_email AS email, confirmed, subscribe_date, receive_html, delete_id 
		FROM #__fq_subscribers WHERE delete_id=0 ";
		if(!empty($search)){
		  $query .= "AND (subscriber_name LIKE '%$search%' 
		  OR subscriber_email LIKE '%$search%') ";
		}
      } else {
		$query = "SELECT list_id, subscriber_id AS id, subscriber_name AS name, subscriber_email AS email, confirmed, subscribe_date, receive_html, delete_id  
		FROM #__fq_subscribers WHERE delete_id=0 AND list_id = " . $id . " " . $confirmed . " ";
		
		if(!empty($search)){
		  $query .= "AND (subscriber_name LIKE '%$search%' 
		  OR subscriber_email LIKE '%$search%') ";
		}
      }		
		$query .= "ORDER BY " . $ordering . " " . $sort;
		if(!empty($start) || (!empty($limit))){
		  $query = $query . " LIMIT $start, " . $limit;
		}
		$database->setQuery($query);
		$total = $database->loadObjectList();
		echo $database->getErrorMsg();
		return $total;
  }
	
  function getTotalSubscribers($id, $search = ''){
    global $database;
	if ($id==0) {
	  $query = "SELECT count(1) AS aantal FROM #__fq_subscribers WHERE delete_id=0 ";
		if(!empty($search)){
		  $query .= " AND (subscriber_name LIKE '%$search%' 
		  OR subscriber_email LIKE '%$search%') ";
		}
    } else {
      $query = "SELECT count(1) AS aantal FROM #__fq_subscribers WHERE delete_id=0 AND list_id = " . $id;
	  if(!empty($search)){
	    $query .= " AND (subscriber_name LIKE '%$search%' 
		OR subscriber_email LIKE '%$search%') ";
      }
	}	
	$database->setQuery($query);
	$database->loadObject($return);
	echo $database->getErrorMsg();
	return $return->aantal;
  }
  
  function showSubscriberOverview($listid){
    global $mosConfig_offset, $mosConfig_list_limit, $mainframe, $database, $mosConfig_absolute_path, $option, $my, $lang;
	$row = new fqList($database);
	$row->load($listid);
	if($row->aid > $my->gid){
	  echo '<font class="error">';
	  mosNotAuth();
	  echo '</font>';
	  exit;
	}
	$grupos = array();
	$sql = "SELECT id as value, list_name as text FROM #__fq_letters ";
	$database->setQuery($sql);
	if (!$database->query()) {
	  echo $database->stderr();
	  return false;
	}
	$grupos[] = mosHTML::makeOption( '0', $lang->translate("a_todos") );
	$grupos = array_merge( $grupos, $database->loadObjectList() );
	$grupos['listid'] = mosHTML::selectList( $grupos, 'listid', 'class="inputbox" size="1" onchange="document.adminForm.submit();"','value', 'text',intval( $listid ));
	$orderby = mosGetParam($_REQUEST, 'orderby', 'subscriber_name');
	$sort = mosGetParam($_REQUEST, 'ordering', 'ASC');
	$search = $mainframe->getUserStateFromRequest( "search{$option}", 'search', '' );
	$search = $database->getEscaped( trim( strtolower( $search ) ) );
	$limit = $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', $mosConfig_list_limit );
	$limitstart = $mainframe->getUserStateFromRequest( "view{$option}limitstart", 'limitstart', 0 );
	$total = $this->getTotalSubscribers($listid, $search);
	require_once( $mosConfig_absolute_path . '/administrator/includes/pageNavigation.php' );
	$pageNav = new mosPageNav( $total, $limitstart, $limit  );
	$rows = $this->getSubscribers($listid, '', $pageNav->limitstart, $pageNav->limit, $orderby, $sort, $search);
	cabecera();
?>
    <script language="JavaScript">
      function reorder(order, sort){
        document.adminForm.orderby.value=order;
        document.adminForm.ordering.value=sort;
        submitbutton('');
      }
    </script>
    <form action="index2.php?option=com_fq&act=subscribers" method="post" name="adminForm">
      <table class="mc">
        <tr> 
          <th width="40%"><?php echo $lang->translate("a_usuarios_usuarios"); ?></td>
          <td width="30%">
		    <?php echo $lang->translate("a_filter"); ?>: <input type="text" name="search" value="<?php echo $search;?>" class="inputbox" onChange="document.adminForm.submit();" /> 
          </td>
          <td width="30%">
		    <?php echo $lang->translate("a_grupo"); ?>: <?php echo $grupos['listid'];?>
		  </td>
        </tr>
      </table>
	  <table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminlist">
        <tr>
          <th width="2%" class="title">#</th>
          <th width="2%" class="title"><input type="checkbox" name="toggle" value="" onClick="checkAll(<?php echo count( $rows ); ?>);" /></th>
          <th width="23%" class="title"><a href="javascript:reorder('subscriber_name', '<?php if($sort == "ASC" && $orderby == "subscriber_name") { echo "DESC"; } else { echo "ASC"; } ?>');"><?php echo $lang->translate("a_usuarios_nombre"); ?></a></th>
          <th width="23%" class="title"><a href="javascript:reorder('subscriber_email', '<?php if($sort == "ASC" && $orderby == "subscriber_email") { echo "DESC"; } else { echo "ASC"; } ?>');"><?php echo $lang->translate("a_usuarios_correo"); ?></a></th>
          <th width="20%" class="title"><a href="javascript:reorder('subscribe_date', '<?php if($sort == "ASC" && $orderby == "subscribe_date") { echo "DESC"; } else { echo "ASC"; } ?>');"><?php echo $lang->translate("a_usuarios_fecha"); ?></a></th>
          <th width="20%" class="title"><a href="javascript:reorder('list_id', '<?php if($sort == "ASC" && $orderby == "list_id") { echo "DESC"; } else { echo "ASC"; } ?>');"><?php echo $lang->translate("a_usuarios_grupo"); ?></a></th>
          <th align="center" width="10%"><a href="javascript:reorder('confirmed', '<?php if($sort == "ASC" && $orderby == "confirmed") { echo "DESC"; } else { echo "ASC"; } ?>');"><?php echo $lang->translate("a_usuarios_confirmado"); ?></a></th>
	    </tr>
        <?php		
  	    for ($i=0, $n=count( $rows ); $i < $n; $i++) {
  		  $row =& $rows[$i];
		  $img = $row->confirmed  ? 'tick.png' : 'publish_x.png';
		  $task = $row->confirmed  ? 'unpublish' : 'publish';
		  $alt = $row->confirmed  ? $lang->translate("a_confirmado") : $lang->translate("a_no_confirmado");
		  $lista=$row->list_id;
		  $row2 = new fqList($database);
		  $row2->load($lista);
        ?>
		<tr class="<?php echo "row$k"; ?>">
	      <td><?php echo $i+1+$pageNav->limitstart;?></td>
	      <td><input type="checkbox" id="cb<?php echo $i;?>" name="cids[]" value="<?php echo $row->id; ?>" onClick="isChecked(this.checked);" /></td>
	      <td> <a href="#edit" onClick="return listItemTask('cb<?php echo $i;?>','edit')"><?php if ($row->name==""){ echo $lang->translate("a_usuarios_anonimo");}else{ echo $row->name;} ?></a></td>
	      <td><?php echo $row->email; ?></td>
	      <td><?php echo $row->subscribe_date; ?></td>
	      <td>
		  <?php echo $row2->list_name; ?></td>
		  <td align="center">
	      <a href="javascript: void(0);" onClick="return listItemTask('cb<?php echo $i;?>','<?php echo $task;?>')">
		     <img src="images/<?php echo $img;?>" width="12" height="12" border="0" alt="<?php echo $alt; ?>" /></a>
	      </td>
	    </tr>
        <?php
    	$k = 1 - $k;
		}
        ?>
      </table>
	  <?php echo $pageNav->getListFooter(); ?>
	  <input type="hidden" name="option" value="<?php echo $option;?>" />
	  <input type="hidden" name="task" value="" />
	  <input type="hidden" name="act" value="subscribers" />
	  <input type="hidden" name="boxchecked" value="0" />
      <input type="hidden" name="orderby" value="<?php echo $orderby; ?>" />
      <input type="hidden" name="ordering" value="<?php echo $sort; ?>" />
    </form>
    <?php
  }
	
  function editSubscriber($id){ 
    global $database, $letter, $option, $mosConfig_live_site, $lang;
	$row = new fqSubscriber( $database );
   	$row->load( $id );
   	if($id == 0){
   	  $row->receive_html = 1;
   	  //$row->confirmed = 1;
   	}
	$listid=$row->list_id;
    $grupos = array();
	$sql = "SELECT id as value, list_name as text FROM #__fq_letters ";
	$database->setQuery($sql);
	if (!$database->query()) {
	  echo $database->stderr();
	  return false;
	}
	$grupos[] = mosHTML::makeOption( '0', $lang->translate("a_seleccione_grupo") );
	$grupos = array_merge( $grupos, $database->loadObjectList() );
	$grupos['listid'] = mosHTML::selectList( $grupos, 'listid', 'class="inputbox" size="1"','value', 'text',intval( $listid ));
    ?>
    <script language="javascript" type="text/javascript">
	  function isEmailValid(fieldValue) {
	  var emailFilter = /^.+@.+\..{2,4}$/;
	  var atSignFound = 0;
	  for (var i = 0; i <= fieldValue.length; i++)
		if ( fieldValue.charAt(i) == "@" )
			atSignFound++;
	  if ( atSignFound > 1 )
		return false;
	  else
		return ( emailFilter.test(fieldValue) && !doesEmailHaveInvalidChar(fieldValue) ) ? true : false;
      }

      function doesEmailHaveInvalidChar(fieldValue) {
	    var illegalChars = /[\(\)\<\>\,\;\:\\\/\"\[\] ]/;
	    return ( illegalChars.test(fieldValue) ) ? true : false;
      }

      function submitbutton(pressbutton) {
	  var form = document.adminForm;
	  var sDir = form.subscriber_email.value; 
	  
		if (pressbutton == 'cancel') {
		  submitform( pressbutton );
		  return;
		}
        if (form.subscriber_name.value == ""){
		  alert( "<?php echo $lang->translate("a_a_usuarios_nombre"); ?>" );
		} else if (sDir == ""){
		  alert( "<?php echo $lang->translate("a_a_usuarios_correo"); ?>" );
		} else if (!isEmailValid(sDir)){
		  alert( "<?php echo $lang->translate("a_a_usuarios_correo2"); ?>" );    
		} else if (form.listid.value == 0){
		  alert( "<?php echo $lang->translate("a_a_usuarios_seleccione_grupo"); ?>" );
		} else {
		  submitform( pressbutton );
		}
      }
    </script>
<link href="<?php echo $mosConfig_live_site;?>/administrator/components/com_fq/css/admin_fq.css" rel="stylesheet" type="text/css" />
    <table class="mc">
      <tr>
	    <th>
          <?php echo ($id != 0) ? $lang->translate("a_usuarios_editar") : $lang->translate("a_usuarios_agregar"); ?>
	    </th>
      </tr>
    </table>
    <form action="index2.php" method="post" name="adminForm">
    <table cellpadding="4" cellspacing="1" border="0" width="100%" class="adminform">
      <?php if (!$row->subscribe_date==""){  ?>
	  <tr>
        <td><strong><?php echo $lang->translate("a_usuarios_fecha"); ?>:</strong></td>
        <td><?php echo $row->subscribe_date; ?></td>
      </tr>
	  <?php } ?>
      <tr>
        <td width="100"><strong><?php echo $lang->translate("a_usuarios_nombre"); ?>:</strong></td>
		<td width="85%"><input type="text" name="subscriber_name" class="inputbox" size="40" value="<?php echo $row->subscriber_name; ?>" /></td>
      </tr>
      <tr>
		<td width="100"><strong><?php echo $lang->translate("a_usuarios_correo"); ?>:</strong></td>
		<td width="85%"><input type="text" name="subscriber_email" class="inputbox" size="40" value="<?php echo $row->subscriber_email; ?>" /></td>
      </tr>
	  <tr>
		<td width="100"><strong><?php echo $lang->translate("a_usuarios_grupo"); ?>:</strong></td>
		<td width="85%"><?php echo $grupos['listid'];?></td>
      </tr>		
      <tr>
		<td width="100"><strong><?php echo $lang->translate("a_usuarios_confirmado"); ?> ?:</strong></td>
		<td width="85%">
		  <input type="radio" name="confirmed" class="inputbox" value="1"<?php if($row->confirmed){ echo " checked"; }?>><?php echo $lang->translate("a_si"); ?>
		  <input type="radio" name="confirmed" class="inputbox" value="0"<?php if(!$row->confirmed){ echo " checked"; }?>><?php echo $lang->translate("a_no"); ?>
		</td>
      </tr>
      <tr>
		<td width="100"><strong><?php echo $lang->translate("a_usuarios_html"); ?>?:</strong></td>
		<td width="85%">
		  <input type="radio" name="receive_html" class="inputbox" value="1"<?php if($row->receive_html){ echo " checked"; }?>><?php echo $lang->translate("a_si"); ?>
		  <input type="radio" name="receive_html" class="inputbox" value="0"<?php if(!$row->receive_html){ echo " checked"; }?>><?php echo $lang->translate("a_no"); ?>
		</td>
      </tr>
    </table>
      <input type="hidden" name="subscriber_id" value="<?php echo $id ?>" />
	  <input type="hidden" name="option" value="<?php echo $option;?>" />
	  <input type="hidden" name="act" value="subscribers" />
	  <input type="hidden" name="task" value="" />
    <?php
  }
	
  function saveSubscriber($listid, $subscriber_name = '', $subscriber_email = '', $mambo = '', $subscribe_date = ''){ 
    global $database, $letter, $mailing, $lang, $newsletterConfig, $mosConfig_absolute_path, $mosConfig_live_site;
	$row = new fqSubscriber( $database );
	
   	if ($mambo == '') {
   	   if (!$row->bind( $_POST )) {
  	     echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
         exit();
  	   }
	   $row->subscribe_date = date( "Y-m-d H:i:s" );
	} else {
      $row->subscriber_name = $subscriber_name;
  	  $row->subscriber_email = $subscriber_email;
	  $row->confirmed = 1;
  	  $row->receive_html = 1;
	  $row->mambo = $mambo;
	  $row->subscribe_date = $subscribe_date;
	} 
  	$row->list_id = $listid;

  	if (!$row->check()) {
      echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
      exit();
  	}
	if (!$row->store()) {
  	  echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
  	  exit();
  	}
	if(empty($row->subscriber_id)){
	  $row->subscriber_id = $database->insertid();
	}
	  if($row->confirmed == 0){
		$list = $letter->getListDetails($listid);
		$query = "SELECT id FROM #__menu WHERE link = 'index.php?option=com_fq'";
		$database->setQuery($query);
		$database->query();
        $menuitem = $database->loadResult();
	    require_once($mosConfig_absolute_path . "/includes/sef.php");
        $subscribelink = sefRelToAbs($mosConfig_live_site . "/index.php?option=com_fq&Itemid=$menuitem&listid=$listid&action=confirm&subscriber=" . md5($row->subscriber_id));
	    $subscribelink1 = '<a href="' . $subscribelink . '" target="_blank">' . $lang->translate("confirmar") . '</a>';
        $subscribelink2 = $subscribelink;
	    $list->subscribemessage1 = str_replace("[CONFIRM]", $subscribelink1, $list->subscribemessage);
	    $list->subscribemessage2 = str_replace("[CONFIRM]", $subscribelink2, $list->subscribemessage);
        $mObj = new stdClass();
		$mObj->list_subject = str_replace("%s", $list->list_name ,$lang->translate("a_bienvenido_asunto"));
        $mObj->list_content = $list->subscribemessage1;
        $mObj->list_textonly = $list->subscribemessage2;
        $send = $mailing->sendSingleMessage($mObj, $row, $list);
        if($send == true){
          echo '<script language="JavaScript">alert(\'' . $lang->translate("a_a_mensaje_confirmacion") . '\');</script>';
        } else {
          echo '<script language="JavaScript">alert(\'' . $lang->translate("a_a_mensaje_no_enviado") . ': ' . $send . '\');</script>';
        }
      }
        echo "<script> location.href = 'index2.php?option=com_fq&act=subscribers&listid=" . $listid . "'; </script>\n";
  }
	
  function deleteSubscribers($id){ 
    global $database, $newsletterConfig;
	$cids = implode(", ", $_REQUEST['cids']);
	$database->setQuery( "SELECT * FROM #__fq_subscribers WHERE subscriber_id IN (" . $cids . ")");
	$rows = $database->loadObjectList();
	$query = "DELETE FROM #__fq_subscribers WHERE subscriber_id IN (" . $cids . ")";
	$database->setQuery($query);
	$database->query();
	$error = $database->getErrorMsg();
	if(!empty($error)){
	  echo "<script> alert('". $error ."'); </script>\n";
	  exit();
	}
	for ($i=0, $n=count($rows); $i < $n; $i++) {
	  $row = $rows[$i];
	  $listid=$row->list_id;
    }
        echo "<script> location.href = 'index2.php?option=com_fq&act=subscribers&listid=" . $listid . "'; </script>\n";
  }
	
  function deleteSubscriber($id){ 
    global $database;
	$query = "DELETE FROM #__fq_subscribers WHERE subscriber_id = " . $id;
	$database->setQuery($query);
	$database->query();
	$error = $database->getErrorMsg();
	if(!empty($error)){
	  echo "<script> alert('". $error ."'); </script>\n";
	  exit();
	}
  }

    function changeConfirm( $id=null, $state=0, $option ) {
	global $database, $my, $adminLanguage;
	$cids = implode(", ", $_REQUEST['cids']);

	if (count( $cids ) < 1) {
		$action = $state == 1 ? 'publish' : 'unpublish';
		echo "<script> alert('". $adminLanguage->A_COMP_CONT_SELECT_REC ." ". $action ."'); window.history.go(-1);</script>\n";
		exit;
	}

	$database->setQuery( "UPDATE #__fq_subscribers SET confirmed='$state'"
	. "\nWHERE subscriber_id IN ($cids)"
	);
	if (!$database->query()) {
		echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		exit();
	}

	if (count( $cids ) == 1) {
		$row = new fqSubscriber($database);
		$row->checkin( intval( $cid[0] ) );
	}
	mosRedirect( "index2.php?option=com_fq&act=subscribers" );
}
	
  function doExport($list){
    global $database, $newsletterConfig, $mosConfig_absolute_path, $lang;
	$mime_type = ($UserBrowser == 'IE' || $UserBrowser == 'Opera') ? 'application/octetstream' : 'application/octet-stream';
	$filename = "respaldo_grupo_" . $list . "__" . date('d-m-Y');
	$output = '<?xml version="1.0" encoding="ISO-8859-1" ?>
<!-- export for list with the id: ' . $list . ' -->
<!DOCTYPE subscribers [
<!ELEMENT subscribers (subscriber+)>
<!ELEMENT subscriber (subscriber_id, name, email, confirmed, subscribe_date, receive_html, mambo, delete_id)>
<!ELEMENT subscriber_id (#PCDATA)>
<!ELEMENT name (  CDATA)>
<!ELEMENT email (#PCDATA)>
<!ELEMENT confirmed (#PCDATA)>
<!ELEMENT subscribe_date (#PCDATA)>
<!ELEMENT receive_html (#PCDATA)>
<!ELEMENT mambo (#PCDATA)>
<!ELEMENT delete_id (#PCDATA)>
]>
<subscribers>
';
	$subscribers = $this->getSubscribers($list);
	foreach ($subscribers AS $subscriber){ 
	  $output .= " <subscriber>\n"; 
	  $output .= " <subscriber_id>" . $subscriber->subscriber_id . "</subscriber_id>\n"; 
	  $output .= " <name>" . htmlentities($subscriber->name) . "</name>\n"; 
	  $output .= " <email>" . $subscriber->email . "</email>\n"; 
	  $output .= " <confirmed>" . $subscriber->confirmed . "</confirmed>\n"; 
	  $output .= " <subscribe_date>" . $subscriber->subscribe_date . "</subscribe_date>\n"; 
	  $output .= " <receive_html>" . $subscriber->receive_html . "</receive_html>\n"; 
	  $output .= " <mambo>" . $subscriber->mambo . "</mambo>\n";
	  $output .= " <delete_id>" . $subscriber->delete_id . "</delete_id>\n";
	  $output .= " </subscriber>\n"; 
	} 
	$output .= "</subscribers>"; 
    if($newsletterConfig['savetoserver'] == '0'){ 
  	  ob_end_clean();
      ob_start(); 
	  header('Content-Type: ' . $mime_type); 
	  header('Expires: ' . gmdate('D, d M Y H:i:s') . ' GMT'); 
	  if ($UserBrowser == 'IE') { 
	    header('Content-Disposition: inline; filename="' . $filename . '.xml"'); 
		header('Cache-Control: must-revalidate, post-check=0, pre-check=0'); 
		header('Pragma: public'); 
	  } else { 
	    header('Content-Disposition: attachment; filename="' . $filename . '.xml"'); 
		header('Pragma: no-cache'); 
	  } 
      print $output; 
	  exit();
	} else { 
	  $fp = fopen($mosConfig_absolute_path . '/administrator/components/com_fq/fq/' . $filename . '.xml', "w+"); 
	  fwrite($fp, $output); 
	  fclose($fp); 
	  ?> 
      <script language="JavaScript"> 
        alert('<?php echo $lang->translate("a_a_respaldo_guardado"); ?>: <?php echo $mosConfig_absolute_path; ?>/administrator/components/com_fq/fq/<?php echo $filename; ?>.xml');
        document.location.href='index2.php?option=com_fq&act=subscribers&listid=<?php echo $list; ?>';
      </script>
      <?php
    }
  }
  
  function importSubscribers($listid, $ban){ 
    global $database, $mosConfig_absolute_path, $mosConfig_live_site, $option, $lang;
?>
<link href="<?php echo $mosConfig_live_site;?>/administrator/components/com_fq/css/admin_fq.css" rel="stylesheet" type="text/css" />
<?php	
      if(!empty($_FILES['xmlfile']) Or !empty($_FILES['csvfile']) Or ($_POST['mambo']==1)){
        if(!empty($_FILES['xmlfile']['name'])){
          if($_FILES['xmlfile']['type'] == "text/xml"){
            $filename = $_FILES['xmlfile']['name'];
            $path = $mosConfig_absolute_path . '/administrator/components/com_fq/fq/';
            if(is_writable($path)){
      	      if(!move_uploaded_file($_FILES['xmlfile']['tmp_name'], $path . $filename)){
	            mosRedirect( "index2.php?option=com_fq&act=subscribers&listid=$listid&task=import", $lang->translate("a_a_usuarios_error_importar") );
              } else {
                $array = parseXmlFile($path . $filename, "subscriber");
                if(sizeof($array) > 0){
          	      foreach($array AS $subscriber){
          	        $query = "REPLACE INTO #__fq_subscribers VALUES('" . $listid . "', '" . $subscriber['subscriber_id'] . "', '" . $subscriber['name'] . "', '" . $subscriber['email'] . "', '" . $subscriber['confirmed'] . "', '" . $subscriber['subscribe_date'] . "', '" . $subscriber['receive_html'] ."', '" . $subscriber['mambo'] . "', '" . $subscriber['delete_id'] . "');";
          	        $database->setQuery($query);
          	        $database->query();
          	        $error = $database->getErrorNum();
                    if($error){
                      if($error == 1062){
              	        echo '<span class="error">' . str_replace("%s", $subscriber['email'], $lang->translate("a_a_usuarios_existe_correo")) . "'. </span><br />";
              	        echo '<hr>';
				      } else {
                        echo $database->getErrorMsg() . "<br />\n";
					    echo '<hr>';
              	      }
              	    }
          	      }
			      ?>
                  <table class="mc">
                    <tr>
	                  <th>
                        <?php echo $lang->translate("a_a_usuarios_importar"); ?>
	                  </th>
                    </tr>
	                <tr>
	                  <td>
	                    <a href="index2.php?option=com_fq&act=subscribers&listid=<?php echo $listid; ?>"><?php echo $lang->translate("a_a_usuarios_continuar"); ?></a>
	                  </td>
					</tr>
                  </table>
                  <?php
                } else { 
                  mosRedirect( "index2.php?option=com_fq&act=subscribers&listid=$listid&task=import", $lang->translate("a_a_usuarios_archivo_vacio") );
            	}
              } 
	        } else {
	          mosRedirect( "index2.php?option=com_fq&act=subscribers&listid=$listid&task=import", str_replace("%s", $path, $lang->translate("a_a_usuarios_no_escribir_dir")) );
        	}
          } else { 
	        mosRedirect( "index2.php?option=com_fq&act=subscribers&listid=$listid&task=import", $lang->translate("a_a_usuarios_solo_xml") );
  	      }
        } else { 
          if($_POST['mambo']==1) {
            $database->setQuery( "SELECT * FROM #__users");
            $rows = $database->loadObjectList();		
            for ($i=0, $n=count( $rows ); $i < $n; $i++) {
              $row2 =& $rows[$i];
              $database->setQuery( "SELECT COUNT(*) FROM #__fq_subscribers WHERE subscriber_name = '$row2->username' AND subscriber_email = '$row2->email' AND list_id = '$listid'" );
              $total = $database->loadResult();
              if ($total==0) {		
	            $subscriber_name = $row2->username;
	            $subscriber_email = $row2->email;
		        $subscribe_date = date( "Y-m-d H:i:s" );
                $this->saveSubscriber($listid, $subscriber_name, $subscriber_email, 1, $subscribe_date);
	          }		
	        }
	        ?>	 
            <table class="mc">
              <tr>
	            <th>
                  <?php echo $lang->translate("a_a_usuarios_importar"); ?>
	            </th>
              </tr>
	          <tr>
	            <td>
	              <a href="index2.php?option=com_fq&act=subscribers&listid=<?php echo $listid; ?>"><?php echo $lang->translate("a_a_usuarios_continuar"); ?></a>
	            </td>
			  </tr>
            </table>
            <?php
	      } else { 
            if(($_FILES['csvfile']['type'] == "application/octet-stream") || ($_FILES['csvfile']['type'] == "application/vnd.ms-excel")){
              $filename = $_FILES['csvfile']['name'];
              $path = $mosConfig_absolute_path . '/administrator/components/com_fq/fq/';
    	      if(is_writable($path)){
      	        if(!move_uploaded_file($_FILES['csvfile']['tmp_name'], $path . $filename)){
	              mosRedirect( "index2.php?option=com_fq&act=subscribers&listid=$listid&task=import", $lang->translate("a_a_usuarios_error_importar") );
        	    } else { 
          	      $name_column = mosGetParam($_POST, 'name_column', '1');
          	      $address_column = mosGetParam($_POST, 'address_column', '2');
          	      $delim = mosGetParam($_POST, 'delimiter', ';');
          	      $offset = mosGetParam($_POST, 'record_number', 1);
          	      $offset = $offset - 1; 
          	      $name_column = $name_column - 1; 
          	      $address_column = $address_column - 1; 
          	      $content = file($path . $filename);
                  if(sizeof($content) > 0){
          	        for($i = $offset; $i < sizeof($content); $i++){
          	          $subscriber = explode($delim, $content[$i]);
          	          $subscriber[$address_column] = ltrim(rtrim($subscriber[$address_column]));
          	          $subscriber[$address_column] = str_replace('"', '', $subscriber[$address_column]);
          	          $subscriber[$name_column] = str_replace('"', '', $subscriber[$name_column]);
          	          if(!empty($subscriber[$address_column])){
                        if(check_email_address($subscriber[$address_column])){
              	          $query = "REPLACE INTO #__fq_subscribers (list_id, subscriber_name, subscriber_email, confirmed, subscribe_date, receive_html) 
              	          VALUES('" . $listid . "', '". addslashes($subscriber[$name_column]) . "', '". addslashes($subscriber[$address_column]) . "', '1', NOW(), 1);";
              	          $database->setQuery($query);
              	          $database->query();
              	          $error = $database->getErrorNum();
                          if($error){ 
                            if($error == 1062){
                  		      echo '<span class="error">' . str_replace("%s", $subscriber['email'], $lang->translate("a_a_usuarios_existe_correo")) . "'. </span><br />";
						      echo '<hr>';
                    		} else {
                              echo $database->getErrorMsg() . "<br />\n";
						      echo '<hr>';
                            } 
                  	      } 
                        } else { 
                          echo '<font class="error"><b>' . $subscriber[$address_column] . ':</b> ' . $lang->translate("a_a_usuarios_correo_invalido") . '</font><br />';
					      echo '<hr>';
                        }
          	          } else { 
          	      	    echo '<font class="error">' . $lang->translate("a_a_usuarios_correo_vacio") . ' ' . $subscriber[$name_column] . '</font><br />';
					    echo '<hr>';
          	          }
          	        } 
				    ?>	 
                    <table class="mc">
                      <tr>
	                    <th>
                          <?php echo $lang->translate("a_a_usuarios_importar"); ?>
	                    </th>
                      </tr>
	                  <tr>
	                    <td>
	                      <a href="index2.php?option=com_fq&act=subscribers&listid=<?php echo $listid; ?>"><?php echo $lang->translate("a_a_usuarios_continuar"); ?></a>
	                    </td>
					  </tr>
                    </table>
                    <?php
                  } else { 
	                mosRedirect( "index2.php?option=com_fq&act=subscribers&listid=$listid&task=import", $lang->translate("a_a_usuarios_archivo_vacio") );
          	      }
        	    } 
    	      } else {
	            mosRedirect( "index2.php?option=com_fq&act=subscribers&listid=$listid&task=import", str_replace("%s", $path, $lang->translate("a_a_usuarios_no_escribir_dir")) );
    	      } 
  	        } else { 
	          mosRedirect( "index2.php?option=com_fq&act=subscribers&listid=$listid&task=import", $lang->translate("a_a_usuarios_solo_csv") );
  	        }
	      }
        }
        ?>
        <?php
      } else {
      ?>
        <div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>
        <script language="Javascript" src="<?php echo $mosConfig_live_site;?>/includes/js/overlib_mini.js"></script>
        <script language="javascript" type="text/javascript">
          function submitbutton(pressbutton) {
		    var form = document.adminForm;
		    if (pressbutton == 'cancel') {
			  submitform( pressbutton );
			  return;
		    }
            if ((form.mambo.checked == false)&&(form.xmlfile.value == "")&&(form.csvfile.value == "")){
			  alert( "<?php echo $lang->translate("a_a_usuarios_tipo_importacion"); ?>" );
			} else if ((form.mambo.checked == true)&&(form.xmlfile.value != "")){
			  alert( "<?php echo $lang->translate("a_a_usuarios_tipo_importacion_una"); ?>" );
			} else if ((form.mambo.checked == true)&&(form.csvfile.value != "")){
			  alert( "<?php echo $lang->translate("a_a_usuarios_tipo_importacion_una"); ?>" );
			} else if ((form.xmlfile.value != "")&&(form.csvfile.value != "")){
			  alert( "<?php echo $lang->translate("a_a_usuarios_tipo_importacion_una"); ?>" );		
			} else {
			  submitform( pressbutton );
			}
          }
        </script>
        <table class="mc">
          <tr>
	        <th>
              <?php echo $lang->translate("a_usuarios_importar"); ?>:
	        </th>
          </tr>
        </table>	
        <form action="index2.php" method="POST" name="adminForm" enctype="multipart/form-data">
          <input type="hidden" name="option" value="<?php echo $option; ?>" />
          <input type="hidden" name="act" value="subscribers" />
          <input type="hidden" name="listid" value="<?php echo $listid; ?>" />
          <input type="hidden" name="task" value="import" />
          <input type="hidden" name="ban" value="1" />
          <table class="adminform">
	        <tr>
              <td colspan="2"><strong><?php echo $lang->translate("a_usuarios_importar_mambo"); ?>: </strong></td>
              <td><input type="checkbox" name="mambo" class="inputbox" value="1"></td>
            <tr>
            <tr>
              <td colspan="2"><strong><?php echo $lang->translate("a_usuarios_importar_xml"); ?>: </strong></td>
              <td><input type="file" name="xmlfile"></td>
            </tr>
			<tr>
              <td colspan="2"><strong><?php echo $lang->translate("a_usuarios_importar_csv"); ?>: </strong></td>
              <td><input type="file" name="csvfile"></td>
            </tr>
            <tr>  
		      <td width="2%" valign="top"><?php echo mosToolTip($lang->translate("a_usuarios_importar_csv_nombre_a")); ?></td>    
              <td width="25%"><?php echo $lang->translate("a_usuarios_importar_csv_nombre"); ?>:</td>
              <td width="73%"><input type="text" name="name_column" size="2" value="1" /></td>
            </tr>
            <tr>
		      <td valign="top"><?php echo mosToolTip($lang->translate("a_usuarios_importar_csv_correo_a")); ?></td>
              <td><?php echo $lang->translate("a_usuarios_importar_csv_correo"); ?>:</td>
              <td><input type="text" name="address_column" size="2" value="2" /></td>
            </tr>
            <tr>
		      <td valign="top"><?php echo mosToolTip($lang->translate("a_usuarios_importar_csv_inicio_a")); ?></td>
              <td><?php echo $lang->translate("a_usuarios_importar_csv_inicio"); ?>:</td>
              <td><input type="text" name="record_number" size="2" value="1" /></td>
            </tr>
            <tr>
		      <td valign="top"><?php echo mosToolTip($lang->translate("a_usuarios_importar_csv_limite_a")); ?></td>
              <td><?php echo $lang->translate("a_usuarios_importar_csv_limite"); ?>:</td>
              <td><input type="text" name="delimiter" size="2" value=";"/></td>
            </tr>
          </table>
        </form>
        <?php
      }
    }
  }
?>