<?php
/**
* @version $Id: admin.artmedia.php,v 1.2 2005/04/10 09:17:52 balu Exp $
* @package artmedia
* @copyright (C) 2005 Andreas Duswald
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* @author Andreas Duswald www.duswald.de
* Mambo is Free Software
*/

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

if ( file_exists($mosConfig_absolute_path.'/components/com_artmedia/languages/'.$mosConfig_lang.'.artmedia.php') ) {
	include($mosConfig_absolute_path.'/components/com_artmedia/languages/'.$mosConfig_lang.'.artmedia.php');
} else {
	include($mosConfig_absolute_path.'/components/com_artmedia/languages/english.artmedia.php');
}

require_once( $mainframe->getPath( 'admin_html' ) );
require_once( $mainframe->getPath( 'class' ) );
$mainframe->setPageTitle( _A_AM_PAGETITLE );

$func = trim( mosGetParam( $_REQUEST, 'func', '' ) );
$task = trim( mosGetParam( $_REQUEST, 'task', '' ) );
$did = intval( mosGetParam( $_REQUEST, 'did', 0 ) );

$artmedia_path = $mosConfig_absolute_path.'/images/artmedia/';

// ArtMedia array
$artmedia['msg'] = "";

switch ($func) {
	case 'upload':
		if ( !move_uploaded_file ($_FILES['userfile']['tmp_name'],$artmedia_path.$_FILES['userfile']['name']) || !chmod($artmedia_path.$_FILES['userfile']['name'],0777) ) {
			$artmedia['msg'] = _A_AM_MSG_FAILED;
		} else {
	    $artmedia['msg'] = _A_AM_MSG_SUCCESS;
		}
	break;

	case "saveeditfile":
		saveMediaDB( $option );
	break;

	case "updatedbfile":
		updateMediaDB( $did, $option, $_POST );
	break;

	case "deldbfile":
		removeMediaDB( $did, $option );
	break;

	case 'publish':
		publishMediaItem( $did, 1, $option );
	break;

	case 'unpublish':
		publishMediaItem( $did, 0, $option );
	break;

	case 'publishmod':
		publishModItem( $did, 1, $option );
	break;

	case 'unpublishmod':
		publishModItem( $did, 0, $option );
	break;

	default:
	break;
}

switch ($task) {

	case 'viewabout':
		ShowAbout( $option );
	break;

	case 'showhelp':
		HTML_artmedia::Help( $option );
	break;

	default:	// viewmedia
		ShowMedia( $option, $artmedia );
	break;
}

// Mediadatei in DB Aufnehmen
function saveMediaDB( $option ) {
  global $database;

  $row = new mosArtmedia( $database );
  if ( !$row->bind( $_POST ) ) {
    echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
    exit();
  }

  if ( !$row->store() ) {
    echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
    exit();
  }
  //$row->updateOrder( "catid='$row->catid'" );

  mosRedirect( "index2.php?option=$option&task=viewmedia" );
}

//Mediadatei aus DB entfernen
function removeMediaDB( $did, $option ) {
  global $database;

	$database->setQuery( "DELETE FROM #__artmedia WHERE id = ".$did."" );
	if ( !$database->query() ) {
		echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
	}

  mosRedirect( "index2.php?option=$option&task=viewmedia" );
}

// Datei aus Verzeichnis lschen
function removeDatei( $dname, $option ) {

}

function updateMediaDB( $did, $option, $_POST ) {
  global $database;

  if( $_POST[modulpub]=="1" ) {
		// Es soll nur eine Datei im Modul angezeigt werden
		// Deshalb alle anderen auf nicht setzen
/*		$database->setQuery( "UPDATE #__artmedia SET modulpub='0' WHERE modulpub = '1'" );
		if ( !$database->query() ) {
			echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
			exit();
		}*/ // Einstellung der anzuzeigenden items im modul via parameter
  }
  $database->setQuery( "UPDATE #__artmedia SET titel='".$_POST[titel]."', untertitel='".$_POST[untertitel]."', beschreibung='".$_POST[beschreibung]."', picture='".$_POST[picture]."', modulpub='".$_POST[modulpub]."', published='".$_POST[published]."'  WHERE id = '$did'" );
  if ( !$database->query() ) {
    echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
    exit();
  }
  mosRedirect( "index2.php?option=$option&task=viewmedia" );
}

/**
* Publishes or Unpublishes one record
* @param integer unique id numbers
* @param integer 0 if unpublishing, 1 if publishing
* @param string The current artmedia option
*/
function publishMediaItem( $did=NULL, $publish=1, $option ) {
	global $database;

	$database->setQuery( "UPDATE #__artmedia SET published='$publish' WHERE id='$did'" );
	if (!$database->query()) {
		echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		exit();
	}
	echo "<script> alert('".$did."'); window.history.go(-1); </script>\n";

	mosRedirect( "index2.php?option=$option&task=viewmedia" );
}

/**
* Publishes or Unpublishes one record (in module)
* @param integer unique id numbers
* @param integer 0 if unpublishing, 1 if publishing
* @param string The current artmedia option
*/
function publishModItem( $did=NULL, $publish=1, $option ) {
	global $database;

	$database->setQuery( "UPDATE #__artmedia SET modulpub='$publish' WHERE id='$did'" );
	if (!$database->query()) {
		echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		exit();
	}
	echo "<script> alert('".$did."'); window.history.go(-1); </script>\n";

	mosRedirect( "index2.php?option=$option&task=viewmedia" );
}

function ShowMedia( $option, $artmedia ) { 
	global $mosConfig_absolute_path, $fend;
	global $database;
  
	# Picture List
	$imgFiles = mosReadDirectory( "$mosConfig_absolute_path/images/stories" );
	$images = array( mosHTML::makeOption( '', _A_AM_OPT_NOPIC ) );
	foreach ($imgFiles as $file) {
		if ( eregi( "bmp|gif|jpg|png", $file ) ) {
			$images[] = mosHTML::makeOption( $file );
		}
	}
  
	//hier gibst Du das Verzeichniss fr die media dateien
	$artmedia['folder'] = $mosConfig_absolute_path.'/images/artmedia';

	$pubopt[] = mosHTML::makeOption( '0', _A_AM_OPT_NOTPUBLIC );
	$pubopt[] = mosHTML::makeOption( '1', _A_AM_OPT_PUBLIC );
	$modpubopt[] = mosHTML::makeOption( '0', _A_AM_OPT_NOTMODULE );
	$modpubopt[] = mosHTML::makeOption( '1', _A_AM_OPT_MODULE );
	
  HTML_artmedia::showMedia( $option, $artmedia, $imagelist, $pubopt, $modpubopt, $images );
}

function ShowAbout( $option ) { 
  HTML_artmedia::showAbout( $option );
}

if ( !function_exists(filend) ) {
	function filend($file) {
		global $fend;
		$fend = split("[.]",$file);
		$fend = $fend[1];
	}
}

HTML_artmedia::Footer();

?>
