<?php

/**
* Booklibrary Import Export Class
* Handles the import and export of data from the booklibrary.
* @package Booklibrary
* @copyright 2005 Gerd Saurer http://booklibrary.mamboforge.net
* @license http://www.gnu.org/copyleft/gpl.html GNU Public License
* @version $Revision: 1.0 $
*/

// ensure this file is being included by a parent file
defined('_VALID_MOS') or die('Direct Access to this location is not allowed.');

// ensure user has access to this function
if (!($acl->acl_check('administration', 'edit', 'users', $my->usertype, 'components', 'all') | $acl->acl_check('administration', 'edit', 'users', $my->usertype, 'components', 'com_booklibrary'))) {
	mosRedirect('index2.php', _NOT_AUTH);
}

require_once ($mainframe->getPath('admin_html'));
require_once ($mainframe->getPath('class'));
require_once ($mosConfig_absolute_path."/components/com_booklibrary/booklibrary.class.lend.php");
require_once ($mosConfig_absolute_path."/components/com_booklibrary/booklibrary.class.lend_request.php");
require_once ($mosConfig_absolute_path."/administrator/components/com_booklibrary/admin.booklibrary.class.ws.php");
require_once ($mosConfig_absolute_path."/administrator/components/com_booklibrary/admin.booklibrary.class.impexp.php");
require_once ($mosConfig_absolute_path."/administrator/components/com_booklibrary/admin.booklibrary.class.conf.php");

require_once ($mosConfig_absolute_path."/includes/domit/xml_domit_include.php");

// *** Get language files
global $mosConfig_alang;

if (file_exists($mosConfig_absolute_path.'/components/com_booklibrary/language/'.$mosConfig_alang.'.php')) {
	include_once ($mosConfig_absolute_path.'/components/com_booklibrary/language/'.$mosConfig_alang.'.php');
} else {
	include_once ($mosConfig_absolute_path.'/components/com_booklibrary/language/english.php');
}



$bid = mosGetParam($_POST, 'bid', array (0));

if($booklibrary_configuration['debug'] == '1'){
	echo "Task: ".$task . "<br>";
	print_r($_POST);
	echo "<hr><br>";
}

switch ($task) {
	
	case "categories":
    	mosRedirect( "index2.php?option=categories&section=com_booklibrary" );
    	break;
	
	case "new" :
		editBook($option, 0);
		break;

	case "edit" :
		editBook($option, array_pop($bid));
		break;

	case "refetchInfos" :
		refetchInfo($option, $bid);
		break;

	case "save" :
		saveBook($option);
		break;

	case "remove" :
		removeBooks($bid, $option);
		break;

	case "publish" :
		publishBooks($bid, 1, $option);
		break;

	case "unpublish" :
		publishBooks($bid, 0, $option);
		break;

	case "cancel" :
		cancelBook($option);
		break;

	case "bookorderdown" :
		orderBooks($bid[0], 1, $option);
		break;

	case "bookorderup" :
		orderBooks($bid[0], -1, $option);
		break;

	case "show_import_export" :
		importExportBooks($option);
		break;

	case "import" :
		import($option);
		break;

	case "export" :
		export($option);
		break;

	case "config" :
		configure($option);
		break;

	case "config_save" :
		configure_save($option);
		break;

	case "lend" :
		if (mosGetParam($_POST, 'save') == 1) {
			saveLend($option, $bid);
		} else{
			lend($option, $bid);
		}
		break;
		
	case "lend_requests" :
		lend_requests($option, $bid);	
		break;
		
	case "accept_lend_requests" :
		accept_lend_requests($option, $bid);	
		break;

	case "decline_lend_requests" :
		decline_lend_requests($option, $bid);	
		break;

	case "about" :
		HTML_booklibrary :: about();
		break;

	case "show_info" :
		showInfo($option, $bid);
		break;

	case "lend_return" :
		if (mosGetParam($_POST, 'save') == 1) {
			saveLend_return($option, $bid);			
		} else {
			lend_return($option, $bid);
		}
		break;

	default :
		showBooks($option);
		break;
}

function showInfo($option, $bid){

	if(is_array($bid) && count($bid) > 0){
		$bid = $bid[0];
	}
	echo "Test: " . $bid;
}

function decline_lend_requests($option, $bids){
	global $database;

	foreach($bids as $bid){
		$lend_request = new mosBookLibrary_lend_request($database);
		$lend_request->load($bid);
		$tmp = $lend_request->decline();
		if($tmp != null){
			echo "<script> alert('" .$tmp . "'); window.history.go(-1); </script>\n";
			exit ();
		}
	}
	
	mosRedirect("index2.php?option=$option&task=lend_requests");
}

function accept_lend_requests($option, $bids){
	global $database;

	foreach($bids as $bid){
		$lend_request = new mosBookLibrary_lend_request($database);
		$lend_request->load($bid);
		$tmp = $lend_request->accept();
		if($tmp != null){
			echo "<script> alert('" .$tmp . "'); window.history.go(-1); </script>\n";
			exit ();
		}
	}
	
	mosRedirect("index2.php?option=$option&task=lend_requests");

}


function lend_requests($option, $bid){
	global $database, $mainframe, $mosConfig_list_limit;
	
	$limit = $mainframe->getUserStateFromRequest("viewlistlimit", 'limit', $mosConfig_list_limit);
	$limitstart = $mainframe->getUserStateFromRequest("view{$option}limitstart", 'limitstart', 0);
	
	$database->setQuery("SELECT count(*) FROM #__booklibrary AS a".
						"\nLEFT JOIN #__booklibrary_lend_request AS l".
						"\nON l.fk_bookid = a.id". 
						"\nWHERE l.status = 0");
	$total = $database->loadResult();
	echo $database->getErrorMsg();

	require_once ($GLOBALS['mosConfig_absolute_path'].'/administrator/includes/pageNavigation.php');
	$pageNav = new mosPageNav($total, $limitstart, $limit);
	
	
	$database->setQuery("SELECT * FROM #__booklibrary AS a".
						"\nLEFT JOIN #__booklibrary_lend_request AS l".
						"\nON l.fk_bookid = a.id". 
						"\nWHERE l.status = 0".
						"\nORDER BY l.lend_from, l.lend_until, l.user_name".
						"\nLIMIT $pageNav->limitstart,$pageNav->limit;");

	$lend_requests = $database->loadObjectList();
	echo $database->getErrorMsg();

	//	print_r($total);
	
	HTML_booklibrary :: showRequestLendBooks($option, & $lend_requests, & $pageNav);

}


/**
* Compiles a list of records
* @param database A database connector object
* @todo select categories
*/
function showBooks($option) {
	global $database, $mainframe, $mosConfig_list_limit;

	$limit = $mainframe->getUserStateFromRequest("viewlistlimit", 'limit', $mosConfig_list_limit);
	$limitstart = $mainframe->getUserStateFromRequest("view{$option}limitstart", 'limitstart', 0);
	$catid = $mainframe->getUserStateFromRequest("catid{$option}", 'catid', 0);
	$lend = mosGetParam($_POST, 'lend');
	$pub = mosGetParam($_POST, 'pub');

	$search = $mainframe->getUserStateFromRequest("search{$option}", 'search', '');
	$search = $database->getEscaped(trim(strtolower($search)));

	$where = array ();

	if ($lend == "lend") {
		array_push($where, "a.fk_lendid <> 0");
	} else if ($lend == "not_lend") {
		array_push($where, "a.fk_lendid = 0");
	} 

	if ($pub== "pub") {
		array_push($where, "a.published = 1");
	} else if ($pub == "not_pub") {
		array_push($where, "a.published = 0");
	} 

	if ($catid > 0) {
		array_push($where, "a.catid='$catid'");
	}
	if ($search) {
		array_push($where, "(LOWER(a.title) LIKE '%$search%' OR LOWER(a.authors) LIKE '%$search%' OR LOWER(a.isbn) LIKE '%$search%' OR LOWER(a.comment) LIKE '%$search%')");
	}
	$database->setQuery("SELECT count(*) FROM #__booklibrary AS a".
						"\nLEFT JOIN #__booklibrary_lend AS l".
						"\nON a.fk_lendid = l.id". 
						(count($where) ? "\nWHERE ".implode(' AND ', $where) : ""));

	$total = $database->loadResult();
	echo $database->getErrorMsg();

	require_once ($GLOBALS['mosConfig_absolute_path'].'/administrator/includes/pageNavigation.php');
	$pageNav = new mosPageNav($total, $limitstart, $limit);

	$selectstring = "SELECT a.*, cc.title AS category, l.id as lendid, l.lend_from as lend_from, l.lend_return as lend_return, l.lend_until as lend_until, u.name AS editor".
					"\nFROM #__booklibrary AS a".
					"\nLEFT JOIN #__categories AS cc ON cc.id = a.catid".
					"\nLEFT JOIN #__booklibrary_lend AS l ON a.fk_lendid = l.id".
					"\nLEFT JOIN #__users AS u ON u.id = a.checked_out". 
					(count($where) ? "\nWHERE ".implode(' AND ', $where) : "").
					"\nORDER BY a.catid, a.ordering".
					"\nLIMIT $pageNav->limitstart,$pageNav->limit;";
					
	$database->setQuery($selectstring);

	$rows = $database->loadObjectList();
	if ($database->getErrorNum()) {
		echo $database->stderr();
		return false;
	}


	// get list of categories
	/*
	 * @todo change to tree select list treeSelectList
	 */
	$categories[] = mosHTML :: makeOption('0', _BOOKLIBRARY_LABEL_SELECT_CATEGORIES);
	$categories[] = mosHTML :: makeOption('-1', _BOOKLIBRARY_LABEL_SELECT_ALL_CATEGORIES);
	$database->setQuery("SELECT id AS value, title AS text FROM #__categories"."\nWHERE section='com_booklibrary' ORDER BY ordering");
	$categories = array_merge($categories, $database->loadObjectList());
	$clist = mosHTML :: selectList($categories, 'catid', 'class="inputbox" size="1" onchange="document.adminForm.submit();"', 'value', 'text', $catid);
	
	$lendmenu[] = mosHTML :: makeOption('0', _BOOKLIBRARY_LABEL_SELECT_TO_LEND);
	$lendmenu[] = mosHTML :: makeOption('-1', _BOOKLIBRARY_LABEL_SELECT_ALL_LEND);
	$lendmenu[] = mosHTML :: makeOption('not_lend', _BOOKLIBRARY_LABEL_SELECT_NOT_LEND);
	$lendmenu[] = mosHTML :: makeOption('lend', _BOOKLIBRARY_LABEL_SELECT_LEND);
	$lendlist = mosHTML :: selectList($lendmenu, 'lend', 'class="inputbox" size="1" onchange="document.adminForm.submit();"', 'value', 'text', $lend);
	
	$pubmenu[] = mosHTML :: makeOption('0', _BOOKLIBRARY_LABEL_SELECT_TO_PUBLIC);
	$pubmenu[] = mosHTML :: makeOption('-1', _BOOKLIBRARY_LABEL_SELECT_ALL_PUBLIC);
	$pubmenu[] = mosHTML :: makeOption('not_pub', _BOOKLIBRARY_LABEL_SELECT_NOT_PUBLIC);
	$pubmenu[] = mosHTML :: makeOption('pub', _BOOKLIBRARY_LABEL_SELECT_PUBLIC);
	$publist = mosHTML :: selectList($pubmenu, 'pub', 'class="inputbox" size="1" onchange="document.adminForm.submit();"', 'value', 'text', $pub);
	
	HTML_booklibrary :: showBooks($option, $rows, $clist, $lendlist, $publist, $search, $pageNav);
}

/**
* Compiles information to add or edit books
* @param integer bid The unique id of the record to edit (0 if new)
* @param array option the current options
*/
function editBook($option, $bid) {
	global $database, $my, $mosConfig_live_site;

	$book = new mosBookLibrary($database);
	// load the row from the db table
	$book->load(intval($bid));

	// get list of categories
	$categories[] = mosHTML :: makeOption('0', _BOOKLIBRARY_LABEL_SELECT_CATEGORIES);
	$database->setQuery("SELECT id AS value, name AS text FROM #__categories"."\nWHERE section='$option' ORDER BY ordering");
	$categories = array_merge($categories, $database->loadObjectList());

	if (count($categories) < 1) {
		mosRedirect("index2.php?option=categories&section=$option", _BOOKLIBRARY_ADMIN_IMPEXP_ADD);
	}

	$clist = mosHTML :: selectList($categories, 'catid', 'class="inputbox" size="1"', 'value', 'text', intval($book->catid));

	// get list of WS
	$retVal = mosBooklibraryWS :: getArray();
	$ws = null;
	for ($i = 0, $n = count($retVal); $i < $n; $i ++) {
		$help = & $retVal[$i];
		$ws[] = mosHTML :: makeOption($help[0], $help[1]);
	}
	$wslist = mosHTML :: selectList($ws, 'informationFrom', 'class="inputbox" size="1"', 'value', 'text', intval($book->informationFrom));

	//get language List
	$retVal1 = mosBooklibraryOthers :: getLanguageArray();
	$lang = null;
	for ($i = 0, $n = count($retVal1); $i < $n; $i ++) {
		$help = & $retVal1[$i];
		$lang[] = mosHTML :: makeOption($help[0], $help[1]);
	}
	$langlist = mosHTML :: selectList($lang, 'language', 'class="inputbox" size="1"', 'value', 'text', $book->language);

	//get Rating
	$retVal2 = mosBooklibraryOthers :: getRatingArray();
	$rating = null;
	for ($i = 0, $n = count($retVal2); $i < $n; $i ++) {
		$help = & $retVal2[$i];
		$rating[] = mosHTML :: makeOption($help[0], $help[1]);
	}
	$ratinglist = mosHTML :: selectList($rating, 'rating', 'class="inputbox" size="1"', 'value', 'text', $book->rating);

	//delete ebook?
	$help = str_replace($mosConfig_live_site, "", $book->ebookURL);
	$delete_ebook_yesno[] = mosHTML :: makeOption($help, _BOOKLIBRARY_YES);
	$delete_ebook_yesno[] = mosHTML :: makeOption('0', _BOOKLIBRARY_NO);
	$delete_ebook = mosHTML :: RadioList($delete_ebook_yesno, 'delete_ebook', 'class="inputbox"', '0', 'value', 'text');

	// fail if checked out not by 'me'
	if ($book->checked_out && $book->checked_out <> $my->id) {
		mosRedirect("index2.php?option=$option", _BOOKLIBRARY_IS_EDITED);
	}

	if ($bid) {
		$book->checkout($my->id);
	} else {
		// initialise new record
		$book->published = 0;
		$book->approved = 0;
	}

	$database->setQuery("SELECT * FROM #__booklibrary_review".
						"\nWHERE fk_bookid='$bid' ORDER BY date");
	$reviews = $database->loadObjectList();

	HTML_booklibrary :: editBook($option, $book, $clist, $wslist, $langlist, $ratinglist, $delete_ebook, $reviews);

}

/**
* Saves the record on an edit form submit
* @param database A database connector object
*/
function saveBook($option) {
	global $database, $my, $booklibrary_configuration;
	global $mosConfig_absolute_path, $mosConfig_live_site, $booklibrary_configuration;
	
	
	//check how the other info should be provided

	$book = new mosBookLibrary($database);
	
	if (!$book->bind($_POST)) {
		echo "<script> alert('".$book->getError()."'); window.history.go(-1); </script>\n";
		exit ();
	}

	//fetch all informations from the webservices if necessary
	$book = mosBooklibraryWS :: fetchInfos($book);


	//storning e-book
	$file = $_FILES['ebook_file'];
	//control if fileupload is correkt
	if($booklibrary_configuration['ebooks']['allow'] && intval($file['error']) > 0 && intval($file['error']) < 4){
		echo "<script> alert('" . _BOOKLIBRARY_LABEL_EBOOK_UPLOAD_ERROR . "'); window.history.go(-1); </script>\n";
		exit ();
	}else if (intval($file['error']) != 4){
		$file_new = $mosConfig_absolute_path . $booklibrary_configuration['ebooks']['location'] . $file['name'];		
		echo $file_new;
		if(!move_uploaded_file($file['tmp_name'],  $file_new)){
			echo "<script> alert('" . _BOOKLIBRARY_LABEL_EBOOK_UPLOAD_ERROR . "'); window.history.go(-1); </script>\n";
			exit ();
		}else {
			$book->ebookURL = $mosConfig_live_site . $booklibrary_configuration['ebooks']['location'] . $file['name'];
		}
	}
	
	$file = $_FILES['picture_file'];

	//control if fileupload is correkt
	if($file['size'] != 0 && $file['error'] != 0 && strpos($file['type'], 'image')){
		echo "<script> alert('" . _BOOKLIBRARY_LABEL_PICTURE_URL_UPLOAD_ERROR . "'); window.history.go(-1); </script>\n";
		exit ();
	}

	if($file['size'] == 0){
		$file = null;
	}
		
	//store pictures local if neccesary
	if(intval($booklibrary_configuration['fetchImages']['boolean']) == 1 || $file['size'] != 0){
		
		$retVal = mosBooklibraryOthers :: storeImageFile($book, $file);
		if ($retVal != null){
			echo "<script> alert('".$retVal."'); window.history.go(-1); </script>\n";
			exit ();
		}
	}

	//delete ebook file if neccesary
	$delete_ebook = mosGetParam($_POST, 'delete_ebook', 0);
	if($delete_ebook != '0'){
		$retVal = @unlink($mosConfig_absolute_path . $delete_ebook);
		if (!$retVal) {
			echo "<script> alert('" ._BOOKLIBRARY_ERROR_DEL . "'); window.history.go(-1); </script>\n";
			exit ();
		} else {
			$book->ebookURL = "";
		}
	}	
	
	if (is_string($book)) {
		echo "<script> alert('".$book."'); window.history.go(-1); </script>\n";
		exit ();
	}

	$book->date = date("Y-m-d H:i:s");
	if (!$book->check()) {
		echo "<script> alert('".$book->getError()."'); window.history.go(-1); </script>\n";
		exit ();
	}
	if (!$book->store()) {
		echo "<script> alert('".$book->getError()."'); window.history.go(-1); </script>\n";
		exit ();
	}
	$book->checkin();
	$book->updateOrder( "catid='$book->catid'" );

	
	//$book->updateOrder("catid='$row->catid'");
	//$id = $row->id;*/

	mosRedirect("index2.php?option=$option");

}

/**
* Deletes one or more records
* @param array An array of unique category id numbers
* @param string The current author option
*/
function removeBooks($bid, $option) {
	global $database;

	if (!is_array($bid) || count($bid) < 1) {
		echo "<script> alert('Select an item to delete'); window.history.go(-1);</script>\n";
		exit;
	}
	if (count($bid)) {
		$bids = implode(',', $bid);
		$database->setQuery("DELETE FROM #__booklibrary WHERE id IN ($bids)");
		if (!$database->query()) {
			echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		}
	}

	mosRedirect("index2.php?option=$option");
}

/**
* Publishes or Unpublishes one or more records
* @param array An array of unique category id numbers
* @param integer 0 if unpublishing, 1 if publishing
* @param string The current author option
*/
function publishBooks($bid, $publish, $option) {
	global $database, $my;

	$catid = mosGetParam($_POST, 'catid', array (0));

	if (!is_array($bid) || count($bid) < 1) {
		$action = $publish ? 'publish' : 'unpublish';
		echo "<script> alert('Select an item to $action'); window.history.go(-1);</script>\n";
		exit;
	}

	$bids = implode(',', $bid);

	$database->setQuery("UPDATE #__booklibrary SET published='$publish'".
						"\nWHERE id IN ($bids) AND (checked_out=0 OR (checked_out='$my->id'))");
	if (!$database->query()) {
		echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		exit ();
	}

	if (count($bid) == 1) {
		$row = new mosBookLibrary($database);
		$row->checkin($bid[0]);
	}
	mosRedirect("index2.php?option=$option");
}
/**
* Moves the order of a record
* @param integer The increment to reorder by
*/
function orderBooks($bid, $inc, $option) {
	global $database;
	
	$book = new mosBookLibrary($database);
	$book->load($bid);
	$book->move($inc);

	mosRedirect("index2.php?option=$option");
}

/**
* Cancels an edit operation
* @param string The current author option
*/
function cancelBook($option) {
	global $database;
	$row = new mosBookLibrary($database);
	$row->bind($_POST);
	$row->checkin();
	mosRedirect("index2.php?option=$option");
}

/**
* refetchs the information of books
* @param string The current author option
*/
function refetchInfo($option, $bid) {
	global $database, $my, $booklibrary_configuration;

	$informationFrom = mosGetParam($_POST, 'informationFrom');

	if (!is_array($bid) || count($bid) < 1) {

		echo "<script> alert('Select an item to refetch'); window.history.go(-1);</script>\n";
		exit;
	}

	$bids = implode(',', $bid);
	$database->setQuery("SELECT id, bookid, isbn, title, informationFrom from #__booklibrary WHERE id IN ($bids)");

	if (!$database->query()) {
		echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		exit ();
	}
	$books = $database->loadObjectList();

	// get list of WS
	$retVal = mosBooklibraryWS :: getWSArray();
	$ws = null;
	for ($i = 0, $n = count($retVal); $i < $n; $i ++) {
		$help = $retVal[$i];
		$ws[] = mosHTML :: makeOption($help[0], $help[1]);
	}
	$wslist = mosHTML :: selectList($ws, 'informationFrom', 'class="inputbox" size="1"', 'value', 'text');

	if ($informationFrom == null) {
		//show fetching information

		HTML_booklibrary :: refetchBoosks($option, $books, $wslist);
	} else {
		//fetching information	
		$infos = array ();

		$bookid = array_pop($bid);

		while ($bookid != null) {

			$book = new mosBookLibrary($database);
			$book->load($bookid);
			$book->informationFrom = $informationFrom;

			$book_tmp = $book;

			$book = mosBooklibraryWS :: fetchInfos($book);
			if (is_string($book)) {
				//there was an error while fetching!!
				array_push($infos, array ($book_tmp->id, $book_tmp->bookid, $book_tmp->isbn, $book));
			} else {
				//storing pictures if neccesary	
				$retVal = null;
				if(intval($booklibrary_configuration['fetchImages']['boolean']) == 1){
					$retVal = mosBooklibraryOthers :: storeImageFile($book, null);
				}
				//fetching was ok!!
				$book->date = date("Y-m-d H:i:s");

				if ($retVal != null){
					// error storing picture
					array_push($infos, array ($book->id, $book->bookid, $book->isbn, $retVal));
				} else if(!$book->check() || !$book->store()) {
					//error while storing information!!
					array_push($infos, array ($book->id, $book->bookid, $book->isbn, $book->getError()));
				} else {
					array_push($infos, array ($book->id, $book->bookid, $book->isbn, "OK"));
				}
				$book->checkin();
			}
			$bookid = array_pop($bid);
			
		}
		$infos = array_reverse($infos);
		HTML_booklibrary :: showInfoRefetchBoosks($option, $infos, $wslist);
	}
}


function configure_save($option){
	global $my, $booklibrary_configuration;
	
	$booklibrary_configuration['proxy']['host']=mosGetParam($_POST, 'proxy_host', '');
	$booklibrary_configuration['proxy']['port']=mosGetParam($_POST, 'proxy_port', '');
	$booklibrary_configuration['proxy']['user']=mosGetParam($_POST, 'proxy_user', '');
	$booklibrary_configuration['proxy']['pwd']=mosGetParam($_POST, 'proxy_pwd', '');
	$booklibrary_configuration['ws']['amazon']['tag']=mosGetParam($_POST, 'ws_amazon_tag', "gerdsaurer-20");
	
	$booklibrary_configuration['price']['show']= mosGetParam($_POST, 'price_show', 0);
	
	$booklibrary_configuration['fetchImages']['boolean']= mosGetParam($_POST, 'fetchImages_boolean', 0);
	$booklibrary_configuration['fetchImages']['location']= mosGetParam($_POST, 'fetchImages_location', "/components/com_booklibrary/covers/");
	$booklibrary_configuration['reviews']['show']= mosGetParam($_POST, 'reviews_show', 0);
	$booklibrary_configuration['reviews']['registrationlevel']= mosGetParam($_POST, 'reviews_registrationlevel', 0);
	$booklibrary_configuration['ebooks']['allow']= mosGetParam($_POST, 'ebooks_allow', 0);
	$booklibrary_configuration['ebooks']['show']= mosGetParam($_POST, 'ebooks_show', 0);
	//$booklibrary_configuration['ebooks']['registrationlevel']= mosGetParam($_POST, 'ebooks_registrationlevel', 0);
	$booklibrary_configuration['ebooks']['location']= mosGetParam($_POST, 'ebooks_location', "/components/com_booklibrary/ebooks/");
	
	$booklibrary_configuration['editbook']['check']['isbn'] = mosGetParam($_POST, 'editbook_check_isbn', 0);
	
	$booklibrary_configuration['lendstatus']['show']=mosGetParam($_POST, 'lendstatus_show', 0);
	$booklibrary_configuration['lendrequest']['registrationlevel']=mosGetParam($_POST, 'lendrequest_registrationlevel', 0);			
	mosBooklibraryOthers :: setParams();
	
	configure($option);
	
}

function configure($option) {
	global $my, $booklibrary_configuration, $acl;
	
	
	$yesno[] = mosHTML :: makeOption('1', _BOOKLIBRARY_YES);
	$yesno[] = mosHTML :: makeOption('0', _BOOKLIBRARY_NO);
	
	$gtree[] = mosHTML :: makeOption('-2', 'Everyone');
	$gtree = array_merge($gtree, $acl->get_group_children_tree( null, 'USERS', false ));
	

	$lists = array ();
	$lists['proxy']['host'] = '<input type="text" name="proxy_host" value="'.$booklibrary_configuration['proxy']['host'].'" class="inputbox" size="50" maxlength="250" title=""/>';
	$lists['proxy']['port'] = '<input type="text" name="proxy_port" value="'.$booklibrary_configuration['proxy']['port'].'" class="inputbox" size="4" maxlength="4" title=""/>';
	$lists['proxy']['user'] = '<input type="text" name="proxy_user" value="'.$booklibrary_configuration['proxy']['user'].'" class="inputbox" size="50" maxlength="250" title=""/>';
	$lists['proxy']['pwd'] = '<input type="text" name="proxy_pwd" value="'.$booklibrary_configuration['proxy']['pwd'].'" class="inputbox" size="50" maxlength="250" title=""/>';

	$lists['price']['show'] = mosHTML :: RadioList($yesno, 'price_show', 'class="inputbox"', $booklibrary_configuration['price']['show'], 'value', 'text');
	$lists['editbook']['check']['isbn'] = mosHTML :: RadioList($yesno, 'editbook_check_isbn', 'class="inputbox"', $booklibrary_configuration['editbook']['check']['isbn'], 'value', 'text');
	
	
	$lists['ws']['amazon']['tag'] = '<input type="text" name="ws_amazon_tag" value="'.$booklibrary_configuration['ws']['amazon']['tag'].'" class="inputbox" size="50" maxlength="50" title=""/>';

	$lists['fetchImages']['boolean'] = mosHTML :: RadioList($yesno, 'fetchImages_boolean', 'class="inputbox"', $booklibrary_configuration['fetchImages']['boolean'], 'value', 'text');
	$lists['fetchImages']['location'] = '<input type="text" name="fetchImages_location" value="'.$booklibrary_configuration['fetchImages']['location'].'" class="inputbox" size="50" maxlength="50" title=""/>';
	
	$lists['reviews']['show'] = mosHTML :: RadioList($yesno, 'reviews_show', 'class="inputbox"', $booklibrary_configuration['reviews']['show'], 'value', 'text');
	//$lists['reviews']['show'] = mosHTML::selectList( $gtree, 'reviews_show', 'size="4"', 'value', 'text', $booklibrary_configuration['reviews']['show'] );
	$lists['reviews']['registrationlevel'] = mosHTML::selectList( $gtree, 'reviews_registrationlevel', 'size="4"', 'value', 'text', $booklibrary_configuration['reviews']['registrationlevel'] );

	$lists['ebooks']['allow'] = mosHTML :: RadioList($yesno, 'ebooks_allow', 'class="inputbox"', $booklibrary_configuration['ebooks']['allow'], 'value', 'text');
	$lists['ebooks']['show'] = mosHTML :: RadioList($yesno, 'ebooks_show', 'class="inputbox"', $booklibrary_configuration['ebooks']['show'], 'value', 'text');
	$lists['ebooks']['location'] = '<input type="text" name="ebooks_location" value="'.$booklibrary_configuration['ebooks']['location'].'" class="inputbox" size="50" maxlength="50" title=""/>';
	$lists['ebooks']['registrationlevel'] = mosHTML::selectList( $gtree, 'ebooks_registrationlevel', 'size="4"', 'value', 'text', $my->gid );

	$lists['lendstatus']['show'] = mosHTML :: RadioList($yesno, 'lendstatus_show', 'class="inputbox"', $booklibrary_configuration['lendstatus']['show'], 'value', 'text');
	//$lists['lendstatus']['show'] = mosHTML::selectList( $gtree, 'lendstatus_show', 'size="4"', 'value', 'text', $booklibrary_configuration['lendstatus']['show'] );
	$lists['lendrequest']['registrationlevel'] = mosHTML::selectList( $gtree, 'lendrequest_registrationlevel', 'size="4"', 'value', 'text', $booklibrary_configuration['lendrequest']['registrationlevel'] );
	

	
	HTML_booklibrary :: showConfiguration($lists, $option);
}

function lend($option, $bid) {
	global $database, $my;

	if (!is_array($bid) || count($bid) < 1) {
		echo "<script> alert('Select an item to lend'); window.history.go(-1);</script>\n";
		exit;
	}

	$bids = implode(',', $bid);

	$select ="SELECT a.*, cc.name AS category, l.id as lendid, l.lend_from as lend_from, ".
			"l.lend_return as lend_return, l.lend_until as lend_until, l.fk_userid as fk_userid, ".
			"l.user_name as user_name, l.user_email as user_email, u.name AS name, u.email as email".
			"\nFROM #__booklibrary AS a".
			"\nLEFT JOIN #__categories AS cc ON cc.id = a.catid".
			"\nLEFT JOIN #__booklibrary_lend AS l ON l.id = a.fk_lendid".
			"\nLEFT JOIN #__users AS u ON u.id = l.fk_userid".
			"\nWHERE a.id in (".$bids.")";
	
	
	$database->setQuery($select);

	if (!$database->query()) {
		echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		exit ();
	}
	$books = $database->loadObjectList();
	
	
	
	// get list of categories
	$userlist[] = mosHTML :: makeOption('-1', '----------');	
	$database->setQuery("SELECT id AS value, name AS text from #__users ORDER BY name");
	$userlist = array_merge($userlist, $database->loadObjectList());
	$usermenu = mosHTML :: selectList($userlist, 'userid', 'class="inputbox" size="1"', 'value', 'text', '-1');
	
	HTML_booklibrary :: showLendBooks($option, $books, $usermenu, "lend");

}

function lend_return($option, $bid) {
	global $database, $my;

	if (!is_array($bid) || count($bid) < 1) {
		echo "<script> alert('Select an item to lend'); window.history.go(-1);</script>\n";
		exit;
	}

	$bids = implode(',', $bid);
	
	//for databases without subselect
	$select ="SELECT a.*, cc.name AS category, l.id as lendid, l.lend_from as lend_from, ".
			"l.lend_return as lend_return, l.lend_until as lend_until, l.fk_userid as fk_userid, ".
			"l.user_name as user_name, l.user_email as user_email, u.name AS name, u.email as email".
			"\nFROM #__booklibrary AS a".
			"\nLEFT JOIN #__categories AS cc ON cc.id = a.catid".
			"\nLEFT  JOIN #__booklibrary_lend AS l ON l.id = a.fk_lendid".
			"\nLEFT JOIN #__users AS u ON u.id = l.fk_userid".
			"\nWHERE a.id in (".$bids.")";
	
	$database->setQuery($select);

	if (!$database->query()) {
		echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		exit ();
	}
	$books = $database->loadObjectList();
	

	// get list of users
	$userlist[] = mosHTML :: makeOption('-1', '----------');	
	$database->setQuery("SELECT id AS value, name AS text from #__users ORDER BY name");
	$userlist = array_merge($userlist, $database->loadObjectList());
	$usermenu = mosHTML :: selectList($userlist, 'userid', 'class="inputbox" size="1"', 'value', 'text', '-1');

	HTML_booklibrary :: showLendBooks($option, $books, $usermenu, "lend_return");

}

function saveLend($option, $bids) {
	global $database, $my;
	if (!is_array($bids) || count($bids) < 1) {
		echo "<script> alert('Select an item to lend'); window.history.go(-1);</script>\n";
		exit;
	}

	for ($i = 0, $n = count($bids); $i < $n; $i ++) {
		$id = $bids[$i];
		$lend = new mosBookLibrary_lend($database);

		$lend->lend_from = date("Y-m-d H:i:s");
		if (mosGetParam($_POST, 'lend_until') != "") {
			$lend->lend_until = mosGetParam($_POST, 'lend_until');
		} else {
			$lend->lend_until = null;
		}
		$lend->fk_bookid = $id;

		$userid = mosGetParam($_POST, 'userid');

		if ($userid == "-1") {
			$lend->user_name = mosGetParam($_POST, 'user_name', '');
			$lend->user_email = mosGetParam($_POST, 'user_email', '');
		} else {
			$lend->fk_userid = intval($userid);
		}

		if (!$lend->check($lend)) {
			echo "<script> alert('".$lend->getError()."'); window.history.go(-1); </script>\n";
			exit ();
		}
		if (!$lend->store()) {
			echo "<script> alert('".$lend->getError()."'); window.history.go(-1); </script>\n";
			exit ();
		}

		$lend->checkin();
		
		$book = new mosBookLibrary($database);
		$book->load($id);
		$book->fk_lendid = $lend->id;
		$book->store();
		$book->checkin();
	}
	
	mosRedirect("index2.php?option=$option");

}

function saveLend_return($option, $lids) {
	global $database, $my;
	if (!is_array($lids) || count($lids) < 1) {
		echo "<script> alert('Select an item to return'); window.history.go(-1);</script>\n";
		exit;
	}

	for ($i = 0, $n = count($lids); $i < $n; $i ++) {
		$id = $lids[$i];
		$lend = new mosBookLibrary_lend($database);

		$lend->load(intval($id));

		$lend->lend_return = date("Y-m-d H:i:s");

		if (!$lend->check($lend)) {
			echo "<script> alert('".$lend->getError()."'); window.history.go(-1); </script>\n";
			exit ();
		}
		if (!$lend->store()) {
			echo "<script> alert('".$lend->getError()."'); window.history.go(-1); </script>\n";
			exit ();
		}

		$lend->checkin();
		
		$book = new mosBookLibrary($database);
		$book->load($lend->fk_bookid);		
		$book->fk_lendid = null;
		$book->store(true);
		$book->checkin(true);
		
	}
	
	mosRedirect("index2.php?option=$option");

}

function import($option) {
	global $database, $my;

	$file = file($_FILES['import_file']['tmp_name']);

	$catid = mosGetParam($_POST, 'import_catid');
	$retVal = mosBooklibraryImportExport :: importBooksCSV($file, $catid);

	HTML_booklibrary:: showImportResult($retVal, $option);
}

function export($option) {
	global $database, $my, $mainframe;

	$catid = mosGetParam($_POST, 'export_catid', 0);
	$lend = mosGetParam($_POST, 'export_lend', null);
	$pub = mosGetParam($_POST, 'export_pub', null);
	$type = mosGetParam($_POST, 'export_type', 0);

	$search = $mainframe->getUserStateFromRequest("search{$option}", 'search', '');
	$search = $database->getEscaped(trim(strtolower($search)));

	$where = array ();

	if ($lend == "lend") {
		array_push($where, "a.fk_lendid <> 0");
	} else if ($lend == "not_lend") {
		array_push($where, "a.fk_lendid = 0");
	} 

	if ($pub== "pub") {
		array_push($where, "a.published = 1");
	} else if ($pub == "not_pub") {
		array_push($where, "a.published = 0");
	} 

	if ($catid > 0) {
		array_push($where, "a.catid='$catid'");
	}
	
	if ($search) {
		array_push($where, "(LOWER(a.title) LIKE '%$search%' OR LOWER(a.authors) LIKE '%$search%' OR LOWER(a.isbn) LIKE '%$search%' OR LOWER(a.comment) LIKE '%$search%')");
	}
	$selectstring = "SELECT id FROM #__booklibrary AS a ".
					(count($where) ? "\nWHERE ".implode(' AND ', $where) : "").
					"\nORDER BY a.catid, a.ordering";
					
	$database->setQuery($selectstring);

	$bids = $database->loadObjectList();
	if ($database->getErrorNum()) {
		echo $database->stderr();
		return;
	}
	
	$books = array();
	$count = 0;
	foreach($bids as $bid){
		$book = new mosBookLibrary($database);
		// load the row from the db table
		$book->load(intval($bid->id));
		$books[$count] = $book;
		$count ++;
	}
	
	$retVal = mosBooklibraryImportExport :: exportBooksXML($books, false);
	
	$type2 = 'xml';
	switch ($type) {
		case '1':
		$type2 = 'csv';	
	    break;
		
		case '2':
		$type2 = 'xml';
		break;
	}
	
	$InfromationArray = mosBooklibraryImportExport :: storeExportFile($retVal, $type2);
	HTML_booklibrary :: showExportResult($InfromationArray, $option);
	
}

function importExportBooks($option) {
	global $database;

	
	
	// get list of categories
	$categories[] = mosHTML :: makeOption('0', _BOOKLIBRARY_LABEL_SELECT_CATEGORIES);
	$database->setQuery("SELECT id AS value, name AS text FROM #__categories"."\nWHERE section='$option' ORDER BY ordering");
	$categories = array_merge($categories, $database->loadObjectList());

	if (count($categories) < 1) {
		mosRedirect("index2.php?option=categories&section=$option", _BOOKLIBRARY_ADMIN_IMPEXP_ADD);
	}

	$impclist = mosHTML :: selectList($categories, 'import_catid', 'class="inputbox" size="1"', 'value', 'text', 0);
	$expclist = mosHTML :: selectList($categories, 'export_catid', 'class="inputbox" size="1"', 'value', 'text', 0);

	$params = array();
	$params['import']['category'] = $impclist;
	$params['export']['category'] = $expclist;
	
	
	$importtypes[0] = mosHTML :: makeOption('0', _BOOKLIBRARY_ADMIN_PLEASE_SEL);
	$importtypes[1] = mosHTML :: makeOption('1', _BOOKLIBRARY_ADMIN_FORMAT_CSV);
	//$importtyps[2] = mosHTML :: makeOption('2', _BOOKLIBRARY_ADMIN_FORMAT_XML)
	$params['import']['type'] = mosHTML :: selectList($importtypes, 'import_type', 'class="inputbox" size="1"', 'value', 'text', 0);
	
	$exporttypes[0] = mosHTML :: makeOption('0', _BOOKLIBRARY_ADMIN_PLEASE_SEL);
	$exporttypes[1] = mosHTML :: makeOption('1', _BOOKLIBRARY_ADMIN_FORMAT_CSV);
	$exporttypes[2] = mosHTML :: makeOption('2', _BOOKLIBRARY_ADMIN_FORMAT_XML);
	$params['export']['type'] = mosHTML :: selectList($exporttypes, 'export_type', 'class="inputbox" size="1"', 'value', 'text', 0);
	

	HTML_booklibrary :: showImportExportBooks($params, $option);
}

?>