<?php
/**********************************************************************************
 * Messiah's WikiBot
 * @version 1.0
 * @copyright (c) 2006 The Inevitable eShop
 * @license GNU GPL (http://www.gnu.org/licenses/gpl.txt)
 * @author http://www.theinevitabledossier.com
 **********************************************************************************/

// no direct access
defined( '_VALID_MOS' ) or die( 'Restricted access' );

$_MAMBOTS->registerFunction( 'onPrepareContent', 'botWikiBot' );

/**
* Links WikiTagged words to English Wikipedia.
*
* <b>Usage:</b>
* [[wiki words to be linked]]
*
*/
function botWikiBot( $published, &$row, &$params, $page=0 ) {

	// check whether mambot has been unpublished
	if ( !$published ) {
		return true;
	}
	
	// define the regular expression for the bot
	$regex = "#\[\[(.*?)\]\]#s";

	// perform the replacement
	$row->text = preg_replace_callback( $regex, 'botwiki_replacer', $row->text );

	return true;
}
/**
* Replaces the WikiTagged words
* @return Wikilinked words
*/
function botwiki_replacer( &$matches ) {
   return "<a href=\"http://de.wikipedia.org/wiki/$matches[1]\" target=\"wiki\">$matches[1]</a>";
}
?>
