<?php
/*
package    : VirtueUpload
version    : 1.0.0 STABLE
author     : Tobias Kuhn - eaxs.de
Homepage   : http://www.eaxs.de
copyright  : Copyright (C) 2006 Tobias Kuhn - eaxs.de
license    : http://www.gnu.org/copyleft/gpl.html

* VirtueUpload is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
*/

defined( '_VALID_MOS' ) or die( 'Restricted access' );

class html_virtueupload {

  var $rows;
  var $userlevel;
  var $curr_path;
  var $curr_page;
  var $msg;
  var $status;
  var $template;

/*==============================================================================
* Function: html_virtueupload
* this is the constructor
* define some variables
==============================================================================*/
function html_virtueupload (){
  global $option;

  $this->rows         = getMyorders ();
  $this->userlevel    = getUserlevel ();
  $this->curr_path    = getPath ();
  $this->curr_page    = mosGetParam( $_REQUEST, 'page');
  $this->msg          = mosGetParam( $_REQUEST, 'msg', null);
  $this->status       = $this->get_status($this->msg);
  $this->template     = getTemplate($option);
}
/*==============================================================================
* Author    : Tobias Kuhn
* Function  : show_form
* Parameter : -
* Return    : HTML form
==============================================================================*/
function show_form () {
  global $mosConfig_absolute_path, $mosConfig_live_site, $sess, $database;

  $ip = $_SERVER['REMOTE_ADDR'];
  $session = session_id();

  $query = "SELECT ip"
         . "\n FROM #__virtueuploads_ban"
         . "\n WHERE ip = '$ip'";
         $database->setQuery($query);
         $banned = $database->loadResult();

  if ($banned != '') {
    return LANG_VMUPL_BANNED;
  }
  if ((VU_CFG_UPLOADENABLED == '1') AND ($this->userlevel >= VU_CFG_ACCESSLEVEL)) {

    $header      = $this->create_header($this->curr_path, $this->template);
    $orderlist   = $this->create_orderlist ($this->userlevel, $this->rows, $this->curr_page);
    $statusfield = $this->create_statusdisplay();
    $filefield   = $this->create_filefield();
    $comfield    = $this->create_comfield();
    $submit      = $this->create_submit();
    $footer      = $this->create_footer();
    $heading     = VULANG_FORM_HEADING;
    $image       = "<img src=\"".$mosConfig_live_site."/components/com_virtueupload/images/upload.png\" width=\"35px\" height=\"35px\">";

    $HTML_form = file_get_contents($mosConfig_absolute_path.'/components/com_virtueupload/templates/'.$this->template.'.php');
    $elements = array(
                     'vu_status'  => $statusfield,
                     'vu_file'    => $filefield,
                     'vu_orders'  => $orderlist,
                     'vu_comment' => $comfield,
                     'vu_image'   => $image,
                     'vu_heading' => $heading,
                     'vu_submit'  => $submit
                     );
      foreach($elements as $element => $content) {
        $HTML_form = str_replace('{'.$element.'}', $content, $HTML_form);
      }
    $output = $header.$HTML_form.$this->status.$footer;
   }
   else {
    $output = '';
  }
  return $output;
}
/*==============================================================================
* Author    : Tobias Kuhn
* Function  : create_header
* Parameter : current url-string
* Return    : HTML form-header
==============================================================================*/
function create_header ($curr_path, $template) {
  global $mosConfig_live_site;

  $header = "<link href=\"".$mosConfig_live_site;
  $header .= "/components/com_virtueupload/templates/css/".$template.".css\" rel=\"stylesheet\" type=\"text/css\"/>";
  $header .= "<form id='VirtueUpload' name='VirtueUpload' action='".sefRelToAbs( $curr_path )."' method='post' enctype='multipart/form-data'>";

  return $header;
}
/*==============================================================================
* Author    : Tobias Kuhn
* Function  : create_orderlist
* Parameter : virtuemart order_id
* Return    : HTML dropdown-list
==============================================================================*/
function create_orderlist ($user_level, &$rows, $curr_page) {
  global $database, $my;

   $query = "SELECT COUNT(*)"
          . "\n FROM #__vm_orders"
          . "\n WHERE user_id = '$my->id'";
          $database->setQuery($query);
          $my_orders = $database->loadResult();

  if ($user_level >= VU_CFG_ACCESSLEVEL AND ($my_orders > 0)) {
    $orderlist = "<select class='vu_orders' name='order_id' size='1'>";
    $orderlist .= "<option value='none'>".VULANG_FORM_ORDER."</option>";
    for ($i=0, $n=count( $rows ); $i < $n; $i++) {
         $row = $rows[$i];
         $orderlist .= "<option value=\"".$row->order_id."\">";
         $orderlist .= VULANG_FORM_ORDERNR.$row->order_id."</option>";
    }
    $orderlist .= "</select>";
  }
  else {
    $orderlist = '';
  }
  return $orderlist;
}
/*==============================================================================
* Author    : Tobias Kuhn
* Function  : create_statusdisplay
* Parameter : -
* Return    : HTML form-field for the current status
==============================================================================*/
function create_statusdisplay () {

  $status_display = "<label for='status'>".VULANG_FORM_STATUS."</label><br>";
  $status_display .= "<input class='vu_status' type='text' id='status' name='status' readonly='readonly' value='".VULANG_STAT_WAITTUPL."'>";

  return $status_display;
}
/*==============================================================================
* Author    : Tobias Kuhn
* Function  : create_filefield
* Parameter : -
* Return    : HTML form-field for the file
==============================================================================*/
function create_filefield () {
  $filefield = "<label for='file'>".VULANG_FORM_LBL_FILE."</label>";
  $filefield .= "<input name='file' type='file' class='vu_file'>";

  return $filefield;
}
/*==============================================================================
* Author    : Tobias Kuhn
* Function  : create_comfield
* Parameter : -
* Return    : HTML form-textarea for the comment
==============================================================================*/
function create_comfield () {
  if (VU_CFG_COMMENTENABLED == '1') {
    $comfield = "<label for='comment'>".VULANG_FORM_LBL_COMMENT."</label><br>";
    $comfield .= "<textarea name='comment' class='vu_comment'></textarea>";
  }
  else {
    $comfield = '';
  }
  return $comfield;
}
/*==============================================================================
* Author    : Tobias Kuhn
* Function  : create_submit
* Parameter : -
* Return    : HTML form-button and end of the form
==============================================================================*/
function create_submit () {
  global $sess;

  $submit = "<input name='submit' type='submit' value='".VULANG_FORM_SUBMIT."' class='vu_submit' onclick=\"";
  $submit .= "this.form.status.value = '".VULANG_STAT_INITUPL."';this.form.status.style.color = '#339900'\">";

  return $submit;
}
/*==============================================================================
* Author    : Tobias Kuhn
* Function  : get_status
* Parameter : current status ID
* Return    : JS set the current upload-status
==============================================================================*/
function get_status ($msg) {


    if($msg == '1') {
      $this->status = "<script type='text/javascript'>document.VirtueUpload.status.value = '".VULANG_STAT_NOFILE."';document.VirtueUpload.status.style.color = '#FF0000';</script>";
      }

    if($msg == '2') {
      $this->status = "<script type='text/javascript'>document.VirtueUpload.status.value = '".VULANG_STAT_EXISTS."';document.VirtueUpload.status.style.color = '#FF0000';</script>";
      }

    if($msg == '3') {
      $this->status = "<script type='text/javascript'>document.VirtueUpload.status.value = '".VULANG_STAT_WRONGEXT."';document.VirtueUpload.status.style.color = '#FF0000';</script>";
      }

    if($msg == '4') {
      $this->status = "<script type='text/javascript'>document.VirtueUpload.status.value = '".VULANG_STAT_WRONGSIZE."';document.VirtueUpload.status.style.color = '#FF0000';</script>";
      }

    if($msg == '5') {
      $this->status = "<script type='text/javascript'>document.VirtueUpload.status.value = '".VULANG_STAT_SUCCESS."';document.VirtueUpload.status.style.color = '#339900';</script>";
      }

    if($msg == '6') {
      $this->status = "<script type='text/javascript'>document.VirtueUpload.status.value = '".VULANG_STAT_ERROR."';document.VirtueUpload.status.style.color = '#FF0000';</script>";
      }

    if($msg == '7') {
      $this->status = "<script type='text/javascript'>document.VirtueUpload.status.value = '".VULANG_STAT_NOORDER."';document.VirtueUpload.status.style.color = '#FF0000';</script>";
      }

  return $this->status;
}
/*==============================================================================
* Author    : Tobias Kuhn
* Function  : create_footer
* Parameter : -
* Return    : HTML end of the form
==============================================================================*/
function create_footer () {
  global $sess;

  $footer .= "<input type='hidden' name='option' value='com_virtueupload'>";
  $footer .= "<input type='hidden' name='task' value='start_upload'>";
  $footer .= "<input type='hidden' name='session_id' value='".session_id()."'>";
  $footer .= "</form>";

  return $footer;
}
}
?>
