<?php

defined('_VALID_MOS') or die('Direct Access to this location is not allowed.');

require_once ($mosConfig_absolute_path . "/administrator/components/com_booklibrary/nusoap/nusoap.php");

/**
* Booklibrary Import Export Class
* Handles the import and export of data from the booklibrary.
* @package Booklibrary
* @copyright 2005 Gerd Saurer http://booklibrary.mamboforge.net
* @license http://www.gnu.org/copyleft/gpl.html GNU Public License
* @version $Revision: 1.0 $
*/
class mosBooklibraryOthers{

	/**
	 * Sets the parametes for connecting to a webservice via a proxy
	 * @param the array of parameters
	 * @deprecated $Revision: 1.0 $ - 31.01.2005
	 */
	function setParams(){	
		global $booklibrary_configuration;
		// Prepare settings
		// Using single quotes is easier because you don't have to escape them. For every setting, add a line.
		$settings = "<?php\n";

		$settings .= "// Do not edit this file. Generated by admin script.\n";
		$settings .= "// Booklibrary Configuration file\n";
		$settings .= "// General Informations \n";
		$settings .= "\$booklibrary_configuration['relase']['version']='" . $booklibrary_configuration['relase']['version'] ."';\n";
		$settings .= "\$booklibrary_configuration['relase']['date']='" . $booklibrary_configuration['relase']['date'] ."';\n";
		$settings .= "// edit book checks\n";
		$settings .= "\$booklibrary_configuration['editbook']['check']['isbn']='" . $booklibrary_configuration['editbook']['check']['isbn']  . "';\n";
		$settings .= "// proxy settings\n";
		$settings .= "\$booklibrary_configuration['proxy']['host']='" . $booklibrary_configuration['proxy']['host'] ."';\n";
		$settings .= "\$booklibrary_configuration['proxy']['port']='" . $booklibrary_configuration['proxy']['port'] ."';\n";
		$settings .= "\$booklibrary_configuration['proxy']['user']='" . $booklibrary_configuration['proxy']['user'] ."';\n";
		$settings .= "\$booklibrary_configuration['proxy']['pwd']='" . $booklibrary_configuration['proxy']['pwd'] ."';\n";		
		$settings .= "// price settings\n";
		$settings .= "\$booklibrary_configuration['price']['show']='" . $booklibrary_configuration['price']['show'] ."';\n";
		$settings .= "// amazon settings\n";
		$settings .= "\$booklibrary_configuration['ws']['amazon']['tag']='" . $booklibrary_configuration['ws']['amazon']['tag'] ."';\n";
		$settings .= "\$booklibrary_configuration['ws']['amazon']['devtag']= '" . $booklibrary_configuration['ws']['amazon']['devtag'] ."';\n";
		$settings .= "// fetch images settings\n";
		$settings .= "\$booklibrary_configuration['fetchImages']['boolean']='" . $booklibrary_configuration['fetchImages']['boolean'] ."';\n";
		$settings .= "\$booklibrary_configuration['fetchImages']['location']='" . $booklibrary_configuration['fetchImages']['location'] ."';\n";
		$settings .= "// review settings\n";
		$settings .= "\$booklibrary_configuration['reviews']['show']='" . $booklibrary_configuration['reviews']['show'] ."';\n";
		$settings .= "\$booklibrary_configuration['reviews']['registrationlevel']='" . $booklibrary_configuration['reviews']['registrationlevel'] ."';\n";		
		$settings .= "// lend settings\n";
		$settings .= "\$booklibrary_configuration['lendstatus']['show']='" . $booklibrary_configuration['lendstatus']['show'] ."';\n";
		$settings .= "\$booklibrary_configuration['lendrequest']['registrationlevel']='" . $booklibrary_configuration['lendrequest']['registrationlevel'] ."';\n";
		$settings .= "// ebook settings\n";
		$settings .= "\$booklibrary_configuration['ebooks']['allow']='" . $booklibrary_configuration['ebooks']['allow'] ."';\n";
		$settings .= "\$booklibrary_configuration['ebooks']['show']='" . $booklibrary_configuration['ebooks']['show'] ."';\n";
		$settings .= "\$booklibrary_configuration['ebooks']['registrationlevel']='" . $booklibrary_configuration['ebooks']['registrationlevel'] ."';\n";
		$settings .= "\$booklibrary_configuration['ebooks']['location']='" . $booklibrary_configuration['ebooks']['location'] ."';\n";
		$settings .= "//debuging\n";
		$settings .= "\$booklibrary_configuration['debug']='" . $booklibrary_configuration['debug'] . "';\n";
		$settings .= "?>\n";

		// Write out new initialization file
		$fd = fopen("./components/com_booklibrary/admin.booklibrary.class.conf.php", "w" )
		or die ("Cannot create configuration file.");
		fwrite( $fd, $settings );
		fclose( $fd );
	}

	/**
	 * Rating Array
	 * @return array an Array containing the informations of all Rating
	 * possibilities
	 */
	function getRatingArray(){
		$i = 0;
		$retVal = array();
		while($i < 5){
			//erster teil x,0
			$tmp = $i * 2;
			array_push($retVal, array($tmp, $i.",0"));
			//zweiter teil x,5
			$tmp ++;
			array_push($retVal, array($tmp, $i.",5"));
			$i ++;
		}
		array_push($retVal, array(10, "10,0"));
		return $retVal;
	}
	
	/**
	 * Language Array - defined in the language files!
	 * @return array an Array containing the informations of all Language
	 * possibilities
	 */
	function getLanguageArray(){
		$retVal = array();
		array_push($retVal, array("nothing", _BOOKLIBRARY_LANGUAGE_NOT_USED));
		array_push($retVal, array("pol", _BOOKLIBRARY_LANGUAGE_POL,));
		array_push($retVal, array("eng", _BOOKLIBRARY_LANGUAGE_ENG,));
		array_push($retVal, array("ger", _BOOKLIBRARY_LANGUAGE_GER));
		array_push($retVal, array("spa", _BOOKLIBRARY_LANGUAGE_SPA));
		array_push($retVal, array("fra", _BOOKLIBRARY_LANGUAGE_FRA));
		return $retVal;
	}
	
	/**
	 * fetches the information from the imageURL field of the book and stores
	 * the book with the isbn number in the deffined folder - then overwrites
	 * the information in the imageURL field that it points to the file
	 * downloaded
	 * @param mosBooklibrary book the book with all information that are
	 * neccesary
	 * @return null if everything is ok els the error string
	 */
	function storeImageFile(& $book, $picture){
		global $mosConfig_live_site, $mosConfig_absolute_path, $booklibrary_configuration;
		
		$old_pic = $book->imageURL;
		
		if ($picture != null){
			$new_pic = substr($book->isbn . strrchr($picture['name'], "."), 1);
			if(!move_uploaded_file($picture['tmp_name'], $mosConfig_absolute_path . $booklibrary_configuration['fetchImages']['location'] . $new_pic)){
				return "Error moving File!";
			} else {
				$book->imageURL = $mosConfig_live_site . $booklibrary_configuration['fetchImages']['location'] . $new_pic;
				return null;
			}
		} else if(count($old_pic) > 0){
			$new_pic = substr($book->isbn . strrchr($book->imageURL, "."), 1);
			if ($fpin = @fopen($old_pic, 'r')) {
				$tmp = '';
				while ($data = fread($fpin, 32768)) {
	            	$tmp .= $data;
	            } 
	            fclose($fpin);
	            // Write out new initialization file
				$fd = fopen($mosConfig_absolute_path . $booklibrary_configuration['fetchImages']['location'] . $new_pic, "w" )
				or die ("Cannot create configuration file.");
				fwrite( $fd, $tmp );
				fclose( $fd );
	            
	            $book->imageURL = $mosConfig_live_site . $booklibrary_configuration['fetchImages']['location'] . $new_pic;	            
	            return null;
	            } else {
	            	return "Bad path to image file $url";
	            }
		}
	}
	

}
?>