<?php

/* **************************************************************************
EstateAgent - a Mambo/Joomla Component

File:					class.estategent.php
Copyright: 			2004 - 2006 by Darko Selesi
Homepage: 		http://www.bits-dont-bite.net
Version: 			1.0.1 Stable                       
Created with: 	QuantaPlus 3.4.3 (http://kdewebdev.org)
						Eclipse 3.1.0 (http://www.eclipse.org)
			  			on RedHat/Fedora Linux Core4 (http://fedora.redhat.com)
License: 			GNU/GPL http://www.gnu.org/copyleft/gpl.html
*************************************************************************** */


defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

class EAObject extends mosDBTable {
    
	var $id = null;
  	var $obj_id = null;
  	var $cat = null;
  	var $type = null;
  	var $title = null;
  	var $description = null;
  	var $location = null;
  	var $condition = null;
  	var $other = null;
  	var $rooms = null;
	var $bedrooms = null;
	var $wc = null;
  	var $space = null;
  	var $homes = null;
  	var $homes_size = null;
  	var $pp_size = null;
  	var $trade_units = null;
  	var $trade_size = null;
  	var $position = null;
  	var $lift = null;
	var $handicap = null;
  	var $yobuilt = null;
  	var $toheat = null;
  	var $toheat_ufloor = null;
  	var $fireside = null;
	var $aircondition = null;
	var $tv = null;
	var $dsl = null;	
	var $balcony = null;
  	var $terrace = null;
	var $swpool = null;
  	var $garden = null;
  	var $parkarea = null;
  	var $garage = null;
  	var $rent = null;
  	var $rent_extra = null;
  	var $price = null;
  	var $commis = null;
  	var $secure = null;
  	var $receipts = null;
  	var $street = null;
  	var $streetnr = null;
  	var $pcode = null;
  	var $town = null;
  	var $district = null;
  	var $state = null;
  	var $country = null;
  	var $hits = null;
  	var $hot = null;
  	var $metadesc = null;
  	var $metakey = null;
  	var $created = null;
  	var $created_by = null;
  	var $access = null;
  	var $publish_up = null;
  	var $publish_down = null;
  	var $publish = null;

  	function EAObject( &$db ) {
    	$this->mosDBTable( '#__estateagent', 'id', $db );
  	}
		
	function count_hits() {
		 
		 $query = "UPDATE #__estateagent SET hits=(hits+1) WHERE id=$this->id";
 	     $this->_db->setQuery($query);
 	     $this->_db->query();
	}
			
	function parseShortInfo($ps,$value=0.00,$country,$state,$town,$district){

		$html = array();		
		$si = array($value,$country,$state,$town,$district);

		for($x=0;$x<count($si);$x++){
			if($ps[$x] && ($si!=0.00 || $si[$x]!="")) $html[] = $si[$x]; 
		}	

		$html = implode(" / ",$html);

		return $html;
	}	

	function getObjectImages($oid=null){
		
		if($oid){
			$this->id = $oid;
		}		
		$query = "SELECT id FROM #__estateagent_images WHERE objid ='".$this->id."'";
		$this->_db->setQuery($query);
		$result = $this->_db->loadResultArray();
				
		return $result;
	}

	function loadGallery($oid=null, $own=null) {
  		global $my;

  		if($oid){
			$this->id = $oid;
		}
		
  		if($own == null) {
  			$this->_db->setQuery("SELECT id,objid,title,description,fname,type,path FROM #__estateagent_images WHERE owner = $my->id AND objid != $this->id AND (type = '.jpg' OR type = '.gif' OR type = '.png') ORDER BY ordering ASC");
  		}
  		else{
  			$this->_db->setQuery("SELECT * FROM #__estateagent_images WHERE objid = $this->id AND (type = '.jpg' OR type = '.gif' OR type = '.png') ORDER BY ordering ASC");
  		}
  		$result = $this->_db->loadObjectList();
  		  		 		
  		return $result;
  	}

	// for evaluation only ------------------------------------
	function loadFiles($oid=null,$t=null) {
  		global $database, $my;
  		
		if($oid){
			$this->id = $oid;
		}
		if($t == null) {
			$this->_db->setQuery("SELECT * FROM #__estateagent_images WHERE objid = $this->id AND type != '.jpg' AND type != '.gif' AND type != '.png' ORDER BY type,ordering ASC");
  			$result = $this->_db->loadObjectList();
		}
		else{
  			$this->_db->setQuery("SELECT * FROM #__estateagent_images WHERE objid = $this->id AND type = '.pdf' ORDER BY ordering ASC");
  			$result['pdf'] = $this->_db->loadObjectList();
  					
			$this->_db->setQuery("SELECT * FROM #__estateagent_images WHERE objid = $this->id AND (type = '.avi' OR type = '.mov' OR type = '.mpg' OR type = '.swf') ORDER BY ordering ASC");
  			$result['mov'] = $this->_db->loadObjectList();
 			
			$this->_db->setQuery("SELECT * FROM #__estateagent_images WHERE objid = $this->id AND (type = '.doc' OR type = '.xls' OR type = '.ppt') ORDER BY ordering ASC");
  			$result['msdoc'] = $this->_db->loadObjectList();
			
			$this->_db->setQuery("SELECT * FROM #__estateagent_images WHERE objid = $this->id AND (type = '.odt' OR type = '.odp' OR type = '.ods') ORDER BY ordering ASC");
  			$result['ooffice'] = $this->_db->loadObjectList();
  		}
	
  		return $result;
  	}

	function country_select_list(){
		global $mosConfig_absolute_path;
		
		// to change the entries of the countries selectlist, edit this file and your languagefile			
		require($mosConfig_absolute_path."/components/com_estateagent/includes/countries.inc.php");
			
		$c = array();
		while(list($key,$val) = each($countries)) { 
			$c[] = mosHTML::makeOption( $key, $val );	
		}
		return $c;		
	}

	function country_ISOtoName($c_iso){
		global $mosConfig_absolute_path;

		require($mosConfig_absolute_path."/components/com_estateagent/includes/countries.inc.php");
		
		while(list($key,$val) = each($countries)) { 
			if($key == $c_iso){
				$cntry = $val;
				break;
			}
		}
		
		return $cntry;	
	}	

	function country_NameToISO($country){
		global $mosConfig_absolute_path;

		require($mosConfig_absolute_path."/components/com_estateagent/includes/countries.inc.php");
		
		$iso_code = "";
		while(list($key,$val) = each($countries)) { 
			if($val == $country){
				$iso_code = $key;
				break;
			}
		}
		
		return $iso_code;	
	}	

}
class EACategory extends mosDBTable {

  	var $id = null;
  	var $name = null;
  	var $description = null;
  	var $parent = null;
  	var $ordering = null;
  	var $access = null;
  	var $publish_up = null;
  	var $publish_down = null;
  	var $publish = null;

	function EACategory( &$db ) {
    	$this->mosDBTable( '#__estateagent_categories', 'id', $db );
  	}
 	
	function getCatEntries($id=null){
				
		if ($id) {
			$this->id = intval( $id );
		}
		$query  = "SELECT id FROM #__estateagent WHERE cat = '".$this->id."'";
		$this->_db->setQuery($query);
        $result = $this->_db->loadResultArray();
				
		return $result;
	}
	
	function getSubcategories($id=null, $gid=1000){
		global $today;
		
		if ($id) {
			$this->id = intval( $id );
		}
		$query  = "SELECT * FROM #__estateagent_categories"
					. " WHERE"
					. " ("
					. "\n ((publish_up >= '0000-00-00' AND publish_up <= '$today') AND publish_down >= '$today')"
       				. "\n OR ((publish_up >= '0000-00-00' AND publish_up <= '$today' ) AND (publish_down = '0000-00-00' OR publish_down >= '$today'))"
       				. "\n OR (publish_up = '0000-00-00' AND publish_down = '0000-00-00')"
       				. "\n )"
					. " AND parent = $this->id AND access <= $gid AND publish='1' ORDER BY ordering";
		$this->_db->setQuery($query);
        $result = $this->_db->loadObjectList();
		
		return $result;				
	}
}

class EAImage extends mosDBTable {

	var $id = null;
  	var $objid = null;
  	var $title = null;
  	var $description = null;
  	var $fname = null;
  	var $type = null;
  	var $path = null;
  	var $owner = null;
  	var $ordering = null;
  	var $publish = null;
  	  	
	function EAImage( &$db ) {
    	$this->mosDBTable( '#__estateagent_images', 'id', $db );
  	}
  	
	function checkForPics($oid){
  		global $database, $mosConfig_live_site;
  				
  		$p = null;

		$query = "SELECT id FROM #__estateagent_images WHERE objid = $oid AND (type = '.jpg' OR type = '.gif' OR type = '.png') AND ordering = 1 AND publish = 1";
  		$database->setQuery($query);
  		$database->loadObject($p);
  		
		if($p != null) {
				return "<img src=\"$mosConfig_live_site/components/com_estateagent/pictures/gui/camera.png\"";
		}
		else{
			return "";
  		}
	}
  	  	
  	function load_firstPic($oid, $path, $pwidth){
  		global $database, $mosConfig_absolute_path, $mosConfig_live_site;
  		
		$html = "";
		$file = "nopic.png";
		$picpath = $path; 		  		
  		$p = null;

		$query = "SELECT title,fname,type,path FROM #__estateagent_images WHERE objid = $oid AND (type = '.jpg' OR type = '.gif' OR type = '.png') AND ordering = 1 AND publish = 1";
  		$database->setQuery($query);
  		$database->loadObject($p);
  		
		if($p != null) {
				$picpath = ($p->path == "")? $picpath : $p->path;
				$p1 = "t" . $p->fname.$p->type;
				$p2 = $p->fname.$p->type;
				$file = (file_exists($mosConfig_absolute_path.$picpath.$p2))? $p2 : (file_exists($mosConfig_absolute_path.$picpath.$p1))? $p1 : $file;				
  		}
		
		$html =	"\n\t<img src=\"".$mosConfig_live_site.$picpath.$file."\" title=\"powered by EstateAgent\" border=\"0\" width=\"".$pwidth."\"/>";
		
		return $html;
  	} 
  	
	// overwritten standard delete method
	function delete($oid=null){
		global $mosConfig_absolute_path, $database;

		if($oid){
			$this->id = $oid;
		}
		// is the image file linked to another object?
		$query = "SELECT id FROM #__estateagent_images WHERE fname = '".$this->fname."' AND id != '".$this->id."'";
		$this->_db->setQuery($query);
  		if($this->_db->loadResult() == null) {	
  			if(chdir($mosConfig_absolute_path.$this->path)) {
	    		$img = $this->fname.$this->type;
    			$thumb = "t".$this->fname.$this->type;
	    		@chmod($img, 0777);
    			@chmod($thumb, 0777);
    			unlink($img);
				unlink($thumb);
    		}
		}
		 
        $query = "DELETE FROM #__estateagent_images"
        			. " WHERE id = '". $this->id ."'";
        $this->_db->setQuery( $query );
  
        if ($this->_db->query()) {
        	return true;
        } else {
        	$this->_error = $this->_db->getErrorMsg();
            return false;
        }	
	}
}

// ************* extended Mambo/Joomla! HTML classes, customized for EA 1.0 by Darko Selesi
// ************* original classes copyright (C) 2000 - 2005 Miro International Pty Ltd / OpenSourceMatters.org

class mosEAHTML extends mosHTML {

	// shows a coloured radiobutton-list ------------------------------	
	function radioList( &$arr, $tag_name, $tag_attribs, $selected=null, $key='value', $text='text' ) {
          reset( $arr );
          $html = "";
          for ($i=0, $n=count( $arr ); $i < $n; $i++ ) {
              $k = $arr[$i]->$key;
              $t = $arr[$i]->$text;
              $id = @$arr[$i]->id;
  
              $extra = "";
              $extra .= $id ? " id=\"" . $arr[$i]->id . "\"" : '';
              if (is_array( $selected )) {
                  foreach ($selected as $obj) {
                      $k2 = $obj->$key;
                      if ($k == $k2) {
                          $extra .= " selected=\"selected\"";
                          break;
                      }
                  }
              } else {
                  $extra .= ($k == $selected ? " checked=\"checked\"" : '');
              }
              $html .= "\n\t<input type=\"radio\" name=\"$tag_name\" value=\"".$k."\"".$tag_attribs." ".$extra." /><span style=\"width:35px; border-style:solid;border-color:#666666;border-width:1px;background-color:".$k."\">".$t."</span>";
          }
          $html .= "\n";
          return $html;
    }
	
	// shows a single checkbox ----------------------------------
    function checkbox( $name, $tag_attribs, $value, $text='', $showtext=0, $checked=null ) {
        $html = "";
				
        $t = ($showtext == '1')? "&nbsp".$text : '';
        $checked = ($checked == 1)? " checked=\"checked\"" : '';
        $html .= "<input type=\"checkbox\" name=\"".$name."\" ".$tag_attribs." value=\"".$value."\"".$checked." />".$t;
          
        return $html;
    }
	
	// shows a group of checkboxes ----------------------------------
    function checkbox_list( &$arr, $tag_name, $tag_attribs, $key='value', $text='text', $checked=array(0,0,0,0,0) ) {
        reset( $arr );
        $html = "";
          
		for ($i=0, $n=count( $arr ); $i < $n; $i++ ) {
              $k = $arr[$i]['key'];
              $t = $arr[$i]['text'];
              
              $extra = ($checked[$i] == 1)? " checked=\"checked\" " : "";
              
              $html .= "<input type=\"checkbox\" name=\"".$tag_name."\" value=\"".$k."\"".$extra." ".$tag_attribs." />".$t."</input>&nbsp;";
        }
         
		return $html;
    }
}

// ************** more EstateAgent functions *****************
function emailToFriendLink( $oid, $type ) {
	global $mosConfig_live_site;
          
	$html = ""; 
    $status = 'status=no,toolbar=no,scrollbars=yes,titlebar=no,menubar=no,resizable=yes,width=480,height=230,directories=no,location=no';
    $link = $mosConfig_live_site .'/index2.php?option=com_estateagent&amp;act=object&amp;task=mtfform&amp;id='. $oid;
    if ( $type==2 ) {
    	$image = mosAdminMenus::ImageCheck( 'emailButton.png', '/images/M_images/', NULL, NULL, _CMN_EMAIL, _CMN_EMAIL );
    } else {
       	$image = '&nbsp;'. _CMN_EMAIL;
    }         	
	$html .= "<td align=\"right\" width=\"5%\">";
    $html .= "<a href=\"#\" onclick=\"window.open('".$link."','EstateAgent','".$status."');\" title=\""._CMN_EMAIL."\">";
    $html .= $image;
    $html .= "</a></td>";
    	
	return $html;
}

function check_email($email){	
	$check = false;
    if (preg_match( "/[\w\.\-]+@\w+[\w\.\-]*?\.\w{1,4}/", $email )) {
       	$check = true;
    }
	return $check; 
}

function showPrintIcon() {  // not ready yet
	
	#$html .= "<a href=\"javascript:void window.open('http://127.0.0.1/joomla/index2.php?option=com_estateagent&amp;act=object&amp;task=showEO&id=$obj', 'win2', 'status=no,toolbar=no,scrollbars=yes,titlebar=no,menubar=no,resizable=yes,width=640,height=480,directories=no,location=no');\" title=\"Drucken\">";
	#$html .= "<img src=\"http://127.0.0.1/joomla/images/M_images/printButton.png\" alt=\"Drucken\" align=\"middle\" name=\"image\" border=\"0\" /></a>";
	
}

// generates the locationsearch querystring
function location_srch_query($country,$state,$town,$district){

		$locations = array($country,$state,$town,$district);
		$fields = array("country","state","town","district");
    	$results = array(); // Array for saving location-part of querystring
        
        $x=0;
        foreach($locations as $lc){
        	$check=0;
        	if($lc == "" || $lc == "no"){
        		$x++;
        		continue;
        	}
        	
        	// checks if one of the last locationfield-parts was set
        	for($y=0;$y<$x;$y++){
        		if($x>=1 && (isset($results[$y]) && $results[$y]!="")){
           			$check = 1;           			
           		}
        	}
        	if($check==1) $results[$x] = " AND " . $fields[$x]."='".$lc."' ";
            else $results[$x] = $fields[$x]."='".$lc."' ";            	
            
        	$x++;     
        }
        
        $query = "";
       	foreach($results as $r){
       		if(isset($r) && $r!="") $query .= $r;
       		else continue;
       	}
        return $query;       
               
}

// generates the extendedsearch querystring
function extended_srch_query($space,$yobuilt,$rooms,$bedrooms,$minrent=0,$maxrent=0,$minprice=0,$maxprice=0,$special){

		$attributes = array($space,$yobuilt,$rooms,$bedrooms,$minrent,$maxrent,$minprice,$maxprice);
		$year = date("Y");
		$results = array(); // saves parts of querystring
        
        $x=0;                        				
	    foreach($attributes as $a){       				
        	$check = "";
        	$results[$x] = "";

        	if($a=="" || $a==0) {
        		$x++;
        		continue;
        	}
                    			
        	// checks if one of the last fields was set
            for($y=0;$y<$x;$y++){
            	if($x >= 1 && $results[$y]!= ""){
            		$check = " AND ";
					break;            		
            	}
            }
            
            if($x==0) {  //Dwelling-space
            	if($a==1) $results[$x] = $check . "space<'51'";
            	elseif($a==2) $results[$x] = $check . "space>'39' AND space<'81'";
            	elseif($a==3) $results[$x] = $check . "space>'69' AND space<'121'";
            	elseif($a==4) $results[$x] = $check . "space>'109' AND space<'161'";
            	elseif($a==5) $results[$x] = $check . "space>'149' AND space<'221'";
           		elseif($a==6) $results[$x] = $check . "space>'199' AND space<'301'";
           		else $results[$x] = $check . "space>='299'";
            }
           	elseif($x==1) { //Year of built                    				
            	if($a==1) $results[$x] = $check . "yobuilt='".$year."'";
            	elseif($a==2) $results[$x] = $check . "yobuilt>'".$year=($year-10)."'";
            	elseif($a==3) $results[$x] = $check . "yobuilt>'".$year=($year-20)."'";
            	elseif($a==4) $results[$x] = $check . "yobuilt>'".$year=($year-40)."'";
            	elseif($a==5) $results[$x] = $check . "yobuilt>'".$year=($year-60)."'";
                elseif($a==6) $results[$x] = $check . "yobuilt>'".$year=($year-80)."'";
                else $results[$x] = $check . "yobuilt<'".$year=($year-80)."'";
            }
            elseif($x==2) { //Number of rooms
            	if($a==1) $results[$x] = $check . "rooms='1'";
            	elseif($a==2) $results[$x] = $check . "rooms>'1'";
            	elseif($a==3) $results[$x] = $check . "rooms>'2'";
            	elseif($a==4) $results[$x] = $check . "rooms>'3'";
            	elseif($a==5) $results[$x] = $check . "rooms>'4'";
            	elseif($a==6) $results[$x] = $check . "rooms>'5'";
            	elseif($a==7) $results[$x] = $check . "rooms>'6'";
            	else $results[$x] = $check . "rooms>'7'";
            }
			elseif($x==3) { //Number of bedrooms
            	if($a==1) $results[$x] = $check . "bedrooms='1'";
            	elseif($a==2) $results[$x] = $check . "bedrooms>'1'";
            	elseif($a==3) $results[$x] = $check . "bedrooms>'2'";
            	elseif($a==4) $results[$x] = $check . "bedrooms>'3'";
            	elseif($a==5) $results[$x] = $check . "bedrooms>'4'";
            	elseif($a==6) $results[$x] = $check . "bedrooms>'5'";
            	elseif($a==7) $results[$x] = $check . "bedrooms>'6'";
            	else $results[$x] = $check . "bedrooms>'7'";
            }
            elseif($x==4) { // Minimal Rent
            	$results[$x] = $check . "rent>'".$a."' ";
            }
            elseif($x==5) { // Maximal Rent
            	$results[$x] = $check . "rent<'".$a."' ";
            }
			elseif($x==6) { // Minimal Price
            	$results[$x] = $check . "price>'".$a."' ";
            }
            elseif($x==7) { // Maximal Price
            	$results[$x] = $check . "price<'".$a."' ";
            }                        
            $x++;
       	}
		
		$query = "";
		// generate attributes part of querystring
       	foreach($results as $r){
       		if($r==0 || $r=="") $query .= $r;
			else $query .= " AND " . $r;
       	}
		
		// add extended attributes, if checked
		if($special){
			$x=0; $y = count($special);
			foreach($special as $s){
				if($x==0 && $query=="") $query .= "$s='1'";
				else $query .= " AND $s='1'";
				$x++;		
			}       
		}
		
		return $query;
}

// loads the locations for generatng the location selectfields for the searchform 
function getMap($todate){
	global $database;
			
	$query = "SELECT country, state, town, district FROM #__estateagent WHERE publish=1";
    $database->setQuery($query);
    $result = $database->loadObjectList();
	echo $database->getErrorMsg();	
	
	return $result;
}


// ************** MAP24 functions ***********************

function map24_cnt_select_list(){	
	global $mosConfig_absolute_path;
	
	require($mosConfig_absolute_path."/components/com_estateagent/includes/map24.inc.php");
					
	$o = array();
	while(list($key,$val) = each($map24_countries)) { 
		$o[] = mosHTML::makeOption( $key, $val );	
	}
	return $o;		
}

// generates HTML selectlist for configuring the default map24 user language	
function map24_lg_select_list(){ 
	global $mosConfig_absolute_path;
	
	require($mosConfig_absolute_path."/components/com_estateagent/includes/map24.inc.php");
			
	$l = array();
	$l[] = mosHTML::makeOption( "UDEF", _UDEF );
	while(list($key,$val) = each($map24_languages)) { 
		$l[] = mosHTML::makeOption( $key, $val );	
	}
	return $l;		
}

// generates a MAP24 - link for showing on the objects site at the frontend 	
function check_map24_sup($lid,$type,$address,$pcode,$town,$country,$logo,$name,$dlg,$dinfo,$dimg ){
	global $mosConfig_absolute_path;
	
	$result = "";

	require($mosConfig_absolute_path."/components/com_estateagent/includes/map24.inc.php");

	// check if user language is supported by map24...	
	$lang = "en";
	if($dlg == "UDEF" && isset($_SERVER['HTTP_ACCEPT_LANGUAGE']) ){
		$lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2);
	}
	elseif($dlg != "UDEF"){
		$lang = $dlg;
	}
		
	// check if theres a map24-server, which supports the users language
	$server = "link2.map24.com";
	while(list($key,$val) = each($map24_servers)) { 
		if($lang == $key){
			$server = $val;
			break;
		}
	}
	
	// check, if the objects country is supported by map24	
	while(list($key,$val) = each($map24_countries)) { 
		if($country == $key){	
			$result  = "<!-- Code generated by Map24.codegenerator and EstateAgent 1.0 --><a href='http://" . $server
						. "?lid=".$lid."&maptype=".$type."&width0=1500&street0=".$address."&zip0=".$pcode."&city0=".$town."&country0="
						. $country."&logo_url0=".$logo."&name0=".$name."&description0=".$dinfo."&lang0=".$lang
						. "' target='_blank'><img src=\"".$dimg."\" border=0 title=\"powered by Map24.com\" /></a><!-- // Map24 -->";
			break;
		}
	}
	return $result;	
}

?>