<?php
/**
 * OpenSEF for Joomla!
 * @copyright (c) 2005 The OpenSEF Project (www.opensef.org)
 * @copyright (c) 2004-2005 Xaneon Development (www.xaneon.com)
 * @license GPL http://www.gnu.org/copyleft/gpl.html
 *
 * TODO
 *
 */

/** Ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct access to this location is not allowed.' );

require_once( dirname( __FILE__ ) . '/includes/sef.common.php' );
require_once( 'sef.config.php' );
require_once( 'sef.langs.php' );

xclSetIncludePath( dirname( __FILE__ ) );

/*
 * TODO
 */
class mosSEFConfig extends xclConfig {
  var $enabled              = '0';
  var $enable_sef           = '1';
  //var $enable_security      = '0';
  var $debug                = '0';
  var $debug_for_ip         = '';
  var $backend_language     = 'english';
  var $backend_sidebar      = '1';
  var $backend_autoupdates  = '0'; // Changed to '0' in beta3
  var $encode_lowercase     = '1';
  var $encode_page_suffix   = '.html';
  var $encode_space_char    = '_';
  var $encode_strip_chars   = '�!$%�@?#&()+*';
  var $content_path_type    = 'full';
  var $content_title_field  = 'title';
  var $section_title_field  = 'title';
  var $category_title_field = 'title';
  var $content_page_format  = '%s_%d';
  var $record_unmapped_urls = '1';
  var $record_invalid_urls  = '1';
  var $record_hits          = '0'; // Hmm?
  var $use_automap          = '1';
  var $use_automap_redirect = '1';
  var $use_multisite        = '1';
  var $use_sef_ext          = '1';
  var $use_core_ext         = '1';
  var $use_canonical_urls   = '1';
  var $use_absolute_urls    = '1';
  var $use_session_fix      = '1';
  var $validate_level       = '1';
  var $validate_404_url     = '';
  var $max_recursion        = '1';
  var $xhtml_compliance     = '0'; // for sefRelToAbs
  var $cache_outgoing       = '1';
  var $alias_wrapper  = 'external';
  var $alias_links  = 'links';
  var $alias_contact  = 'contact_us';
  var $alias_newsfeeds  = 'news_feeds';
  var $use_alias_wrapper  = '1';
  var $use_alias_links  = '1';
  var $use_alias_contact  = '1';
  var $use_alias_newsfeeds  = '1';
  var $spec_chars_d  = null;
  var $spec_chars  = null;

  /*
   * TODO
   */
  function mosSEFConfig( &$db, $reload = false ) {
    $this->xclConfig( $db, 'com_sef', $reload );
  }
}

/*
 * TODO
 */
class mosSEFAlias extends xclDBTable {
  var $id = null;
  var $site_id = null;
  var $external = null;
  var $internal = null;
  var $direction = null;
  var $published = null;
  var $valid = null;
  var $stop = null;
  var $created = null;
  var $created_by = null;
  var $modified = null;
  var $modified_by = null;
  var $catid = null;
  var $hits = null;
  var $notes = null;

  /*
   * TODO
   */
  function mosSEFAlias( &$db, $id = null ) {
    $this->xclDBTable( '#__sef', 'id', $db, $id );
  }

  /*
   * TODO
   */
  function checkin( $oid = null ) {
    return true;
  }

  /*
   * TODO
   */
  function load( $oid = null ) {
    if (!empty( $oid )) {
      return parent::load( $oid );
    }
    else {
      $this->published = '1';
      $this->valid = '1';
      $this->stop = '0';
      $this->hits = 0;
      return true;
    }
  }

  /*
   * TODO
   */
  function check() {
    if (!empty( $this->internal )&& sefIsJoomlaSEF( $this->internal ))
      $this->internal = sefRewriteFromJoomlaSEF( $this->internal );
    // Ensure empty string/number zero => null translation
    if (empty( $this->site_id ))
      $this->site_id = null;
    if (empty( $this->direction ))
      $this->direction = null;
    if (empty( $this->catid ))
      $this->catid = 0;
    if (empty( $this->hits ))
      $this->hits = 0;
    $this->notes = trim( $this->notes );
    if (strlen( $this->notes ) == 0)
      $this->notes = null;
    return parent::check();
  }

  /*
   * TODO: do we need this anymore?
   */
  function save( $source, $order_filter = null ) {
    if (!$this->bind( $_POST ))
      return false;
    if (!$this->check())
      return false;
    if (!$this->store( true ))
      return false;
    $this->_error = '';
    return true;
  }

  /*
   * TODO
   */
  function getSiteURL() {
    if ($this->site_id) {
      $query = "SELECT CONCAT_WS('', s.host, s.base_url) FROM #__sef_site AS s" .
        "\nWHERE s.id = '{$this->site_id}'";
      $this->_db->setQuery( $query );
      return $this->_db->loadResult();
    }
    return null;
  }

  /*
   * TODO
   */
  function getFullAlias() {
    $base_url = $this->getSiteURL();
    return str_replace( '//', '/', $base_url . '/' . $this->external );
  }

  /*
   * TODO
   */
  function lookupIncoming( $site_id, $url ) { // static method
    $db =& $GLOBALS['database'];
    if ($site_id == null) $site_id = -1;
    $query = "SELECT * FROM #__sef WHERE 1" .
      "\nAND (direction IS NULL OR direction = '' OR direction = 'i')" .
      //"\nAND (site_id " . ($site_id ? '= ' . $site_id : 'IS NULL') . ')' .
      "\nAND (site_id IS NULL " .
        ($site_id ? ' OR site_id = ' . $site_id : '') . ')' .
      "\nAND (external = '$url'" . (substr( $url, -1, 1 ) != '/' ?
        " OR external = '$url/'" : '') . ')' .
      "\nORDER BY site_id DESC, LENGTH(external) ASC, published DESC, valid DESC, LENGTH(direction) DESC LIMIT 1";
    $db->setQuery( $query );
    $results = $db->loadObjectList();
    if (is_array( $results ) && count( $results )) {
      $results = xclCastObjectList( $results, 'mosSEFAlias' );
      return $results[0];
    }
    return null;
  }

  /*
   * TODO
   */
  function lookupOutgoing( $site_id, $url ) { // static method
    $db =& $GLOBALS['database'];
    if ($site_id == null) $site_id = -1;
    //$query = "SELECT * FROM #__sef WHERE published = '1'" .
    $query = "SELECT * FROM #__sef WHERE 1" .
      "\nAND (direction IS NULL OR direction = '' OR direction = 'o')" .
      "\nAND (site_id IS NULL " .
        ($site_id ? ' OR site_id = ' . $site_id : '') . ')' .
      "\nAND internal = '$url'" .
      "\nORDER BY site_id DESC, published DESC, valid DESC, LENGTH(direction) DESC LIMIT 1";
    $db->setQuery( $query );
    $results = $db->loadObjectList();
    if (is_array( $results ) && count( $results )) {
      $results = xclCastObjectList( $results, 'mosSEFAlias' );
      return $results[0];
    }
    return null;
  }

  /*
   * TODO
   */
  function recordHit( $site_id, $url, $valid = false ) {
    $db =& $GLOBALS['database'];
    /*if (($row = mosSEFAlias::lookup( $site_id, $url, $valid ))) {
      if (!empty( $GLOBALS['sefConfig']->record_invalid_urls ))
        $row->hit(); // Log the hit; will increase the row's 'hits' column.
    }
    else {*/
      // A row for this invalid URL doesn't exist yet; let's create one.
      $row = new mosSEFAlias( $db );
      $row->site_id = $site_id;
      $row->published = '0';
      $row->valid = ($valid ? '1' : '0');
      $row->external = (!$valid ? $url : null);
      $row->internal = ($valid ? $url : null);
      $row->hits = 1;
      // TODO: maybe make this a configuration option?
      if (!empty( $_SERVER['HTTP_REFERER'] ))
        $row->notes = $_SERVER['HTTP_REFERER'];
      $row->check();
      if (!$row->store( false )) {
        // TODO: insert failed, should not happen. Are SQL tables missing??
        die( "DEBUG: row->store() failed!" );
      }
    //}
  }

}

/*
 * TODO
 */
class mosSEFComponent extends xclDBTable {
  var $id = null;
  var $site_id = null;
  var $menu_id = null;
  var $component = null;
  var $alias = null;
  var $published = null;
  var $ordering = null;

  /*
   * TODO
   */
  function mosSEFComponent( &$db, $id = null ) {
    $this->xclDBTable( '#__sef_component', 'id', $db, $id );
  }

  /*
   * TODO
   */
  function checkin( $oid = null ) {
    return true;
  }

  /*
   * TODO
   */
  function load( $oid = null ) {
    if (!empty( $oid )) {
      return parent::load( $oid );
    }
    else {
      return true;
    }
  }

  /*
   * TODO
   */
  function check() {
    if (empty( $this->site_id ))
      $this->site_id = null;
    if (empty( $this->menu_id ))
      $this->menu_id = 0;
    if (empty( $this->ordering ))
      $this->ordering = '0';
    return parent::check();
  }

  /*
   * TODO
   */
  function lookupByURL( $site_id, $url ) { // static method
    $db =& $GLOBALS['database'];
    $query = "SELECT * FROM #__sef_component" .
      "\nWHERE (site_id IS NULL " .
        ($site_id ? ' OR site_id = ' . $site_id : '') . ')' .
      "\nAND alias IS NOT NULL" .
      "\nAND (CONCAT('/', alias) = '{$url}'" .
      "\nOR '{$url}' LIKE CONCAT('/', alias, '/%'))" .
      "\nORDER BY site_id DESC, LENGTH(alias) DESC LIMIT 1";
    $db->setQuery( $query );
    $results = $db->loadObjectList();
    if (is_array( $results ) && count( $results )) {
      $results = xclCastObjectList( $results, 'mosSEFComponent' );
      return $results[0];
    }
    $null = null;
    return $null;
  }

  /*
   * TODO
   */
  function lookup( $site_id, $menu_id, $component ) { // static method
    $db =& $GLOBALS['database'];
    if ($site_id == -1) $site_id = null;
    $query = "SELECT * FROM #__sef_component" .
      //"\nWHERE (site_id IS NULL " .
      //  ($site_id ? ' OR site_id = ' . $site_id : '') . ')' .
      "\nWHERE site_id " . ($site_id ? '= ' . $site_id : 'IS NULL') .
      "\nAND menu_id = '$menu_id' AND component = '$component'" .
      "\nORDER BY site_id DESC, LENGTH(alias) DESC LIMIT 1";
    $db->setQuery( $query );
    $results = $db->loadObjectList();
    if (is_array( $results ) && count( $results )) {
      $results = xclCastObjectList( $results, 'mosSEFComponent' );
      return $results[0];
    }
    $null = null;
    return $null;
  }
}

/*
 * TODO
 */
class mosSEFSite extends xclDBTable {
  var $_default = false;
  var $id = null;
  var $host = null;
  var $base_url = null;
  var $title = null;
  var $published = null;
  var $access = null;
  var $sitename = null;
  var $lang = null;
  var $locale = null;
  var $offset = null;
  var $offline = null;
  var $debug = null;
  var $error_reporting = null;
  var $metadesc = null;
  var $metakeys = null;
  //var $notes = null;

  /*
   * TODO
   */
  function defaults() {
    $url = parse_url( $GLOBALS['mosConfig_live_site'] );
    $port = (isset($url['port']))? ':'.$url['port']:'';
    $this->host = $url['host'].$port;
    $this->base_url = (isset( $url['path'] ) ? $url['path'] : '');
    $this->title = '';
    $this->published = '1';
    $this->access = '0';
  }

  /*
   * TODO
   */
  function mosSEFSite( &$db, $id = null ) {
    $this->_globals = array('sitename', 'lang', 'locale', 'offset', 'offline',
      'debug', 'error_reporting', 'MetaDesc', 'MetaKeys');
    if ($id === -1) {
      $this->_default = true;
      foreach ($this->_globals as $prop) {
        $propl = strtolower( $prop );
        $this->$propl = $GLOBALS['mosConfig_' . $prop];
      }
      $this->lang = xclGetLangISOCode( $GLOBALS['mosConfig_lang'] );
      $this->defaults();
    }
    else {
      $this->xclDBTable( '#__sef_site', 'id', $db, $id );
    }
  }

  /*
   * TODO
   */
  function getDefault() { // static
    return new mosSEFSite( $GLOBALS['database'], -1 );
  }

  /*
   * TODO
   */
  function check() {
    // Ensure empty string/number zero => null translation
    foreach ($this->_globals as $field) {
      $field = strtolower( $field );
      if (strlen( $this->$field ) == 0)
        $this->$field = null;
    }
    return parent::check();
  }

  /*
   * TODO
   */
  function isDefault() {
    return $this->_default;
  }

  /*
   * TODO
   */
  function load( $oid = null ) {
    if (!empty( $oid )) {
      return parent::load( $oid );
    }
    else {
      $this->defaults();
      $this->base_url .= '/newsite';
      $this->title = 'New Site';
      return true;
    }
  }

  /*
   * TODO
   */
  function checkin( $oid = null ) {
    return true;
  }

  /*
   * TODO
   */
  function hasAccess() {
    if ($this->id && $this->access) {
      global $my;
      return ($my->gid >= $this->access);
    }
    return true;
  }

  /*
   * TODO
   */
  function lookup( $host, $url = null ) { // static method
    $db =& $GLOBALS['database'];
    $query = "SELECT * FROM #__sef_site" .
      "\nWHERE (base_url = '{$url}'" .
      "\nOR '{$url}' LIKE CONCAT_WS('', base_url, '/%'))" .
      "\nAND host = '{$host}'" .
      "\nORDER BY LENGTH(base_url) DESC, LENGTH(host) DESC LIMIT 1";
    $db->setQuery( $query );
    $results = $db->loadObjectList();
    if (is_array( $results ) && count( $results ) > 0) {
      $results = xclCastObjectList( $results, 'mosSEFSite' );
      return $results[0];
    }
    $null = null;
    return $null; //new mosSEFSite( $db, -1 );
  }

  /*
   * TODO
   */
  function overrideGlobals() {
    // TODO: setting this would be a good idea except that *ALL* URLs,
    // including the ones for templates, images and stuff, are generated
    // with our modified path, which means those resources won't work.
    // Hmm...
    //$GLOBALS['mosConfig_live_site'] = 'http://' . $this->host . $this->base_url;

    foreach ($this->_globals as $prop) {
      $propl = strtolower( $prop );
      if (is_null( $this->$propl ) || strlen( $this->$propl ) == 0)
        continue;
      switch ($propl) {
        case 'error_reporting':
          error_reporting( intval( $this->error_reporting ) );
          $GLOBALS['mosConfig_error_reporting'] =$this->error_reporting;
        case 'lang':
          // TODO: check MambelFish support, for now just this:
          $_GET['lang'] = $_REQUEST['lang'] = $this->lang;
          $langName = xclGetLangName( $this->lang );
          $GLOBALS['mosConfig_lang'] =
            ($langName ? $langName : $this->lang);
          break;
        case 'locale':
          if (!@setlocale( LC_TIME, $this->locale )) {
            // Try setting it to the language value as plan B
            @setlocale( LC_TIME, $this->lang );
          }
          // fall through
        default:
          $GLOBALS['mosConfig_' . $prop] = $this->$propl;
          break;
      }
    }
  }

  /*
   * TODO
   */
  function getComponentCount() {
    if ($this->id) {
      $query = "SELECT COUNT(*) FROM #__sef_component" .
        "\nWHERE site_id = '$this->id'";
      $this->_db->setQuery( $query );
      return $this->_db->loadResult();
    }
    return null;
  }

  /*
   * TODO
   */
  function getComponents() {
    if ($this->id) {
      $query = "SELECT * FROM #__sef_component" .
        "\nWHERE site_id = '$this->id'" .
        "\nORDER BY id ASC"; // TODO
      $this->_db->setQuery( $query );
      return $this->_db->loadObjectList();
    }
    return array();
  }

  /*
   * TODO
   */
  function getComponentAlias( &$component, &$menu_id ) {
  	$row = mosSEFComponent::lookup( $this->id, $menu_id, $component );
    return (is_object( $row ) ? $row->alias : null);
  }

  /*
   * TODO
   */
  function getSiteURL() {
    // TODO: need to make sure to match protocol to what the visitor is using (http/https).
    return 'http://' . $this->host . $this->base_url;
  }

  /*
   * TODO
   */
  function getRelativeURL( $url ) {
    if ($this->base_url != '') {
      if (substr( $url, 0, strlen( $this->base_url ) ) == $this->base_url) {
        $url = substr( $url, strlen( $this->base_url ) );
      }
    }
    return ($url ? $url : '/');
  }

}

/*
 * TODO
 */
class sefObject {
  var $debug = false;
  var $db = null;
  var $config = null;
  var $site = null;
  var $log = null;

  /*
   * TODO
   */
  function sefObject( &$db, &$config, &$site ) {
    $this->db =& $db;
    $this->config =& $config;
    $this->site =& $site;
  }

  /*
   * TODO
   */
  function log( $msg ) {
    if ($this->debug && !empty( $msg )) {
      $this->log[] = $msg;
    }
  }

  /*
   * TODO
   */
  function setDebug( $enabled = true ) {
    $this->debug = $enabled;
  }

  /*
   * TODO
   */
  function getLog() {
    return $this->log;
  }
}
class getWeblink extends mosDBTable {
	/** @var int Primary key */
	var $id					= null;
	/** @var int */
	var $catid				= null;
	/** @var int */
	var $sid				= null;
	/** @var string */
	var $title				= null;
	/** @var string */
	var $url				= null;
	/** @var string */
	var $description		= null;
	/** @var datetime */
	var $date				= null;
	/** @var int */
	var $hits				= null;
	/** @var int */
	var $published			= null;
	/** @var boolean */
	var $checked_out		= null;
	/** @var time */
	var $checked_out_time	= null;
	/** @var int */
	var $ordering			= null;
	/** @var int */
	var $archived			= null;
	/** @var int */
	var $approved			= null;
	/** @var string */
	var $params				= null;

	/**
	* @param database A database connector object
	*/
	function getWeblink( &$db ) {
		$this->mosDBTable( '#__weblinks', 'id', $db );
	}
	
}
class getContact extends mosDBTable {
	/** @var int Primary key */
	var $id 				= null;
	/** @var string */
	var $name 				= null;
	/** @var string */
	var $con_position 		= null;
	/** @var string */
	var $address 			= null;
	/** @var string */
	var $suburb 			= null;
	/** @var string */
	var $state 				= null;
	/** @var string */
	var $country 			= null;
	/** @var string */
	var $postcode 			= null;
	/** @var string */
	var $telephone 			= null;
	/** @var string */
	var $fax 				= null;
	/** @var string */
	var $misc 				= null;
	/** @var string */
	var $image 				= null;
	/** @var string */
	var $imagepos 			= null;
	/** @var string */
	var $email_to 			= null;
	/** @var int */
	var $default_con 		= null;
	/** @var int */
	var $published 			= null;
	/** @var int */
	var $checked_out 		= null;
	/** @var datetime */
	var $checked_out_time 	= null;
	/** @var int */
	var $ordering 			= null;
	/** @var string */
	var $params 			= null;
	/** @var int A link to a registered user */
	var $user_id 			= null;
	/** @var int A link to a category */
	var $catid 				= null;
	/** @var int */
	var $access 			= null;

	/**
	* @param database A database connector object
	*/
	function getContact() {
		global $database;
		$this->mosDBTable( '#__contact_details', 'id', $database );
	}

}
class getNewsfeeds extends mosDBTable {
/** @var int Primary key */
	var $id					= null;
/** @var int */
	var $catid				= null;
/** @var string */
	var $name				= null;
/** @var string */
	var $link				= null;
/** @var string */
	var $filename			= null;
/** @var int */
	var $published			= null;
/** @var int */
	var $numarticles		= null;
/** @var int */
	var $cache_time			= null;
/** @var int */
	var $checked_out		= null;
/** @var time */
	var $checked_out_time	= null;
/** @var int */
	var $ordering			= null;

/**
* @param database A database connector object
*/
	function getNewsfeeds( &$db ) {
		$this->mosDBTable( '#__newsfeeds', 'id', $db );
	}
}
?>