<?php
############################################
# Wines      - A Mambo Wine Component      #
# based on AKOgallery and recipes          #
# Copyright (C) 2004  by Tommaso Tamantini #
# Homepage   : www.lagarlata.net		   #
# Version    : 1.1.                        #
# License    : GNU GPL Public License      #
############################################

# Don't allow direct linking
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

# Show wine header
WineHeader();

switch ($sorting) {
	case 'find':
		$suchstring = trim( strtolower( $sstring ) );
		$query1   = "SELECT A.* ,B.title FROM #__wines AS A, #__categories AS B WHERE ((LOWER(A.imgtext) LIKE '%$suchstring%') OR (LOWER(A.imgtitle) LIKE '%$suchstring%') OR (LOWER(A.grapes) LIKE '%$suchstring%') OR (LOWER(A.notes) LIKE '%$suchstring%') OR (LOWER(A.properties) LIKE '%$suchstring%')) AND A.published = 1 AND B.id=A.catid ORDER BY A.id DESC";
		$tl_title = _WINES_VWS_SEARCHRESULTS_FOR." $sstring";
		break;
	case 'lastcomment':
		$query1   = "SELECT a.*, cc.cmtid,bb.title FROM #__wines AS a, #__wines_comments AS cc,#__categories AS bb WHERE bb.id=a.catid AND a.id=cc.cmtpic AND a.published = '1' ORDER BY cc.cmtid DESC LIMIT $ag_toplist";
		$tl_title = _WINES_VWS_TOP." $ag_toplist "._WINES_VWS_LAST_COMMENTED;
		break;
	case 'lastadd':
		$query1   = "SELECT #__wines.*,#__categories.title FROM #__wines,#__categories WHERE #__categories.id=#__wines.catid AND #__wines.published = '1' ORDER BY id DESC LIMIT $ag_toplist";
		$tl_title = _WINES_VWS_TOP." $ag_toplist "._WINES_VWS_LAST_ADDED;
		break;
	case 'rating':
		$query1   = "SELECT #__wines.*,#__categories.title FROM #__wines,#__categories WHERE #__categories.id=#__wines.catid AND #__wines.published = '1' ORDER BY ROUND(imgvotesum/imgvotes, 2) DESC LIMIT $ag_toplist";
		$tl_title = _WINES_VWS_TOP." $ag_toplist "._WINES_VWS_BEST_RATED;
		break;
	default:
		$query1   = "SELECT #__wines.*,#__categories.title FROM #__wines,#__categories WHERE #__categories.id=#__wines.catid AND #__wines.published = '1' ORDER BY imgcounter DESC LIMIT $ag_toplist";
		$tl_title = _WINES_VWS_TOP." $ag_toplist "._WINES_VWS_MOST_VIEWED;
		break;
}

# Database Query
$database->setQuery($query1);
$rows = $database->loadObjectList();

echo "<table  class='sectiontableentry2' width='100%' border='0' cellspacing='1' cellpadding='4'>";
echo "<tr><td colspan='3' class='sectiontableheader' width='100%'>$tl_title</td></tr>";

$rowcounter = 1;
foreach($rows as $row1) {
	$linecolor = ($rowcounter % 2) + 1;
	echo "<tr>";
	echo "<td class='sectiontableentry".$linecolor."' align='left' valign='top' width='50%'>";
	echo "<img src='images\M_images\arrow.png'/><a href='index.php?option=com_wines&Itemid=$Itemid&func=detail&id=$row1->id'><b>$row1->imgtitle</b></a>";
	echo "</td><td class='sectiontableentry".$linecolor."' width='30%' valign='top'>$row1->title";
	echo "</td><td class='sectiontableentry".$linecolor."' width='20%' valign='top'>";
	if ($ag_showdetail) echo _WINES_ADMIN_HITS.": $row1->imgcounter";
	if ($ag_showrating) {
		if ($row1->imgvotes>0) {
			$fimgvotesum = number_format($row1->imgvotesum/$row1->imgvotes,2,",",".");
			$frating = "$fimgvotesum ($row1->imgvotes "._WINES_VOTES.")";
		} else {
			$frating = _WINES_NO_VOTES;
		}
		echo "<br />"._WINES_RATING.": $frating";
	}
	if ($ag_showcomment) {
		# Check how many comments exist
		$comments_query  = "SELECT cmtid FROM ".$mosConfig_dbprefix."wines_comments WHERE cmtpic='$row1->id'";
		$comments_result = $database->openConnectionWithReturn($comments_query);
		$comments        = mysql_num_rows($comments_result);
		echo "<br />"._WINES_DEL_COMMENT.": $comments";
	}
	echo "</td>";
	$rowcounter++;
}
echo "</tr></table>";

?>