<?php
/**
* @version $Id: content.searchbot.php,v 1.17 2004/09/12 18:01:09 rcastley Exp $
* @package Jobline
* @copyright (C) 2005 Olle Johansson
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* Mambo is Free Software
*/

/** ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

$_MAMBOTS->registerFunction( 'onSearch', 'botSearchJobline' );

/**
* Search method
*
* The sql must return the following fields that are used in a common display
* routine: href, title, section, created, text, browsernav
* @param string Target search string
* @param string Type of search: "exact", "all", "any"
* @param string Sort order: "newest", "oldest", "popular", "alpha"
*/
function botSearchJobline( $text, $phrase='', $ordering='' ) {
	global $my, $database;
	global $mosConfig_absolute_path, $mosConfig_lang, $mosConfig_offset;
	$_SESSION['searchword'] = $text;
	
	$now = date( "Y-m-d H:i:s", time()+$mosConfig_offset*60*60 );

	$text = trim( $text );
	if ($text == '') {
		return array();
	}

	$wheres = array();
	switch ($phrase) {
		case 'exact':
			$wheres2 = array();
			$wheres2[] = "LOWER(a.title) LIKE '%$text%'";
			$wheres2[] = "LOWER(a.description) LIKE '%$text%'";
			$wheres2[] = "LOWER(a.qualifications) LIKE '%$text%'";
			$wheres2[] = "LOWER(a.company) LIKE '%$text%'";
			$wheres2[] = "LOWER(a.location) LIKE '%$text%'";
			$wheres2[] = "LOWER(a.city) LIKE '%$text%'";
			$wheres2[] = "LOWER(a.reference) LIKE '%$text%'";
			$where = '(' . implode( ') OR (', $wheres2 ) . ')';
			break;
		case 'all':
		case 'any':
		default:
			$words = explode( ' ', $text );
			$wheres = array();
			foreach ($words as $word) {
				$wheres2 = array();
				$wheres2[] = "LOWER(a.title) LIKE '%$word%'";
				$wheres2[] = "LOWER(a.description) LIKE '%$word%'";
				$wheres2[] = "LOWER(a.qualifications) LIKE '%$word%'";
				$wheres2[] = "LOWER(a.company) LIKE '%$word%'";
				$wheres2[] = "LOWER(a.location) LIKE '%$word%'";
				$wheres2[] = "LOWER(a.city) LIKE '%$word%'";
				$wheres2[] = "LOWER(a.reference) LIKE '%$word%'";
				$wheres[] = implode( ' OR ', $wheres2 );
			}
			$where = '(' . implode( ($phrase == 'all' ? ') AND (' : ') OR ('), $wheres ) . ')';
			break;
	}

	switch ($ordering) {
		case 'newest':
		default:
			$order = 'a.created DESC';
			break;
		case 'oldest':
			$order = 'a.created ASC';
			break;
		case 'popular':
			$order = 'a.hits DESC';
			break;
		case 'alpha':
			$order = 'a.title ASC';
			break;
/*
		case 'category':
			$order = 'b.title ASC, a.title ASC';
			$morder = 'a.title ASC';
			break;
*/
	}

	// Check out of we need to show only published items
	$publishedquery = "";
    include_once( "$mosConfig_absolute_path/components/com_jobline/configuration.php" );
	if ( $cfgjl['publishinglimit'] > 0 ) {
		$ptime = date( "Y-m-d H:i:s", time() - intval( $cfgjl['publishinglimit'] ) * 86400 );
		$publishedquery = "\n	AND a.created >= '$ptime'";
	}

	$database->setQuery( "SELECT a.title AS title,"
	. "\n a.created AS created,"
	. "\n a.description AS text,"
	. "\n a.company AS section,"
	. "\n CONCAT( 'index.php?option=com_jobline&task=view&id=', a.id ) AS href,"
	. "\n '2' AS browsernav"
	. "\n FROM #__jl_jobposting AS a"
	. "\n WHERE ( $where )"
	. "\n AND a.state = '1' AND a.access <= '$my->gid'"
	. "$publishedquery"
	. "\n ORDER BY $order"
	);
	$list = $database->loadObjectList();

	return $list;
}
?>