<?php
/**
* Letterman Newsletter Component
* 
* @package Letterman
*  @author soeren
* @copyright Soeren Eberhardt <soeren@mambo-phpshop.net>
    (who just needed an easy and *working* Newsletter component for Mambo 4.5.1 and mixed up Newsletter and YaNC)
* @copyright Mark Lindeman <mark@pictura-dp.nl> 
    (parts of the Newsletter component by Mark Lindeman; Pictura Database Publishing bv, Heiloo the Netherland)
* @copyright Adam van Dongen <adam@tim-online.nl>
    (parts of the YaNC component by Adam van Dongen, www.tim-online.nl)
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*
*/

// ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

/**
*  Table Class
*
* Provides access to the mos_letterman table
*/
class mosLetterman extends mosDBTable {
	/** @var int Unique id*/
	var $id=null;
	/** @var string */
	var $subject=null;
	/** @var string */
	var $headers=null;
	/** @var string */
	var $message=null;
	/** @var string */
	var $html_message=null;
	/** @var int */
	var $published=null;
	/** @var int */
	var $checked_out=null;
	/** @var datetime */
	var $checked_out_time=null;
	/** @var datetime */
	var $publish_up=null;
	/** @var datetime */
	var $publish_down=null;
	/** @var int */
	var $created=null;
    /** @var datetime */
	var $send=null;
    /** @var datetime */
	var $hits=null;
	/** @var int */
	var $access=null;
	/**
	* @param database A database connector object
	*/
	function mosLetterman( &$database ) {
		global $mosConfig_absolute_path, $lm_params;
		$this->mosDBTable( '#__letterman', 'id', $database );
		
		if( !isset($GLOBALS['lm_params']) || !empty($_REQUEST['lm_params'])) {
			// pull id of letterman component
			$query = "SELECT a.id FROM `#__components` AS a"
			. "\n WHERE `a`.`option` = 'com_letterman' AND `parent` = 0";
			$database->setQuery( $query );
			$letterman_id = $database->loadResult();
			
			// load Letterman parameters
			$component = new mosComponent( $database );
			$component->load( $letterman_id );
			$GLOBALS['lm_params'] = $lm_params = new mosParameters( $component->params );
			
			if( empty($lm_params->_params->newsletter_css)) {
				$database->setQuery('SELECT template FROM `#__templates_menu` WHERE client_id=0 ORDER BY menuid ASC LIMIT 0, 1');
				$cur_template = $database->loadResult();
				$template_css_file = $mosConfig_absolute_path."/templates/$cur_template/css/template_css.css";
				if( file_exists($template_css_file)) {
					
					$template_css = str_replace( "\r\n", "\n", file_get_contents( $template_css_file ));
					
					$txt = array();
					foreach ($lm_params->_params as $k=>$v) {
						$txt[] = "$k=$v";
					}
					$txt[] = "newsletter_css=".$template_css;
						
					$total = count( $txt );
					for( $i=0; $i < $total; $i++ ) {
						if ( strstr( $txt[$i], "\n" ) ) {
							$txt[$i] = str_replace( "\n", '<br />', $txt[$i] );
						}
					}
					
					$params = implode( "\n", $txt );
					
					$component->params = $params;
					$component->store();
				}
	
			}
		}
		
	}
	function check() {
		
		if( empty( $this->created ) ) {
			$this->created = date('Y-m-d H:i:s');
		}
		
		return true;
	}
}
/**
*  Table Class
*
* Provides access to the mos_letterman_subscribers table
*/
class mosLettermanSubscribers extends mosDBTable {
	/** @var int Unique id*/
	var $subscriber_id=null;
	/** @var string */
	var $subscriber_name=null;
	/** @var string */
	var $user_id=null;
	/** @var string */
	var $subscriber_email=null;
	/** @var int */
	var $confirmed=null;
	/** @var int */
	var $subscribe_date=null;
	/**
	* @param database A database connector object
	*/
	function mosLettermanSubscribers( &$database ) {
		$this->mosDBTable( '#__letterman_subscribers', 'subscriber_id', $database );
	}
}

?>
