<?php
/*
package    : VirtueUpload
version    : 1.0.0 STABLE
author     : Tobias Kuhn - eaxs.de
Homepage   : http://www.eaxs.de
copyright  : Copyright (C) 2006 Tobias Kuhn - eaxs.de
license    : http://www.gnu.org/copyleft/gpl.html

* VirtueUpload is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
*/

defined( '_VALID_MOS' ) or die( 'Restricted access' );
require_once($mosConfig_absolute_path .'/administrator/components/com_virtueupload/admin.virtueupload.cfg.php');
require_once( $mosConfig_absolute_path.'/administrator/components/com_virtueupload/language/'.VU_CFG_LANGUAGE );

class html_virtueupload {

/*==============================================================================
* Author    : Tobias Kuhn
* Function  : list_uploads
* Parameter : log entrys,
* Return    : -
==============================================================================*/
function list_uploads(&$rows, $pageNav) {
  global $mosConfig_live_site, $database;
  ?>
  <table class="adminheading">
	  <tr>
		<td width="239">
		  <img src="<?php echo $mosConfig_live_site;?>/administrator/components/com_virtueupload/images/VU_logo.png" width="239" height="62"/>
		</td>
        <td height="62px" valign="middle" align="left">
           <font color="darkgreen"> [ <?php echo VULANG_LOG_OVERVIEW; ?> ]</font>
        </td>
      </tr>
	</table>
    <form action="index2.php" method="POST" name="adminForm">
      <script language="javascript" type="text/javascript">
	    function submitbutton(pressbutton) {
	      if (pressbutton == 'banlist') {
		      submitform(pressbutton);
	      }
          if (pressbutton == 'banlist') {
		      submitform(pressbutton);
	      }
          if (pressbutton == 'settings') {
		      submitform(pressbutton);
	      }
          if (pressbutton == 'settings') {
		      submitform(pressbutton);
	      }
          if (pressbutton == 'delete') {
		      submitform(pressbutton);
	      }
          if (pressbutton == 'delete') {
		      submitform(pressbutton);
	      }
	    }
	  </script>
	  <table class="adminlist">
	    <tr>
		  <th width="5px" align="center">
		    #
		  </th>
		  <th width="5px" align="center">
		    <input type="checkbox" name="toggle" value="" onClick="checkAll(<?php echo count( $rows ); ?>);" />
		  </th>
		  <th width="5px" align="center">
		    ID
		  </th>
		  <th width="25%" align="left">
            <?php echo VULANG_LOG_FILENAME; ?>
		  </th>
          <th width="10%" align="left">
            <?php echo VULANG_LOG_FILESIZE; ?>
		  </th>
		  <th width="25%" align="left">
            <?php echo VULANG_LOG_UPLOADBY; ?>
		  </th>
          <th width="10%" align="center">
            <?php echo VULANG_LOG_ORDERID; ?>
		  </th>
          <th width="20%" align="center">
            <?php echo VULANG_LOG_COMMENT; ?>
		  </th>
		  <th width="10%" align="center">
            <?php echo VULANG_LOG_DATE; ?>
		  </th>
		</tr>
        <?php $k = 0;
        for ($i=0, $n=count( $rows ); $i < $n; $i++) {
          $row          = &$rows[$i];
          $access 	    = mosCommonHTML::AccessProcessing( $row, $i );
		  $checked 	    = mosCommonHTML::CheckedOutProcessing( $row, $i );
          $details = $mosConfig_live_site."/administrator/index2.php?option=com_virtueupload&task=details&id=".$row->id;

          if ($row->upload_by == VULANG_LOG_UNKNOWN && (VU_CFG_RETRIEVEENABLED == '1')) {
            $user = $row->upload_by." = <font color='darkgreen'>".retrieve_user($row->cdate, $row->ip)." ?</font>";
          }
          else {
            $user = $row->upload_by;
          }


        ?>
        <tr class="<?php echo "row$k"; ?>">
          <td width="5px" align="center">
            <?php echo $pageNav->rowNumber( $i ); ?>
	      </td>
          <td width="5px" align="center">
		    <?php echo mosHTML::idBox($i, $row->id); ?>
	      </td>
	      <td width="5px" align="center">
	        <?php echo $row->id; ?>
	      </td>
	      <td width="25%" align="left">
	        <a href="<?php echo $details; ?>" title="<?php echo VULANG_LOG_DETAILS; ?>"><?php echo $row->file_name; ?></a>
	      </td>
          <td width="10%" align="left">
            <?php echo $row->file_size; ?> KB
	      </td>
	      <td width="25%" align="left">
            <?php echo $user; ?>
	      </td>
	      <td width="10%" align="center">
	        <?php
              echo $row->order_id; ?>
	      </td>
          <td width="20%" align="center">
	        <?php if($row->comment != ''){ ?>
              <?php echo VULANG_LOG_YES; ?><?php } else { echo VULANG_LOG_NO;} ?>
	      </td>
          <td width="10%" align="center">
	        <?php echo $row->date; ?>
	      </td>
       </tr>
       <?php  $k = 1 - $k;} ?>
     </table>
     <?php echo $pageNav->getListFooter(); ?>
     <table style="text-align:center">
       <tr>
         <td>
           <?php echo VU_COPYRIGHT ?>
         </td>
       </tr>
     </table>
   <input type="hidden" name="option" value="com_virtueupload" />
   <input type="hidden" name="task" value="" />
   <input type="hidden" name="boxchecked" value="0" />
   <input type="hidden" name="hidemainmenu" value="0" />
   <input type="hidden" name="redirect" value="<?php echo $redirect;?>" />
 </form>
<?php
}
/*==============================================================================
* Author    : Tobias Kuhn
* Function  : show_cfg
* Parameter : virtuemart shopper-groups
* Return    : -
==============================================================================*/
function show_cfg (&$rows, &$langdir) {
  global $database, $mosConfig_absolute_path, $mosConfig_live_site;

  $tabs = new mosTabs(1);
  ?>
    <table class="adminheading">
	  <tr>
		<td width="239">
		  <img src="<?php echo $mosConfig_live_site;?>/administrator/components/com_virtueupload/images/VU_logo.png" width="239" height="62"/>
		</td>
        <td height="62px" valign="middle" align="left">
           <font color="darkgreen"> [ <?php echo VULANG_CFG_CONFIG; ?> ]</font>
        </td>
      </tr>
	</table>

    <?php
      $tabs->startPane("content-pane");
      $tabs->startTab(VULANG_TAB_COMMON,VULANG_TAB_COMMON);
    ?>

    <form name="adminForm" action="index2.php" method="POST">

    <script language="javascript" type="text/javascript">
	function submitbutton(pressbutton) {
	  if (pressbutton == 'save') {
		submitform(pressbutton);
	  }
      if (pressbutton == 'cancel') {
		submitform(pressbutton);
	  }
	}
	</script>
    <fieldset>
    <legend><?php echo VULANG_CFG_COMMON ?></legend>
    <table class="adminform">
      <tr>
        <td width="20%" valign="top">
          <strong><?php echo VULANG_CFG_UPLOADENABLED ?></strong>
        </td>
        <td width="30%" valign="top">
          <input type="checkbox" name="CFG_enableupload" class="inputbox" <?php if (VU_CFG_UPLOADENABLED == 1) echo "checked=\"checked\""; ?> value="1" />
        </td>
        <td width="50%" valign="top">
          <?php echo VULANG_CFG_UPLOAD_DESC ?>
        </td>
      </tr>
      <tr>
        <td width="20%" valign="top">
          <strong><?php echo VULANG_CFG_LANG ?></strong>
        </td>
        <td width="30%" valign="top">
          <select class="inputbox" name="CFG_language" size="1">
            <?php
              while($file = readdir($langdir)) {
                if ($file != "." && $file != ".."){
                  if ($file == VU_CFG_LANGUAGE) {
				      $selected= 'selected="selected"';
			       }
                   else {
				     $selected = '';
                   }
                   echo "<option value=\"$file"."\"$selected>";
                   echo $file."</option>";
                }
              }
            closedir($langdir);
            ?>
          </select>
        </td>
        <td width="50%" valign="top">
          <?php echo VULANG_CFG_LANG_DESC ?>
        </td>
      </tr>
      <tr>
        <td width="20%" valign="top">
          <strong><?php echo VULANG_CFG_ADMINMAIL ?></strong>
        </td>
        <td width="30%" valign="top">
          <input size="40" type="text" name="CFG_adminmail" class="inputbox" value="<?php echo VU_CFG_ADMINMAIL ?>" />
        </td>
        <td width="50%" valign="top">
          <?php echo VULANG_CFG_ADMINMAIL_DESC ?></font></b>
        </td>
      </tr>
    </table>
    </fieldset>
    <table style="text-align:center">
       <tr>
         <td>
           <?php echo VU_COPYRIGHT ?>
         </td>
       </tr>

     </table>

    <?php
      $tabs->endTab();
      $tabs->startTab(VULANG_TAB_UPLOAD,VULANG_TAB_UPLOAD);
    ?>

    <fieldset>
    <legend><?php echo VULANG_CFG_UPLOAD ?></legend>
    <table class="adminform">
      <tr>
        <td width="20%" valign="top">
          <strong><?php echo VULANG_CFG_UPLOADPATH ?></strong><br><?php echo $mosConfig_absolute_path.'/' ?>
        </td>
        <td width="30%" valign="top">
          <input size="40" type="text" name="CFG_uploadroot" class="inputbox" value="<?php echo VU_CFG_UPLOADROOT ?>" />
        </td>
        <td width="50%" valign="top">
          <?php echo VULANG_CFG_UPLOADPATH_DESC ?>
        </td>
      </tr>
      <tr>
        <td width="20%" valign="top">
          <strong><?php echo VULANG_CFG_COMMENT ?></strong>
        </td>
        <td width="30%" valign="top">
          <input type="checkbox" name="CFG_enablecomment" class="inputbox" <?php if (VU_CFG_COMMENTENABLED == 1) echo "checked=\"checked\""; ?> value="1" />
        </td>
        <td width="50%" valign="top">
          <?php echo VULANG_CFG_COMMENT_DESC ?>
        </td>
      </tr>
      <tr>
        <td width="20%" valign="top">
          <strong><?php echo VULANG_CFG_AUTORETRIEVE ?></strong>
        </td>
        <td width="30%" valign="top">
          <input type="checkbox" name="CFG_enableretrieve" class="inputbox" <?php if (VU_CFG_RETRIEVEENABLED == 1) echo "checked=\"checked\""; ?> value="1" />
        </td>
        <td width="50%" valign="top">
          <?php echo VULANG_CFG_AUTORETRIEVE_DESC ?></font></b>
        </td>
      </tr>
      <tr>
        <td width="20%" valign="top">
          <strong><?php echo VULANG_CFG_RENAME ?></strong>
        </td>
        <td width="30%" valign="top">
          <input type="checkbox" name="CFG_filerename" class="inputbox" <?php if (VU_CFG_FILERENAME == 1) echo "checked=\"checked\""; ?> value="1" />
        </td>
        <td width="50%" valign="top">
          <?php echo VULANG_CFG_RENAME_DESC ?></font></b>
        </td>
      </tr>
    </table>
    </fieldset>
    <table style="text-align:center">
       <tr>
         <td>
           <?php echo VU_COPYRIGHT ?>
         </td>
       </tr>
     </table>

    <?php
      $tabs->endTab();
      $tabs->startTab(VULANG_TAB_SECURITY,VULANG_TAB_SECURITY);
    ?>

    <fieldset>
    <legend><?php echo VULANG_CFG_SECURITY ?></legend>
    <table class="adminform">
      <tr>
        <td width="20%" valign="top">
          <strong><?php echo VULANG_CFG_ACCESS ?><strong>
        </td>
        <td width="30%" valign="top">
          <select class="inputbox" name="CFG_accesslevel" size="1">
            <option value=""><?php echo VULANG_CFG_PUBLICUPL ?></option>
          <?php
           for ($i=0, $n=count( $rows ); $i < $n; $i++) {
                $row = &$rows[$i];

                if ($row->shopper_group_id == VU_CFG_ACCESSLEVEL) {
				  $selected= ' selected="selected"';
			    }
                else {
				  $selected = '';
                }
                echo "<option value=\"" . $row->shopper_group_id  . "\"$selected>";
                echo $row->shopper_group_name.'; '.$row->vendor_name."</option>";
           } ?>
           </select>
        </td>
        <td width="50%" valign="top">
          <?php echo VULANG_CFG_ACCESS_DESC ?>
        </td>
      </tr>
      <tr>
        <td width="20%" valign="top">
          <strong><?php echo VULANG_CFG_RESEXTENSIONS ?></strong>
        </td>
        <td width="30%" valign="top">
          <input size="40" type="text" name="CFG_extensions" class="inputbox" value="<?php echo VU_CFG_EXTENSIONS ?>" />
        </td>
        <td width="50%" valign="top">
          <?php echo VULANG_CFG_RESEXTENSIONS_DESC ?>
        </td>
      </tr>
      <tr>
        <td width="20%" valign="top">
          <strong><?php echo VULANG_CFG_MAXSIZE ?></strong>
        </td>
        <td width="30%" valign="top">
          <input size="40" type="text" name="CFG_maxsize" class="inputbox" value="<?php echo VU_CFG_MAXSIZE/1024 ?>" />
        </td>
        <td width="50%" valign="top">
          <?php echo VULANG_CFG_MAXSIZE_DESC.@ini_get('upload_max_filesize') ?></font></b>
        </td>
      </tr>
      <tr>
        <td width="20%" valign="top">
          <strong><?php echo VULANG_CFG_BAN ?></strong>
        </td>
        <td width="30%" valign="top">
          <input size="40" type="text" name="CFG_banuser" class="inputbox" value="<?php echo VU_CFG_BANUSER ?>" />
        </td>
        <td width="50%" valign="top">
          <?php echo VULANG_CFG_BAN_DESC ?></font></b>
        </td>
      </tr>
    </table>
    </fieldset>
    <table style="text-align:center">
       <tr>
         <td>
           <?php echo VU_COPYRIGHT ?>
         </td>
       </tr>
     </table>

    <?php
      $tabs->endTab();
      $tabs->startTab(VULANG_TAB_HACK,VULANG_TAB_HACK);
    ?>

    <fieldset>
    <legend><?php echo VULANG_CFG_HACK; ?> </legend>
    <table class="adminform">
      <tr>
        <td width="100%" valign="top">
          <strong><?php echo VULANG_CFG_VIRTUEHACK_DESC; ?></strong>
        </td>
      </tr>
    </table>
    <table class="adminform">
      <tr>
        <td width="15%" valign="top">
          <strong><?php echo VULANG_CFG_HACKPOP ?></strong>
        </td>
        <td width="20%" valign="top">
          <textarea name="pophack" width="100%" rows="3" class="inputbox" onClick="javascript:this.form.pophack.focus();this.form.pophack.select();" readonly><?php echo VULANG_CFG_HACKPOP_CODE ?></textarea>
        </td>
        <td width="65%" valign="top">
          <?php echo VULANG_CFG_HACKPOP_DESC ?>
        </td>
      </tr>
      <tr>
        <td width="15%" valign="top">
          <strong><?php echo VULANG_CFG_HACKFLY ?></strong>
        </td>
        <td width="20%" valign="top">
          <textarea name="flyhack" width="100%" rows="3" class="inputbox" onClick="javascript:this.form.flyhack.focus();this.form.flyhack.select();" readonly><?php echo VULANG_CFG_HACKFLY_CODE ?></textarea>
        </td>
        <td width="65%" valign="top">
          <?php echo VULANG_CFG_HACKFLY_DESC ?>
        </td>
      </tr>
      <tr>
        <td width="15%" valign="top">
          <strong><?php echo VULANG_CFG_HACKACC ?></strong>
        </td>
        <td width="20%" valign="top">
          <textarea name="acchack" width="100%" rows="3" class="inputbox" onClick="javascript:this.form.acchack.focus();this.form.acchack.select();" readonly><?php echo VULANG_CFG_HACKACC_CODE ?></textarea>
        </td>
        <td width="65%" valign="top">
          <?php echo VULANG_CFG_HACKACC_DESC ?>
        </td>
      </tr>
    </table>
    </fieldset>
    <table style="text-align:center">
       <tr>
         <td>
           <?php echo VU_COPYRIGHT ?>
         </td>
       </tr>
     </table>

    <?php
      $tabs->endTab();
      $tabs->startTab(About, About);
    ?>

    <table width="100%" border="0" cellpadding="0" cellspacing="0" style="background-color: #FFFFFF !important;">
  <tr>
    <td width="239" height="62" valign="top">
    <img src="<?php echo $mosConfig_live_site;?>/administrator/components/com_virtueupload/images/VU_logo.png" width="239" height="62"/>
    </td>
  </tr>
  <tr>
    <td valign="top">
    <strong>VirtueUpload 1.0.0 is an add-on component for VirtueMart</strong>
    <br />
    <br />
    <strong>Development</strong>
    <br />
    - Tobias Kuhn
    <br />
    <br />
    <strong>Tested by</strong>
    <br />
    - Yorgos Pontsaris, pontsaris@freemail.gr
    <br />
    - 'deneb'
    <br />
    - 'websnooky'
    <br />
    - 'RAM85'
    <br />
    <br />
    <strong>Translation</strong>
    <br />
    - Greek: Yorgos Pontsaris, pontsaris@freemail.gr
    <br />
    <br />
    </td>
  </tr>
  </table>

    <table style="text-align:center">
       <tr>
         <td>
           <?php echo VU_COPYRIGHT ?>
         </td>
       </tr>
     </table>

    <input type="hidden" name="option" value="com_virtueupload" />
    <input type="hidden" name="task" value="settings" />
    </form>
<?php
  $tabs->endPane();
}
/*==============================================================================
* Author    : Tobias Kuhn
* Function  : show_details
* Parameter : file and user details
* Return    : -
==============================================================================*/
function show_details ($details) {
  global $mosConfig_live_site, $mosConfig_absolute_path, $database;
  ?>
  <table class="adminheading">
	<tr>
	  <td width="239">
		<img src="<?php echo $mosConfig_live_site;?>/administrator/components/com_virtueupload/images/VU_logo.png" width="239" height="62"/>
	    </td>
        <td height="62px" valign="middle" align="left">
          <font color="darkgreen"> [ <?php echo VULANG_DET_DETAILS; ?> ]</font>
        </td>
      </tr>
    </table>
    <form action="index2.php" method="POST" name="adminForm">
    <table class="adminform" width="100%">
    <tr>
      <td width="50%" valign="top">
        <fieldset>
        <legend><?php echo VULANG_DET_FILEINFO; ?></legend>
        <table class="adminlist">
          <?php
            foreach ($details AS $detail) {
              $link = $mosConfig_absolute_path."/".$detail->link."/".$detail->file_name;
              $download = $mosConfig_live_site."/".$detail->link."/".$detail->file_name;
              ?>
              <tr>
                <td width="30%" align="left">
                  <strong><?php echo VULANG_LOG_FILENAME; ?> :</strong>
	            </td>
                <td width="80%" align="left">
                  <?php echo $detail->file_name; ?>
	            </td>
             </tr>
             <tr>
                <td width="30%" align="left">
                  <strong><?php echo VULANG_LOG_FILESIZE; ?> :</strong>
	            </td>
                <td width="80%" align="left">
                  <?php echo $detail->file_size; ?> KB
	            </td>
             </tr>
             <tr>
                <td width="30%" align="left">
                  <strong><?php echo VULANG_DET_ID; ?></strong>
	            </td>
                <td width="80%" align="left">
                  <?php echo $detail->id; ?>
	            </td>
             </tr>
             <tr>
                <td width="30%" align="left">
                  <strong><?php echo VULANG_LOG_ORDERID; ?> :</strong>
	            </td>
                <td width="80%" align="left">
                  <?php echo $detail->order_id; ?>
	            </td>
             </tr>
             <tr>
                <td width="30%" align="left">
                  <strong><?php echo VULANG_LOG_DATE; ?> :</strong>
	            </td>
                <td width="80%" align="left">
                  <?php echo $detail->date; ?>
	            </td>
             </tr>
             <tr>
                <td width="30%" align="left">
                  <strong><?php echo VULANG_DET_LOCATION; ?></strong>
	            </td>
                <td width="80%" align="left">
                  <?php echo $mosConfig_absolute_path."/".$detail->link; ?>
	            </td>
             </tr>
             <tr>
                <td width="30%" align="left">
                  <strong><?php echo VULANG_DET_DL; ?></strong>
	            </td>
                <td width="80%" align="left">
                  <?php
                    if (file_exists($link)) { ?>
                     <a href="<?php echo $download; ?>" target="_self"><input type="button" class="button" value="<?php echo VULANG_DET_DLBUTTON; ?>"></a>
                    <?php } else { ?> <font color="red"><?php echo VULANG_DET_NOFILE; }?></font>
	            </td>
             </tr>
          <?php } ?>
        </table>
        </fieldset>

      </td>
      <td width="50%" valign="top">
        <fieldset>
        <legend><?php echo VULANG_DET_USERINFO; ?></legend>
        <table class="adminlist">
          <?php
            foreach ($details AS $detail) {
              $link = "javascript:void window.open('$mosConfig_live_site/administrator/index3.php?page=order.order_printdetails&order_id=$detail->order_id&no_menu=1&option=com_virtuemart', 'win2', 'status=no,toolbar=no,scrollbars=yes,titlebar=no,menubar=no,resizable=yes,width=640,height=480,directories=no,location=no')";

              $query = "SELECT ban_id"
                     . "\n FROM #__virtueuploads_ban"
                     . "\n WHERE ip = '$detail->ip'"
                     . "\n AND session_id = '$detail->session_id'";
                     $database->setQuery($query);
                     $banned = $database->loadResult();
              ?>
              <tr>
                <td width="30%" align="left">
                  <strong><?php echo VULANG_DET_USERNAME; ?></strong>
	            </td>
                <td width="80%" align="left">
                  <?php echo $detail->upload_by; ?>
	            </td>
             </tr>
             <tr>
                <td width="30%" align="left">
                  <strong><?php echo VULANG_DET_IP; ?></strong>
	            </td>
                <td width="80%" align="left">
                  <?php echo $detail->ip; ?>
	            </td>
             </tr>
             <tr>
                <td width="30%" align="left">
                  <strong><?php echo VULANG_DET_SESS; ?></strong>
	            </td>
                <td width="80%" align="left">
                  <?php
                    if ($detail->session_id != '') {
                      echo $detail->session_id;
                    }
                    else { ?>
                    <font color="red"><?php echo VULANG_DET_NOSESS ?></font><?php } ?>
	            </td>
             </tr>
             <tr>
                <td width="30%" align="left">
                  <strong><?php echo VULANG_DET_BANNED; ?></strong>
	            </td>
                <td width="80%" align="left">
                  <?php
                    if ($banned != '') { ?>
                      <font color="red"><?php echo VULANG_LOG_YES." (Ban-ID: ".$banned.")"; ?></font>
                    <?php }
                    else {
                      echo VULANG_LOG_NO; } ?>
	            </td>
             </tr>
             <tr>
                <td width="30%" align="left">
                  <strong><?php echo VULANG_DET_VIEWORDER; ?></strong>
	            </td>
                <td width="80%" align="left">
                  <?php
                    if ($detail->order_id != '0') { ?>
                      <a href="<?php echo $link; ?>"><input type="button" class="button" value="<?php echo VULANG_DET_VIEWBUTTON; ?>"></a>
                  <?php } else { ?> <font color="red"><?php echo VULANG_DET_NOORDER; }?></font>
	            </td>
             </tr>
             <tr>
                <td width="30%" align="left">
                  <strong><?php echo VULANG_LOG_COMMENT; ?> :</strong>
	            </td>
                <td width="80%" align="left">
                  <textarea cols="50" rows"10"><?php echo $detail->comment; ?></textarea>
	            </td>
             </tr>
          <?php } ?>
        </table>
        </fieldset>
      </td>
    </tr>
  </table>

  <input type="hidden" name="option" value="com_virtueupload" />
   <input type="hidden" name="task" value="details" />
 </form>
  <table style="text-align:center">
       <tr>
         <td>
           <?php echo VU_COPYRIGHT ?>
         </td>
       </tr>
     </table>
<?php
}
/*==============================================================================
* Author    : Tobias Kuhn
* Function  : show_banlist
* Parameter : ban entrys
* Return    : order_id
==============================================================================*/
function show_banlist(&$bans, $pageNav) {
  global $mosConfig_live_site;
  ?>
  <table class="adminheading">
	  <tr>
		<td width="239">
		  <img src="<?php echo $mosConfig_live_site;?>/administrator/components/com_virtueupload/images/VU_logo.png" width="239" height="62"/>
		</td>
        <td height="62px" valign="middle" align="left">
           <font color="darkgreen"> [ <?php echo VULANG_BAN_LIST; ?> ]</font>
        </td>
      </tr>
	</table>
    <form action="index2.php" method="POST" name="adminForm">
      <script language="javascript" type="text/javascript">
	    function submitbutton(pressbutton) {
	      if (pressbutton == 'unban') {
		      submitform(pressbutton);
	      }
          if (pressbutton == 'unban') {
		      submitform(pressbutton);
	      }
          if (pressbutton == 'cancel') {
		      submitform(pressbutton);
	      }
          if (pressbutton == 'cancel') {
		      submitform(pressbutton);
	      }
	    }
	  </script>
	  <table class="adminlist">
	    <tr>
		  <th width="5px" align="center">
		    #
		  </th>
		  <th width="5px" align="center">
		    <input type="checkbox" name="toggle" value="" onClick="checkAll(<?php echo count( $rows ); ?>);" />
		  </th>
		  <th width="10px" align="center">
		    ID
		  </th>
		  <th width="25%" align="left">
            <?php echo VULANG_DET_USERNAME; ?>
		  </th>
          <th width="25%" align="left">
            <?php echo VULANG_DET_IP; ?>
		  </th>
		  <th width="25%" align="left">
            <?php echo VULANG_DET_SESS; ?>
		  </th>
          <th width="25%" align="center">
            <?php echo VULANG_LOG_DATE; ?>
		  </th>
		</tr>
        <?php $k = 0;
        for ($i=0, $n=count( $bans ); $i < $n; $i++) {
          $ban          = &$bans[$i];
          $access 	    = mosCommonHTML::AccessProcessing( $row, $i );
		  $checked 	    = mosCommonHTML::CheckedOutProcessing( $row, $i );
        ?>
        <tr class="<?php echo "row$k"; ?>">
          <td width="5px" align="center">
            <?php echo $pageNav->rowNumber( $i ); ?>
	      </td>
          <td width="5px" align="center">
		    <?php echo mosHTML::idBox($i, $ban->ban_id); ?>
	      </td>
	      <td width="10px" align="center">
	        <?php echo $ban->ban_id; ?>
	      </td>
	      <td width="25%" align="left">
	        <?php echo $ban->name; ?>
	      </td>
          <td width="25%" align="left">
            <?php echo $ban->ip; ?>
	      </td>
	      <td width="25%" align="left">
            <?php echo $ban->session_id; ?>
	      </td>
	      <td width="10%" align="center">
	        <?php
              echo $ban->date; ?>
	      </td>
       <?php  $k = 1 - $k;} ?>
     </table>
     <?php echo $pageNav->getListFooter(); ?>
     <table style="text-align:center">
       <tr>
         <td>
           <?php echo VU_COPYRIGHT ?>
         </td>
       </tr>
     </table>
   <input type="hidden" name="option" value="com_virtueupload" />
   <input type="hidden" name="task" value="banlist" />
   <input type="hidden" name="boxchecked" value="0" />
   <input type="hidden" name="hidemainmenu" value="1" />
 </form>
  <?php
}
}
?>
