<?php

/* ************************************************************************************
EstateAgent - a Mambo/Joomla Component

File:					admin.estateagent.php
Copyright: 			2004 - 2006 by Darko Selesi
Homepage: 		http://www.bits-dont-bite.net
Version: 			1.0.1 Stable                       
Created with: 	QuantaPlus 3.4.3 (http://kdewebdev.org)
						Eclipse 3.1.0 (http://www.eclipse.org)
			  			on RedHat/Fedora Linux Core4 (http://fedora.redhat.com)
License: 			GNU/GPL http://www.gnu.org/copyleft/gpl.html
*************************************************************************** */

// ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

require_once( $mosConfig_absolute_path."/administrator/components/com_estateagent/configuration.php");
require_once( $mosConfig_absolute_path."/administrator/components/com_estateagent/class.estateagent.php");
require_once( $mainframe->getPath( 'admin_html' ) );

if(file_exists($mosConfig_absolute_path . "/components/com_estateagent/languages/" . $mosConfig_lang . ".php")){
  	include($mosConfig_absolute_path . "/components/com_estateagent/languages/" . $mosConfig_lang . ".php");
}
else{
  	include($mosConfig_absolute_path . "/components/com_estateagent/languages/english.php");
}

$option 		= mosGetParam( $_REQUEST, 'option', 'com_estateagent' );
$act 			= mosGetParam( $_REQUEST, 'act', 'manageObj' );
$task 		= mosGetParam( $_REQUEST, 'task', '' );
$id 			= mosGetParam( $_REQUEST, 'id', 0 );
$cid     		= mosGetParam( $_REQUEST, 'cid', array(0) );
$limitstart	= mosGetParam( $_REQUEST, 'limitstart', 0);
$limit			= mosGetParam( $_REQUEST, 'limit', 20);

if (!is_array( $cid )) {
      $cid = array(0);
}

switch ($act) {
	case "manageObj":
        manageObj($option, $act, $task, $id, $cid, $limitstart, $limit);
        break;
    case "manageCat":
        manageCat($option, $act, $task, $id, $cid, $limitstart, $limit);
		break;    
    case "manageAgts":  // client (agents) administration
    	// not implemented yet
    	break;
    case "showStc": // statistic - functionality
		// not implemented yet
		break;	
    case "configEA":	// configuration functionality
        configEA($option, $task);
		break;
 	case "EAinfo":
        HTML_estateagent::showEAinfo();
    	break;
}

// backend administration menu
function backendMenu() {
	global $mosConfig_live_site;

	echo "<tr>";
    echo "<td colspan=\"4\" align=\"left\"><a href=\"http://www.bits-dont-bite.net\" target=\"_blank\" style=\"filter: alpha(opacity=7);\" onmouseover=\"if( this.filters) { this.filters.alpha.opacity=100; }\" onmouseout=\"if( this.filters) { this.filters.alpha.opacity=70; }\"><img style=\"-moz-opacity: 0.7;\" onmouseover=\"this.style.MozOpacity=1.0;\" onmouseout=\"this.style.MozOpacity = 0.7;\" src=\"" . $mosConfig_live_site . "/components/com_estateagent/pictures/gui/ealogo.png\" alt=\"visit the home of the EstateAgent\" border=\"0\"></a></td>";
    echo "<td colspan=\"3\" align=\"right\" valign=\"top\"><img src=\"" . $mosConfig_live_site . "/images/M_images/arrow.png\" border=\"0\" />&nbsp;"
				. "<a href=\"index2.php?option=com_estateagent&act=manageObj\">" . _EAB_MENU_LINK1 . "</a> |"
    			. " <a href=\"index2.php?option=com_estateagent&act=manageCat\">" . _EAB_MENU_LINK2 . "</a> |"
    			#. " <a href='index2.php?option=com_estateagent&act=manageAgts'>" . _EAB_MENU_LINK3 . "</a> |"
				. " <a href=\"index2.php?option=com_estateagent&act=configEA\">" . _EAB_MENU_LINK4 . "</a> |"
				. " <a href=\"index2.php?option=com_estateagent&act=EAinfo\">" . _EAB_MENU_LINK5 . "</a></td>";
    echo "</tr>";	
}

function backendFooter(){
	global $ea_version;
	// STOP!!! You may NOT remove this line! If you wish to change it, please contact me -> info@bits-dont-bite.net --------------------------------------------
	echo "<p><div class=\"smalldark\"><a href=\"http://www.bits-dont-bite.net/\" target=\"_blank\"><b>EstateAgent " . $ea_version . "</b></a><br /><span style=\"font-size:9px\">&copy 2004-2006 by bits-dont-bite.net / Darko Selesi</span></div></p><br />";
 	// ----------------------------------------------------------------------------------------------------------------------------------------------------------
}

function manageObj($option, $act, $task, $id, $cid, $limitstart, $limit) {
	global $database, $my, $mosConfig_live_site, $mosConfig_absolute_path, $mosConfig_offset, $ea_measure, $ea_currency, $ea_picpath, $ea_tbwidth;
				
	switch ($task) {
		
		case 'new':
    	case 'edit':
			   				
   			$obj = new EAObject( $database );
   				
			if($task == "edit") {
				if($id == 0) $obj->load($cid[0]);
				else $obj->load($id);
				$action = '<input type="hidden" name="id" id="id" value="' . $obj->id .'" />';
				$action .= _EAB_OBJ_EDIT;
			}
     		else{
				$query = "SELECT id FROM #__estateagent ORDER BY id ASC";
	    		$database->setQuery($query);
        		$result = $database->loadResultArray();
        		        		
        		if(count($result) == 0 || $result == "") $obj->id = 1;
       	 		else $obj->id = (end($result) + 1);
        		       		        		
        		$action = '<input type="hidden" name="cid" id="cid" value="' . $obj->id .'" />';
				$action .= _EAB_OBJ_NEW;
        	}
   			   			
   			// make categories html selectlist
   			$query = "SELECT id, name FROM #__estateagent_categories WHERE parent = 0 ORDER BY ordering";
			$database->setQuery($query);
			$cats = $database->loadObjectList();
			#echo $database->getErrorMsg();
			
			$c[] = mosHTML::makeOption( '0', _EAB_CAT_OVW );
           	foreach($cats as $cat) {       			         	
				$c[] = mosHTML::makeOption( $cat->id, $cat->name );			
				
				// let`s look for subcategories
				$query = "SELECT id, name FROM #__estateagent_categories WHERE parent = $cat->id ORDER BY ordering";
        		$database->setQuery($query);
        		$scats = $database->loadObjectList();						
				
				foreach($scats as $scat) {									
					$c[] = mosHTML::makeOption( $scat->id, "&nbsp;'->&nbsp;" . $scat->name );
				}		
			}           	
			$lists['categories'] = mosHTML::selectList( $c, 'cat', 'class="inputbox" size="1" ', 'value', 'text', $obj->cat );
			
			$t[] = mosHTML::makeOption('0',_EAB_OBJ_TYPE1);
			$t[] = mosHTML::makeOption('1',_EAB_OBJ_TYPE2);
			$t[] = mosHTML::makeOption('2',_EAB_OBJ_TYPE3);
			$t[] = mosHTML::makeOption('3',_EAB_OBJ_TYPE4);
			$t[] = mosHTML::makeOption('4',_EAB_OBJ_TYPE5);
			$lists['type'] = mosHTML::selectList($t,'type','id="type" class="inputbox" size="1" onChange="javascript:changeGUI(document.getElementById(\'type\').selectedIndex);" ', 'value', 'text', $obj->type );
						
			$obj->lift					= mosEAHTML::checkbox('lift', 'class="inputbox"', '1', '', 0, $obj->lift );
			$obj->handicap			= mosEAHTML::checkbox('handicap', 'class="inputbox"', '1', '', 0, $obj->handicap );
   			$obj->toheat_ufloor		= mosEAHTML::checkbox( 'toheat_ufloor', 'class="inputbox"', '1', '', 0, $obj->toheat_ufloor );
  			$obj->fireside				= mosEAHTML::checkbox( 'fireside', 'class="inputbox"', '1', '', 0, $obj->fireside );
			$obj->aircondition		= mosEAHTML::checkbox( 'aircondition', 'class="inputbox"', '1', '', 0, $obj->aircondition );
			$obj->tv						= mosEAHTML::checkbox( 'tv', 'class="inputbox"', '1', '', 0, $obj->tv );
  			$obj->dsl					= mosEAHTML::checkbox( 'dsl', 'class="inputbox"', '1', '', 0, $obj->dsl );
   			$obj->balcony			= mosEAHTML::checkbox( 'balcony', 'class="inputbox"', '1', '', 0, $obj->balcony );   			
   			$obj->terrace				= mosEAHTML::checkbox( 'terrace', 'class="inputbox"', '1', '', 0, $obj->terrace );
   			$obj->garden				= mosEAHTML::checkbox( 'garden', 'class="inputbox"', '1', '', 0, $obj->garden );
			$obj->swpool				= mosEAHTML::checkbox( 'swpool', 'class="inputbox"', '1', '', 0, $obj->swpool );
   			$obj->parkarea			= mosEAHTML::checkbox( 'parkarea', 'class="inputbox"', '1', '', 0, $obj->parkarea );   			
   			$obj->garage				= mosEAHTML::checkbox( 'garage', 'class="inputbox"', '1', '', 0, $obj->garage );   			
   			$obj->hot					= mosEAHTML::checkbox( 'hot', 'class="inputbox"', '1', '', 0, $obj->hot );   			
   			 
   			// get object images and generate gallery HTML-code
   			$gl = "";
   			$g = $obj->loadGallery($obj->id,1); 
   			if(count($g) > 0) { 
   				$c = 2;
   				foreach($g as $i) {
   					if($c%2 == 0) $gl .= "<tr>";   						
   					$i->path = ($i->path == "")? $ea_picpath : $i->path;
   					$gl .= "<td style=\"width:50%; text-align:center\"><img src=\"".$mosConfig_live_site.$i->path.$i->fname.$i->type."\" width=\"250px\" border=\"0\" /></td>";  					
   					if($c%2 != 0) $gl .= "</tr>";
   					$c++;
   				}
   				if(count($g)%2 != 0) $gl .= "<td>&nbsp;</td></tr>";
   			}	
   			else {
   				$gl = "<tr><td>" . _EAB_OBJ_NOIMG . "</td></tr>";
   			}
   				  			
   			$lists['countries'] = mosHTML::selectList( $obj->country_select_list(), 'country', 'class="inputbox" size="1"', 'value', 'text', $obj->country );
   			
 	        $lists['access'] = mosAdminMenus::Access( $obj );  				
			
			$active = ( intval( $obj->created_by ) ? intval( $obj->created_by ) : $my->id );
 		    $lists['created_by'] = mosAdminMenus::UserSelect( 'created_by', $active );
 		    
			$obj->created = ($obj->created == "")? date( "Y-m-d" ) : $obj->created;
  			$obj->publish_up = ($obj->publish_up == "")? date( "Y-m-d" ) : $obj->publish_up;;
   			if($task == "new" || trim( $obj->publish_down ) == '0000-00-00') {
 	              $obj->publish_down = _EAB_OBJ_PUBNEVER;
 			}
 			$obj->publish = mosEAHTML::checkbox( 'publish', 'class="inputbox"', '1', '', 0, $obj->publish ); 
   			   			  			
   			$sql = "SELECT template FROM #__templates_menu WHERE client_id='1' AND menuid='0'";
       		$database->setQuery( $sql );  			
   			
   			$params['cur_templ'] 	= $database->loadResult();
   			$params['measure'] 	= $ea_measure;
   			$params['currency'] 	= $ea_currency;
   			$params['picpath']		= $ea_picpath;
   			   			   			   			
   			HTML_estateagent::editObj($option,$act,$action,$obj,$gl,$lists,$params);
   			   			   			  	
		break;
		
		case 'resetC':

			$obj = new EAObject($database);
			$obj->load($id);
			
			$obj->hits = 0;
			$obj->store();
			  
			$msg = _EAB_OBJ_RESETCNT_SUCCESS;
			mosRedirect( 'index2.php?option=com_estateagent&act=manageObj&task=edit&hidemainmenu=1&id='. $id, $msg );

		break;

		case 'unpublish':
        case 'publish':
            
			if (count( $cid ) < 1) {
           		$action = $publish ? 'publish' : 'unpublish';
           		echo "<script> alert('Select a object to $action'); window.history.go(-1);</script>\n";
           		exit;
       		}
   
       		$cids = implode( ',', $cid );
   
   			$publish = ($task == "publish")? "1" : "0";
			
  			$database->setQuery( "UPDATE #__estateagent SET publish=$publish WHERE id IN ( $cids )" );
  			$database->query();
  			
  			if($database->getErrorMsg() == "") $msg = _EAB_OBJ_SCSS;
			else $msg = _EAB_OBJ_ERROR;
			
			mosRedirect( "index2.php?option=$option&act=manageObj&limitstart=$limitstart&limit=$limit", $msg );
			
 		break;        
        
        case 'save':											
    		    		
    		$obj = new EAObject( $database );
    		      		
       		if (!$obj->bind( $_POST )) {
           		echo "<script> alert('".$obj->getError()."'); window.history.go(-1); </script>\n";
           		exit();
      		}
   			$obj->id 					= ($cid[0] > 0)? "" : mosGetParam($_POST,'id','');
   			$obj->obj_id				= trim( $obj->obj_id);
  			$obj->description 		= str_replace( '<br>', '<br />', $obj->description );
  			$obj->location			= str_replace( '<br>', '<br />', $obj->location );
  			$obj->condition 			= str_replace( '<br>', '<br />', $obj->condition );
  			$obj->other  				= str_replace( '<br>', '<br />', $obj->other );
			$obj->created				= $obj->created? $obj->created : date( "Y-m-d" );
  			$obj->created_by    	= $obj->created_by ? $obj->created_by : $my->id;
  													
 			if (!$obj->check()) {
           		echo "<script> alert('".$obj->getError()."'); window.history.go(-1); </script>\n";
           		exit();
       		}
       		if (!$obj->store()) {
           		echo "<script> alert('".$obj->getError()."'); window.history.go(-1); </script>\n";
           		exit();
       		}
       		       		   			   
			mosRedirect( "index2.php?option=$option&act=manageObj&limitstart=$limitstart&limit=$limit" );
    		          
	  	break;
        
        case 'remove':			
			
			$msg = _EAB_OBJ_DELSCSS;
			
			$total = count( $cid );
 			if ( $total < 1) {
           		echo "<script> alert('"._EAB_OBJ_ERROR16."'); window.history.go(-1);</script>\n";
           		exit;
       		}
			if(count($cid) < 1){
				$cid[0] = $id;
			}			
			
			foreach($cid as $o){							
				$obj = new EAObject($database);
				//delete object images
				$images = $obj->getObjectImages($o);							
				foreach($images as $i) {								
					$img = new EAImage($database);
					$img->load($i);
					$img->delete();
				}
				if(!$obj->delete($o)) $msg = _EAB_OBJ_DELERROR;
			}
				
			mosRedirect( "index2.php?option=com_estateagent&act=manageObj&limitstart=$limitstart&limit=$limit", $msg );
			
 		break;
		
		case 'accesspublic':
 		case 'accessregistered':
        case 'accessspecial':
                   
      		$row = new EAObject( $database );
      		$row->load( $cid[0] );
      		switch($task){
			
				case 'accesspublic':
					$row->access = 0;
				break;
  			
				case 'accessregistered':
					$row->access = 1;
				break;
				
				case 'accessspecial':
					$row->access = 2;
				break;
			}

      		if ( !$row->check() ) {
          		return $row->getError();
      		}
      		if ( !$row->store() ) {
          		return $row->getError();
      		}
    
      		mosRedirect( "index2.php?option=com_estateagent&act=manageObj&limitstart=$limitstart&limit=$limit" );
  
		break;

		default:
           	
			#$limitstart		= mosGetParam( $_POST, 'limitstart', 0);
			#$limit				= mosGetParam( $_POST, 'limit', 20);		
			$filter 			= trim(mosGetParam( $_REQUEST, 'filter', '' ));
			$slcat 			= mosGetParam( $_REQUEST, 'corder', '' );

			$and = " AND ";
			$where = "";						
			if(isset( $filter ) && $filter != "") {
            	$where = " (o.obj_id LIKE '%$filter%'" .
            				" OR o.title LIKE '%$filter%'" .
            				" OR o.description LIKE '%$filter%'" .
            				" OR o.condition LIKE '%$filter%'" .
            				" OR o.street LIKE '%$filter%'" .
            				" OR o.town LIKE '%$filter%'" .
            				" OR o.district LIKE '%$filter%'" .
            				" OR o.state LIKE '%$filter%'" .
            				" OR o.country LIKE '%$filter%'" .	
            				" OR o.other LIKE '%$filter%')";
  			}	
			
			if($where == ""){ // if no filter set
				if($slcat != "") $where = $and . " o.cat = $slcat ";				
			}
			else{
				if($slcat != "") $where = $and . $where . " AND o.cat = $slcat ";
				else $where = $and . $where;
			}
						
			$sort = mosGetParam( $_REQUEST, 'sort', 'ASC' );
    		    		
			$query = "SELECT count(o.id)"
						. " FROM #__estateagent AS o, #__estateagent_categories AS c"
						. " LEFT JOIN #__groups AS g ON g.id = o.access"	
						. " WHERE c.id = o.cat $where ORDER BY o.created $sort";
			$database->setQuery($query);
			$total = $database->loadResult();    		

    		include_once("includes/pageNavigation.php");
  			$pageNav = new mosPageNav( $total, $limitstart, $limit );
						
			$query = "SELECT o.id, o.obj_id, o.cat, o.title, o.country, o.state, o.town, o.district, o.hits, o.publish_up, o.publish_down, o.publish, o.hot, o.access, c.name AS catname, g.name AS groupname"
						. " FROM #__estateagent AS o, #__estateagent_categories AS c"
						. " LEFT JOIN #__groups AS g ON g.id = o.access"	
						. " WHERE c.id = o.cat $where ORDER BY o.created $sort LIMIT $limitstart,$limit";
			$database->setQuery($query);
			$objects = $database->loadObjectList();
			#echo $database->getErrorMsg();			       		
       					
       		$query = "SELECT id, name FROM #__estateagent_categories WHERE parent = 0 ORDER BY ordering";
			$database->setQuery($query);
			$cats = $database->loadObjectList();
			#echo $database->getErrorMsg();       		
        	
        	if(count($cats) > 0) {
        		$i = 0;
        		$catoption[$i] = mosHTML::makeOption( '', _EAB_CAT_OPT );
        		foreach($cats as $cat) {
       				$i++;
					$catoption[$i] = mosHTML::makeOption( $cat->id, $cat->name );
						
					$query = "SELECT id, name FROM #__estateagent_categories WHERE parent = $cat->id ORDER BY ordering";
        			$database->setQuery($query);
        			$scats = $database->loadObjectList();
						
					foreach($scats as $scat) {
						$i++;
						$catoption[$i] = mosHTML::makeOption( $scat->id, "&nbsp;'-->".$scat->name );
					}						
				}		
           		$corder = mosHTML::selectList($catoption,'corder','size="1" class="inputbox" style="width:170px" onchange="document.adminForm.submit()"','value','text', $slcat);
			       				
				$opt[] = mosHTML::makeOption( 'ASC', _EAB_SORT_OPT1 );			
        		$opt[] = mosHTML::makeOption( 'DESC', _EAB_SORT_OPT2 );
        		$sort = mosHTML::selectList($opt, 'sort', 'size="1" class="inputbox" style="width:105px;" onchange="document.adminForm.submit()"','value','text', $sort);

				$params['picpath'] = $ea_picpath; 				
			
    			HTML_estateagent::showObjOverview($option,$act,$objects,$cats,$filter,$corder,$sort,$pageNav,$params);
        	}
        	else{
        		$msg = _EAB_CAT_CREATECAT;   					
   				mosRedirect( "index2.php?option=$option&act=manageCat", $msg );
        	}
        		
    	break;
	}
}
// ---------------------------------------------------------
// category functions --------------------------------
// ---------------------------------------------------------
function manageCat($option, $act, $task, $id, $cid, $limitstart, $limit){
	global $database,$mosConfig_absolute_path;
		
	switch($task) {
		
		case "new":
		case "edit":	
						
			$lists = array();
					
 			$cat = new EACategory($database);	   		
	   		
			if($id == 0 && $cid[0] == 0){
				// initialise new record         	
          		$cat->parent 	= 0;
          		$cat->ordering  	= 0;
          		$cat->publish   	= 1; 	   
			}
			elseif($id == 0){
 				$cat->load($cid[0]);
			}
			else $cat->load($id);
    		
			$cat->publish_up = ($cat->publish_up == "")? date( "Y-m-d" ) : $cat->publish_up;;
   			if($task == "new" || trim( $cat->publish_down ) == '0000-00-00') {
 	              $cat->publish_down = _EAB_OBJ_PUBNEVER;
 			}
			
			$query = "SELECT count(*) FROM #__estateagent_categories";
			$database->setQuery($query);
			$total = $database->loadResult();
    		
    	    // build the html select list for ordering
 		    $query = "SELECT ordering AS value, name AS text"
       					. "\n FROM #__estateagent_categories"
       					. "\n WHERE parent=$cat->parent"
       					. "\n ORDER BY ordering";
       		$val = ($total > 0)? 1 : 0;
			$lists['ordering'] = mosAdminMenus::SpecificOrdering( $cat, $val, $query, 0 );
    	    
    	    // build the html select list for the group access
 	        $lists['access'] = mosAdminMenus::Access( $cat );  				
			
			$query = "SELECT id AS value, name AS text FROM #__estateagent_categories WHERE parent = 0 AND id != $cid[0]";
        	$database->setQuery($query);       		        	
        	$rows[] = mosHTML::makeOption( 0, _EAB_CAT_OVW7 );
	        if($total > 0) $rows = array_merge( $rows, $database->loadObjectList() );       	
        	$lists['parent'] = mosHTML::selectList($rows,'parent','size="1" class="inputbox" style="width:160px"','value','text', $cat->parent);
			  
			$lists['publish']= mosHTML::yesnoRadioList( 'publish', 'class="inputbox"', $cat->publish );
			
  			HTML_estateagent::editCat($option, $act, $cat, $lists);
		
		break;
				
		case "save":
												  
			$row = new EACategory( $database );
       		
       		if (!$row->bind( $_POST )) {
           		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>";
           		exit();
      		}   
  			$row->description 	= str_replace( '<br>', '<br />', $row->description );
  														
 			if (!$row->check()) {
           		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>";
           		exit();
       		}
       		if (!$row->store()) {
           		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>";
           		exit();
       		}
       		
       		if($row->parent != 0){
       			$row->updateOrder( "parent=$row->parent" );
				$c = new EACategory($database);
				$c->updateOrder( "parent=0" );	
       		}
       		else{
   				$row->updateOrder( "parent=0" );
			}
       		
			mosRedirect( "index2.php?option=$option&act=manageCat&limitstart=$limitstart&limit=$limit" );
			
		break;
 		
 		case "remove":
 			// todo: include error-handling			 
			 			
			if(count($cid) < 1) {
				$cid[0] = $id;
			}
			
			foreach($cid as $c){
					
				$dcat = new EACategory($database);
	    		$dcat->load($c);
								
				// has this category subcategories? if yes get the IDs...
    			$subcat = $dcat->getSubcategories();					
				foreach($subcat as $sc){
					// get the entries of each subcaterory, delete them and their images	
					$scat = new EACategory($database);
					$scat->load($sc->id);
	
					// get entries of this subcategory
					$objects = $scat->getCatEntries();													
					foreach($objects as $o){							
						$obj = new EAObject($database);
						//delete object images
						$images = $obj->getObjectImages($o);							
						foreach($images as $i) {								
							$img = new EAImage($database);
							$img->load($i);
							$img->delete();
						}
						$obj->delete($o);
					}
					// delete subcategory
					$p = $scat->parent;
					$scat->delete();
					$scat->updateOrder( "parent='".$p."'" );
				} // end subcategories
					
				// get entries of maincategory
				$objects = $dcat->getCatEntries();													
				foreach($objects as $o){							
					$obj = new EAObject($database);
					//delete object images
					$images = $obj->getObjectImages($o);							
					foreach($images as $i) {								
						$img = new EAImage($database);
						$img->load($i);
						$img->delete();
					}
					$obj->delete($o);
				}
				$p = $dcat->parent;
				$dcat->delete();
				$dcat->updateOrder( "parent='".$p."'" );
			}
			
			mosRedirect( "index2.php?option=$option&act=manageCat&limitstart=$limitstart&limit=$limit" );
			
 		break;
 		
 		case "publish":
 		case "unpublish":
 		
			if (count( $cid ) < 1) {
           		$action = $publish ? 'publish' : 'unpublish';
           		echo "<script> alert('"._EAB_OBJ_ERROR17."'); window.history.go(-1);</script>\n";
           		exit;
       		}
			
			$cids = implode( ',', $cid );
   			
			$status = ($task == "publish")? 1 : 0;
						
   			$database->setQuery( "UPDATE #__estateagent_categories SET publish=$status WHERE id IN ($cids)" );
   			$database->query();
			$error = $database->getErrorMsg();
			if(!empty($error)){
				echo "<script> alert('". $error ."'); window.history.go(-1); </script>\n";
				exit();
			}
			else{
				mosRedirect( "index2.php?option=$option&act=manageCat&limitstart=$limitstart&limit=$limit" );
			}

 		break;
		
		case "orderup":
		case "sorderup":
		       
       		$row = new EACategory( $database );
      		$row->load( $cid[0] );
       		if($task == "orderup") $row->move( -1, "parent = '0'" );
   			else $row->move( -1, "parent = $row->parent" );			
			
			mosRedirect( "index2.php?option=$option&act=manageCat&limitstart=$limitstart&limit=$limit" ); 
		
		break;
		
		case "orderdown":
		case "sorderdown":
		
			$row = new EACategory( $database );
      		$row->load( $cid[0] );
       		if($task == "orderdown") $row->move( 1, "parent = '0'" );
   			else $row->move( 1, "parent = $row->parent" );
								
			mosRedirect( "index2.php?option=$option&act=manageCat&limitstart=$limitstart&limit=$limit" );
		
		break;
		
		case 'accesspublic':
 		case 'accessregistered':
        case 'accessspecial':
                   
      		$row = new EACategory( $database );
      		$row->load( $cid[0] );
      		switch($task){
			
				case 'accesspublic':
					$row->access = 0;
				break;
  			
				case 'accessregistered':
					$row->access = 1;
				break;
				
				case 'accessspecial':
					$row->access = 2;
				break;
			}

      		if ( !$row->check() ) {
          		return $row->getError();
      		}
      		if ( !$row->store() ) {
          		return $row->getError();
      		}
    
      		mosRedirect( "index2.php?option=com_estateagent&act=manageCat&limitstart=$limitstart&limit=$limit" );
  
		break;
   
		default:
						
			// get maincategories
			$query = "SELECT c.*, g.name AS groupname FROM #__estateagent_categories c"						
						. " LEFT JOIN #__groups g ON g.id = c.access"
						. " WHERE c.parent = 0"
						. " ORDER BY c.ordering ASC LIMIT $limitstart,$limit";
    		$database->setQuery($query);
    		$cats = $database->loadObjectList();
    
			include_once("includes/pageNavigation.php");
  			$pageNav = new mosPageNav( count($cats), $limitstart, $limit );

			if(count($cats) > 0) {
    			// check entries in every category
    			$entries = array(); $x=0;
   				foreach($cats as $c){
    				$query = "SELECT count(*) FROM #__estateagent " 
							. " WHERE cat = $c->id";
	   				$database->setQuery($query);	
    				$entries[$x] = $database->loadResult();
    				$x++;
    			}    	    	    	   	    	    
                
   			 	// get subcategories and check for entries   
    			$scats = array();$sentries = array();$x=0;
    			foreach($cats as $c){     			
					$query  = "SELECT c.*, g.name AS groupname FROM #__estateagent_categories AS c"
							 	. " LEFT JOIN #__groups AS g ON g.id = c.access"
								. " WHERE c.parent = $c->id ORDER BY c.ordering ASC";
					$database->setQuery($query);
        			$scats[$x] = $database->loadObjectList();				
					#$scats[$x] = EACategory::get_subcategories($c->id, 1000, $database);    		
    				$sentries[$x]=array();$y=0;
    				foreach($scats[$x] as $s){
    					$query = "SELECT count(*) FROM #__estateagent " 
							. " WHERE cat = $s->id";							
	    				$database->setQuery($query);	
    					$sentries[$x][$y] = $database->loadResult();
    					$y++;
    				}   		    		    		
    			$x++;
    			}   	    	    	   
   			}
			else{
				$cats = 0; $scats = 0; $entries = 0; $sentries = 0;
			}			

    		HTML_estateagent::showCatOverview($option, $act, $cats, $scats, $entries, $sentries, $pageNav);
    		
		break;
	}
}

#########################################################################
# Configuration Functions
#########################################################################

function configEA($option, $task) {
		
	switch($task) {
			
 		case "save":
			global $mosConfig_absolute_path;
    		    		
    		$cfgfile = $mosConfig_absolute_path."/administrator/components/com_estateagent/configuration.php";
  			$permission = is_writable($cfgfile);  			
  			if ($permission == false) @chmod ($cfgfile, 0777);
  			
    		$object = $_POST;
    		$object['ea_offmessage'] 	= addslashes($object['ea_offmessage']);
    		$object['ea_measure'] 		= ($object['ea_measure'] == "m") ? "m&sup2" : "ft&sup2";
			$object['ea_imgprtn'] 			=  ($object['ea_imgprtn'])? $object['ea_imgprtn'] : "0";
			$object['ea_tbprtn'] 			=  ($object['ea_tbprtn'])? $object['ea_tbprtn'] : "0";
			$object['ea_map24_tlogo'] 	= (stristr($object['ea_map24_tlogo'],"http://")) ? $object['ea_map24_tlogo'] : "http://" . $object['ea_map24_tlogo'];			
			$object['ea_map24_dimg'] 	= (stristr($object['ea_map24_dimg'],"http://")) ? $object['ea_map24_dimg'] : "http://" . $object['ea_map24_dimg'];
			
			$shortinfo = "";			
			for($x=0; $x < 5; $x++) {
				if($x == current($_POST['ea_shortinfo'])) {
					$shortinfo .=  "1,";
					next($_POST['ea_shortinfo']);
				}
				else $shortinfo .= "0,";
			}
			$shortinfo = substr($shortinfo, -10, 9);

    		$cfg = "<?php\n";
    		$cfg .= "defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );\n\n";
  			$cfg .= "\$ea_picpath = \"".$object['ea_picpath']."\";\n";
  			$cfg .= "\$ea_offline = \"".$object['ea_offline']."\";\n";
  			$cfg .= "\$ea_offmessage = \"".trim($object['ea_offmessage'])."\";\n";
  			$cfg .= "\$ea_sorting = \"".$object['ea_sorting']."\";\n";
  			$cfg .= "\$ea_perpage = \"".$object['ea_perpage']."\";\n";
  			$cfg .= "\$ea_cat_entries = \"".$object['ea_cat_entries']."\";\n";
  			$cfg .= "\$ea_show_scats = \"".$object['ea_show_scats']."\";\n";
			$cfg .= "\$ea_mcat_fullview = \"".$object['ea_mcat_fullview']."\";\n";
  			$cfg .= "\$ea_hot_pos = \"".$object['ea_hot_pos']."\";\n";
  			$cfg .= "\$ea_hot_color = \"".$object['ea_hot_color']."\";\n";			
			$cfg .= "\$ea_shortinfo = \"".$shortinfo."\";\n";
			$cfg .= "\$ea_fulllocation = \"".$object['ea_fulllocation']."\";\n";
			$cfg .= "\$ea_mtf = \"".$object['ea_mtf']."\";\n";
			$cfg .= "\$ea_f_srch = \"".$object['ea_f_srch']."\";\n";
  			$cfg .= "\$ea_l_srch = \"".$object['ea_l_srch']."\";\n";
			$cfg .= "\$ea_loc_srchtype = \"".$object['ea_loc_srchtype']."\";\n";
  			$cfg .= "\$ea_d_srch = \"".$object['ea_d_srch']."\";\n";
  			$cfg .= "\$ea_fpstyle = \"".$object['ea_fpstyle']."\";\n";
			$cfg .= "\$ea_hotfp = \"".$object['ea_hotfp']."\";\n";
 			$cfg .= "\$ea_hotfpa = \"".$object['ea_hotfpa']."\";\n";
  			$cfg .= "\$ea_map24 = \"".$object['ea_map24']."\";\n";
  			$cfg .= "\$ea_map24_lid = \"".trim($object['ea_map24_lid'])."\";\n";
  			$cfg .= "\$ea_map24_type = \"".$object['ea_map24_type']."\";\n";
  			$cfg .= "\$ea_map24_dinfo = \"".trim($object['ea_map24_dinfo'])."\";\n";
  			$cfg .= "\$ea_map24_tlogo = \"".trim($object['ea_map24_tlogo'])."\";\n";
			$cfg .= "\$ea_map24_dimg = \"".trim($object['ea_map24_dimg'])."\";\n";
  			$cfg .= "\$ea_map24_dlg = \"".trim($object['ea_map24_dlg'])."\";\n";
    		$cfg .= "\$ea_maxpicsize = \"".$object['ea_maxpicsize']."\";\n";
    		$cfg .= "\$ea_currency = \"".$object['ea_currency']."\";\n";
    		$cfg .= "\$ea_nformat = \"".$object['ea_nformat']."\";\n";
    		$cfg .= "\$ea_mtgcalc = \"".$object['ea_mtgcalc']."\";\n";
			$cfg .= "\$ea_mtg_default_interest_percent = \"".$object['ea_mtg_default_interest_percent']."\";\n";
			$cfg .= "\$ea_mtg_default_year_term = \"".$object['ea_mtg_default_year_term']."\";\n";
			$cfg .= "\$ea_mtg_default_down_percent = \"".$object['ea_mtg_default_down_percent']."\";\n";
			$cfg .= "\$ea_mtg_default_show_progress = \"".$object['ea_mtg_default_show_progress']."\";\n";
			$cfg .= "\$ea_measure = \"".$object['ea_measure']."\";\n";
    		$cfg .= "\$ea_maxpics = \"".$object['ea_maxpics']."\";\n";
    		$cfg .= "\$ea_gplib = \"".$object['ea_gplib']."\";\n";
    		$cfg .= "\$ea_imgwidth = \"".$object['ea_imgwidth']."\";\n";
        	$cfg .= "\$ea_imgheight = \"".$object['ea_imgheight']."\";\n";
			$cfg .= "\$ea_imgprtn = \"".$object['ea_imgprtn']."\";\n";
			$cfg .= "\$ea_imgqulty = \"".$object['ea_imgqulty']."\";\n";
			$cfg .= "\$ea_watermark = \"".$object['ea_watermark']."\";\n";
    		$cfg .= "\$ea_tbwidth = \"".$object['ea_tbwidth']."\";\n";
  			$cfg .= "\$ea_tbheight = \"".$object['ea_tbheight']."\";\n";
  			$cfg .= "\$ea_tbprtn = \"".$object['ea_tbprtn']."\";\n";
  			$cfg .= "\$ea_tbqulty = \"".$object['ea_tbqulty']."\";\n";
  			$cfg .= "\$ea_gl_pup = \"".$object['ea_gl_pup']."\";\n";
			$cfg .= "\$ea_allowsubmission = \"".$object['ea_allowsubmission']."\";\n";
  			$cfg .= "\$ea_maxobjects = \"".$object['ea_maxobjects']."\";\n";
			$cfg .= "\$ea_footer = \"".$object['ea_footer']."\";\n";
  			$cfg .= "\$ea_version = \"1.0.1 Stable\";\n";
  			$cfg .= "?>";

  			if ($fp = fopen("$cfgfile", "w")) {
    			fputs($fp, $cfg, strlen($cfg));
    			fclose ($fp);
    			@chmod ($cfgfile, 0644);
    			$msg = _EAB_CFG_SCSS;
    		}
			else{
				$msg = _EAB_CFG_ERROR1;
			}
			
    		mosRedirect( "index2.php?option=$option&act=configEA", $msg );
    		
 		break;
		
		default:
			global $mosConfig_absolute_path;
						
			require($mosConfig_absolute_path."/administrator/components/com_estateagent/configuration.php");
			            						
			$yesno[] = mosHTML::makeOption( '0', _EAB_CFG_STS01 );
        	$yesno[] = mosHTML::makeOption( '1', _EAB_CFG_STS02 );
			$lists['ea_offline'] = mosHTML::selectList( $yesno, 'ea_offline', 'class="inputbox" size="1"', 'value', 'text', $ea_offline );
			
			$lists['ea_offmessage'] = $ea_offmessage;
			
			$lists['ea_picpath'] = $ea_picpath;
			$lists['picpath_avalaible'] = (@is_dir($mosConfig_absolute_path.$ea_picpath))? "<span style='color:green; font-weight:bold'>"._EAB_CFG_STS02."</span>" : "<span style='color:red; font-weight:bold'>"._EAB_CFG_STS01."</span>";
			$lists['picpath_writeable'] = (@is_writeable($mosConfig_absolute_path.$ea_picpath))? "<span style='color:green; font-weight:bold'>"._EAB_CFG_STS02."</span>" : "<span style='color:red; font-weight:bold'>"._EAB_CFG_STS01."</span>";
			
			$ea_measure = ($ea_measure == "m&sup2") ? "m" : "ft";
            $ms[] = mosHTML::makeOption( 'm', _EAB_CFG_STS03 );
            $ms[] = mosHTML::makeOption( 'ft', _EAB_CFG_STS04 );
            $lists['ea_measure'] = mosHTML::selectList( $ms, 'ea_measure', 'class="inputbox" size="1"', 'value', 'text', $ea_measure );
			
			$lists['ea_currency'] = $ea_currency;
			
			$nf[] = mosHTML::makeOption( '0', _EAB_CFG_STS152 );
            $nf[] = mosHTML::makeOption( '1', _EAB_CFG_STS153 );
            $lists['ea_nformat'] = mosHTML::selectList( $nf, 'ea_nformat', 'class="inputbox" size="1"', 'value', 'text', $ea_nformat );
						
			$fps[] = mosHTML::makeOption( '0', _EAB_CFG_STS08 );
    		$fps[] = mosHTML::makeOption( '1', _EAB_CFG_STS09 );    		
            $lists['ea_fpstyle'] = mosHTML::selectList( $fps, 'ea_fpstyle', 'class="inputbox" size="1"', 'value', 'text', $ea_fpstyle );
		
			$hot[] = mosHTML::makeOption( '0', _EAB_CFG_HOTOPTION0 );
			$hot[] = mosHTML::makeOption( '1', _EAB_CFG_HOTOPTION1 );
			$hot[] = mosHTML::makeOption( '2', _EAB_CFG_HOTOPTION2 );
			$hot[] = mosHTML::makeOption( '2', _EAB_CFG_HOTOPTION3 );
			$lists['ea_hotfp'] = mosHTML::selectList( $hot, 'ea_hotfp', 'class="inputbox" size="1"', 'value', 'text', $ea_hotfp );						
        	$lists['ea_hotfpa'] = mosHTML::integerSelectList( 1, 15, 1, 'ea_hotfpa', 'class="inputbox"', $ea_hotfpa, $format="" );

			$lists['ea_maxpicsize'] = $ea_maxpicsize;
			$lists['ea_maxpics'] = mosHTML::integerSelectList( 1, 10, 1, 'ea_maxpics', 'class="inputbox"', $ea_maxpics, $format="" ); 
			$glb[] = mosHTML::makeOption( '0', _EAB_CFG_STS01 );
            $glb[] = mosHTML::makeOption( 'gd1', 'GD' );
        	$glb[] = mosHTML::makeOption( 'gd2', 'GD2' );
        	$lists['ea_gplib'] = mosHTML::selectList( $glb, 'ea_gplib', 'class="inputbox" size="1"', 'value', 'text', $ea_gplib );
			$lists['ea_imgwidth'] = $ea_imgwidth;
        	$lists['ea_imgheight'] = $ea_imgheight;
			$lists['ea_imgprtn'] = ($ea_imgprtn == "1")? " checked" : "";
			$lists['ea_imgqulty'] = $ea_imgqulty;			        	
        	$lists['ea_tbwidth'] = $ea_tbwidth;
        	$lists['ea_tbheight'] = $ea_tbheight;
			$lists['ea_tbprtn'] = ($ea_tbprtn == "1")? " checked" : "";
			$lists['ea_tbqulty'] = $ea_tbqulty;
			$lists['ea_watermark'] = mosHTML::selectList( $yesno, 'ea_watermark', 'class="inputbox" size="1"', 'value', 'text', $ea_watermark );
			$lists['ea_gl_pup'] = mosHTML::selectList( $yesno, 'ea_gl_pup', 'class="inputbox" size="1"', 'value', 'text', $ea_gl_pup );						
        	
			$lists['ea_cat_entries'] = mosHTML::selectList( $yesno, 'ea_cat_entries', 'class="inputbox" size="1"', 'value', 'text', $ea_cat_entries );
        	$lists['ea_show_scats'] = mosHTML::selectList( $yesno, 'ea_show_scats', 'class="inputbox" size="1"', 'value', 'text', $ea_show_scats );
			$lists['ea_mcat_fullview'] = mosHTML::selectList( $yesno, 'ea_mcat_fullview', 'class="inputbox" size="1"', 'value', 'text', $ea_mcat_fullview );

			$hp[] = mosHTML::makeOption( '0', _EAB_CFG_STS212 );
            $hp[] = mosHTML::makeOption( '1', _EAB_CFG_STS213 );
        	$lists['ea_hot_pos'] = mosHTML::selectList( $hp, 'ea_hot_pos', 'class="inputbox" size="1"', 'value', 'text', $ea_hot_pos );
			$hotc[] = mosHTML::makeOption( '#FFFFFF', "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" );
			$hotc[] = mosHTML::makeOption( '#000000', "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" );
			$hotc[] = mosHTML::makeOption( '#00CC00', "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" );
			$hotc[] = mosHTML::makeOption( '#99FF00', "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" );
            $hotc[] = mosHTML::makeOption( '#FFFF33', "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" );
        	$hotc[] = mosHTML::makeOption( '#FF9900', "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" );
            $hotc[] = mosHTML::makeOption( '#CC0000', "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" );
            $hotc[] = mosHTML::makeOption( '#0000CC', "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" );
        	$hotc[] = mosHTML::makeOption( '#00CCCC', "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" );
            $lists['ea_hot_color'] = mosEAHTML::radioList( $hotc, 'ea_hot_color', 'class="inputbox"', $ea_hot_color, 'value', 'text', $ea_hot_color);	
			
			$pp[] = mosHTML::makeOption( '5', '5' );
            $pp[] = mosHTML::makeOption( '10', '10' );
    		$pp[] = mosHTML::makeOption( '25', '25' );
            $pp[] = mosHTML::makeOption( '50', '50' );
            $pp[] = mosHTML::makeOption( '80', '80' );
        	$lists['ea_perpage'] = mosHTML::selectList( $pp, 'ea_perpage', 'class="inputbox" size="1"', 'value', 'text', $ea_perpage );
			
			$lists['ea_fulllocation'] = mosHTML::selectList( $yesno, 'ea_fulllocation', 'class="inputbox" size="1"', 'value', 'text', $ea_fulllocation);

			$s[] = array( "key" => '0', "text" => _EAB_CFG_SHORTINFO1 );
			$s[] = array( "key" => '1', "text" => _EAB_CFG_SHORTINFO2);
			$s[] = array( "key" => '2', "text" => _EAB_CFG_SHORTINFO3);
			$s[] = array( "key" => '3', "text" => _EAB_CFG_SHORTINFO4);
			$s[] = array( "key" => '4', "text" => _EAB_CFG_SHORTINFO5);
			$sinfo = explode(",",$ea_shortinfo);
			$lists['ea_shortinfo'] = mosEAHTML::checkbox_list( $s, 'ea_shortinfo[]', 'class="inputbox"', 'value', 'text', $sinfo ); 			
			
        	$lists['ea_mtgcalc'] = mosHTML::selectList( $yesno, 'ea_mtgcalc', 'class="inputbox" size="1"', 'value', 'text', $ea_mtgcalc );
			$lists['ea_mtg_default_interest_percent'] 	= $ea_mtg_default_interest_percent;
			$lists['ea_mtg_default_year_term'] =  $ea_mtg_default_year_term;
			$lists['ea_mtg_default_down_percent'] =  $ea_mtg_default_down_percent;
			$lists['ea_mtg_default_show_progress'] = mosHTML::selectList( $yesno, 'ea_mtg_default_show_progress', 'class="inputbox" size="1"', 'value', 'text', $ea_mtg_default_show_progress );

			$mtf[] = mosHTML::makeOption( '0', _EAB_CFG_STS01 );
			$mtf[] = mosHTML::makeOption( '1', _EAB_CFG_MTF_TYPE1  );
			$mtf[] = mosHTML::makeOption( '2', _EAB_CFG_MTF_TYPE2  );
			$lists['ea_mtf'] = mosHTML::selectList( $mtf, 'ea_mtf', 'class="inputbox"', 'value', 'text', $ea_mtf ); 

			$lists['ea_f_srch'] = mosHTML::selectList( $yesno, 'ea_f_srch', 'class="inputbox"', 'value', 'text', $ea_f_srch ); 			
			$lists['ea_l_srch'] = mosHTML::selectList( $yesno, 'ea_l_srch', 'class="inputbox"', 'value', 'text', $ea_l_srch ); 			
			$lists['ea_d_srch'] = mosHTML::selectList( $yesno, 'ea_d_srch', 'class="inputbox"', 'value', 'text', $ea_d_srch ); 			

			$lt[] = mosHTML::makeOption( '0', _EAB_CFG_LOC_SRCHTYPE1 );
			$lt[] = mosHTML::makeOption( '1', _EAB_CFG_LOC_SRCHTYPE2 );
			$lists['ea_loc_srchtype'] = mosHTML::selectList( $lt, 'ea_loc_srchtype', 'class="inputbox"', 'value', 'text', $ea_loc_srchtype ); 			
									
        	$lists['ea_map24'] = mosHTML::selectList( $yesno, 'ea_map24', 'class="inputbox" size="1"', 'value', 'text', $ea_map24 );
			$mpt[] = mosHTML::makeOption( 'CGI', _EAB_CFG_MAP24_STATIC );
            $mpt[] = mosHTML::makeOption( 'JAVA', _EAB_CFG_MAP24_DYNAMIC );
        	$lists['ea_map24_type'] = mosHTML::selectList( $mpt, 'ea_map24_type', 'class="inputbox" size="1"', 'value', 'text', $ea_map24_type );
			$map = map24_lg_select_list();
			$lists['ea_map24_dlg'] = mosHTML::selectList( $map, 'ea_map24_dlg', 'class="inputbox" size="1"', 'value', 'text', $ea_map24_dlg );			
			$lists['ea_map24_lid'] = $ea_map24_lid;
			$lists['ea_map24_dinfo'] = $ea_map24_dinfo;
			$lists['ea_map24_tlogo'] = $ea_map24_tlogo;
			$lists['ea_map24_dimg'] = $ea_map24_dimg;
						
			$lists['ea_allowsubmission'] = mosHTML::selectList( $yesno, 'ea_allowsubmission', 'class="inputbox" size="1"', 'value', 'text', $ea_allowsubmission );
			$lists['ea_maxobjects'] = $ea_maxobjects;

			$f[] = mosHTML::makeOption( '0', _EAB_CFG_STS01 );
			$f[] = mosHTML::makeOption( '1', _EAB_CFG_FOOTER1 );
			$f[] = mosHTML::makeOption( '2', _EAB_CFG_FOOTER2 );
			$lists['ea_footer'] = mosHTML::selectList( $f, 'ea_footer', 'class="inputbox"', 'value', 'text', $ea_footer );
			
			HTML_estateagent::configEA($lists);
				
		break;
	}
}

?>