<?php
/**
* @version $Id: artmedia.html.php,v 1.3 2005/04/10 09:17:53 balu Exp $
* @package artmedia
* @copyright (C) 2005 Andreas Duswald
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* @author Andreas Duswald www.duswald.de
* Mambo is Free Software
*/

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

class HTML_artmedia {

	/**
	* Shows Art*Media content
	*/
	function displayArtmedia( $currentcat=NULL, &$params, $version ) {
		global $mosConfig_absolute_path, $mediaid, $hide_js;
		?>

		<div class="contentpane<?php echo $params->get( 'pageclass_sfx' ); ?>">

		<?php
		if ( $params->get( 'page_title' ) ) { ?>
			<div class="componentheading<?php echo $params->get( 'pageclass_sfx' ); ?>">
				<?php echo $params->get( 'header' ); ?>
			</div>
			<?php } ?>

			<table width="100%" cellpadding="4" cellspacing="0" border="0" align="center" class="contentpane<?php echo $params->get( 'pageclass_sfx' ); ?>">
				<tr>
					<td width="100%" valign="top" class="contentdescription<?php echo $params->get( 'pageclass_sfx' ); ?>">
						<?php
						if ( $params->get( 'image' ) <> -1 ) {
							?>
							<img src="<?php echo $currentcat->img; ?>" align="<?php echo $currentcat->align; ?>" hspace="6" alt="<?php echo _AM_TITLE; ?>" />
							<?php
						}
						if ( $params->get( 'description' ) ) echo $currentcat->descript;
						?>
					</td>
				</tr>
				<tr>
					<td valign="top">
						<div align="center">
							
							<?php
							if( $mediaid ) {
								HTML_artmedia::showMedia( $params, $rows );
							}
							HTML_artmedia::showTable( $params, $rows );
							?>

						</div>
					</td>
				</tr>
			</table>
			<br />
			<table cellpadding="0" cellspacing="0" border="0" width="99%">
				<tr>
					<td height="1" style="background-color:#eeeeee;"></td>
				</tr>
				<tr>
					<td height="4"></td>
				</tr>
			</table>
		</div>

		<?php
		HTML_artmedia::Footer( $version );
		
		// displays back button
		mosHTML::BackButton ( $params, $hide_js );
	}

	/**
	* Shows media for a given $mediaid
	*/
	function showMedia( &$params, &$rows ) {
		global $database, $mediaid;

		$database->setQuery("SELECT * FROM #__artmedia WHERE id='$mediaid' AND published=1");
		$rows = $database->loadObjectList();
		if ( $rows) {
			foreach($rows as $row) {
				$sndfile = $row->dname;
				?>
				<table class="contentpane" cellpadding="0" cellspacing="0" style="border-collapse:collapse; border-color:#111111;">
					<tr>
						<th class="sectiontableheader" colspan="2"><b><? echo $row->titel; ?></b></th>
					</tr>
					<tr>
						<td height="8" colspan="2"></td>
					</tr>
					<tr>
						<td>
							<div align="center">
								<?php
								// Windows Media Player
								HTML_artmedia::WMP( $sndfile );
								?>
							</div>
						</td>
						<td align="center">
						<?php
						if ( $row->picture ) { ?>
							<img align="absmiddle" hspace="0" border="0" valign="top" id="Bild1" src="./images/stories/<?php echo $row->picture; ?>" alt="" />
						<?php } else { ?>
							<img height="20" width="20" border="0" src="./images/M_images/blank.png" alt="" />
						<?php } ?>
						</td>
					</tr>
					<tr>
						<td colspan="2">
						<div align="center">
							<table cellpadding="0" cellspacing="0" border="0" width="99%" style="margin-top:8px;">
								<tr>
									<td height="1" style="background-color:#eeeeee;"></td>
								</tr>
								<tr>
									<td height="4"></td>
								</tr>
								<tr>
									<td><b><? echo $row->untertitel; ?></b></td>
								</tr>
								<tr>
									<td height="4"></td>
								</tr>
								<tr>
									<td height="1" style="background-color:#eeeeee;"></td>
								</tr>
								<tr>
									<td><p align="justify"><? echo $row->beschreibung; ?></p></td>
								</tr>
							</table>
						</div>
						</td>
					</tr>
				</table>
				<br />
			<?php 
			}
		} else {
			echo "<span class='error'>" . _AM_ERROR_MEDIA . "</span>";
		}
	}

	/**
	* Shows the Art*Media table
	*/
	function showTable( &$params, &$rows ) {
		global $database;

		$database->setQuery("SELECT * FROM #__artmedia WHERE published=1 ORDER BY titel");	// param for ordering (select) -> todo
		$rows = $database->loadObjectList();
		if ( $rows ) { ?>

			<table class="contentpane" cellpadding="0" cellspacing="0">
				<?php
				if ( $params->get( 'downloads' ) ) {
					$widthB = " width='35%'";
					$widthC = " width='35%'";
				} else {
					$widthB = " width='44%'";
					$widthC = "";
				}
				if ( $params->get( 'headings' ) ) {
					?>
					<tr>
						<th class="sectiontableheader" width="6%"><b><?php echo _AM_LABEL_PICTURE; ?></b></th>
						<th class="sectiontableheader"<?php echo $widthB; ?>><b><?php echo _AM_LABEL_TITLE; ?></b></th>
						<th class="sectiontableheader"<?php echo $widthC; ?>><b><?php echo _AM_LABEL_SUBTITLE; ?></b></th>
						<?php
						if ( $params->get( 'downloads' ) ) {
							?>
							<th class="sectiontableheader"><b><?php echo _AM_LABEL_DOWNLOAD; ?></b></th>
						<?php } ?>
						<?php
						if ( $params->get( 'hits' ) ) {
							?>
							<th class="sectiontableheader" width="6%" style="text-align:right;"><b><?php echo _AM_LABEL_HITS; ?></b></th>
						<?php } ?>
					</tr>
				<?php } ?>
				<?php
				$rcount = "1";
				foreach($rows as $row) {
					$mediaid = $row->id;
					if ($rcount=="1") { $rcount="2"; } else { $rcount="1"; }
					?>
					<tr>
						<td class="sectiontableentry<?php echo $rcount;?>" width="6%">&nbsp;
							<?php
							if ( $row->picture ) { ?>
								<img height="20" vspace="2" hspace="0" border="0" valign="top" id="Bild1" src="./images/stories/<?php echo $row->picture; ?>" alt="" />
							<?php } else { ?>
								<img height="20" vspace="2" hspace="0" border="0" valign="top" src="./images/M_images/blank.png" alt="" />
							<?php } ?>
						</td>
						<?php
						// Popup-link
						HTML_artmedia::Popuplink( $row, $mediaid, $rcount, $params );
						?>
					
						<td class="sectiontableentry<?php echo $rcount;?>"<?php echo $widthC; ?>>&nbsp;<? echo $row->untertitel; ?></td>
						<?php
						if ( $params->get( 'downloads' ) ) {
							?>
							<td class="sectiontableentry<?php echo $rcount;?>" nowrap="nowrap">&nbsp;<a href="./images/artmedia/<? echo $row->dname; ?>" target="_blank"><? echo $row->dname; ?></a></td>
						<?php } ?>
						<?php
						if ( $params->get( 'hits' ) ) {
							?>
							<td class="sectiontableentry<?php echo $rcount;?>" width="6%" style="text-align:right;"><?php echo $row->hits; ?>&nbsp;</td>
						<?php } ?>
					</tr>
					<?php
				}
				?>
			</table>
		<?php
		} else {
			echo "<span class='error'>" . _AM_ERROR_DATABASE . "</span>";
		}
	}

	/**
	* Writes Popup link
	*/
	function Popuplink( &$row, $mediaid, $rcount, &$params ) {
		global $mosConfig_live_site;

		$params->get( 'pop_title' ) ? $pt = 1 : $pt = 0;
		$params->get( 'pop_subtitle' ) ? $ps = 1 : $ps = 0;
		$params->get( 'pop_description' ) ? $pd = 1 : $pd = 0;
		$pheight = "500";
		if ( $pt == 0 && $ps == 0 && $pd == 0 ) $pheight = "330";
		$status = 'status=no,toolbar=no,scrollbars=yes,titlebar=no,menubar=no,resizable=yes,width=350,height='.$pheight.',directories=no,location=no,top=200,left=200';
		$link = $mosConfig_live_site .'/index2.php?option=com_artmedia&amp;task=view&amp;id='.$mediaid.'&amp;pt='.$pt.'&amp;ps='.$ps.'&amp;pd='.$pd;
		?>
		<td class="sectiontableentry<?php echo $rcount;?>"<?php echo $widthB; ?>>
			&nbsp;<a href="javascript:;" onclick="javascript:void window.open('<?php echo $link; ?>', 'win2', '<?php echo $status; ?>');" title="<?php echo _AM_POPUP_LINK;?>"><b><?php echo $row->titel; ?></b></a>
		</td>
		<?php
	}

	/**
	* Shows a single media within a popup
	*/
	function showPopup ( $id, $dname, $template='' ) {
		global $mosConfig_live_site, $cur_template, $database;

		$pt = intval( mosGetParam( $_REQUEST, 'pt', 0 ) );
		$ps = intval( mosGetParam( $_REQUEST, 'ps', 0 ) );
		$pd = intval( mosGetParam( $_REQUEST, 'pd', 0 ) );

		$database->setQuery("SELECT * FROM #__artmedia WHERE id='$id'");
		$rows = $database->loadObjectList();
		foreach($rows as $row) {
			?>
			<title>Art*Media | <?php echo $dname; ?></title>
			<link rel="stylesheet" href="<?php echo $mosConfig_live_site; ?>/templates/<?php echo $cur_template; ?>/css/template_css.css" type="text/css" />
			<div align="center">
			<table width="98%" border="0" cellpadding="0" cellspacing="0">
				<?php
				if ( $pt == 1 ) { ?>
					<tr>
						<td height="20">
							<h3><?php echo $row->titel; ?></h3>
						</td>
					</tr>
				<?php } ?>
				<tr>
					<td valign="top">
						<div align="center">
							<?php
							// Windows Media Player
							HTML_artmedia::WMP( $dname );
							?>
						</div>
						<br />
						<?php
						if ( $ps == 1 ) {
							echo "<b>" . $row->untertitel . "</b>";
						}
						if ( $pd == 1 ) { ?>
						<table cellpadding="0" cellspacing="0" border="0" style="margin-top:10px; width:99%;">
							<tr>
								<td height="1" style="background-color:#eeeeee;"></td>
							</tr>
						</table>
						<p align='justify'><?php echo $row->beschreibung; ?></p>
						<?php }	?>
					</td>
				</tr>
			</table>
			</div>
		<?php
		}
		?>
		<br />
		<div align="center">
			<input type="button" name="cancel" value="Close" class="button" onclick="window.close();">
		</div>
	<?php
	}

	function WMP( $soundfile ) { ?>
		<object classid="clsid:6BF52A52-394A-11D3-B153-00C04F79FAA6" id="WindowsMediaPlayer1" align="middle">
			<param name="URL" value="./images/artmedia/<? echo $soundfile; ?>">
			<param name="rate" value="1">
			<param name="balance" value="0">
			<param name="currentPosition" value="0">
			<param name="defaultFrame" value>
			<param name="playCount" value="1">
			<param name="autoStart" value="-1">
			<param name="currentMarker" value="0">
			<param name="invokeURLs" value="-1">
			<param name="baseURL" value>
			<param name="volume" value="50">
			<param name="mute" value="0">
			<param name="uiMode" value="full">
			<param name="stretchToFit" value="1">
			<param name="windowlessVideo" value="0">
			<param name="enabled" value="-1">
			<param name="enableContextMenu" value="-1">
			<param name="fullScreen" value="0">
			<param name="SAMIStyle" value>
			<param name="SAMILang" value>
			<param name="SAMIFilename" value>
			<param name="captioningID" value>
			<param name="enableErrorDialogs" value="0">
			<embed TYPE="video/x-ms-asf-plugin" PLUGINSPAGE="http://www.microsoft.com/Windows/Downloads/Contents/Products/MediaPlayer/" src="./images/artmedia/<? echo $soundfile; ?>" NAME="MediaPlayer" />
		</object>
	<?php }

	/**
	* Copyright
	*/
	function Footer( $version ) { ?>
		<div align="center">
			<font face="Arial" size="1"><b><font color="#0000FF">Art</font><font color="#FF9900">*</font><font color="#FF0000">Media</font></b> <?php echo $version; ?> &copy <a href="http://www.MamboArt.de" target="_blank"><font face="Arial" size="1">MamboArt.de</font></a></font>
		</div>
	<?php
	}
}
?>
