<?php
/**
* Letterman Newsletter Component
* 
* @package Letterman
* @author Soeren
* @copyright Soeren Eberhardt <soeren@mambo-phpshop.net>
    (who just needed an easy and *working* Newsletter component for Mambo 4.5.1 and mixed up Newsletter and YaNC)
* @copyright Mark Lindeman <mark@pictura-dp.nl> 
    (parts of the Newsletter component by Mark Lindeman; Pictura Database Publishing bv, Heiloo the Netherland)
* @copyright Adam van Dongen <adam@tim-online.nl>
    (parts of the YaNC component by Adam van Dongen, www.tim-online.nl)
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*
*/
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

// load the html drawing class, MUST include the option for components
require_once( $mosConfig_absolute_path . '/components/com_letterman/letterman.html.php');
require_once( $mosConfig_absolute_path . '/components/com_letterman/letterman.class.php');

// Load configuration in constructor
$letterman = new mosLetterman($database);

if( !@include( $mosConfig_absolute_path . "/administrator/components/com_letterman/language/$mosConfig_lang.messages.php" ) ) {
	include( $mosConfig_absolute_path . "/administrator/components/com_letterman/language/english.messages.php" );
}

/* END CONFIG */
$pop = mosGetParam( $_REQUEST, 'pop', 0 );
$access = !$mainframe->getCfg( 'shownoauth' );
$task = trim( mosGetParam( $_REQUEST, 'task', "" ) );
$id = intval( mosGetParam( $_REQUEST, 'id', 0 ) );
$subscriber = mosGetParam( $_REQUEST, 'subscriber', '' );
$limit 		= intval( mosGetParam( $_REQUEST, 'limit', $mosConfig_list_limit ) );
$limitstart = intval( mosGetParam( $_REQUEST, 'limitstart', 0 ) );

$letterman_rights = Array();
// Editor usertype check
$letterman_rights['is_editor'] = $is_editor = (strtolower($my->usertype) == 'editor' || strtolower($my->usertype) == 'administrator' || strtolower($my->usertype) == 'super administrator' );
// Sender usertype check
$letterman_rights['is_sender'] = (strtolower($my->usertype) == 'manager' || strtolower($my->usertype) == 'administrator' || strtolower($my->usertype) == 'super administrator' );
// Who can delete?
$letterman_rights['can_delete'] = (strtolower($my->usertype) == 'administrator' || strtolower($my->usertype) == 'super administrator' );

$GLOBALS['Itemid'] = intval( mosGetParam( $_REQUEST, 'Itemid' ) );
if($GLOBALS['Itemid']== "" ) {
    $database->setQuery ( "SELECT id FROM #__menu WHERE link LIKE '%com_letterman%'" );
     $database->loadObject($myid);
    if( !empty($myid->id))
        $GLOBALS['Itemid'] = $myid->id;
    else
        $GLOBALS['Itemid'] = 1;
}

$database->setQuery ( "SELECT name FROM #__menu WHERE id='$Itemid'" );
$menuname = $database->loadResult();

HTML_letterman::header();

switch ($task) {
    case 'view':
		showItem( $id, $gid, $is_editor, $pop, $option );
        // showItem ( $id );
        break;
        
	case "edit":
		if( $letterman_rights['is_editor'] )
            editNewsletter( $id, $option );
		break;

	case "save":
        if( $letterman_rights['is_editor'] )
            saveNewsletter( $option );
		break;
      
	case "cancel":
        if( $letterman_rights['is_editor'] )
            cancelNewsletter( $option );
		break;  
        
	case "sendNow":
		if( $letterman_rights['is_sender'] ) {
            HTML_letterman::send_bar( $id );
            sendNewsletter( $id, $option );
        }
		break;

	case "sendMail":
		if( $letterman_rights['is_sender'] )
            sendMail();
		break;

	case "remove":
		if( $letterman_rights['can_delete'] )
            removeNewsletter( $id, $option );
		break;

    case 'subscribe': 
        HTML_letterman::subscribe( $subscriber); 
        break;
        
    case 'unsubscribe';
        HTML_letterman::unsubscribe( $subscriber);
        break;

    case 'confirm': 
        confirmSubscriber( $subscriber ); 
        break;
        
    default:
        HTML_letterman::subscriber_bar();
        if( $letterman_rights['is_editor'] ) {
            HTML_letterman::new_bar();
        }
        listAll( $letterman_rights );
}

HTML_letterman::footer();

function lm_email_check($email){
	// First, we check that there's one @ symbol, and that the lengths are right
	if (!ereg("[^@]{1,64}@[^@]{1,255}", $email)) {
		// Email invalid because wrong number of characters in one section, or wrong number of @ symbols.
		return false;
	}
	// Split it into sections to make life easier
	$email_array = explode("@", $email);
	$local_array = explode(".", $email_array[0]);
	for ($i = 0; $i < sizeof($local_array); $i++) {
		if (!ereg("^(([A-Za-z0-9!#$%&'*+/=?^_`{|}~-][A-Za-z0-9!#$%&'*+/=?^_`{|}~\.-]{0,63})|(\"[^(\\|\")]{0,62}\"))$", $local_array[$i])) {
			return false;
		}
	}
	if (!ereg("^\[?[0-9\.]+\]?$", $email_array[1])) { // Check if domain is IP. If not, it should be valid domain name
		$domain_array = explode(".", $email_array[1]);
		if (sizeof($domain_array) < 2) {
			return false; // Not enough parts to domain
		}
		for ($i = 0; $i < sizeof($domain_array); $i++) {
			if (!ereg("^(([A-Za-z0-9][A-Za-z0-9-]{0,61}[A-Za-z0-9])|([A-Za-z0-9]+))$", $domain_array[$i])) {
				return false;
			}
		}
	}
	return true;
}
function extended_email_check( $email ) {
	global $mosConfig_absolute_path, $mosConfig_live_site, $mosConfig_mailfrom;
	
   	require_once( $mosConfig_absolute_path.'/administrator/components/com_letterman/includes/email_validation.php');
	$validator =& new email_validation_class();
	$localdata = parse_url( $mosConfig_live_site );
	$tmp = explode( '@', $mosConfig_mailfrom );
	$mailuser = $tmp[0];
	$mailserver = $tmp[1];
	
    /* how many seconds to wait before each attempt to connect to the
	   destination e-mail server */
	$validator->timeout=10;

	/* how many seconds to wait for data exchanged with the server.
	   set to a non zero value if the data timeout will be different
		 than the connection timeout. */
	$validator->data_timeout=0;

	/* user part of the e-mail address of the sending user
	   (info@phpclasses.org in this example) */
	$validator->localuser=$mailuser;

	/* domain part of the e-mail address of the sending user */
	$validator->localhost=$mailserver;

	/* Set to 1 if you want to output of the dialog with the
	   destination mail server */
	$validator->debug=0;

	/* Set to 1 if you want the debug output to be formatted to be
	displayed properly in a HTML page. */
	$validator->html_debug=1;


	/* When it is not possible to resolve the e-mail address of
	   destination server (MX record) eventually because the domain is
	   invalid, this class tries to resolve the domain address (A
	   record). If it fails, usually the resolver library assumes that
	   could be because the specified domain is just the subdomain
	   part. So, it appends the local default domain and tries to
	   resolve the resulting domain. It may happen that the local DNS
	   has an * for the A record, so any sub-domain is resolved to some
	   local IP address. This  prevents the class from figuring if the
	   specified e-mail address domain is valid. To avoid this problem,
	   just specify in this variable the local address that the
	   resolver library would return with gethostbyname() function for
	   invalid global domains that would be confused with valid local
	   domains. Here it can be either the domain name or its IP address. */
	$validator->exclude_address="";
	
	$result = $validator->ValidateEmailBox($email);
	
	return $result;
}

function listAll( $letterman_rights )
{
    global $database, $gid, $mosConfig_offset, $mosConfig_absolute_path,
    		$Itemid, $menuname, $limit, $limitstart;
    $now = date( "Y-m-d H:i:s", time()+$mosConfig_offset*60*60 );

    $sql = "SELECT id, subject, send, hits FROM `#__letterman`"
    ."\nWHERE ";
    if( !$letterman_rights['is_editor'] )
        $sql.="\npublished=1 AND";
    
    $sql .= "\naccess <= $gid ";
    if( !$letterman_rights['is_editor'] ) {
        $sql .= "\nAND (publish_up = '0000-00-00 00:00:00' OR publish_up <= '$now') ";
        $sql .= "\nAND (publish_down = '0000-00-00 00:00:00' OR publish_down >= '$now')";
    }
    
    $database->setQuery( $sql );
	$database->query();
	$num_rows = $database->getNumRows();
	
	require_once( $mosConfig_absolute_path.'/includes/pageNavigation.php');
	$pageNav = new mosPageNav( $num_rows, $limitstart, $limit );
	
	$sql .= "\nORDER BY created DESC";
	$sql .= "\nLIMIT $limitstart, $limit";
	$database->setQuery( $sql );
    
	$newsletters = $database->loadObjectList();
    
    echo $database->getErrorMsg();
    
    HTML_letterman::listAll( $menuname , $newsletters, $letterman_rights, $pageNav );

}

function showItem( $uid, $gid, $is_editor, $pop, $option ) {
	global $database, $mainframe;
	global $mosConfig_offset, $mosConfig_live_site;

	$now = date( "Y-m-d H:i:s", time()+$mosConfig_offset*60*60 );

	if ($is_editor) {
		$xwhere='';
	} 
    else {
		$xwhere = ""
		. "\n	AND published=1 "
		. "\n	AND (publish_up = '0000-00-00 00:00:00' OR publish_up <= '$now')"
		. "\n	AND (publish_down = '0000-00-00 00:00:00' OR publish_down >= '$now')"
		;
	}

    $sql = "SELECT id, subject AS title, send, created, hits, html_message AS text FROM #__letterman"
    ."\nWHERE id=$uid $xwhere"
    ."\nAND access <= $gid "
    ."\nORDER BY created DESC";
    $database->setQuery( $sql );
	$row = null;
	if ($database->loadObject( $row )) {
    
        $item = new mosLetterman($database);
        $item->hit( $row->id );
        
		HTML_letterman::showItem( $row, $gid );
        
	} 
    else {
		echo _NOT_AUTH;
		return;
	}
}
function saveSubscriber($name, $email){
	global $database, $my, $Itemid, $mosConfig_live_site, 
			$mosConfig_absolute_path, $lm_params;
    
    $name = addslashes(strip_tags($name));
    $email = addslashes(strip_tags($email));
    
    $row = new mosLettermanSubscribers( $database );
    
    if( $lm_params->get( 'extended_email_validation', '1') && function_exists('GetMXRR')) {
		if( !extended_email_check( $email ) ) {
			mosRedirect( sefRelToAbs('index.php?option=com_letterman&amp;task=subscribe&amp;Itemid='.$Itemid), LM_VALID_EMAIL_PLEASE);;
		}
    }
    else {
	    if (!lm_email_check($email)) {
			mosRedirect( sefRelToAbs('index.php?option=com_letterman&amp;task=subscribe&amp;Itemid='.$Itemid), LM_VALID_EMAIL_PLEASE);
		}
    }
 	// load the row from the db table
    $row->subscriber_id = "";
 	$row->user_id = $my->id;
 	$row->subscriber_name = $name;
 	$row->subscriber_email = $email;
	$row->subscribe_date = date( "Y-m-d H:i:s" );
	
    if (!$row->store()) {
		echo "<script type=\"text/javascript\"> alert('".LM_SAME_EMAIL_TWICE."'); window.history.go(-1); </script>\n";
	}
	else{
        $subscriberhash = md5($database->insertid());
        $subject = str_replace( "[mosConfig_live_site]", $mosConfig_live_site, LM_SUBSCRIBE_SUBJECT );
        $confirmlink = sefRelToAbs($mosConfig_live_site."/index.php?option=com_letterman&task=confirm&subscriber=$subscriberhash");
        $content = str_replace( "[LINK]", $confirmlink, LM_SUBSCRIBE_MESSAGE );
        if( $my->id ) {
        	$content = str_replace( "[NAME]", $my->name, $content );
        }
        else {
        	$content = str_replace( "[NAME]", $name, $content );
        }
        $content = str_replace( "[mosConfig_live_site]", $mosConfig_live_site, $content );
        
        if( !$send = mosMail("", "", $email, $subject, $content) ) {
          echo '<script type="text/javascript">alert("'.LM_ERROR_SENDING_SUBSCRIBE. $send . '");</script>';
        }
    
        echo LM_SUCCESS_SUBSCRIBE."<br/><br/>";
        echo '<a href="' . sefRelToAbs("index.php?option=com_letterman&amp;Itemid=$Itemid") . '">'.LM_RETURN_TO_NL.'</a><br /><br />';

	}
}

function deleteSubscriber($name, $email ){
	global $database, $Itemid, $my, $mosConfig_live_site;

    if( $name != "" )
        $check = "SELECT user_id FROM #__letterman_subscribers WHERE subscriber_name = '" . $name . "' AND subscriber_email = '" . $email . "'";
    else
        $check = "SELECT user_id FROM #__letterman_subscribers WHERE subscriber_email = '" . $email . "'";
    $database->setQuery( $check );
    $database->loadObject( $result );

    if( !$result ) {
        mosRedirect( sefReltoAbs("index.php?option=com_letterman&Itemid=$Itemid"), _ERROR_PASS );
    }
    else {
        if( $name != "" )
            $query = "DELETE FROM #__letterman_subscribers WHERE subscriber_name = '" . $name . "' AND subscriber_email = '" . $email . "'";
        else
            $query = "DELETE FROM #__letterman_subscribers WHERE subscriber_email = '" . $email . "'";
        $database->setQuery($query);
        $database->query();
        
        $subject = str_replace( "[mosConfig_live_site]", $mosConfig_live_site, LM_UNSUBSCRIBE_SUBJECT );
        $content = str_replace( "[NAME]", $name, LM_UNSUBSCRIBE_MESSAGE );
        $content = str_replace( "[mosConfig_live_site]", $mosConfig_live_site, $content );
        
        if( !$send = mosMail("", "", $email, $subject, $content) ) {
          echo '<script type="text/javaScript">alert("'.LM_ERROR_SENDING_UNSUBSCRIBE . $send . '");</script>';
        }
		 
		echo LM_SUCCESS_UNSUBSCRIBE."<br/><br/>";
		echo '<a href="' . sefRelToAbs("index.php?option=com_letterman&amp;Itemid=$Itemid") . '">'.LM_RETURN_TO_NL.'</a><br /><br />';
    }
}

function confirmSubscriber( $subscriber ){
    global $database, $Itemid;
    $subscriber = addslashes(strip_tags($subscriber));
    
	$database->setQuery( "SELECT confirmed FROM #__letterman_subscribers WHERE md5(subscriber_id) = '" . $subscriber . "'" );
    $database->loadObject( $result );
	
    if( $result ) {
        $query = "UPDATE #__letterman_subscribers SET confirmed = 1 WHERE md5(subscriber_id) = '" . $subscriber . "'";
        $database->setQuery($query);
        $database->query();
        echo "<h3>".LM_SUCCESS_CONFIRMATION."</h3><br/>";
        echo '<a href="' . sefRelToAbs("index.php?option=com_letterman&amp;Itemid=$Itemid") . '">'.LM_RETURN_TO_NL.'</a><br /><br />';
    }
    else {
		echo LM_ERROR_CONFIRM_ACC_NOTFOUND;
	}
}

function editNewsletter( $uid, $option ) {
	global $database, $my;

	$row = new mosLetterman( $database );
	// load the row from the db table
	$row->load( $uid );
    
    if( !empty($row->checked_out)) {
        if( $row->checked_out != $my->id )
            mosRedirect( "index.php?option=$option&Itemid=$Itemid", _NOT_AUTH );
    }
    
	if ($uid) {
		$row->checkout( $my->id );
	} else {
		// initialise new record
		$row->published = 0;
	}

	// make the select list for the image positions
	$yesno[] = mosHTML::makeOption( '0', 'No' );
	$yesno[] = mosHTML::makeOption( '1', 'Yes' );

	// build the html select list
	$publist = mosHTML::selectList( $yesno, 'published', 'class="inputbox" size="2"',
	'value', 'text', $row->published );
	
	// get list of groups
	$database->setQuery( "SELECT id AS value, name AS text FROM #__groups ORDER BY id" );
	$groups = $database->loadObjectList();	if (!($orders = $database->loadObjectList())) {
		echo $database->stderr();
		return false;
	}

	// build the html select list
	$glist = mosHTML::selectList( $groups, 'access', 'class="inputbox" size="1"',
	'value', 'text', intval( $row->access ) );


	HTML_Letterman::editNewsletter( $row, $publist, $option , $glist );
}

function saveNewsletter( $option ) {
	global $database, $my, $Itemid;

	$row = new mosLetterman( $database );
	if (!$row->bind( $_POST )) {
		echo "<script type=\"text/javascript\"> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}

	if (!$row->check()) {
		echo "<script type=\"text/javascript\"> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	if (!$row->store()) {
		echo "<script type=\"text/javascript\"> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	$row->checkin();

	mosRedirect( "index.php?option=$option&Itemid=$Itemid", _E_ITEM_SAVED );
}
/**
* Cancels an edit operation
* @param string The current url option
*/
function cancelNewsletter( $option ) {
	global $database, $Itemid;
	$row = new mosLetterman( $database );
	$row->bind( $_POST );
	$row->checkin();
	mosRedirect( "index.php?option=$option&Itemid=$Itemid" );
}

/**
* Deletes one or more records
* @param array An array of unique category id numbers
* @param string The current url option
*/
function removeNewsletter( $id, $option ) {
	global $database;

	$item = new mosLetterman( $database );
    if (!$item->delete( $id )) {
        echo "<script type=\"text/javascript\"> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
    }
    else {
        mosRedirect( "index.php?option=$option&Itemid=$Itemid" );
    }
}

function sendNewsletter ( $uid, $option )
{
	global $database, $my, $mosConfig_absolute_path, $mosConfig_lang;
	// Get default emailaddress
	$database->setQuery( "SELECT email FROM `#__users` WHERE usertype='superadministrator' OR gid=25 LIMIT 0,1");
	$row = $database->loadObjectList();
	$admin_email = $row[0]->email;

	$row = new mosLetterman( $database );
	// load the row from the db table
	$row->load( $uid );

	// get list of groups
	$groups = array(
						mosHTML::makeOption( "subscribers", '- All Subscribers -' )
					);
	if( file_exists($mosConfig_absolute_path.'/components/com_virtuemart/virtuemart_parser.php')) {
		$shop = "virtuemart";
	}
	elseif( file_exists($mosConfig_absolute_path.'/components/com_phpshop/phpshop_parser.php')) {
		$shop = 'phpshop';
	}
	else {
		$shop = '';
	}
	if( $shop != '') {
		// the configuration file for the Shop
		require_once( $mosConfig_absolute_path. "/administrator/components/com_$shop/$shop.cfg.php" );
	
		if( $shop == 'virtuemart') {
			// The abstract language class
			require_once( CLASSPATH."language.class.php" );
		}
		else {
			// load mosAbstractLanguage
    		require_once($mosConfig_absolute_path. '/administrator/components/com_phpshop/mos_4.6_code.php');
		}
		// load the Language File
		if (file_exists( ADMINPATH. 'languages/'.$mosConfig_lang.'.php' )) {
			require_once( ADMINPATH. 'languages/'.$mosConfig_lang.'.php' );
		}
		else {
			require_once( ADMINPATH. 'languages/english.php' );
		}
		$shop_lang = new phpShopLanguage();
		$groups[] = mosHTML::makeOption( '- - - - - - - -', '- - - - - - - -' );
		$groups[] = mosHTML::makeOption( "customers", '- '.$shop_lang->_PHPSHOP_STATISTIC_CUSTOMERS.' ('.$shop.') -' );
	}
	// CB integration
	if( file_exists($mosConfig_absolute_path.'/components/com_comprofiler/comprofiler.php')) {
	    $database->setQuery("SELECT name FROM `#__comprofiler_fields` where type = 'checkbox' and published=1");
	    $result = $database->loadResultArray();
	    if(is_array($result)) {
	    	$groups[] = mosHTML::makeOption( '- - - - - - - -', '- - - - - - - -' );
		    foreach($result as $r) {
		      	$groups = array_merge($groups, array(mosHTML::makeOption( "cb:$r", "- Community Builder, field $r -" )));
			}
	    }
	}
    
	$groups[] = mosHTML::makeOption( '- - - - - - - -', '- - - - - - - -' );
	$groups[] = mosHTML::makeOption( '0', '- All User Groups -' );
	$groups[] = mosHTML::makeOption( '- - - - - - - -', '- - - - - - - -' );
	$database->setQuery( "SELECT group_id AS value, name AS text FROM #__core_acl_aro_groups WHERE group_id<>17 AND group_id NOT in(28,29,30) ORDER BY group_id" );
	$groups = array_merge( $groups, $database->loadObjectList() );
	
	
	// build the html select list
	$grouplist = mosHTML::selectList( $groups, 'sendto', 'class="inputbox" size="1"',
	'value', 'text', '-1' );

	$grouplist = str_replace( '"- - - - - - - -"', '"- - - - - - - -" disabled="disabled"', $grouplist);
	
	HTML_Letterman::sendNewsletter( $row, $option , $grouplist, $admin_email );
}

function sendMail() {

	global $database, $my, $mosConfig_sitename, $mosConfig_live_site, $mosConfig_lang,
	$mosConfig_absolute_path, $mosConfig_mailfrom, $mosConfig_fromname, $lm_params;
	if( !function_exists( "sefRelToAbs" )) {
		include_once( $mosConfig_absolute_path."/administrator/components/com_letterman/includes/sef.php" );
	}
	/*
	* because sending mail may take a long time, we want to disable timeout
	* unfortunately when you are running php in safe mode you cannot use set_time_limnit(0)
	* therefor I've made the timout optional.
	*/
	
	$mails_per_pageload  = intval( mosGetParam( $_POST, "mails_per_pageload", 100 ));
	$startfrom  = intval( mosGetParam( $_POST, "startfrom", 0 ));
	$option  = mosGetParam( $_POST, "option", 'com_letterman' );
	$disable_timeout  = mosGetParam( $_POST, "disable_timeout", '' );
	$id  = mosGetParam( $_POST, "id", '' );
	$sendto = mosGetParam( $_POST, "sendto", null );
	$mailfrom = mosGetParam( $_POST, "mailfrom", $mosConfig_mailfrom );
	$confirmed_accounts = mosGetParam( $_POST, "confirmed_accounts", "0" );
	$replyto = mosGetParam( $_POST, "replyto" );
	
	if ( $disable_timeout ) {
		@set_time_limit(0);
	}
	// Get default emailaddress
	$database->setQuery( "SELECT email FROM `#__users` WHERE usertype='superadministrator' LIMIT 0,1");
	$admin_email = $database->loadResult();
	echo $database->getErrorMsg();
	
	$mailfrom = $mailfrom ? $mailfrom : $admin_email;
	$replyto = $replyto ? $replyto : $admin_email;

	if ( $sendto===null) {
		mosRedirect( "index.php?option=com_letterman&mosmsg=".LM_ERROR_NEWSLETTER_COULDNTBESENT );
	}
	// Get Itemid for Letterman
	$database->setQuery ( "SELECT id FROM `#__menu` WHERE link LIKE '%com_letterman%'" );
	$database->loadObject($myid);
	if( !empty($myid->id)) {
		$Itemid = $myid->id;
	}
	else {
		$Itemid = 1;
	}

	// Get newsletter
	$database->setQuery( "SELECT subject, message, html_message FROM `#__letterman` WHERE id='$id'");
	$database->loadObject( $newsletter );

	// Build e-mail message format
	$subject = $newsletter->subject;
	$message = $newsletter->message;
	$unsub_link = sefRelToAbs("index.php?option=$option&task=unsubscribe&Itemid=$Itemid");
	if( substr( $unsub_link, 0, 4 ) != "http" ) {
		$unsub_link = $mosConfig_live_site ."/". $unsub_link;
	}
	$unsub_link_html = "<a href=\"$unsub_link\">$unsub_link</a>";

	$footer_html = str_replace( "[UNLINK]", $unsub_link_html, LM_NEWSLETTER_FOOTER );
	$footer_html = str_replace( "[mosConfig_live_site]", "<a href=\"$mosConfig_live_site\">$mosConfig_live_site</a>", $footer_html );

	$footer_text = str_replace( "[UNLINK]", $unsub_link, LM_NEWSLETTER_FOOTER );
	$footer_text = str_replace( "[mosConfig_live_site]", $mosConfig_live_site, $footer_text );
	$footer_text = str_replace( "<br/>", "", $footer_text );
	$footer_text = str_replace( "<br />", "", $footer_text );

	$html_message = "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">
					  <html>
						  <head>
							  <title>$mosConfig_sitename :: $subject</title>
							  <style type=\"text/css\">
							  ".strip_tags( $lm_params->get('newsletter_css'))."
							  </style>
						  </head>
						  <body>"
							. $newsletter->html_message
							. $footer_html .
							"</body>
					  </html>";
	
	$html_message = str_replace( "../../..", $mosConfig_live_site, $html_message );
	
	// Create the PHPMailer Object ( we need that NOW! )
	$mymail = mosCreateMail( $mailfrom, $mosConfig_fromname, $subject, $html_message);
	// Patch to get correct Line Endings
	switch( substr( strtoupper( PHP_OS ), 0, 3 ) ) {
		case "WIN":
		$mail->LE = "\r\n";
		break;
		case "MAC": // fallthrough
		case "DAR": // Does PHP_OS return 'Macintosh' or 'Darwin' ?
		$mail->LE = "\r";
		default: // change nothing
		break;
	}
	$mymail->AddReplyTo( $replyto, $mosConfig_fromname );
	
	$embed_images = $lm_params->get('embed_images', 1);
	
	// Handle <img />Images and embed ALL images
	$images = array();
	if (preg_match_all("/<img[^>]*>/", $html_message, $images) > 0) {
		$i = 0;
		foreach ($images as $image) {
			if ( is_array( $image ) ) {
				foreach( $image as $src) {
					preg_match("'src=\"[^\"]*\"'si", $src, $matches);
					$source = str_replace ("src=\"", "", $matches[0]);

					$source = str_replace ("\"", "", $source);
					
					if( $embed_images ) {
						$filename = basename( $source );
						// must be a remote Image or somethin with ../../../image.gif then
						if (!stristr($source, $mosConfig_live_site)) {
	
							// must be a local image.
							// Attention! Now we guess it's located somewhere in the folder /images/ !!!
							if (!stristr($source, "http")) {
								// convert "media/mypicture.gif" to "/home/user/public_html/media/mypicture.gif"
								$tmp_source = "$mosConfig_absolute_path/$source";
								if( !file_exists($tmp_source)) {
									// IN /ADMINISTRATOR/ then!
									// convert "images/mypicture.gif" to "/home/user/public_html/administrator/images/mypicture.gif"					
									$tmp_source = "$mosConfig_absolute_path/administrator/$source";
									if( !file_exists($tmp_source)) {
										// leave the URL unchanged (we don't know where to find the image here!)
										continue;
									}
								}
								$source = $tmp_source;
							}
							else {
								// remote pictures are left unchanged
								continue;
							}
						}
						else {
							$source = str_replace( $mosConfig_live_site, $mosConfig_absolute_path, $source );
						}
						$pathinfo  = pathinfo( $filename );
						$cid = basename( $filename, ".".$pathinfo['extension'] );
						$size = @getimagesize( $source );
	
						switch($pathinfo['extension']) {
							case "jpg":
							case "jpeg":
							$mimetype = "image/jpeg"; break;
							case "png":
							$mimetype = "image/png"; break;
							case "gif":
							$mimetype = "image/gif"; break;
							case "swf":
							$mimetype = "image/swf"; break;
						}
						$mymail->AddEmbeddedImage( $source, $cid, $filename, "base64", $mimetype );
						$newtag = $size[3] ." src=\"cid:$cid\"";
						$html_message = str_replace( $matches[0], $newtag, $html_message );
					}
					else {
						if (!stristr($source, $mosConfig_live_site)) {
							if( substr($source, 0, 3) == '../') {
								$source = str_replace('../', '', $source);
							}
							// must be a remote Image or somethin with ../images/stories/image.jpg then
							$source = "$mosConfig_live_site/$source";
							$html_message = str_replace( $matches[0], "src=\"$source\"", $html_message );
						}
					}
				}
			}
		}
	}
	
	// Handle Attachments
	$regex = '#\[ATTACHMENT filename="(.*?)"\]#si';
	$attachments = array();
	if (preg_match_all($regex, $message, $attachments) > 0) {
		
		foreach ($attachments[1] as $idx => $attachment ) {
			$mymail->AddAttachment( $mosConfig_absolute_path.$attachment, basename($mosConfig_absolute_path.$attachment));
		}
	}
	$message = preg_replace( $regex, '', $message );
	
	// Get all users email and group
	if( $sendto == "subscribers" ) {
		$q = "SELECT subscriber_name AS name, subscriber_email AS email FROM #__letterman_subscribers";
		if( $confirmed_accounts == "1" )
		$q .= " WHERE confirmed='1'";
	}
	// Currenly supported: VirtueMart and mambo-phpShop customers
	elseif( $sendto == 'customers') {
		if( file_exists($mosConfig_absolute_path.'/components/com_virtuemart/virtuemart_parser.php')) {
			$shop = "virtuemart";
			// the configuration file for the Shop
			require_once( $mosConfig_absolute_path. "/administrator/components/com_$shop/$shop.cfg.php" );
			$q = 'SELECT user_email as email, CONCAT( first_name, \' \', last_name) as name FROM `#__{vm}_user_info` WHERE address_type=\'BT\'';
			
			// This is just needed for VirtueMart's table prefix vm
			require_once( CLASSPATH. 'ps_database.php' );
			$db = new ps_DB();
			$db->setQuery( $q );
			$q = $db->_sql;
		}
		elseif( file_exists($mosConfig_absolute_path.'/components/com_phpshop/phpshop_parser.php')) {
			$shop = 'phpshop';
			// the configuration file for the Shop
			require_once( $mosConfig_absolute_path. "/administrator/components/com_$shop/$shop.cfg.php" );
			$q = 'SELECT email, CONCAT( first_name, \' \',  last_name) as name FROM `#__users` WHERE address_type=\'BT\'';			
		}
	}
	//Marlar's CB integration
    elseif( substr($sendto,0,3) == 'cb:' ) {
        $sendto=substr($sendto, 3);
        $database->setQuery("SHOW COLUMNS FROM `#__comprofiler` LIKE '$sendto'");
        if(is_null($database->loadRow())){
              echo "<div style='font-size:15px; width:700px;border: 2px solid black; padding: 30px 10px; margin: 50px;'>I can't find the specified field '$sendto' in Community Builder to control email sending!<br><br>";
              echo "Please go to Community Builder -&gt; Field Management and create a Check Box (single) named <b>$sendto</b></div>";
              die;
        }
		$q = "SELECT CONCAT_WS(' ', firstname, middlename, lastname) AS name, email FROM `#__comprofiler` t1 INNER JOIN `#__users` t2 ON t1.user_id=t2.id WHERE $sendto=1";
		//Marlar's CB hack end
	}
	else {
		$query_appendix = ", `#__core_acl_aro`, `#__core_acl_groups_aro_map` WHERE #__core_acl_aro.value=#__users.id AND #__core_acl_groups_aro_map.aro_id = #__core_acl_aro.aro_id AND #__core_acl_groups_aro_map.group_id='$sendto'";
		$q = "SELECT #__users.name, email FROM #__users ";
		$q .= ($sendto !== '0') ? $query_appendix : "";
		
	}
	$database->setQuery( $q );
	$database->query();
	$all_rows = $database->getNumRows();
	
	echo $database->getErrorMsg();

	$q .= " LIMIT $startfrom, $mails_per_pageload";
	$database->setQuery( $q );
		
	// Now process all Recipients
	$i = 0;
	$errors = 0;
	
	if( strstr( $html_message, '[NAME]') === false && strstr( $message, '[NAME]') === false) {
		// Send ONE newsletter to $mails_per_pageload recipients at once
		
		// Now we need to extract "www.myhost.de" out of http://www.myhost.de
		$pagedata = parse_url($mosConfig_live_site);
		
		// We need at least ONE "To:" Address, believe me!
		// Otherwise this email will be filtered out as SPAM or rejected
		// All BCC recipients will see this "To:" address, so let's not take
		// a subscriber from the list
		$mymail->AddAddress( $mailfrom, LM_SUBSCRIBER.'@'.$pagedata['host'] );
		
		$mymail->Body = $html_message;
		// Add an alternative body whenever you can. A mail without Altbody
		// and pure HTML can be quickly considered as SPAM (see the 4/4 Mambo Newsletter, pah!)
		$mymail->AltBody = $message;
		
		$rows = $database->loadObjectList();
		foreach( $rows as $row ) {
			// Add all recipients as blind carbon copy recipients
			// These users will see the "To:" field we have added above
			$mymail->AddBCC( $row->email, $row->name );
		}
		//Send email
		if( !$mymail->Send()) {
			$errors = 1;
		}
		
		$i = count( $rows );
		
	}
	else {
	
		// Send individual newsletters for each recipient
		$rows = $database->loadObjectList();
		foreach ($rows as $row) {
			if( empty($row->name) ) {
				$name = LM_SUBSCRIBER;
			}
			else {
				$name = $row->name;
			}
			// Now let's update the HTML Mail Body
			$mymail->Body = str_replace( "[NAME]", $name, $html_message);
			// Set alternative Body with Text Message
			$mymail->AltBody = str_replace( "[NAME]", $name, $message . $footer_text );
	
			$mymail->ClearAddresses();
			$mymail->AddAddress( $row->email, $row->name );
	
			//Send email
			if( $mymail->Send()) {
				$i++;
			}
			else {
				$errors++;
			}
		}
	}
	$msg = '';
	if( $errors > 0) {
		$msg = $mymail->ErrorInfo." =&gt; $errors Errors
";
	}
	$database->setQuery( "UPDATE `#__letterman` SET send=NOW() WHERE id=$id" );
	$database->query();
	$msg .= str_replace( "{X}", $i, LM_NEWSLETTER_SENDTO_X_USERS);
	if( $startfrom+$i >= $all_rows  ) {
		mosRedirect( "index.php?option=$option", $msg );
	}
	else {
		HTML_letterman::sendMailInfo( $all_rows, $startfrom+$mails_per_pageload, $msg );
	}

}


?>
