<?php
/**
* @version $Id: weblinks.php,v 1.33 2004/09/26 09:11:18 stingrey Exp $
* @package Mambo_4.5.1
* @copyright (C) 2000 - 2004 Miro International Pty Ltd
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* Mambo is Free Software
*/

/** ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

// load language
if (file_exists($mosConfig_absolute_path."/components/com_booklibrary/language/{$mosConfig_lang}.php" )) {
	include_once($mosConfig_absolute_path."/components/com_booklibrary/language/{$mosConfig_lang}.php" );
} else {
	include_once($mosConfig_absolute_path."/components/com_booklibrary/language/english.php" );
}


/** load the html drawing class */
require_once( $mainframe->getPath( 'front_html' ) );
require_once( $mainframe->getPath( 'class' ) );
require_once ($mosConfig_absolute_path."/components/com_booklibrary/booklibrary.class.lend_request.php");
require_once ($mosConfig_absolute_path."/components/com_booklibrary/booklibrary.class.lend.php");
require_once ($mosConfig_absolute_path."/components/com_booklibrary/booklibrary.class.review.php");
require_once ($mosConfig_absolute_path."/administrator/components/com_booklibrary/admin.booklibrary.class.others.php");
require_once ($mosConfig_absolute_path."/administrator/components/com_booklibrary/admin.booklibrary.class.conf.php");

$mainframe->setPageTitle( _BOOKLIBRARY_TITLE );

$task = trim( mosGetParam( $_REQUEST, 'task', "" ) );
$id = intval( mosGetParam( $_REQUEST, 'id', 0 ) );
$catid = intval( mosGetParam( $_REQUEST, 'catid', 0 ) );
$bids = mosGetParam($_REQUEST, 'bid', array(0));

if($booklibrary_configuration['debug'] == '1'){
	echo "Task: ".$task . "<br>";
	print_r($_POST);
	echo "<hr><br>";
}


switch ($task) {

	case 'show_search':
	showSearchBooks( $option, $catid, $option );
	break;
	
	case 'search':
	searchBooks( $option, $catid, $option );
	break;

	case 'view':
	showItem( $id, $catid );
	break;

	case 'review':
	reviewBook( $option );
	break;
	
	case 'showCategory':
	//if no category is selected show default action
	if ( $catid ) {
		showCategory( $catid );
	} else{
		$task = "xxx";
	}
	break;

	case 'lend_request':
		showLendRequest( $option, $bids );
	break;
	
	case 'save_lend_request':
		saveLendRequest( $option, $bids );
	break;
	
	
	/*case 'test':
		print_r();
		$my->usertype
	break;*/
	
	default:
	listCategories($catid);
	break;
	

}

function saveLendRequest($option, $bids){
	global $mainframe, $database, $my, $Itemid, $acl;
	global $booklibrary_configuration;
	
	//echo "saveLR:" . userGID($my->id) . "<p>";
	//echo "lendstat-show:" . $booklibrary_configuration['lendstatus']['show'] . "<p>";
	//echo "lendstat-regi:" . $booklibrary_configuration['lendrequest']['registrationlevel'] . "<p>";

	if(!checkAccess( $booklibrary_configuration['lendstatus']['show'],'RECURSE', userGID($my->id), $acl) ||
					!checkAccess( $booklibrary_configuration['lendrequest']['registrationlevel'],'RECURSE', userGID($my->id), $acl)){
		echo _BOOKLIBRARY_NOT_AUTHORIZED;
		return;
	}
	
	$help = array();	
	foreach($bids as $bid){
		$lend_request = new mosBookLibrary_lend_request($database); 
		if (!$lend_request->bind($_POST)) {
			echo "<script> alert('".$lend_request->getError()."'); window.history.go(-1); </script>\n";
			exit ();
		}
		$lend_request->lend_request = date("Y-m-d H:i:s");
		$lend_request->fk_bookid = $bid;
		
		if (!$lend_request->check()) {
			echo "<script> alert('".$lend_request->getError()."'); window.history.go(-1); </script>\n";
			exit ();
		}
		if (!$lend_request->store()) {
			echo "<script> alert('".$lend_request->getError()."'); window.history.go(-1); </script>\n";
			exit ();
		}
		$lend_request->checkin();
		array_push($help, $lend_request);
	}

	
	$currentcat = NULL;
	// Parameters
	$menu =& new mosMenu( $database );
	$menu->load( $Itemid );
	$params =& new mosParameters( $menu->params );
	$params->def( 'header', $menu->name );
	$params->def( 'pageclass_sfx', '' );
	//
	$params->def( 'show_search', '1' );
	$params->def( 'back_button', $mainframe->getCfg( 'back_button' ) );

	$currentcat->descrip = _BOOKLIBRARY_LABEL_LEND_REQUEST_THANKS;
	
	// page image
	$currentcat->img = "./components/com_booklibrary/images/book.gif";


	$currentcat->header = '';
	if ( @$currentcat->name <> '' ) {
		$currentcat->header = $currentcat->name;
	} else {
		$currentcat->header = $params->get( 'header' );
	}
	$currentcat->header = $currentcat->header;
	
	// used to show table rows in alternating colours
	$tabclass = array( 'sectiontableentry1', 'sectiontableentry2' );

	HTML_booklibrary :: showLendRequestThanks($params, $currentcat);;
	
}

function showLendRequest($option, $bid){
	global $mainframe, $database, $my, $Itemid, $acl;
	global $booklibrary_configuration;
	
	if(!checkAccess( $booklibrary_configuration['lendstatus']['show'],'RECURSE', userGID($my->id), $acl) ||
					!checkAccess( $booklibrary_configuration['lendrequest']['registrationlevel'],'RECURSE', userGID($my->id), $acl)){
		echo _BOOKLIBRARY_NOT_AUTHORIZED;
		return;
	}
	
		
	$bids = implode(',', $bid);
	
	// getting all books for this category
	$query = "SELECT * FROM #__booklibrary"
		. "\nWHERE id IN (" .  $bids . ") AND fk_lendid = 0"
		. "\nORDER BY catid, ordering";
	$database->setQuery( $query );
	$books = $database->loadObjectList();
	
	
	$currentcat = NULL;
	// Parameters
	$menu =& new mosMenu( $database );
	$menu->load( $Itemid );
	$params =& new mosParameters( $menu->params );
	$params->def( 'header', _BOOKLIBRARY_DESC_TITLE );
	//$params->def( 'header', $menu->name );
	$params->def( 'pageclass_sfx', '' );
	$params->def( 'show_lendstatus', 1 );
	$params->def( 'show_lendrequest', 1 );
	$params->def( 'lend_save', 1); 
	$params->def( 'back_button', $mainframe->getCfg( 'back_button' ) );


	// page description
	$currentcat->descrip = _BOOKLIBRARY_DESC_LEND;
	
	// page image
	$currentcat->img = './components/com_booklibrary/images/book.gif';
	$currentcat->align = 'right';

	$currentcat->header = '';
	if ( @$currentcat->name <> '' ) {
		$currentcat->header = $currentcat->name;
	} else {
		$currentcat->header = $params->get( 'header' );
	}
	//$currentcat->header = $currentcat->header . ": " . $category->title;
	
	// used to show table rows in alternating colours
	$tabclass = array( 'sectiontableentry1', 'sectiontableentry2' );

	HTML_booklibrary :: showLendRequest($books, $currentcat, $params, $tabclass, $catid, $sub_categories);;
}


/**
 * @todo implement add comments for registered users
 */
function reviewBook(){
	global $mainframe, $database, $my, $Itemid, $acl, $booklibrary_configuration;
	
	if(!checkAccess( $booklibrary_configuration['reviews']['show'],'RECURSE', userGID($my->id), $acl) || 
			!checkAccess( $booklibrary_configuration['reviews']['registrationlevel'],'RECURSE', userGID($my->id), $acl)) {
		echo _BOOKLIBRARY_NOT_AUTHORIZED;
	 	return;
	}	
	
	//check if user is allowed to add reviews	
	$review = new mosBookLibrary_review($database);
	$review->date = date("Y-m-d H:i:s");
	$review->fk_userid = $my->id; 
	
	if (!$review->bind($_POST)) {
		echo "<script> alert('".$book->getError()."'); window.history.go(-1); </script>\n";
		exit ();
	}
	
	if (!$review->check()) {
		echo "<script> alert('".$book->getError()."'); window.history.go(-1); </script>\n";
		exit ();
	}
	if (!$review->store()) {
		echo "<script> alert('".$book->getError()."'); window.history.go(-1); </script>\n";
		exit ();
	}
	
	
	//showing the original entries
	mosRedirect("?option=com_booklibrary&task=view&catid=$catid&id=$review->fk_bookid&Itemid=$Itemid");

}


/**
 * This function is used to show a list of all books
 */
function listCategories( $catid ) {
	global $mainframe, $database, $my;
	global $mosConfig_shownoauth, $mosConfig_live_site, $mosConfig_absolute_path;
	global $cur_template, $Itemid;

	/* Query to retrieve all categories that belong under the web links section and that are published. */
	$query = "SELECT *, COUNT(a.id) AS numlinks FROM #__categories AS cc"
		. "\n LEFT JOIN #__booklibrary AS a ON a.catid = cc.id"
		. "\n WHERE a.published='1' AND a.approved='1' AND section='com_booklibrary' AND parent_id='$catid' AND cc.published='1' AND cc.access <= '$my->gid'"
		. "\n GROUP BY cc.id"
		. "\n ORDER BY cc.ordering";
	$database->setQuery( $query );
	$categories = $database->loadObjectList();

	$currentcat = NULL;
	// Parameters
	$menu =& new mosMenu( $database );
	$menu->load( $Itemid );
	$params =& new mosParameters( $menu->params );
	$params->def( 'header', $menu->name );
	$params->def( 'pageclass_sfx', '' );
	$params->def( 'show_search', '1' );
	$params->def( 'back_button', $mainframe->getCfg( 'back_button' ) );

	// page header
	$currentcat->header = '';
	if ( @$currentcat->name <> '' ) {
		$currentcat->header = $currentcat->name;
	} else {
		$currentcat->header = $params->get( 'header' );
	}
	
	// page description
	$currentcat->descrip = _BOOKLIBRARY_DESC;

	// used to show table rows in alternating colours
	$tabclass = array( 'sectiontableentry1', 'sectiontableentry2' );

	HTML_booklibrary::showCategories( $params, $categories, $catid, $tabclass, $currentcat);
}




/**
 * This function is used to show a list of all books
 */
function showCategory( $catid ) {
	global $mainframe, $database, $acl, $my;
	global $mosConfig_shownoauth, $mosConfig_live_site, $mosConfig_absolute_path;
	global $cur_template, $Itemid, $booklibrary_configuration;


	// getting all books for this category
	$query = "SELECT id, isbn, authors, rating, title, catid, fk_lendid, date, hits, URL,imageURL FROM #__booklibrary"
		. "\nWHERE catid = '$catid' AND published='1' AND approved='1' AND archived=0"
		. "\nORDER BY ordering";
	$database->setQuery( $query );
	$books = $database->loadObjectList();
	
	
	//getting the current category informations
	$query = "SELECT * FROM #__categories WHERE id='$catid'";
	$database->setQuery( $query );	
	$category = $database->loadObjectList();
	$category = $category[0];
	
	// get all subcategories
	$query = "SELECT *, COUNT(a.id) AS numlinks FROM #__categories AS cc"
	. "\n LEFT JOIN #__booklibrary AS a ON a.catid = cc.id"
	. "\n WHERE a.published='1' AND a.approved='1' AND section='com_booklibrary' AND cc.published='1' AND cc.parent_id='$catid' AND cc.access <= '$my->gid'"
	. "\n GROUP BY cc.id"
	. "\n ORDER BY cc.ordering"
	;
	$database->setQuery( $query );
	$sub_categories = $database->loadObjectList();
	
	$currentcat = NULL;
	// Parameters
	$menu =& new mosMenu( $database );
	$menu->load( $Itemid );
	$params =& new mosParameters( $menu->params );
	$params->def( 'header', $menu->name );
	$params->def( 'pageclass_sfx', '' );
	$params->def( 'category_name', $category->title );
	$params->def( 'show_search', '1' );
	
	
	if(checkAccess( $booklibrary_configuration['lendstatus']['show'],'RECURSE', userGID($my->id), $acl)){
		$params->def( 'show_lendstatus', 1 );
		if (checkAccess( $booklibrary_configuration['lendrequest']['registrationlevel'],'RECURSE', userGID($my->id), $acl)) {
			$params->def( 'show_lendrequest', 1);
		}
	}
	
	
	$params->def( 'show_rating', 1 );
	//todo check if the registration level is correct
	//$booklibrary_configuration['lendrequest']['registrationlevel']
	
	$params->def( 'hits', 1 );
	$params->def( 'back_button', $mainframe->getCfg( 'back_button' ) );


	$currentcat->descrip = $category->description;
	
	// page image
	$currentcat->img = null;
	$path = $mosConfig_live_site .'/images/stories/';
	if ( $category->image != null && count($category->image) > 0) {
		$currentcat->img = $path . $category->image;
		$currentcat->align = $category->image_position;
	}

	$currentcat->header = '';
	if ( @$currentcat->name <> '' ) {
		$currentcat->header = $currentcat->name;
	} else {
		$currentcat->header = $params->get( 'header' );
	}
	$currentcat->header = $currentcat->header . ": " . $category->title;
	
	// used to show table rows in alternating colours
	$tabclass = array( 'sectiontableentry1', 'sectiontableentry2' );

	HTML_booklibrary::displayBooks($books, $currentcat, $params, $tabclass, $catid, $sub_categories);
}

/**
 * @todo add global configurable parameters show_review and show_lendstatus
 */
function showItem ( $id, $catid ) {
	global $mainframe, $database, $my, $acl;
	global $mosConfig_shownoauth, $mosConfig_live_site, $mosConfig_absolute_path;
	global $cur_template, $Itemid, $booklibrary_configuration;

	//Record the hit
	$sql="UPDATE #__booklibrary SET hits = hits + 1 WHERE id = ". $id ."";
	$database->setQuery( $sql );
	$database->query();

	//load the book
	$book = new mosBookLibrary( $database );
	$book->load($id);
	
	// Parameters
	$menu =& new mosMenu( $database );
	$menu->load( $Itemid );
	$params =& new mosParameters( $menu->params );
	$params->def( 'header', $menu->name );
	$params->def( 'pageclass_sfx', '' );

	if(checkAccess( $booklibrary_configuration['lendstatus']['show'],'RECURSE', userGID($my->id), $acl)){
		$params->def( 'show_lendstatus', 1 );
		if (checkAccess( $booklibrary_configuration['lendrequest']['registrationlevel'],'RECURSE', userGID($my->id), $acl)) {
			$params->def( 'show_lendrequest', 1);
		}
	}
	
	if(checkAccess( $booklibrary_configuration['reviews']['show'],'RECURSE', userGID($my->id), $acl)){
		$params->def( 'show_reviews', 1 );
		if (checkAccess( $booklibrary_configuration['reviews']['registrationlevel'],'RECURSE', userGID($my->id), $acl)) {
			$params->def( 'show_inputreviews', 1);
		}
	}	
		
	$params->def( 'pageclass_sfx', '' );
	$params->def( 'item_description', 1 );
	$params->def( 'lend_request', $booklibrary_configuration['lendrequest']['registrationlevel'] );
	$params->def( 'show_ebook', $booklibrary_configuration['ebooks']['show'] );
	$params->def( 'show_price', $booklibrary_configuration['price']['show']);
	$params->def( 'back_button', $mainframe->getCfg( 'back_button' ) );
	
	
	// page header
	$currentcat->header = '';
	if ( @$currentcat->name <> '' ) {
		$currentcat->header = $currentcat->name;
	} else {
		$currentcat->header = $params->get( 'header' );
	}
	$currentcat->header = $currentcat->header . ": " . $book->title;	
	
	// show thte book 
	HTML_booklibrary::displayBook( $book, $tabclass, $params, $currentcat, $ratinglist );

}


function showSearchBooks($options, $catid, $option){
	global $mainframe, $database, $my;
	global $mosConfig_shownoauth, $mosConfig_live_site, $mosConfig_absolute_path;
	global $cur_template, $Itemid;
	
	$currentcat = NULL;
	// Parameters
	$menu =& new mosMenu( $database );
	$menu->load( $Itemid );
	$params =& new mosParameters( $menu->params );
	$params->def( 'header', $menu->name );
	$params->def( 'pageclass_sfx', '' );
	//
	$params->def( 'show_search', '1' );
	$params->def( 'back_button', $mainframe->getCfg( 'back_button' ) );

	$currentcat->descrip = _BOOKLIBRARY_SEARCH_DESC1;
      $currentcat->align = 'right';
	
	// page image
	$currentcat->img = "./components/com_booklibrary/images/book.gif";


	$currentcat->header = '';
	if ( @$currentcat->name <> '' ) {
		$currentcat->header = $currentcat->name;
	} else {
		$currentcat->header = $params->get( 'header' );
	}
	$currentcat->header = $currentcat->header . ": " . _BOOKLIBRARY_LABEL_SEARCH;
	
	// used to show table rows in alternating colours
	$tabclass = array( 'sectiontableentry1', 'sectiontableentry2' );

	$categories[] = mosHTML :: makeOption('0', 'Wszystkie kategrie');
	$database->setQuery("SELECT id AS value, name AS text FROM #__categories"."\nWHERE section='$option' ORDER BY ordering");
	$categories = array_merge($categories, $database->loadObjectList());

	if (count($categories) < 1) {
		mosRedirect("index2.php?option=categories&section=$option", 'Musisz najpierw stworzy Kategorie dla tej Sekcji.');
	}

	$clist = mosHTML :: selectList($categories, 'catid', 'class="inputbox" size="1"', 'value', 'text', 0);


	// show thte book 
	HTML_booklibrary::showSearchBooks( $params, $currentcat, $clist , $option);

}

function searchBooks($options, $catid, $option){
	global $mainframe, $database, $my, $acl;
	global $mosConfig_shownoauth, $mosConfig_live_site, $mosConfig_absolute_path;
	global $cur_template, $Itemid, $booklibrary_configuration;
		
	
	$search = mosGetParam( $_REQUEST, 'searchtext', '' );	
	
	$where = array();
	
	array_push($where, "(LOWER(b.title) LIKE '%$search%' OR LOWER(b.authors) LIKE '%$search%' OR LOWER(b.isbn) LIKE '%$search%' OR LOWER(b.comment) LIKE '%$search%')");
	array_push($where, "b.published='1'");
	array_push($where, "b.approved='1'");
	array_push($where, "b.archived=0");
	if($catid){
		array_push($where, "c.id=$catid");
	}
	
	// getting all books for this category
	$query = "SELECT b.*, c.title as category_titel, c.ordering as category_ordering FROM #__booklibrary AS b ".
		"\nLEFT JOIN #__categories AS c".
		"\nON b.catid = c.id". 
		((count($where) ? "\nWHERE ".implode(' AND ', $where) : "")).
		"\nORDER BY category_ordering, ordering";
	$database->setQuery( $query );
	$books = $database->loadObjectList();
	

	$currentcat = NULL;
	// Parameters
	$menu =& new mosMenu( $database );
	$menu->load( $Itemid );
	$params =& new mosParameters( $menu->params );
	$params->def( 'header', $menu->name );
	$params->def( 'pageclass_sfx', '' );
	$params->def( 'category_name', _BOOKLIBRARY_LABEL_SEARCH );
	$params->def( 'search_request', '1' );	
	$params->def( 'hits', 1 );
	$params->def( 'show_rating', 1 );
	
	
	if(checkAccess( $booklibrary_configuration['lendstatus']['show'],'RECURSE', userGID($my->id), $acl)){
		$params->def( 'show_lendstatus', 1 );
		if (checkAccess( $booklibrary_configuration['lendrequest']['registrationlevel'],'RECURSE', userGID($my->id), $acl)) {
			$params->def( 'show_lendrequest', 1);
		}
	}

	$params->def( 'back_button', $mainframe->getCfg( 'back_button' ) );



	$currentcat->descrip = _BOOKLIBRARY_SEARCH_DESC2;
	$currentcat->align = 'right';
	// page image
	$currentcat->img = "./components/com_booklibrary/images/book.gif";

	$currentcat->header = '';
	if ( @$currentcat->name <> '' ) {
		$currentcat->header = $currentcat->name;
	} else {
		$currentcat->header = $params->get( 'header' );
	}
	$currentcat->header = $currentcat->header . ": " . _BOOKLIBRARY_LABEL_SEARCH;
	
	// used to show table rows in alternating colours
	$tabclass = array( 'sectiontableentry1', 'sectiontableentry2' );

	HTML_booklibrary::displayBooks($books, $currentcat, $params, $tabclass, $catid, null);

}


function checkAccess( $accessgroupid, $recurse, $usersgroupid, &$acl){
		//echo "agroup: ".$accessgroupid." ugroupid: ".$usersgroupid." recurse ".$recurse;
		//echo "<br>";
	  if ($accessgroupid == 0 ) {
		//wyczone pokazywanie
            return 0;
        } else {
		//wczone pokazywanie
		return 1;
	  }
      if ($accessgroupid == -2 || ($accessgroupid == -1 && $usersgroupid > 0)) {
		//grant public access or access to all registered users
         return 1;
      }
      else {
		//need to do more checking based on more restrictions
         if( $usersgroupid == $accessgroupid ) {
         //direct match
         return 1;
         }
         else {
            if ($recurse=='RECURSE') {
               //check if there are children groups
               $groupchildern=array();
               $groupchildren=$acl->get_group_children( $accessgroupid, 'ARO', $recurse );

               if ( is_array( $groupchildren ) && count( $groupchildren ) > 0) {
                  if ( in_array($usersgroupid, $groupchildren) ) {
                     //match
                     return 1;
                  }
               }
            }
         }
     //deny access
     return 0;
   }
}

function userGID($oID){
  	global $database,$ueConfig;
	if($oID > 0) {
		$query = "SELECT gid FROM #__users WHERE id = '".$oID."'";
		$database->setQuery($query);
		$gid = $database->loadResult();
		return $gid;
	}
	else return 0;
}

?>
