<?php
// $Id: admin.books.php,v 1.16 2003/12/15 23:51:10 eddieajau Exp $
/**
* Book admin component code
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License: http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.16 $
**/


defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

/**
* Booklibrary
* @package Books
* @copyright 2000-2003 Miro International Pty Ltd
* @license http://www.gnu.org/copyleft/gpl.html GNU Public License
* @version $Revision: 1.5 $
*/

require_once ($mosConfig_absolute_path."/components/com_booklibrary/booklibrary.class.lend.php");
require_once ($mosConfig_absolute_path."/components/com_booklibrary/booklibrary.class.review.php");


/**
* Book database table class
*/
class mosBooklibrary extends mosDBTable {
	/** @var int Primary key */
	var $id=null;
	/** @var int */
	var $bookid=null;	
	/** @var int */
	var $catid=null;
	/** @var int */
	var $sid=null;
	/** @var string */
	var $isbn=null;
	/** @var datetime */
	var $date=null;
	/** @var int */
	var $hits=null;
	/** @var int */
	var $ordering=null;
	/** @var int */
	var $published=null;
	/** @var boolean */
	var $checked_out=null;
	/** @var time */
	var $checked_out_time=null;
	/** @var int */
	var $archived=null;
	/** @var varchar(200) */
	var $title=null;
	/** @var varchar(200) */
	var $imageURL=null;
	/** @var varchar(250) */
	var $URL=null;
	/** @var int */
	var $rating=null;
	/** @var varchar(200) */
	var $authors=null;
	/** @var varchar(200) */
	var $manufacturer=null;
	/** @var varchar(300) */
	var $comment=null;
	/** @var int */
	var $informationFrom=null;
	/** @var varchar(3) */
	var $language=null;
	/** @var int */
	var $fk_lendid=null;
	/** @var publication year */
	var $release_Date = null;
	/** @var edition */
	var $edition = null;
	/** @var ebookURL */
	var $ebookURL = null;
	/** @var price */
	var $price = null;

	/**
	* @param database A database connector object
	*/
	function mosBookLibrary( &$db ) {
		$this->mosDBTable( '#__booklibrary', 'id', $db );
	}
	
	// overloaded check function
	function check() {
		global $booklibrary_configuration;
		
		// check for valid name
		if (trim( $this->isbn ) == '') {
			$this->_error = _BOOK_ISBN;
			return false;
		}
		
		// check for existing isbn
		
		$this->_db->setQuery( "SELECT id FROM #__booklibrary "
			. "\nWHERE bookid='$this->bookid'");						
		$xid = intval( $this->_db->loadResult() );
		if ($xid && $xid != intval( $this->id )) {
			$this->_error = _BOOKLIBRARY_ADMIN_INFOTEXT_JS_EDIT_BOOKID;
			return false;
		}
		if($booklibrary_configuration['editbook']['check']['isbn'] == '1'){
			$this->_db->setQuery( "SELECT id FROM #__booklibrary "
				. "\nWHERE isbn='$this->isbn'");						
			$xid = intval( $this->_db->loadResult() );
			if ($xid && $xid != intval( $this->id )) {
				$this->_error = _BOOKLIBRARY_ADMIN_INFOTEXT_JS_EDIT_ISBN;
				return false;
			}
		
		}
		return true;
	}
	
	/**
	 * Is used to load a book by the isbn number
	 * @param string the isbn number
	 */
	function loadISBN($isbn){		
		$this->_db->setQuery( "SELECT * FROM $this->_tbl WHERE isbn='$isbn'" );
		return $this->_db->loadObject( $this );
	}
	
		
	/**
	* @param string Target search string
	* not used at the moment
	*/
	function search( $text, $state='', $sectionPrefix='' ) {
		$text = trim( $text );
		/** if ($text == '') { **/
			return array();
		/**}
		
		$this->_db->setQuery( "SELECT date AS created, title,"
		. "\n	author,  '1' AS browsernav, '{$sectionPrefix}Books' AS section"
		. "\nFROM #__booklibrary WHERE (title LIKE '%$text%' OR author LIKE '%$text%'"
		. "\n)"
		. "\n ORDER BY created DESC"
		);
		
		return $this->_db->loadObjectList(); **/
	}
	
	function getReviews(){
		$this->_db->setQuery("SELECT id FROM #__booklibrary_review \n".
							"WHERE fk_bookid='$this->id' ORDER BY id");
		$tmp = $this->_db->loadResultArray();		
		$retVal = array();		
		for($i = 0, $j = count($tmp); $i < $j; $i++ ){
			$help = new mosBooklibrary_review($this->_db);
			$help->load(intval($tmp[$i]));
			$retVal[$i] = $help;
		}		
		return $retVal;	
	}
	
	function getLend(){
		$lend = null;
		if($this->fk_lendid != null && $this->fk_lendid != 0){
			$lend = & new mosBookLibrary_lend($this->_db);
			// load the row from the db table
			$lend->load(intval($this->fk_lendid));
		}
		return $lend;
	}
	
	function getAllLends($exclusion=""){
		$this->_db->setQuery("SELECT id FROM #__booklibrary_lend \n".
							"WHERE fk_bookid='$this->id' " . $exclusion . " ORDER BY id");
		$tmp = $this->_db->loadResultArray();		
		$retVal = array();		
		for($i = 0, $j = count($tmp); $i < $j; $i++ ){
			$help = new mosBooklibrary_lend($this->_db);
			$help->load(intval($tmp[$i]));
			$retVal[$i] = $help;
		}		
		return $retVal;	
	}

	function getAllLendRequests($exclusion=""){
		$this->_db->setQuery("SELECT id FROM #__booklibrary_lend_request \n".
							"WHERE fk_bookid='$this->id'" . $exclusion . " ORDER BY id");
		$tmp = $this->_db->loadResultArray();		
		$retVal = array();		
		for($i = 0, $j = count($tmp); $i < $j; $i++ ){
			$help = new mosBooklibrary_lend_request($this->_db);
			$help->load(intval($tmp[$i]));
			$retVal[$i] = $help;
		}		
		return $retVal;	
	}


	function toXML(& $xmlDoc, $all){
		
		//create and append name element 
		$retVal = & $xmlDoc->createElement("book"); 
		
		$bookid = & $xmlDoc->createElement("bookid");
		$bookid->appendChild($xmlDoc->createTextNode($this->bookid));
		$retVal->appendChild(& $bookid);
		
		$catid = & $xmlDoc->createElement("catid");
		$catid->appendChild($xmlDoc->createTextNode($this->catid));
		$retVal->appendChild(& $catid);
		
		$title = & $xmlDoc->createElement("title");
		$title->appendChild($xmlDoc->createCDATASection($this->title));
		$retVal->appendChild(& $title);
		
		$authors = & $xmlDoc->createElement("authors");
		$authors->appendChild($xmlDoc->createCDATASection($this->authors));
		$retVal->appendChild(& $authors);
		
		$manufacturer = & $xmlDoc->createElement("manufacturer");
		$manufacturer->appendChild($xmlDoc->createCDATASection($this->manufacturer));
		$retVal->appendChild(& $manufacturer);
				
		$releasedate = & $xmlDoc->createElement("releasedate");
		$releasedate->appendChild($xmlDoc->createTextNode($this->release_Date));
		$retVal->appendChild(& $releasedate);

		$language = & $xmlDoc->createElement("language");
		$language->appendChild($xmlDoc->createTextNode($this->language));
		$retVal->appendChild(& $language);

		$hits = & $xmlDoc->createElement("hits");
		$hits->appendChild($xmlDoc->createTextNode($this->hits));
		$retVal->appendChild(& $hits);

		$rating = & $xmlDoc->createElement("rating");
		$rating->appendChild($xmlDoc->createTextNode($this->rating));
		$retVal->appendChild(& $rating);

		$price = & $xmlDoc->createElement("price");
		$price->appendChild($xmlDoc->createTextNode($this->price));
		$retVal->appendChild(& $price);

		$url = & $xmlDoc->createElement("url");
		$url->appendChild($xmlDoc->createTextNode($this->URL));
		$retVal->appendChild(& $url);

		$imageURL = & $xmlDoc->createElement("imageURL");
		$imageURL->appendChild($xmlDoc->createTextNode($this->imageURL));
		$retVal->appendChild(& $imageURL);

		$edition = & $xmlDoc->createElement("edition");
		$edition->appendChild($xmlDoc->createTextNode($this->edition));
		$retVal->appendChild(& $edition);

		$ebookURL = & $xmlDoc->createElement("ebookURL");
		$ebookURL->appendChild($xmlDoc->createTextNode($this->ebookURL));
		$retVal->appendChild(& $ebookURL);

		$informationFrom = & $xmlDoc->createElement("informationFrom");
		$informationFrom->appendChild($xmlDoc->createTextNode($this->informationFrom));
		$retVal->appendChild(& $informationFrom);

		$date = & $xmlDoc->createElement("date");
		$date->appendChild($xmlDoc->createTextNode($this->date));
		$retVal->appendChild(& $date);

		$comment = & $xmlDoc->createElement("comment");
		$comment->appendChild($xmlDoc->createCDATASection($this->comment));
		$retVal->appendChild(& $comment);

		
		if($all){
			$lends_data = $this->getLend();
			$exclusion = "";
			
			$lends = & $xmlDoc->createElement("lends");
			$lends_data = $this->getAllLends($exclusion);;
			
			foreach($lends_data as $lend_data){
				$lends->appendChild($lend_data->toXML(& $xmlDoc));
			}
			$retVal->appendChild(& $lends);
		
			$lendrequests = & $xmlDoc->createElement("lendrequests");
			$lendrequests_data = $this->getAllLendRequests($exclusion);
			foreach($lendrequests_data as $lendrequest_data){
				$lendrequests->appendChild($lendrequest_data->toXML(& $xmlDoc));
			}
			$retVal->appendChild(& $lendrequests);
			

			$reviews = & $xmlDoc->createElement("reviews");
			$reviews_data = $this->getReviews();
			foreach($reviews_data as $review_data){
				$reviews->appendChild($review_data->toXML(& $xmlDoc));
			}
			$retVal->appendChild(& $reviews);	
			
		}
		
		return $retVal;
	}

	function toXML2($all){
	
		$retVal = "<book>\n";
		$retVal .= "<bookid>" . $this->bookid . "</bookid>\n";
		$retVal .= "<sid>" . $this->sid . "</sid>\n";
		$retVal .= "<isbn>" . $this->isbn . "</isbn>\n";
		$retVal .= "<date>" . $this->date . "</date>\n";
		$retVal .= "<hits>" . $this->hits . "</hits>\n";
		$retVal .= "<ordering>" . $this->ordering . "</ordering>\n";
		$retVal .= "<published>" . $this->published . "</published>\n";	
		$retVal .= "<archived>" . $this->archived . "</archived>\n";
		$retVal .= "<title>" . htmlspecialchars( $this->title) . "</title>\n";
		$retVal .= "<imageURL>" . $this->imageURL . "</imageURL>\n";
		$retVal .= "<URL>" . $this->URL . "</URL>\n";
		$retVal .= "<rating>" . $this->rating . "</rating>\n";
		$retVal .= "<authors>" . htmlspecialchars($this->authors) . "</authors>\n";
		$retVal .= "<manufacturer>" . htmlspecialchars($this->manufacturer) . "</manufacturer>\n";
		$retVal .= "<comment>" . $this->comment . "</comment>\n";
		$retVal .= "<informationFrom>" . $this->informationFrom . "</informationFrom>\n";	
		$retVal .= "<language>" . $this->language . "</language>\n";
		$retVal .= "<releaseDate>" . $this->release_Date . "</releaseDate>\n";
		$retVal .= "<edition>" . $this->edition . "</edition>\n";
		$retVal .= "<ebookURL>" . $this->ebookURL . "</ebookURL>\n";
		$retVal .= "<price>" . $this->price . "</price>\n";
		
		if($all){
			$actualLend = $this->getLend();
			$exclusion = "";
			if($actualLend != null){
				$exclusion = "AND id <> " . $actualLend->id;
				$retVal .= $actualLend->toXML("actualLend");
			}
			
			$retVal .= "<lends>";
				$lends = $this->getAllLends($exclusion);
				foreach($lends as $lend){
					$retVal .= $lend->toXML();
				}
			$retVal .= "</lends>";
			
			
			$retVal .= "<lendrequests>";
				$lendrequests = $this->getAllLendRequests($exclusion);
				foreach($lendrequests as $lendrequest){
					$retVal .= $lendrequest->toXML();
				}
			$retVal .= "</lendrequests>";
	
			
			$retVal .= "<reviews>";
				$reviews = $this->getReviews();
				foreach ($reviews as $review){
					$retVal .= $review->toXML();	
				}
			$retVal .= "</reviews>\n";
		}
		$retVal .= "</book>\n";
	
		
		return $retVal;
	}

}
?>
