<?php

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );
/**
* Booklibrary Lend Class
* Holds all Information about a lend entry
* @package Booklibrary
* @copyright 2005 Gerd Saurer http://booklibrary.mamboforge.net
* @license http://www.gnu.org/copyleft/gpl.html GNU Public License
* @version $Revision: 1.0 $
*/
class mosBooklibrary_lend extends mosDBTable {
	/** @var int Primary key */
	var $id = null;
	/** @var int the book id this lend is assosiated with*/
	var $fk_bookid=null;	
	/** @var int the user id of the user who lend this book can also be null if $user_name is set*/
	var $fk_userid=null;
	/** @var datetime since when this book is lend out*/
	var $lend_from=null;
	/** @var datetime when the book should be returned*/
	var $lend_until=null;
	/** @var datetime when the book realy was/is returned*/
	var $lend_return=null;
	/** @var boolean */
	var $checked_out=null;
	/** @var time */
	var $checked_out_time=null;
	/** @var string the user who lend this book if it's no user of the database*/
	var $user_name=null;
	/** @var string the e-amil adress user who lend this book if it's no user of the database*/
	var $user_email=null;
	/** @var string the e-amil adress user who lend this book if it's no user of the database*/
	var $user_mailing=null;
	
	/**
	* @param database A database connector object
	*/
	function mosBookLibrary_lend( &$db ) {
		$this->mosDBTable( '#__booklibrary_lend', 'id', $db );
	}
	
	// overloaded check function
	function check() {
		
		// check if book is already led out
		$this->_db->setQuery( "SELECT id FROM #__booklibrary_lend "
			. "\nWHERE fk_bookid='$this->fk_bookid' AND lend_return = null"
		);						
		$xid = intval( $this->_db->loadResult() );
		if ($xid) {
			$this->_error = _BOOK_LEND_OUT;
			return false;
		}
		return true;
	}
	
		
	/**
	 * @return array - name: The sting of the User the book is lend to - email: The email adress of the user
	 */
	function getLendTo(){
		$retVal['name'] = null;
		$retVal['email'] = null;
		if($this->fk_userid != null && $this->fk_userid != 0){
			$this->_db->setQuery( "SELECT name, email from #__users where id=$this->fk_userid");
			$help = $this->_db->loadRow();
			$retVal['name'] = $help[0];
			$retVal['email'] = $help[1];
		}
		else{
			$retVal['name'] = $this->user_name;
			$retVal['email'] = $this->user_email;
		}
		return $retVal;
	}
	
	function toXML(& $xmlDoc, $elementname="lend"){
		
		//create and append name element 
		$retVal = & $xmlDoc->createElement("lend"); 
		
		$fk_userid = & $xmlDoc->createElement("fk_userid");
		$fk_userid->appendChild($xmlDoc->createTextNode($this->fk_userid));
		$retVal->appendChild(& $fk_userid);
		
		$lend_from = & $xmlDoc->createElement("lend_from");
		$lend_from->appendChild($xmlDoc->createTextNode($this->lend_from));
		$retVal->appendChild(& $lend_from);
		
		$lend_until = & $xmlDoc->createElement("lend_until");
		$lend_until->appendChild($xmlDoc->createTextNode($this->lend_until));
		$retVal->appendChild(& $lend_until);
		
		$lend_return = & $xmlDoc->createElement("lend_return");
		$lend_return->appendChild($xmlDoc->createTextNode($this->lend_return));
		$retVal->appendChild(& $lend_return);
		
		$user_name = & $xmlDoc->createElement("user_name");
		$user_name->appendChild($xmlDoc->createTextNode($this->user_name));
		$retVal->appendChild(& $user_name);
		
		$user_email = & $xmlDoc->createElement("user_email");
		$user_email->appendChild($xmlDoc->createTextNode($this->user_email));
		$retVal->appendChild(& $user_email);
		
		$user_mailing = & $xmlDoc->createElement("user_mailing");
		$user_mailing->appendChild($xmlDoc->createTextNode($this->user_mailing));
		$retVal->appendChild(& $user_mailing);
		
		
		return $retVal;
	}
}
?>
