<?php
############################################
# Wines      - A Mambo Wine Component      #
# based on AKOgallery and recipes          #
# Copyright (C) 2004  by Tommaso Tamantini #
# Homepage   : www.lagarlata.net		   #
# Version    : 1.1                         #
# License    : GNU GPL Public License      #
############################################

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );
require_once($mosConfig_absolute_path."/administrator/components/com_wines/class.wines.php");
require_once( $mainframe->getPath( 'admin_html' ) );

// CHECK LANGUAGE
if (!defined( '_WINES_LANG_INCLUDED' )) {
    if (file_exists($mosConfig_absolute_path."/administrator/components/com_wines/language/".$mosConfig_lang.".php") ) { 
        include_once($mosConfig_absolute_path."/administrator/components/com_wines/language/".$mosConfig_lang.".php");
    } else { 
        include_once($mosConfig_absolute_path."/administrator/components/com_wines/language/english.php");
    }
}



switch ($act) {
  case "categories":
    $task = "categories";
    break;

  case "comments":
    $task = "comments";
    break;

  case "settings":
    $task = "settings";
    break;
}

switch ($task) {
  case "publish":
    publishPicture( $id, 1, $option );
    break;

  case "unpublish":
    publishPicture( $id, 0, $option );
    break;

  case "new":
    editWine( $option, 0 );
    break;

  case "edit":
    editWine( $option, $id[0] );
    break;

  case "remove":
    removePicture( $id, $option );
    break;

  case "save":
    savePicture( $option );
    break;

  case "categories":
    mosRedirect( "index2.php?option=categories&section=com_wines" );
    break;

  case "comments":
    showComments( $option );
    break;

  case "publishcmt":
    publishComment( $id, 1, $option );
    break;

  case "unpublishcmt":
    publishComment( $id, 0, $option );
    break;

  case "removecmt":
    removeComment( $id, $option );
    break;

  case "uploadhandler":
    require_once($mosConfig_absolute_path."/administrator/components/com_wines/config.wines.php");
    echo "<img src='components/com_wines/images/logo.png' /><p />";
    if (strlen($screenshot) > 0 and $screenshot != "none")
      copy ($screenshot, $mosConfig_absolute_path.$ag_pathimages."/$screenshot_name");
    echo "Upload complete...<br />";
    if ($thumbcreation)
      resize_image($mosConfig_absolute_path.$ag_pathimages."/$screenshot_name", $mosConfig_absolute_path.$ag_paththumbs."/tn_$screenshot_name", "$ag_thumbwidth", "$ag_thumbcreation", "$ag_thumbquality");
    echo "Thumbnail complete...<br />";
    mosRedirect( "index2.php?option=com_wines&act=upload&batchul=1" );
    break;

  case "settings":
    showConfig( $option );
    break;

  case "savesettings":
    saveConfig ($option, $ag_pathimages, $ag_paththumbs, $ag_thumbcreation, $ag_thumbwidth, $ag_thumbquality, $ag_showdetail, $ag_showrating, $ag_showcomment, $ag_anoncomment, $ag_perpage, $ag_maxvoting, $ag_toplist, $ag_slideshow, $ag_bbcodesupport, $ag_sendEmail, $ag_sendEmailAddress,$ag_postnewwine,$wine_showlogo);
    break;

  default:
    showWines( $option );
    break;
}

function showWines( $option ) {
  global $database;

  # Prepare pagelimit choices
  $limit = intval( mosGetParam( $_POST, 'limit', 10 ) );
  $limitstart = intval( mosGetParam( $_POST, 'limitstart', 0 ) );

  # Prepare category and search choices
  $catid = intval( mosGetParam( $_POST, 'catid', 0 ) );
  $search = trim( strtolower( mosGetParam( $_POST, 'search', '' ) ) );
  $where = array();
  if ($catid > 0) {
    $where[] = "catid='$catid'";
  }
  if ($search) {
    $where[] = "LOWER(imgtitle) LIKE '%$search%' OR LOWER(imgtext) LIKE '%$search%' ";
  }

  # Get total number of records
  $database->setQuery( "SELECT count(*) FROM #__wines AS a".(count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "") );
  $total = $database->loadResult();
  echo $database->getErrorMsg();
  #$total=10;
  if ($limit > $total) {
    $limitstart = 0;
  }

  # Do the main database query
  $where[] = "a.catid=cc.id";
  $database->setQuery( "SELECT a.*, cc.title AS category"
    . "\nFROM #__wines AS a, #__categories AS cc"
    . (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "")
    . "\nORDER BY a.imgdate DESC"
    . "\nLIMIT $limitstart,$limit"
  );
  $rows = $database->loadObjectList();
  if ($database->getErrorNum()) {
    echo $database->stderr();
    return false;
  }

  # Get the list of categories
  $categories[] = mosHTML::makeOption( '0', 'Select Category' );
  $categories[] = mosHTML::makeOption( '-1', '- All Categories' );
  $database->setQuery( "SELECT id AS value, title AS text FROM #__categories"
    . "\nWHERE section='com_wines' ORDER BY ordering" );
  $categories = array_merge( $categories, $database->loadObjectList() );
  $clist = mosHTML::selectList( $categories, 'catid', 'class="inputbox" size="1" onchange="document.adminForm.submit();"', 'value', 'text', $catid );

  # Set up page navigation
  include_once( "includes/pageNavigation.php" );
  $pageNav = new mosPageNav( $total, $limitstart, $limit  );

  # Bring it all to the screen
  html_wines::showWines( $option, $rows, $clist, $search, $pageNav );
}

function removePicture( $cid, $option ) {
  global $database;
  if (!is_array( $cid ) || count( $cid ) < 1) {
    echo "<script> alert('Select an item to delete'); window.history.go(-1);</script>\n";
    exit;
  }
  if (count( $cid )) {
    $cids = implode( ',', $cid );
    $database->setQuery( "DELETE FROM #__wines WHERE id IN ($cids)" );
    if (!$database->query()) {
      echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
    }
  }
  mosRedirect( "index2.php?option=$option" );
}


function publishPicture( $cid=null, $publish=1,  $option ) {
  global $database;

  if (!is_array( $cid ) || count( $cid ) < 1) {
    $action = $publish ? 'publish' : 'unpublish';
    echo "<script> alert('Select an item to $action'); window.history.go(-1);</script>\n";
    exit;
  }

  $cids = implode( ',', $cid );

  $database->setQuery( "UPDATE #__wines SET published='$publish' WHERE id IN ($cids)" );
  if (!$database->query()) {
    echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
    exit();
  }

  mosRedirect( "index2.php?option=$option" );
}

function editWine( $option, $uid ) {
  global $database, $mosConfig_absolute_path;
  require_once($mosConfig_absolute_path."/administrator/components/com_wines/config.wines.php");

  # oop database connector
  $row = new moswines( $database );

  # load the row from the db table
  $row->load( $uid );

  # check for categories and compile to dropdown menu
  $categories[] = mosHTML::makeOption( '0', 'Select Category' );
  $database->setQuery( "SELECT id AS value, name AS text FROM #__categories WHERE section='$option' ORDER BY ordering" );
  $categories = array_merge( $categories, $database->loadObjectList() );
  if (count( $categories ) < 1) mosRedirect( "index2.php?option=categories&section=$option", 'You must add a category for this section first.' );
  $clist = mosHTML::selectList( $categories, 'catid', 'class="inputbox" size="1"', 'value', 'text', intval( $row->catid ) );

  # Create Picture List
  $imgFiles = mosReadDirectory( "$mosConfig_absolute_path$ag_pathimages" );
  $images = array( mosHTML::makeOption( '', 'Select Image') );
  foreach ($imgFiles as $file) {
    if (eregi( "bmp|gif|jpg|png", $file )) {
      $images[] = mosHTML::makeOption( $file );
    }
  }
  $imagelist = mosHTML::selectList( $images, 'imgfilename', "class=\"inputbox\" size=\"1\""
  . " onchange=\"javascript:if (document.forms[0].imgfilename.options[selectedIndex].value!='') {document.imagelib2.src='..$ag_pathimages/' + document.forms[0].imgfilename.options[selectedIndex].value} else {document.imagelib2.src='../images/M_images/blank.png'}\"",
  'value', 'text', $row->imgfilename );

  # Create Thumbail List
  $thuFiles = mosReadDirectory( "$mosConfig_absolute_path$ag_paththumbs" );
  $thumbs = array( mosHTML::makeOption( '', 'Select Thumbnail') );
  foreach ($thuFiles as $tfile) {
    if (eregi( "bmp|gif|jpg|png", $tfile )) {
      $thumbs[] = mosHTML::makeOption( $tfile );
    }
  }
  $thumblist = mosHTML::selectList( $thumbs, 'imgthumbname', "class=\"inputbox\" size=\"1\""
  . " onchange=\"javascript:if (document.forms[0].imgthumbname.options[selectedIndex].value!='') {document.imagelib.src='..$ag_paththumbs/' + document.forms[0].imgthumbname.options[selectedIndex].value} else {document.imagelib.src='../images/M_images/blank.png'}\"",
  'value', 'text', $row->imgthumbname );

  if (!$uid) $row->published = 0;

  html_wines::editWine( $option, $row, $clist, $imagelist, $thumblist, $ag_pathimages, $ag_paththumbs );
}

function savePicture( $option ) {
  global $database;

  $row = new moswines( $database );

  if (!$row->bind( $_POST )) {
    echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
    exit();
  }

  $row->imgdate = mktime();

  if (!$row->store()) {
    echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
    exit();
  }

  mosRedirect( "index2.php?option=$option" );
}

function resize_image($src_file, $dest_file, $new_size, $method, $dest_qual)
{
  $imagetype = array( 1 => 'GIF', 2 => 'JPG', 3 => 'PNG', 4 => 'SWF', 5 => 'PSD', 6 => 'BMP', 7 => 'TIFF', 8 => 'TIFF', 9 => 'JPC', 10 => 'JP2', 11 => 'JPX', 12 => 'JB2', 13 => 'SWC', 14 => 'IFF');
  $imginfo = getimagesize($src_file);

  if ($imginfo == null) die("ERROR: Source file not found!");

  $imginfo[2] = $imagetype[$imginfo[2]];

  // GD can only handle JPG & PNG images
  if ($imginfo[2] != 'JPG' && $imginfo[2] != 'PNG' && ($method == 'gd1' || $method == 'gd2')) die("ERROR: GD can only handle JPG and PNG files!");

  // height/width
  $srcWidth = $imginfo[0];
  $srcHeight = $imginfo[1];

  echo "Creating thumbnail from $imginfo[2], $imginfo[0] x $imginfo[1]...<br>";

  $ratio = max($srcWidth, $srcHeight) / $new_size;
  $ratio = max($ratio, 1.0);
  $destWidth = (int)($srcWidth / $ratio);
  $destHeight = (int)($srcHeight / $ratio);

  // Method for thumbnails creation
  switch ($method) {

  case "gd1" :
    if (!function_exists('imagecreatefromjpeg')) {
        die('GD image library not installed!');
    }
    if ($imginfo[2] == 'JPG')
      $src_img = imagecreatefromjpeg($src_file);
    else
      $src_img = imagecreatefrompng($src_file);
    if (!$src_img){
      $ERROR = $lang_errors['invalid_image'];
      return false;
    }
    $dst_img = imagecreate($destWidth, $destHeight);
    imagecopyresized($dst_img, $src_img, 0, 0, 0, 0, $destWidth, (int)$destHeight, $srcWidth, $srcHeight);
    imagejpeg($dst_img, $dest_file, $dest_qual);
    imagedestroy($src_img);
    imagedestroy($dst_img);
    break;

  case "gd2" :
    if (!function_exists('imagecreatefromjpeg')) {
        die('GD image library not installed!');
    }
    if (!function_exists('imagecreatetruecolor')) {
        die('GD2 image library does not support truecolor thumbnailing!');
    }
    if ($imginfo[2] == 'JPG')
      $src_img = imagecreatefromjpeg($src_file);
    else
      $src_img = imagecreatefrompng($src_file);
    if (!$src_img){
      $ERROR = $lang_errors['invalid_image'];
      return false;
    }
    $dst_img = imagecreatetruecolor($destWidth, $destHeight);
    imagecopyresampled($dst_img, $src_img, 0, 0, 0, 0, $destWidth, (int)$destHeight, $srcWidth, $srcHeight);
    imagejpeg($dst_img, $dest_file, $dest_qual);
    imagedestroy($src_img);
    imagedestroy($dst_img);
    break;
  }

  // Set mode of uploaded picture
  chmod($dest_file, octdec('755'));

  // We check that the image is valid
  $imginfo = getimagesize($dest_file);
  if ($imginfo == null){
    return false;
  } else {
    return true;
  }
}

function showUpload( $option, $batchul) {
  global $winversion;	
  echo "<table cellpadding='4' cellspacing='0' border='0' width='100%'><tr><td width='100%' class='sectionname'><img src='components/com_wines/images/logo.png'></td></tr></table>";
  echo "<form action='index2.php?task=uploadhandler' method='post' name='adminForm' enctype='multipart/form-data'>";
  echo "<table width='100%' border='0' cellpadding='4' cellspacing='2' class='adminForm'>";
  echo "<tr align='center' valign='middle'><td align='center' valign='top'>";
  if ($batchul) echo "Upload completed. Choose next picture:<p />";
  echo "<input type='hidden' name='option' value='$option' />";
  echo "<input type='file' name='screenshot' /><br />";
  echo "<input type='checkbox' name='thumbcreation' value='ON' checked /> Create Thumbnail<br />";
  echo "<input type='submit' value='Upload' />";
  echo "</td></tr></table></form>";
  echo "<p><font class='smalldark'><b>Wines By Tommaso Tamantini</b></font></p>";
}

function showConfig( $option ) {
  global $mosConfig_absolute_path;
  global $winversion;
  require($mosConfig_absolute_path."/administrator/components/com_wines/config.wines.php");
?>
    <script language="javascript" type="text/javascript">
    function submitbutton(pressbutton) {
      var form = document.adminForm;
      if (pressbutton == 'cancel') {
        submitform( pressbutton );
        return;
      }
      if (form.ag_paththumbs.value == ""){
        alert( "Thumbnails path must be provided!" );
      } else {
        submitform( pressbutton );
      }
    }
    </script>

  <form action="index2.php" method="POST" name="adminForm">
  <table cellpadding="4" cellspacing="0" border="0" width="100%">
  <tr>
    <td width="100%" class="sectionname">
      <img src="components/com_wines/images/logo.png">
    </td>
  </tr>
  </table>
<script language="javascript" src="js/dhtml.js"></script>
<table cellpadding="3" cellspacing="0" border="0" width="100%">
  <tr>
    <td width="" class="tabpadding">&nbsp;</td>
    <!--<td id="tab1" class="offtab" onclick="dhtml.cycleTab(this.id)">Backend</td>-->
    <td id="tab2" class="offtab" onclick="dhtml.cycleTab(this.id)">Frontend</td>
    <td width="90%" class="tabpadding">&nbsp;</td>
  </tr>
</table>

  <div id="page1" class="pagetext">
  <table width="100%" border="0" cellpadding="4" cellspacing="2" class="adminForm">
    <TR>
      <td class="sectionname" colspan="3"><div align="center">General Settings</div></td>
    </TR>
    <tr align="center" valign="middle">
      <td width="20%" align="left" valign="top"><strong><?php echo "Picture Path:" ?></strong></td>
      <td width="20%" align="left" valign="top"><input type="text" name="ag_pathimages" value="<? echo "$ag_pathimages"; ?>"></td>
      <td width="60%" align="left" valign="top"><?php echo "Path where the pictures will be stored." ?></td>
    </tr>
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo "Thumbnails Path:" ?></strong></td>
      <td align="left" valign="top"><input type="text" name="ag_paththumbs" value="<? echo "$ag_paththumbs"; ?>"></td>
      <td align="left" valign="top"><?php echo "Path where the thumbnails will be stored." ?></td>
    </tr>
    <TR>
      <td class="sectionname" colspan="3"><div align="center">Thumbnail Settings</div></td>
    </TR>
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo "Thumbnail Creator:" ?></strong></td>
      <td align="left" valign="top">
      <?php
        $thumbcreator[] = mosHTML::makeOption( 'none', 'None' );
        $thumbcreator[] = mosHTML::makeOption( 'gd1', 'GD Library' );
        $thumbcreator[] = mosHTML::makeOption( 'gd2', 'GD2 Library' );
        #$thumbcreator[] = mosHTML::makeOption( 'im', 'ImageMagick' );
        $mc_ag_thumbcreation = mosHTML::selectList( $thumbcreator, 'ag_thumbcreation', 'class="inputbox" size="3"', 'value', 'text', $ag_thumbcreation );
        echo $mc_ag_thumbcreation;
      ?>
      </td>
      <td align="left" valign="top"><?php echo "Choose image processor for thumbnail creation." ?></td>
    </tr>
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo "Thumbnail Width:" ?></strong></td>
      <td align="left" valign="top"><input type="text" name="ag_thumbwidth" value="<? echo "$ag_thumbwidth"; ?>"></td>
      <td align="left" valign="top"><?php echo "Width of the thumbnails created." ?></td>
    </tr>
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo "Thumbnail Quality:" ?></strong></td>
      <td align="left" valign="top"><input type="text" name="ag_thumbquality" value="<? echo "$ag_thumbquality"; ?>"></td>
      <td align="left" valign="top"><?php echo "Quality of the thumbnails created." ?></td>
    </tr>
  </table>
  </div>
  <div id="page2" class="pagetext">
  <table width="100%" border="0" cellpadding="4" cellspacing="2" class="adminForm">
    <TR>
      <td class="sectionname" colspan="3"><div align="center">General Settings</div></td>
    </TR>
    <!--
	<tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo "Show Details:" ?></strong></td>
      <td align="left" valign="top">
      <?php
        $yesno[] = mosHTML::makeOption( '0', 'No' );
        $yesno[] = mosHTML::makeOption( '1', 'Yes' );
        $yn_ag_showdetail = mosHTML::selectList( $yesno, 'ag_showdetail', 'class="inputbox" size="2"', 'value', 'text', $ag_showdetail );
        echo $yn_ag_showdetail;
      ?>
      </td>
      <td align="left" valign="top"><?php echo "Show picture details to user?" ?></td>
    </tr>
	-->
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo "Wines per Page:" ?></strong></td>
      <td align="left" valign="top"><input type="text" name="ag_perpage" value="<? echo "$ag_perpage"; ?>"></td>
      <td align="left" valign="top"><?php echo "Number of wines shown per Let the user comment on wines." ?></td>
    </tr>
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo "Toplist entries:" ?></strong></td>
      <td align="left" valign="top"><input type="text" name="ag_toplist" value="<? echo "$ag_toplist"; ?>"></td>
      <td align="left" valign="top"><?php echo "Number of entries in the toplists." ?></td>
    </tr>
    <TR>
      <td class="sectionname" colspan="3"><div align="center">Rate Settings</div></td>
    </TR>
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo "Allow Rating:" ?></strong></td>
      <td align="left" valign="top">
      <?php
        $yn_ag_showrating = mosHTML::selectList( $yesno, 'ag_showrating', 'class="inputbox" size="2"', 'value', 'text', $ag_showrating );
        echo $yn_ag_showrating;
      ?>
      </td>
      <td align="left" valign="top"><?php echo "Let the user vote pictures." ?></td>
    </tr>
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo "Highest rating:" ?></strong></td>
      <td align="left" valign="top"><input type="text" name="ag_maxvoting" value="<? echo "$ag_maxvoting"; ?>"></td>
      <td align="left" valign="top"><?php echo "Highest possible rating." ?></td>
    </tr>
    <TR>
      <td class="sectionname" colspan="3"><div align="center">Comment Settings</div></td>
    </TR>
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo "Allow Comments:" ?></strong></td>
      <td align="left" valign="top">
      <?php
        $yn_ag_showcomment = mosHTML::selectList( $yesno, 'ag_showcomment', 'class="inputbox" size="2"', 'value', 'text', $ag_showcomment );
        echo $yn_ag_showcomment;
      ?>
      </td>
      <td align="left" valign="top"><?php echo "Let the user comment on wines." ?></td>
    </tr>
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo "Anonymous Comments:" ?></strong></td>
      <td align="left" valign="top">
      <?php
        $yn_ag_anoncomment = mosHTML::selectList( $yesno, 'ag_anoncomment', 'class="inputbox" size="2"', 'value', 'text', $ag_anoncomment );
        echo $yn_ag_anoncomment;
      ?>
      </td>
      <td align="left" valign="top"><?php echo "Let unregistered users comment." ?></td>
    </tr>
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo "Allow BBCode:" ?></strong></td>
      <td align="left" valign="top">
      <?php
        $yn_ag_bbcodesupport = mosHTML::selectList( $yesno, 'ag_bbcodesupport', 'class="inputbox" size="2"', 'value', 'text', $ag_bbcodesupport );
        echo $yn_ag_bbcodesupport;
      ?>
      </td>
      <td align="left" valign="top"><?php echo "Allow the use of simple BBCode in comments." ?></td>
    </tr>
    <!--<TR>
      <td class="sectionname" colspan="3"><div align="center">Slideshow Settings</div></td>
    </TR>
    <tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo "Allow Slideshows:" ?></strong></td>
      <td align="left" valign="top">
      <?php
        $yn_ag_slideshow = mosHTML::selectList( $yesno, 'ag_slideshow', 'class="inputbox" size="2"', 'value', 'text', $ag_slideshow );
        //echo $yn_ag_slideshow;
      ?>
      </td>
      <td align="left" valign="top"><?php echo "Show Slideshow buttons to users." ?></td>
    </tr>-->
 	<tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo "Send e-mail on new wine:" ?></strong></td>
      <td align="left" valign="top">
      <?php
        $yn_ag_sendEmail = mosHTML::selectList( $yesno, 'ag_sendEmail', 'class="inputbox" size="2"', 'value', 'text', $ag_sendEmail );
        echo $yn_ag_sendEmail;
      ?>
      </td>
      <td align="left" valign="top"><?php echo "Send an e-mail when a new wine has been submitted" ?></td>
    </tr>

 	<tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo "E-mail:" ?></strong></td>
      <td align="left" valign="top">
        <input type="text" name="ag_sendEmailAddress" value="<? echo "$ag_sendEmailAddress"; ?>">
      </td>
      <td align="left" valign="top"><?php echo "Destination address" ?></td>
    </tr>
	<tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo "Show Wine Details:" ?></strong></td>
      <td align="left" valign="top">
      <?php
        $yn_ag_showdetail = mosHTML::selectList( $yesno, 'ag_showdetail', 'class="inputbox" size="2"', 'value', 'text', $ag_showdetail );
        echo $yn_ag_showdetail;
      ?>
      </td>
      <td align="left" valign="top"><?php echo "Show Wine details to user" ?></td>
    </tr>
	<tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo "Post new wines:" ?></strong></td>
      <td align="left" valign="top">
      <?php
        $yn_ag_postnewwine = mosHTML::selectList( $yesno, 'ag_postnewwine', 'class="inputbox" size="2"', 'value', 'text', $ag_postnewwine );
        echo $yn_ag_postnewwine;
      ?>
      </td>
      <td align="left" valign="top"><?php echo "Let the user to post wines" ?></td>
    </tr>
	<tr align="center" valign="middle">
      <td align="left" valign="top"><strong><?php echo "Show wine logo:" ?></strong></td>
      <td align="left" valign="top">
      <?php
        $yn_wine_showlogo = mosHTML::selectList( $yesno, 'wine_showlogo', 'class="inputbox" size="2"', 'value', 'text', $wine_showlogo );
        echo $yn_wine_showlogo;
      ?>
      </td>
      <td align="left" valign="top"><?php echo "Show/Hide the wine logo" ?></td>
    </tr>
  </table>
  
  
  
  </div>
  <script language="javascript" type="text/javascript">dhtml.cycleTab('tab2');</script>
  <input type="hidden" name="option" value="<?php echo $option; ?>">
  <input type="hidden" name="act" value="<?php echo $act; ?>">
  <input type="hidden" name="task" value="">
  <input type="hidden" name="boxchecked" value="0">
</form>
  <p><font class='smalldark'><b>Wines by Tommaso Tamantini.<br />Based on AkoGallery by Arthur Konze (www.mamboportal.com)</b></font></p>
<?php                                                                      
}                                                                          

function saveConfig ($option, $ag_pathimages, $ag_paththumbs, $ag_thumbcreation, $ag_thumbwidth, $ag_thumbquality, $ag_showdetail, $ag_showrating, $ag_showcomment, $ag_anoncomment, $ag_perpage, $ag_maxvoting, $ag_toplist, $ag_slideshow, $ag_bbcodesupport,$ag_sendEmail,$ag_sendEmailAddress,$ag_postnewwine,$wine_showlogo)
{
  $configfile = "components/com_wines/config.wines.php";
  @chmod ($configfile, 0766);
  $permission = is_writable($configfile);
  if (!$permission) {
    $mosmsg = "Config file not writeable!";
    mosRedirect("index2.php?option=$option&act=config",$mosmsg);
    break;
  }

  $config = "<?php\n";
  $config .= "\$ag_pathimages = \"$ag_pathimages\";\n";
  $config .= "\$ag_paththumbs = \"$ag_paththumbs\";\n";
  $config .= "\$ag_thumbcreation = \"$ag_thumbcreation\";\n";
  $config .= "\$ag_thumbwidth = \"$ag_thumbwidth\";\n";
  $config .= "\$ag_thumbquality = \"$ag_thumbquality\";\n";
  $config .= "\$ag_showdetail = \"$ag_showdetail\";\n";
  $config .= "\$ag_showrating = \"$ag_showrating\";\n";
  $config .= "\$ag_showcomment = \"$ag_showcomment\";\n";
  $config .= "\$ag_anoncomment = \"$ag_anoncomment\";\n";
  $config .= "\$ag_perpage = \"$ag_perpage\";\n";
  $config .= "\$ag_maxvoting = \"$ag_maxvoting\";\n";
  $config .= "\$ag_toplist = \"$ag_toplist\";\n";
  $config .= "\$ag_slideshow = \"$ag_slideshow\";\n";
  $config .= "\$ag_bbcodesupport = \"$ag_bbcodesupport\";\n";
  $config .= "\$ag_sendEmail = \"$ag_sendEmail\";\n";  
  $config .= "\$ag_sendEmailAddress = \"$ag_sendEmailAddress\";\n";
  $config .= "\$ag_postnewwine = \"$ag_postnewwine\";\n"; 
  $config .= "\$wine_showlogo = \"$wine_showlogo\";\n"; 
  $config .= "?>";

  if ($fp = fopen("$configfile", "w")) {
    fputs($fp, $config, strlen($config));
    fclose ($fp);
  }
  mosRedirect("index2.php?option=$option&task=settings", "Settings saved");
}


##############

function publishComment( $cid=null, $publish=1,  $option ) {
  global $database;

  if (!is_array( $cid ) || count( $cid ) < 1) {
    $action = $publish ? 'publish' : 'unpublish';
    echo "<script> alert('Select an item to $action'); window.history.go(-1);</script>\n";
    exit;
  }

  $cids = implode( ',', $cid );

  $database->setQuery( "UPDATE #__wines_comments SET published='$publish' WHERE cmtid IN ($cids)" );
  if (!$database->query()) {
    echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
    exit();
  }

  mosRedirect( "index2.php?option=$option&task=comments" );
}

function removeComment( $cid, $option ) {
  global $database;
  if (!is_array( $cid ) || count( $cid ) < 1) {
    echo "<script> alert('Select an item to delete'); window.history.go(-1);</script>\n";
    exit;
  }
  if (count( $cid )) {
    $cids = implode( ',', $cid );
    $database->setQuery( "DELETE FROM #__wines_comments WHERE cmtid IN ($cids)" );
    if (!$database->query()) {
      echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
    }
  }
  mosRedirect( "index2.php?option=$option&task=comments" );
}

function showComments( $option ) {
  global $database;

  # Prepare pagelimit choices
  $limit = intval( mosGetParam( $_POST, 'limit', 10 ) );
  $limitstart = intval( mosGetParam( $_POST, 'limitstart', 0 ) );

  # Prepare search choices
  $search = trim( strtolower( mosGetParam( $_POST, 'search', '' ) ) );
  $where = array();
  if ($search) {
    $where[] = "LOWER(cmttext) LIKE '%$search%' OR LOWER(cmtname) LIKE '%$search%' ";
  }

  # Get total number of records
  $database->setQuery( "SELECT count(*) FROM #__wines_comments AS a".(count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "") );
  $total = $database->loadResult();
  echo $database->getErrorMsg();
  if ($limit > $total) {
    $limitstart = 0;
  }

  # Do the main database query
  $database->setQuery( "SELECT * FROM #__wines_comments "
    . (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "")
    . "\nORDER BY cmtdate DESC"
    . "\nLIMIT $limitstart,$limit"
  );
  $rows = $database->loadObjectList();
  if ($database->getErrorNum()) {
    echo $database->stderr();
    return false;
  }

  # Set up page navigation
  include_once( "includes/pageNavigation.php" );
  $pageNav = new mosPageNav( $total, $limitstart, $limit  );

  # Bring it all to the screen
  html_wines::showComments( $option, $rows, $search, $pageNav );
}