<?php
/**
 * OpenSEF for Joomla!
 * @copyright (c) 2005 The OpenSEF Project (www.opensef.org)
 * @copyright (c) 2004-2005 Xaneon Development (www.xaneon.com)
 * @license GPL http://www.gnu.org/copyleft/gpl.html
 *
 * TODO
 */

/** Ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct access to this location is not allowed.' );

/*
 * TODO
 */
class xclPackageInfo {
  var $loaded = false;
  var $xmlFile = null;
  var $xmlDoc = null;

  /*
   * TODO
   */
  function xclPackageInfo( $xmlFile ) {
    if (empty( $xmlFile ) || !file_exists( $xmlFile ))
      return null;

    require_once( $GLOBALS['mosConfig_absolute_path'] .
      '/includes/domit/xml_domit_lite_include.php' );
    $xmlDoc =& new DOMIT_Lite_Document();
    $xmlDoc->resolveErrors( true );
    if (!$xmlDoc->loadXML( $xmlFile, false, true ))
      return false;

    $this->loaded = true;
    $this->xmlFile = $xmlFile;
    $this->xmlDoc =& $xmlDoc;
  }

  /*
   * TODO
   */
  function isAvailable() {
    return $this->loaded;
  }

  /*
   * TODO
   */
  function getElement( $path ) {
    return $this->xmlDoc->getElementsByPath( $path, 1 );
  }

  /*
   * TODO
   */
  function getElementText( $path, $defaultValue = null ) {
    $element =& $this->xmlDoc->getElementsByPath( $path, 1 );
    return (is_object( $element ) ? $element->getText() : $defaultValue);
  }

  /*
   * TODO
   */
  function getElementAttribute( $path, $attribute, $defaultValue = null ) {
    if (($element = $this->xmlDoc->getElementsByPath( $path, 1 )) !== null) {
      $attrs =& $element->attributes;
      if (!is_null( $attribute ) && is_array( $attrs )
          && isset( $attrs[$attribute] )) {
        return $attrs[$attribute];
      }
    }
    return $defaultValue;
  }

  /*
   * TODO
   */
  function getUpdateList( $remotePath = null, $scope = null, $version = null ) {
    if (!$scope)
      $scope = strtolower( $this->getElementText( '/mosinstall/name' ) );
    if (!$version)
      $version = $this->getElementText( '/mosinstall/version' );
    if (!$remotePath)
      $remotePath = $this->getElementText( '/mosinstall/setupUrl', 'http://www.open-sef.org/updates/' );

    $fileName = $scope . '-' . $version . '.ini';
    $localPath = mosPathName( $GLOBALS['mosConfig_absolute_path'] . '/media' );
    $filePath = mosPathName( $localPath . $fileName, false );
    $rnd = (true ? '?rnd=' . mt_rand() : '');

    if (file_exists( $filePath )) {
      if (@unlink( $filePath ) === false) {
        trigger_error( "Could not remove existing file '$filePath'", E_USER_NOTICE );
      }
    }

    if (!file_exists( $filePath ) || is_writable( $filePath )) {
      $contents = @file_get_contents( $remotePath . $fileName . $rnd );
      if (strlen( $contents ) == 0) {
        trigger_error( "Could not open URL '$remotePath$fileName'", E_USER_WARNING );
        return null;
      }
      else {
        if (($file = @fopen( $filePath, 'wb' )) === false) {
          trigger_error( "Could not write to file '$filePath'", E_USER_WARNING );
          return null;
        }
        else {
          fwrite( $file, $contents, strlen( $contents ) );
          fclose( $file );
        }
      }
    }

    $iniData = parse_ini_file($filePath, true);
    //var_dump( $iniData );
    if (!is_array( $iniData )) {
      trigger_error( "Failed to parse INI file '$filePath'", E_USER_WARNING );
      return null;
    }

    $packages = array();
    foreach ($iniData as $sectionName => $sectionData) {
      if (is_array( $sectionData ) && count( $sectionData ) > 0) {
        foreach ($sectionData as $packageName => $fileData) {
          $fileInfo = explode( ';', $fileData );
          $package = new stdClass();
          $package->type = $sectionName;
          $package->name = $packageName;
          $package->fileName = $fileInfo[0];
          $package->url = $fileInfo[1];
          $package->version = $fileInfo[2];
          $package->date = $fileInfo[3];
          $package->size = $fileInfo[4];
          $package->title = $fileInfo[5];
          $package->author = '';
          $packages[] = $package;
        }
      }
    }
    return $packages;
  }

}

/*
 * TODO
 */
class xclConfig {
  var $_cacheFile             = null;
  var $_db                    = null;
  var $_scope                 = null;

  /*
   * TODO
   */
  function xclConfig( &$db, $scope, $reload = false ) {
    $this->_db =& $db;
    $this->_scope = $scope;
    $this->_cacheFile = $GLOBALS['mosConfig_absolute_path'] .
      "/administrator/components/{$scope}/cache.config.php";
    $this->load( $reload );
  }

  /*
   * TODO
   */
  function load( $reload = false ) {
    if (file_exists( $this->_cacheFile ) && !$reload) {
      $this->enabled = (filesize( $this->_cacheFile ) > 0 ? '1' : '0');
      include( $this->_cacheFile );
    }
    else {
      $query = 'SELECT name, value FROM #__opensef_config' .
        "\nWHERE scope = '{$this->_scope}' ORDER BY name ASC";
      $this->_db->setQuery( $query );
      $rows = $this->_db->loadObjectList();
      if ($this->_db->getErrorNum()) {
        trigger_error( $this->_db->stderr(), E_USER_WARNING );
        return false;
      }
      foreach ($rows as $row) {
        $rowData = get_object_vars( $row );
        $rowName = $rowData['name'];
        $rowValue = (isset( $rowData['value'] ) ? $rowData['value'] : null);
        $this->$rowName = $rowValue;
      }
      if ($this->enabled)
        $this->store( false );
    }
    return true;
  }

  /*
   * TODO
   */
  function store( $updateDb = false ) {
    if ($updateDb) {
      $vars = get_object_vars( $this );
      foreach ($vars as $key => $value) {
        if ($key[0] != '_') {
          $value = addslashes( $value );
          $query = 'REPLACE INTO #__opensef_config' .
            "\nSET scope = '{$this->_scope}'," .
            "\nname = '$key', value = '$value'";
          $this->_db->setQuery( $query );
          if (!$this->_db->query()) {
            trigger_error( $this->_db->stderr(), E_USER_WARNING );
            return false;
          }
        }
      }
    }
    if (file_exists( $this->_cacheFile )) {
      if (!is_writable( $this->_cacheFile )) {
        @chmod( $this->_cacheFile, 0666 );
        if (!is_writable( $this->_cacheFile )) {
          trigger_error( "$this->_cacheFile is not writable!", E_USER_ERROR );
          return false;
        }
      }
    }
    if (($file = @fopen( $this->_cacheFile, 'w' )) !== false) {
      if (!isset( $this->enabled) || $this->enabled == '0') {
        ftruncate( $file, 0 );
      }
      else {
        $output = '<?php' . "\n";
        $vars = get_object_vars( $this );
        foreach ($vars as $key => $value) {
          if ($key[0] != '_') {
            $value = addslashes( $value );
            if ($key == 'spec_chars_d' || $key == 'spec_chars') {
            	$output .= "\$this->$key = array($value);\n";	
            } else {
            	$output .= "\$this->$key = '$value';\n";
          	}
          }
        }
        $output .= '?>';
        fwrite( $file, $output, strlen( $output ));
      }
      fclose( $file );
    }
    return true;
  } // function store

}

?>