<?php
/**
 * OpenSEF for Joomla!
 * @copyright (c) 2005 The OpenSEF Project (www.opensef.org)
 * @copyright (c) 2004-2005 Xaneon Development (www.xaneon.com)
 * @license GPL http://www.gnu.org/copyleft/gpl.html
 *
 * This file contains helpers that are relied on by a large portion of
 * the actual project code. Also, simply including this file will
 * update PHP's include path to make loading the project's other
 * include files easier, as well as load any needed PHP compatibility
 * functions to bring us up to the 4.3.10/5.0 level.
 */

/** Ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct access to this location is not allowed.' );

// If we're using PHP 4.x, load a compatibility/backport layer so that
// our script has access to most of the constants and functions defined
// in PHP as of versions 4.3.10 and 5.0.
if (version_compare( phpversion(), '5.0' ) === -1) {
  @include_once( dirname( __FILE__ ) . '/sef.compat.php' );
}

// Set the PHP include path so that our script can easily include files
// from the current (administrator/com_xxx/includes/) directory.
xclSetIncludePath();

/*
 * Helper for adding to PHP's include path in a simple manner.
 */
function xclSetIncludePath( $path = null ) {
  if (is_null( $path )) $path = dirname( __FILE__ );
  ini_set( 'include_path', $path .
    PATH_SEPARATOR . ini_get( 'include_path' ) );
}

/*
 * Helper for casting records returned as stdClass instances into a
 * more useful mosDBTable-derived data object. As this works by
 * copying the data, it's likely quite inefficient, but seemingly the
 * only way to do this in PHP4 at the moment.
 *
 * @param array $rows array of stdClass instances
 * @param string $class name of class to cast array elements into
 */
function xclCastObjectList( &$rows, $class ) {
  $objs = array();
  foreach ($rows as $row) {
    $data = get_object_vars( $row );
    $obj = new $class( $GLOBALS['database'] );
    foreach ($data as $name => $value)
      $obj->$name = $value;
    $objs[] = $obj;
  }
  return $objs;
}

/*
 * Extension of Joomla's mosDBTable. This subclass saves effort in
 * writing mosDBTable implementations by adding useful functionality
 * that is needed in many common cases. Ideally, this functionality
 * would be found mosDBTable itself.
 */
class xclDBTable extends mosDBTable {

  /*
   * The parameters to the constructor are the same as for mosDBTable,
   * with the addition of the last optional $id parameter.
   *
   * @param string $table
   * @param string $key
   * @param object $db
   * @param number $id if given, load the specified record
   */
  function xclDBTable( $table, $key, &$db, $id = null ) {
    $this->mosDBTable( $table, $key, $db );
    $this->load( $id );
  }

  /*
   * Default implementation of pre-save field validation, needed for
   * every subclass of mosDBTable. Also handles Created & Last
   * Modified fields automatically, if they exist in the table.
   *
   * @return true|false whether field validation succeeded
   */
  function check() {
    global $my;
    $vars =& get_object_vars($this);
    $now = date( 'Y-m-d H:i:s' );
    $user = (!empty( $my->id ) ? $my->id : 0);

    if ($this->_tbl_key == 'id' && empty( $this->id ))
      $this->id = null;
    if (array_key_exists( 'created', $vars ) && empty( $this->created )) {
      $this->created = $now;
      $this->created_by = $user;
    }
    if (array_key_exists( 'modified', $vars )) {
      $this->modified = $now;
      $this->modified_by = $user;
    }
    return true;
  }

  /*
   * Override mosDBTable's storage function with a better
   * implementation. Joomla's database class functions are
   * unsatisfactory at least in that it seems quite impossible
   * to store NULL values in fields.
   */
  function store() {  
    $isUpdate = false;
    $vars =& get_object_vars( $this );
    if (empty( $vars[$this->_tbl_key] )) {
      $query = "INSERT INTO $this->_tbl (%s) VALUES (%s)";
    }
    else {
      $isUpdate = true;
      $query = "UPDATE {$this->_tbl} SET %s WHERE" .
        " {$this->_tbl_key} = '" .
          $this->_db->getEscaped( $vars[$this->_tbl_key] ) . "'";
    }
    $data = array();
    foreach ($vars as $field => $value) {
      if ($field[0] == '_'
          || ($isUpdate && $field == $this->_tbl_key)  
          || is_array( $value ) || is_object( $value ))
        continue;
      if ($value === null) {
        $value = 'NULL';
      }
      else if ($value === '') {
        $value = "''";
      }
      else {
        $value = "'" . $this->_db->getEscaped( $value ) . "'";
      }
      $data[$field] = $value;
    }
    if (!$isUpdate) {
      $query = sprintf( $query,
        implode( ', ', array_keys( $data ) ),
        implode( ', ', array_values( $data ) ) );
    }
    else {
      $stmts = array();
      foreach ($data as $field => $value)  
        $stmts[] = $field . ' = ' . $value;
      $query = sprintf( $query, implode( ', ', $stmts ) );
    }
    $this->_db->setQuery( $query );
    return $this->_db->query();
  }
}

?>