<?php
/////////////////////////////////////////////////////////////////////////////
// FQ - Correos multiples                                                  //
// Copyright (C) 2004-2005                                                 //
// http://www.brutalidadtotal.com                                          //
// FQ es un componente para Mambo 4.5.                                     // 
// Este componente permite enviar correos a usuarios registrados en        //
// diferentes grupos. Puede enviar correos en formato HTML o solo texto.   //
// Este componente es un programa gratis; usted puede redistribuirlo y/o   //
// modificarlo bajo terminos de Licencia GNU.                              //
//----------------------------------------------------------------------   //
// $Id: class.dbclasses.php,v 1.0 2004/12/23 17:00:12                      //
/////////////////////////////////////////////////////////////////////////////

defined( '_VALID_MOS' ) or die( 'El acceso directo no esta permitido a esta pagina.' );

function check_email_address($email) {
  if (!ereg("[^@]{1,64}@[^@]{1,255}", $email)) {
    return false;
  }
  $email_array = explode("@", $email);
  $local_array = explode(".", $email_array[0]);
  for ($i = 0; $i < sizeof($local_array); $i++) {
     if (!ereg("^(([A-Za-z0-9!#$%&'*+/=?^_`{|}~-][A-Za-z0-9!#$%&'*+/=?^_`{|}~\.-]{0,63})|(\"[^(\\|\")]{0,62}\"))$", $local_array[$i])) {
      return false;
    }
  }  
  if (!ereg("^\[?[0-9\.]+\]?$", $email_array[1])) {
    $domain_array = explode(".", $email_array[1]);
    if (sizeof($domain_array) < 2) {
        return false;
    }
    for ($i = 0; $i < sizeof($domain_array); $i++) {
      if (!ereg("^(([A-Za-z0-9][A-Za-z0-9-]{0,61}[A-Za-z0-9])|([A-Za-z0-9]+))$", $domain_array[$i])) {
        return false;
      }
    }
  }
  return true;
}

class fqSubscriber extends mosDBTable {
  var $list_id=null;
  var $subscriber_id=null;
  var $subscriber_name=null;
  var $subscriber_email=null;
  var $confirmed=null;
  var $subscribe_date=null;
  var $receive_html=null;
  var $mambo=null;
  var $delete_id=null;
	/**
	* @param database A database connector object
	*/
	function fqSubscriber( &$db ) {
		$this->mosDBTable( '#__fq_subscribers', 'subscriber_id', $db );
	}
}

class fqList extends mosDBTable {
  var $id = null;
  var $list_name = null;
  var $list_desc = null;
  var $sendername = null;
  var $senderemail = null;
  var $bounceadres = null;
  var $subscribemessage = null;
  var $unsubscribemessage = null;
  var $html = null;
  var $hidden = null;
  var $aid = 25;
  var $default_letter = null;
  var $published = null;
	/**
	* @param database A database connector object
	*/
	function fqList( &$db ) {
		$this->mosDBTable( '#__fq_letters', 'id', $db );
	}
}
class fqMailing extends mosDBTable {
  var $id = null;
  var $send_date = null;
  var $list_subject  = null;
  var $list_content  = null;
  var $list_textonly  = null;
  var $images  = null;
  var $attachments  = null;
  var $layout  = null;
  var $published  = null;
	/**
	* @param database A database connector object
	*/
	function fqMailing( &$db ) {
		$this->mosDBTable( '#__fq_mailing ', 'id', $db );
	}
}
class fqStats extends mosDBTable {
  var $id = null;
  var $subject = null;
  var $send  = null;
  var $date  = null;
	/**
	* @param database A database connector object
	*/
	function fqStats( &$db ) {
		$this->mosDBTable( '#__fq_stats ', 'id', $db );
	}
}
?>