<?php
/**
* Booklibrary Import Export Class
* Handles the import and export of data from the booklibrary.
* @package Booklibrary
* @copyright 2005 Gerd Saurer http://booklibrary.mamboforge.net
* @license http://www.gnu.org/copyleft/gpl.html GNU Public License
* @version $Revision: 1.0 $
*/
class mosBooklibraryImportExport{
	

	/**
	 * Imports the lines given to this methode into the database and writes a
	 * Table containing the informations of the imported books.
	 * The imported books will be set to not published 
	 * Format: #;id;isbn;title;author;language
	 * @param array lines a array of lines read from the file
	 * @param int catid the id of the category the books should be added to 
	 */
	function importBooksCSV($lines, $catid){
		global $database;
			
			$retVal= array();
			$i = 0;
	    	foreach ($lines as $line) {
	    		$tmp = array();
	    		$line = explode(';', $line, -1);
				$book = new mosBookLibrary($database);
				$book->bookid = $line[0];
				$book->isbn = $line[1];
				$book->title = $line[2];
				$book->authors = $line[3];
				$book->language = $line[4];
				$book->catid = $catid;
				$book->date = date("Y-m-d H:i:s");
	              
	            // todo optimize!!!
	            $tmp[0] = $i;
	            $tmp[1] = $line[0];
	            $tmp[2] = $line[1];
	            $tmp[3] = $line[2];
	            $tmp[4] = $line[3];
	            $tmp[5] = $line[4];
				
				if (!$book->check() || !$book->store()) {
					$tmp[6] =  $book->getError();
				} else {
					$tmp[6] =  "OK";
				}
	            
				$book->checkin();
				$book->updateOrder( "catid='$book->catid'" );
				$retVal[$i] = $tmp;
				$i ++;
			}
			return $retVal;
	}
	
	
	function exportBooksXML($books, $all){
		global $mosConfig_live_site, $mosConfig_absolute_path, $booklibrary_configuration;
		
		$xmlDoc =& new DOMIT_Document(); 
	
	
		$xmlDoc->appendChild($xmlDoc->createProcessingInstruction('xml', "version=\"1.0\" encoding=\"iso-8859-2\"")); 
	    //$xmlDoc->appendChild($xmlDoc->createProcessingInstruction("xml-stylesheet", "type=\"text/xslt\" href=\"standard.css\"");
		
	    
	    
	   //append doctype info; just pass in doctype name and text 
	   /*$doctypeText = "<!DOCTYPE sr:staterotation [\n\t" . 
	            "<!ELEMENT sr:staterotation   (sr:rotation+)>\n\t" . 
	              "<!ELEMENT sr:rotation        (sr:state, sr:banner)>\n\t" . 
	              "<!ELEMENT sr:state           (#PCDATA)>\n\t" . 
	              "<!ELEMENT sr:banner          (#PCDATA)>\n" . 
	            "]>)"; 
	   $doctype =& new DOMIT_DocumentType('sr:staterotation', $doctypeText); 
	   $xmldoc->appendChild($doctype);*/
	
		//create and append list element 
		$xmlDoc->appendChild($xmlDoc->createElement("books")); 
	
		foreach ($books as $book) {
			$xmlDoc->documentElement->appendChild($book->toXML(& $xmlDoc, $all));
		}	
		
		$fileAddr = "/administrator/components/com_booklibrary/exports/" . "booklibrary_" . date("Ymd_His") . ".xml";
		
		return $xmlDoc->toNormalizedString ();;
		
	}
	
	function storeExportFile($data, $type){
		global $mosConfig_live_site, $mosConfig_absolute_path, $booklibrary_configuration;
		
		$fileName = "booklibrary_" . date("Ymd_His");
		$fileBase = "/administrator/components/com_booklibrary/exports/";
		
		//write the xml file
		$fp = fopen($mosConfig_absolute_path . $fileBase . $fileName . ".xml" , "w", 0); #open for writing
  		fwrite($fp, $data); #write all of $data to our opened file
  		fclose($fp); #close the file
  		
  		
  		$InformationArray = array();
  		$InformationArray['xml_file'] = $fileName . '.xml';
  		$InformationArray['log_file'] = $fileName . '.log';
  		$InformationArray['fileBase'] = "file://" . getcwd (). "/components/com_booklibrary/exports/";
  		$InformationArray['urlBase'] = $mosConfig_live_site . $fileBase;
  		$InformationArray['out_file'] = $InformationArray['xml_file'];
  		$InformationArray['error'] = null;
  		
  		switch($type){
  			case 'csv':
	  			$InformationArray['xslt_file'] = 'csv.xsl';
	  			$InformationArray['out_file'] = $fileName . '.csv';
	  			mosBooklibraryImportExport :: transformPHP4($InformationArray);
  			break;
  			
  			default:
  			break;
  		}

		return $InformationArray;
	}

	
	function transformPHP4(&$InformationArray){

			// create the XSLT processor
			$xh = xslt_create() or die("Could not create XSLT processor");
			
			xslt_set_encoding($xh, 'ISO-8859-1');
			//xslt_set_error_handler($xh, "my_xslt_error_handler");
			
			xslt_set_base ($xh, $InformationArray['fileBase'] );
			
			// Process the document
			$result = xslt_process($xh, $InformationArray['xml_file'], $InformationArray['xslt_file'], $InformationArray['out_file']);
			
			if (!$result) {
			    // Something croaked. Show the error
			    $InformationArray['error'] = "Cannot process XSLT document: " . xslt_errno($xh) . " " . xslt_error($xh);
			} 
			
			// Destroy the XSLT processor
			xslt_free($xh);

	}
			
   function my_xslt_error_handler($handler, $errno, $level, $info)
   {
       // for now, let's just see the arguments
       var_dump(func_get_args());
   }


}
?>