<?php
/**
 * OpenSEF for Joomla!
 * @copyright (c) 2005 The OpenSEF Project (www.opensef.org)
 * @copyright (c) 2004-2005 Xaneon Development (www.xaneon.com)
 * @license GPL http://www.gnu.org/copyleft/gpl.html
 *
 * TODO
 */

/** Ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct access to this location is not allowed.' );

/*
 * TODO
 */
class xclExport {
  var $db = null;
  var $fileExt = '.txt';
  var $pathName = null;
  var $fileName = null;
  var $filePath = null;
  var $file = null;
  var $filters = null;
  var $sortField = null;

  /*
   * TODO
   */
  function xclExport( &$db, $filePath = null ) {
    $this->db =& $db;
    if (is_null( $filePath )) {
      $this->pathName = mosPathName(
        $GLOBALS['mosConfig_absolute_path'] . '/media' );
      $filePath = $this->pathName . $this->fileName;
    }
    else {
      // TODO: add support for parsing the path.
    }
    $this->filePath = $filePath;
    $this->file = fopen( $filePath, 'wb' );
  }

  /*
   * TODO
   */
  function getFileName() {
    return $this->fileName;
  }

  /*
   * TODO
   */
  function getFilePath() {
    return $this->filePath;
  }

  /*
   * TODO
   */
  function getURL() {
    // TODO: add support for other paths than /media.
    return $GLOBALS['mosConfig_live_site'] . '/media/' . $this->fileName;
  }

  /*
   * TODO
   */
  function open() {
    return ($this->file !== false);
  }

  /*
   * TODO
   */
  function close() {
    if ($this->file)
      fclose( $this->file );
  }

  /*
   * TODO
   */
  function remove() {
    // TODO: implementation.
    return false;
  }

  /*
   * TODO
   */
  function writeText( $text ) {
    if ($this->file) {
      fwrite( $this->file, $text, strlen( $text ) );
    }
  }

  /*
   * TODO
   */
  function addFilter( $where ) {
    if (is_null( $this->filters )) $this->filters = array();
    $this->filters[] = $where;
  }

  /*
   * TODO
   */
  function clearFilters() {
    $this->filters = null;
  }

  /*
   * TODO
   */
  function setSortField( $field ) {
    $this->sortField = $field;
  }
}

class xclExportCSV extends xclExport {
  var $table = null;

  /*
   * TODO
   */
  function xclExportCSV( &$db, $table, $filePath = null) {
    $this->table = $table;
    if (is_null( $filePath )) {
      $fileName = str_replace( 'com_', '', $GLOBALS['option'] );
      $fileName .= '_export_' . date( 'Ymd_His' );
      $fileName .= '.' . str_replace( '#__', '', $table ) . '.csv';
      $this->fileName = $fileName;
    }
    $this->xclExport( $db, $filePath );
  }

  /*
   * TODO
   */
  function writeText( $text ) {
    parent::writeText( '; ' . $text . "\n" );
  }

  /*
   * TODO
   */
  function exportTable() {
    // TODO: implement this.
    return false;
  }
}

/*
 * TODO
 */
class xclExportSQL extends xclExport {
  /*
   * TODO
   */
  function xclExportSQL( &$db, $filePath = null ) {
    if (is_null( $filePath )) {
      $fileName = str_replace( 'com_', '', $GLOBALS['option'] );
      $fileName .= '_export_' . date( 'Ymd_His' ) . '.sql';
      $this->fileName = $fileName;
    }
    $this->xclExport( $db, $filePath );
  }

  /*
   * TODO
   */
  function writeText( $text ) {
    parent::writeText( '# ' . $text . "\n" );
  }

  /*
   * TODO
   */
  function getTablePrefix() {
    return $this->db->_table_prefix;
  }

  /*
   * TODO
   */
  function getMetaData( $table ) {
    $db =& $this->db;
    $db->setQuery( "SHOW COLUMNS FROM $table" );
    $rows = $this->db->loadObjectList();
    if (is_array( $rows ) && count( $rows ) > 0) {
      $result = array();
      foreach ($rows as $row) {
        $field =& new stdClass();
        $field->name = $row->Field;
        $field->type = $row->Type; // TODO: strip off length
        $field->length = 0; // TODO: get length from type
        $field->isKey = !empty( $row->Key );
        $field->isPrimaryKey = ($row->Key == 'PRI');
        $field->isAutoIncrement = (strpos( $row->Extra, 'auto_increment' ) !== false);
        $field->allowNull = !(empty( $row->Null ) || $row->Null == 'NO');
        $field->defaultValue = $row->Default;
        $result[$field->name] =& $field;
      }
      return $result;
    }
    return null;
  }

  /*
   * TODO
   */
  function exportTable( $table, $title = null ) {
    $db =& $this->db;
    $metaData =& xclExportSQL::getMetaData( $table );
    if (is_null( $metaData )) return false;
    // TODO: change this to use mysql_fetch_assoc so that
    // we can export large tables with minimum memory usage.
    $query = 'SELECT * FROM ' . $table;
    if (is_array( $this->filters ))
      $query .= '';
    if (!is_null( $this->sortField ) && array_key_exists( 'id', $metaData )) {
      $query .= " ORDER BY {$this->sortField} ASC";
    }
    else if (array_key_exists( 'id', $metaData )) {
      $query .= ' ORDER BY id ASC';
    }
    $db->setQuery( $query );
    $rows = $db->loadObjectList();
    $rowCount = count( $rows );
    if (!is_null( $title )) {
      $comment = "\n# $title ($rowCount)\n";
      fwrite( $this->file, $comment, strlen( $comment ) );
    }
    foreach ($rows as $row) {
      // TODO: line ending constant?
      $query = "INSERT INTO `$table` (%s) VALUES (%s);\n";
      $fields = $values = array();
      foreach (get_object_vars( $row ) as $field => $value) {
        $fieldInfo =& $metaData[$field];
        $fields[] = "`$field`";
        if (is_null( $value ) || $value === $fieldInfo->defaultValue) {
          $values[] = ($fieldInfo->allowNull ? 'NULL' :
            "'" . $db->getEscaped( $fieldInfo->defaultValue ) . "'");
        }
        else {
          $values[] = "'" . $db->getEscaped( $value ) . "'";
        }
      }
      $query = sprintf( $query, implode( ', ', $fields ), implode( ', ', $values ) );
      fwrite( $this->file, $query, strlen( $query ) );
    }
    return $rowCount;
  }

}

?>