<?php
/*********************************************
* alphacontent - Mambo/Joomla! Component     *
* Copyright (C) 2005-2006 by  Bernard Gilly  *
* Homepage   : www.visualclinic.fr           *
* Version    : 2.2                           *
* License    : GNU/GPL                       *
*********************************************/

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

class sef_alphacontent {

	var $querystring=null;
	/**
	* Creates the SEF advance URL out of the Mambo request
	* Input: $string, string, The request URL (index.php?option=com_XXXXX&Itemid=$Itemid)
	* Output: $sefstring, string, SEF advance URL ($var1/$var2/)
	**/
	function create( $string ) {
		global $database, $config;

		$sefstring = "";		
	
		// get settings for custom string
		$ac_sef_alpha = ( $config->ac_sef_subs_alpha != '' ) ? $config->ac_sef_subs_alpha : 'listalpha' ;
		$ac_sef_sort = ( $config->ac_sef_subs_sort != '' ) ? $config->ac_sef_subs_sort : 'sort' ;
		$ac_sef_limit = ( $config->ac_sef_subs_limit != '' ) ? $config->ac_sef_subs_limit : 'limit' ;
		$ac_sef_limitstart = ( $config->ac_sef_subs_limitstart != '' ) ? $config->ac_sef_subs_limitstart : 'start' ;
		$ac_sef_com_using = ($config->ac_sef_com_using != '' ) ? $config->ac_sef_com_using : '0' ;
		
		//*****************************************
		// Sorting & limit & limitstart
		//*****************************************
		if (eregi("&amp;sort=",$string)) {
			$sefstring .= $ac_sef_sort.'/';
			// Get sorting
			$temp = split("&amp;sort=", $string);
			$temp = split("&", $temp[1]);
			$sefstring .= $temp[0] . '/';	
			
			if (eregi("&amp;limit=",$string)) {
				$sefstring .= $ac_sef_limit.'/';
				// Get limit
				$temp = split("&amp;limit=", $string);
				$temp = split("&", $temp[1]);
				$sefstring .= $temp[0] . '/';	
			}
			
			if (eregi("&amp;limitstart=",$string)) {
				$sefstring .= $ac_sef_limitstart.'/';
				// Get limitstart
				$temp = split("&amp;limitstart=", $string);
				$temp = split("&", $temp[1]);
				$sefstring .= $temp[0] . '/';	
			}
		}
		//*****************************************
		// ALPHA
		//*****************************************
		if (eregi("&amp;alpha=",$string)) {
			$sefstring .= $ac_sef_alpha.'/';
			// Get letter alphabet
			$temp = split("&amp;alpha=", $string);
			$temp = split("&", $temp[1]);
			$sefstring .= $temp[0] . '/'; 
		}	
		//*****************************************
		// SECTION
		//*****************************************
		if (eregi("&amp;section=",$string)) {
			// Get Section Name by Id
			$temp = split("&amp;section=", $string);
			$temp = split("&", $temp[1]);
			$sect = $temp[0];			
			$database->setQuery( "SELECT title FROM #__sections WHERE id='".$sect."'" );
			$sect_name = $database->loadResult();
			$sect_name = ac_sefcode($sect_name, 'encode', $ac_sef_com_using);
			$sefstring .= $sect_name . '/';
				//*****************************************
				// CATEGORY
				//*****************************************
				// Get Category Name by Id
				if (eregi("&amp;cat=",$string)) {
					$temp = split("&amp;cat=", $string);
					$temp = split("&", $temp[1]);
					$cat = $temp[0];			
					$database->setQuery( "SELECT title FROM #__categories WHERE id='".$cat."' " );
					$cat_name = $database->loadResult();
					$cat_name = ac_sefcode($cat_name, 'encode', $ac_sef_com_using);
					$sefstring .= $cat_name . '/';
				}
		}	

		return $sefstring;	
		
	}
	
	/**
	* Reverts to the Mambo query string out of the SEF advance URL
	* Input:
	*    $url_array, array, The SEF advance URL split in arrays (first custom virtual directory beginning at $pos+1)
	*    $pos, int, The position of the first virtual directory (component)
	* Output: $QUERY_STRING, string, Mambo query string (var1=$var1&var2=$var2)
	*    Note that this will be added to already defined first part (option=com_example&Itemid=$Itemid)
	**/
	function revert ($url_array, $pos) {
		// define all variables you pass as globals
		global $database, $mosConfig_absolute_path, $alpha, $section, $cat, $sort, $limit, $limitstart;
		
		// force a new class of settings for function revert
		require( $mosConfig_absolute_path.'/administrator/components/com_alphacontent/alphacontent_config_sef.php' );
		$config_revert =  new alphaConfigSEF;
	
		// get settings
		$ac_sef_alpha = ( $config_revert->ac_sef_subs_alpha != '' ) ? $config_revert->ac_sef_subs_alpha : 'listalpha' ;
		$ac_sef_sort = ( $config_revert->ac_sef_subs_sort != '' ) ? $config_revert->ac_sef_subs_sort : 'sort' ;
		$ac_sef_limit = ( $config_revert->ac_sef_subs_limit != '' ) ? $config_revert->ac_sef_subs_limit : 'limit' ;
		$ac_sef_limitstart = ( $config_revert->ac_sef_subs_limitstart != '' ) ? $config_revert->ac_sef_subs_limitstart : 'start' ;
		$ac_sef_com_using = ($config_revert->ac_sef_com_using != '' ) ? $config_revert->ac_sef_com_using : '0' ;
		
 		// Examine the SEF advance URL and extract the variables building the query string	
		$QUERY_STRING = "";

		// sorting & limit & start
		if (isset($url_array[$pos+2]) && $url_array[$pos+2]!="" && $url_array[$pos+2]==$ac_sef_sort) {		
			$sort = $url_array[$pos+3];
			$_REQUEST['sort'] = $_GET['sort'] = $sort ;
			$QUERY_STRING .= "&sort=$sort";
			
			if (isset($url_array[$pos+4]) && $url_array[$pos+4]!="" && $url_array[$pos+4]==$ac_sef_limit) {
				$limit = $url_array[$pos+5];
				$_REQUEST['limit'] = $_GET['limit'] = $limit ;
				$QUERY_STRING .= "&limit=$limit";
			}			
			
			if (isset($url_array[$pos+6]) && $url_array[$pos+6]!="" && $url_array[$pos+6]==$ac_sef_limitstart) {
				$limitstart = $url_array[$pos+7];
				$_REQUEST['limitstart'] = $_GET['limitstart'] = $limitstart ;
				$QUERY_STRING .= "&limitstart=$limitstart";
			}			
			
			if (isset($url_array[$pos+8]) && $url_array[$pos+8]!="" && $url_array[$pos+8]==$ac_sef_alpha) {
				$alpha = $url_array[$pos+9];
				$_REQUEST['alpha'] = $_GET['alpha'] = $alpha ;
				$QUERY_STRING .= "&alpha=$alpha";
			}
			
			if (isset($url_array[$pos+8]) && $url_array[$pos+8]!="" && $url_array[$pos+8]!=$ac_sef_alpha) {
				$section = ac_sefcode($url_array[$pos+8], 'decode', $ac_sef_com_using);
				$database->setQuery( "SELECT id FROM #__sections WHERE title='".$section."'" );
				$section_id = $database->loadResult();
				$_REQUEST['section'] = $_GET['section'] = $section_id;
				$QUERY_STRING .= "&section=$section_id";
				
				if (isset($url_array[$pos+9]) && $url_array[$pos+9]!="") {
					$cat = ac_sefcode($url_array[$pos+9], 'decode', $ac_sef_com_using);
					$database->setQuery( "SELECT id FROM #__categories WHERE title='".$cat."'" );
					$cat_id = $database->loadResult();
					$_REQUEST['cat'] = $_GET['cat'] = $cat_id;
					$QUERY_STRING .= "&cat=$cat_id";
				}
				
			}
		}elseif (isset($url_array[$pos+2]) && $url_array[$pos+2]!="" && $url_array[$pos+2]!=$ac_sef_sort) {		
			// not sorting			
			if (isset($url_array[$pos+2]) && $url_array[$pos+2]!="" && $url_array[$pos+2]==$ac_sef_alpha) {
				$alpha = $url_array[$pos+3];				
				$_REQUEST['alpha'] = $_GET['alpha'] = $alpha ;
				$QUERY_STRING .= "&alpha=$alpha";
			}	
			if (isset($url_array[$pos+2]) && $url_array[$pos+2]!="" && $url_array[$pos+2]!=$ac_sef_alpha) {
				$section = $url_array[$pos+2];
				$section = ac_sefcode( $section, 'decode', $ac_sef_com_using);
				$database->setQuery( "SELECT id FROM #__sections WHERE title='".$section."'" );
				$section_id = $database->loadResult();				
				$_REQUEST['section'] = $_GET['section'] = $section_id;
				$QUERY_STRING .= "&section=$section_id";
							
				if (isset($url_array[$pos+3]) && $url_array[$pos+3]!="") {
					$cat = $url_array[$pos+3];
					$cat = ac_sefcode($cat, 'decode', $ac_sef_com_using);
					$database->setQuery( "SELECT id FROM #__categories WHERE title='".$cat."'" );
					$cat_id = $database->loadResult();					
					$_REQUEST['cat'] = $_GET['cat'] = $cat_id;
					$QUERY_STRING .= "&cat=$cat_id";
				}
			}
		}
		
		return $QUERY_STRING;
	}
}

	/**
 	* function for sefencode or sefdecode
	**/
	function ac_sefcode($ac_sef_string, $ac_sef_action, $ac_sef_com_using){
		global $sefConfig, $sufix, $longurl;
		
		switch( $ac_sef_com_using ){	
			case '0':  // SEF Advance 
				switch($ac_sef_action){ // sefencode or sefdecode
					case 'encode':
					$ac_sef_string = sefencode($ac_sef_string);
					break;				
					case 'decode':
					$ac_sef_string = sefdecode($ac_sef_string);
					break;
				}	
				break;		
			case '1':  // OpenSEF
				switch($ac_sef_action){ // sefencode or sefdecode
					case 'encode':
					$ac_sef_string = ac_sefencode($ac_sef_string);
					break;				
					case 'decode':
					$ac_sef_string = ac_sefdecode($ac_sef_string);
					break;
				}	
				break;
			case '2':  // Internal : This sef_ext.php not used !		
				break;	
		}
		return $ac_sef_string;
	}
	
function ac_sefencode($string) {
	global $sefConfig, $sufix, $lowercase, $url_exception;
	
	if (empty($sefConfig)) {
		$ext_suffix = $sufix;
		$ext_space = _SEF_SPACE;
		$ext_lower = $lowercase;
		$ext_strip = $url_exception;
		foreach ($url_replace as $key => $val) {
			array_push($ext_characters,$key);
			array_push($ext_replacements,$val);
		}
		
	} else {
		$ext_suffix = $sefConfig->encode_page_suffix;
		$ext_space = $sefConfig->encode_space_char;
		$ext_lower = $sefConfig->encode_lowercase;
		$ext_strip = explode(',',$sefConfig->encode_strip_chars);
		$ext_characters = explode(',',$sefConfig->spec_chars_d);
		$ext_replacements = explode(',',$sefConfig->spec_chars);
	}
	
	$string = str_replace($ext_characters,$ext_replacements,$string);
	$string = urlencode($string);
	$string = eregi_replace("%2F", "%10", $string);
	$string = eregi_replace($ext_space, "%11", $string);
	$string = eregi_replace("\+", $ext_space, $string);
	$string = eregi_replace("%2C", "", $string);
	foreach ($ext_strip as $value) {
		if ($value) 
			$string = ereg_replace(urlencode($value), '', $string);
			//$string = ereg_replace(urlencode($value), $value, $string);
	}
	if ($ext_lower) {
		$string = strtolower($string);
	}
	return $string;
}
/**
 * Get back to original string
 *
 * @param string $string
 * @return decoded string
 */
function ac_sefdecode($string) {
	global $sefConfig, $sufix;
	
	if (empty($sefConfig)) {
		$ext_suffix = $sufix;
		$ext_space = _SEF_SPACE;
		foreach ($url_replace as $key => $val) {
			array_push($ext_characters,$key);
			array_push($ext_replacements,$val);
		}
		
	} else {
		$ext_suffix = $sefConfig->encode_page_suffix;
		$ext_space = $sefConfig->encode_space_char;
		$ext_characters = explode(',', $sefConfig->spec_chars_d);
		$ext_replacements = explode(',', $sefConfig->spec_chars);
	}
	
	$string = eregi_replace($ext_suffix, "", $string);
	$string = eregi_replace($ext_space, "%20", $string);
	$string = eregi_replace("%11", $ext_space, $string);
	$string = eregi_replace("%10", "%2F", $string);
	$string = urldecode($string);
	$string = str_replace($ext_replacements, $ext_characters, $string);
	$string = addslashes($string);
	
	return $string;
}
?>