<?php
/**
 * @package OpenSEF for Joomla!
 * @copyright (c) 2005 The OpenSEF Project (www.opensef.org)
 * @copyright (c) 2004-2005 Xaneon Development (www.xaneon.com)
 * @license GPL http://www.gnu.org/copyleft/gpl.html
 *
 * These are default implementations for the core functions of OpenSEF; it
 * might be called the OpenSEF Core API. It's expected that any code which
 * needs to make use of OpenSEF's functionality will include this file.
 *
 * Note that this is designed in a fashion which allows site admins and 3PD
 * developers to develop their own add-ons that extend or replace the OpenSEF
 * core, or do additional URL handling according to fully custom rules.
 *
 * To override the default implementation of an OpenSEF core function, just
 * create a new core extension file and implement a identically named function
 * there. Your core extension will take precedence over the functions defined
 * here.
 *
 */

/** Ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct access to this location is not allowed.' );

// OPENSEF CORE FUNCTIONS

if (!function_exists( 'sefLoadSecurityHandler' )) {
  /*
   * TODO
   */
  function sefLoadSecurityHandler( &$db, &$config, &$site ) {
    if (!defined( '_SECURITY_HANDLER' ))
      require_once( 'core/sef.security.php' ); // Default security handler
    $className = constant( '_SECURITY_HANDLER' );
    $securityHandler =& new $className( $db, $config, $site );
    $securityHandler->setDebug( !empty( $config->debug ) );
    return $securityHandler;
  }
}

if (!function_exists( 'sefLoadResolver' )) {
  /*
   * TODO
   */
  function sefLoadResolver( &$db, &$config, &$site ) {
    if (!defined( '_SEF_RESOLVER' ))
      require_once( 'core/sef.resolver.php' ); // Default resolver
    $className = constant( '_SEF_RESOLVER' );
    $resolver =& new $className( $db, $config, $site );
    $resolver->setDebug( !empty( $config->debug ) );
    return $resolver;
  }
}

if (!function_exists( 'sefLoadRewriter' )) {
  /*
   * TODO
   */
  function sefLoadRewriter( &$db, &$config, &$site ) {
    if (!defined( '_SEF_REWRITER' ))
      require_once( 'core/sef.rewriter.php' ); // Default rewrite
    $className = constant( '_SEF_REWRITER' );
    $rewriter =& new $className( $db, $config, $site );
    $rewriter->setDebug( !empty( $config->debug ) );
    return $rewriter;
  }
}

if (!function_exists( 'sefLoadAutoMapper' )) {
  /*
   * TODO
   */
  function sefLoadAutoMapper( &$db, &$config, &$site ) {
    if (!defined( '_SEF_AUTOMAPPER' ))
      require_once( 'core/sef.mapper.php' ); // Default auto-mapper
    $className = constant( '_SEF_AUTOMAPPER' );
    $autoMapper =& new $className( $db, $config, $site );
    $autoMapper->setDebug( !empty( $config->debug ) );
    return $autoMapper;
  }
}

if (!function_exists( 'sefLoadExtension' )) {
  /*
   * TODO
   */
  function sefLoadExtension( $component ) {
    global $sefConfig;
    // TODO: PHP5 will have autoloading support, probably rendering this
    // function pretty much obsolete if we can take advantage of it.

    if (class_exists( 'sef_' . $component ))
      return true; // Already loaded

    $path = $GLOBALS['mosConfig_absolute_path'];
    $paths = array(
      "$path/administrator/components/com_sef/extensions/sef_ext.$component.php",
      "$path/administrator/components/com_$component/sef_ext.php",
      "$path/components/com_$component/sef_ext.php",
    );

    // We check whether the file exists, is readable, that it's not empty,
    // and then after loading that the class really exists; this is pretty
    // fail-safe and will move on to the next possible file if one doesn't
    // satisfy any of these conditions.
    // Performance note: PHP caches the results of calling file_exists,
    // is_readable, etc., meaning the tests will be quite cheap in practice.
    $debug = !empty( $sefConfig->debug );
    foreach ($paths as $path) {
      if (file_exists( $path ) && is_readable( $path ) && filesize( $path ) > 0) {
        if (!$debug) ob_start();
        @include_once( $path );
        if (!$debug) ob_end_clean();
        if (class_exists( 'sef_' . $component ))
          return true;
      }
    }

    return false;
  }
}

// SEF CORE FUNCTIONS

if (!function_exists( 'sefEncode' )) {
  /*
   * This is used by components that provide a SEF Advance extension.
   */
  function sefEncode( $string ) { return urlencode( $string ); }
}

if (!function_exists( 'sefDecode' )) {
  /*
   * This is used by components that provide a SEF Advance extension.
   */
  function sefDecode( $string ) { return urldecode( $string ); }
}

if (!function_exists( 'sefRelToAbs' )) {
  /*
   * Rewrite internal URL to OpenSEF URL.
   * Replaces the core Joomla! function in includes/sef.php.
   */
  function sefRelToAbs( $string ) {
    global $sefRewriter;
    if (!isset( $sefRewriter ) || !is_object( $sefRewriter )) {
      global $database, $sefConfig, $sefSite;
      $sefRewriter = sefLoadRewriter( $database, $sefConfig, $sefSite );
    }
    return $sefRewriter->rewrite( $string );
  }
}

if (!function_exists( 'sefIsJoomlaSEF' )) {
  /*
   * Determines whether a given URL is in the native Joomla! SEF format.
   */
  function sefIsJoomlaSEF( $url ) {
    if ($url[0] == '/') $url = substr( $url, 1 );
    return (eregi( '^content/', $url )
      || eregi( '^wrapper/', $url )
      || eregi( '^weblinks/', $url )
      || eregi( '^newsfeeds/', $url )
      || eregi( '^contact/', $url )
      || eregi( '^component/.*option,com_', $url ));
  }
}

if (!function_exists( 'sefIsJoomlaURL' )) {
  /*
   * Determines whether a given URL is an internal Joomla! URL address.
   */
  function sefIsJoomlaURL( $url ) {
    if ($url[0] == '/') $url = substr( $url, 1 );
    return (eregi( '^index.php', $url )
      || eregi( '^index2.php', $url ));
  }
}

if (!function_exists( 'sefIsExternalURL' )) {
  /*
   * Determines whether a given URL is a full, absolute URL including the
   * 'http://' prefix.
   */
  function sefIsExternalURL( $url ) {
    return (eregi( '^(http|https|ftp)\://', $url ) ? true : false);
  }
}

if (!function_exists( 'sefRewriteToJoomlaSEF' )) {
  /*
   * Rewrites an internal Joomla! URL into Joomla!'s native SEF format.
   */
  function sefRewriteToJoomlaSEF( $url, $path = null ) {
  	global $sefConfig;
    $component = null;
    if (ereg( '[\?&]+option=com_([0-9a-zA-Z_\-]+)&', $url, $matches ))
      $component = $matches[1];
    $menu_id = 0;
    if (ereg( '&Itemid=([0-9]+)', $url, $matches ))
      $menu_id = $matches[1];
    if ($component == 'content') {
      $rewrites = array(
        '#^index\.php\?option=com_content#' => 'content',
        '#&([\w]+)=([\w\d]+)#'  => '/\\2',
        '#([^/])$#'             => '\\1/', // Add trailing slash if necessary
      );
    }
    elseif ($component == 'wrapper') {
    	$rewrites = array(
        '#^index\.php\?option=com_wrapper#' => 'wrapper',
        '#&([\w]+)=([\w\d]+)#'  => '/\\2',
        '#([^/])$#'             => '\\1/', // Add trailing slash if necessary
      	);
    }
    elseif ($component == 'weblinks') {
    	$rewrites = array(
        '#^index\.php\?option=com_weblinks#' => 'weblinks',
        '#&([\w]+)=([\w\d]+)#'  => '/\\2',
        '#([^/])$#'             => '\\1/', // Add trailing slash if necessary
      	);
    }
    elseif ($component == 'newsfeeds') {
    	$rewrites = array(
        '#^index\.php\?option=com_newsfeeds#' => 'newsfeeds',
        '#&([\w]+)=([\w\d]+)#'  => '/\\2',
        '#([^/])$#'             => '\\1/', // Add trailing slash if necessary
      	);
    	
    }
    elseif ($component == 'contact') {
    	$rewrites = array(
        '#^index\.php\?option=com_contact#' => 'contact',
        '#&([\w]+)=([\w\d]+)#'  => '/\\2',
        '#([^/])$#'             => '\\1/', // Add trailing slash if necessary
      	);
    }
    else {
      $path = ($path ? $path : 'component/option,com_' .
        $component . '/Itemid,' . $menu_id . '/');
      $rewrites = array(
        '#^index\.php#'         => '',
        "#[\?&]+option=com_$component#" => '',
        '#[\?&]+Itemid=([\d]+)#' => '',
        '#\?#'                  => '&',
        '#&([\w]+)=([^&]+)#'    => '/\\1,\\2',
        '#^[/]?#'               => $path, // Consume one slash and prepend component path
        '#([^/])$#'             => '\\1/', // Add trailing slash if necessary
      );
    }
    return preg_replace( array_keys( $rewrites ),
      array_values( $rewrites ), $url );
  }
}

if (!function_exists( 'sefRewriteFromJoomlaSEF' )) {
  /*
   * Rewrites a native Joomla! SEF URL into an internal Joomla! URL.
   */
  function sefRewriteFromJoomlaSEF( $url ) {
    if ($url[0] == '/') $url = substr( $url, 1 );
    if (ereg( '^content/', $url ) && !ereg( '/category/', $url ) && !ereg( '/blogcategory/', $url )) {
      $rewrites = array(
        '#^content#'           => '',
        
        '#/([^/]+)/([^/]+)/([^/]+)/([^/]+)/([^/]+)/#' =>
          '&task=\\1&id=\\2&Itemid=\\3&limit=\\4&limitstart=\\5',
     
        '#/([^/]+)/([^/]+)/([^/]+)/([^/]+)/#' =>
          '&task=\\1&year=\\2&month=\\3&module=\\4',
                
        '#/([^/]+)/([^/]+)/([^/]+)/#' => '&task=\\1&id=\\2&Itemid=\\3',
        '#/([^/]+)/([^/]+)/#'   => '&task=\\1&id=\\2',
        '#/([^/]+)/#'           => '&task=\\1',
        '#^#'                   => 'index.php?option=com_content',
      );
    }
    elseif (ereg( '^content/', $url ) && ereg( '/blogcategory/', $url ) ) {
       $rewrites = array(
        '#^content#'           => '',
         
        '#/([^/]+)/([^/]+)/([^/]+)/([^/]+)/([^/]+)/#' =>
          '&task=\\1&id=\\2&Itemid=\\3&count=\\4&intro=\\5',      

        '#/([^/]+)/([^/]+)/([^/]+)/#' => '&task=\\1&id=\\2&Itemid=\\3',
        '#/([^/]+)/([^/]+)/#'   => '&task=\\1&id=\\2',
        '#/([^/]+)/#'           => '&task=\\1',
        '#^#'                   => 'index.php?option=com_content',
    
      );
    }
       
    elseif (ereg( '^content/', $url ) && ereg( '/category/', $url ) ) {
       $rewrites = array(
        '#^content#'           => '',
        
        '#/([^/]+)/([^/]+)/([^/]+)/([^/]+)/([^/]+)/([^/]+)/#' =>
          '&task=\\1&sectionid=\\2&id=\\3&Itemid=\\4&limit=\\5&limitstart=\\6',
        '#/([^/]+)/([^/]+)/([^/]+)/([^/]+)/#' =>
          '&task=\\1&sectionid=\\2&id=\\3&Itemid=\\4',  
        '#/([^/]+)/([^/]+)/([^/]+)/#' => '&task=\\1&id=\\2&Itemid=\\3',
        '#/([^/]+)/([^/]+)/#'   => '&task=\\1&id=\\2',
        '#/([^/]+)/#'           => '&task=\\1',
        '#^#'                   => 'index.php?option=com_content',
    
      );
    }
    elseif (ereg( '^wrapper/', $url ) ) {
     $rewrites = array(
        '#^wrapper#'           => '',
      
        '#/([^/]+)/([^/]+)/([^/]+)/([^/]+)/#' => '&task=\\1&catid=\\2&id=\\3&Itemid=\\4',
        '#/([^/]+)/([^/]+)/([^/]+)/#' => '&task=\\1&catid=\\2&id=\\3',
        '#/([^/]+)/([^/]+)/#'   => '&catid=\\1&Itemid=\\2',
        '#/([^/]+)/#'           => '&Itemid=\\1',
        '#^#'                   => 'index.php?option=com_wrapper',
    
      );
    }
    elseif (ereg( '^weblinks/', $url ) ) {
      $rewrites = array(
        '#^weblinks#'           => '',
      
        '#/([^/]+)/([^/]+)/([^/]+)/([^/]+)/#' => '&task=\\1&catid=\\2&id=\\3&Itemid=\\4',
        '#/([^/]+)/([^/]+)/([^/]+)/#' => '&task=\\1&catid=\\2&id=\\3',
        '#/([^/]+)/([^/]+)/#'   => '&catid=\\1&Itemid=\\2',
        '#/([^/]+)/#'           => '&Itemid=\\1',
        '#^#'                   => 'index.php?option=com_weblinks',
    
      );
    }
    elseif (ereg( '^newsfeeds/', $url ) ) {
       $rewrites = array(
        '#^newsfeeds#'           => '',
      
        '#/([^/]+)/([^/]+)/([^/]+)/#' => '&task=\\1&feedid=\\2&Itemid=\\3',
        '#/([^/]+)/([^/]+)/#'   => '&catid=\\1&Itemid=\\2',
        '#/([^/]+)/#'           => '&Itemid=\\1',
        '#^#'                   => 'index.php?option=com_newsfeeds',
    
      );
    }
    elseif (ereg( '^contact/', $url ) ) {
       $rewrites = array(
        '#^contact#'           => '',
        '#/([^/]+)/([^/]+)/([^/]+)/#' => '&task=\\1&contact_id=\\2&Itemid=\\3',
        '#/([^/]+)/([^/]+)/#'   => '&catid=\\1&Itemid=\\2',
        '#/([^/]+)/#'           => '&Itemid=\\1',
        '#^#'                   => 'index.php?option=com_contact',
    
      );
    }
    else if (ereg( '^component/', $url )) {
      // Now this is pretty simple. Removed the earlier assumptions about the
      // 'option' parameter being the first, as phpShop among other doesn't
      // stick to any particular convention.
      $rewrites = array(
        '#^component/([^,]+),([^/]+)#' => 'index.php?\\1=\\2',
        '#/([^,]+),([^/]+)#'    => '&\\1=\\2',
        '#/$#'                  => '',
      );
    }
    return preg_replace( array_keys( $rewrites ),
      array_values( $rewrites ), $url );
  }
}

?>