
<?php

defined('_VALID_MOS') or die('Direct Access to this location is not allowed.');

require_once ($mosConfig_absolute_path . "/administrator/components/com_booklibrary/nusoap/nusoap.php");


/**
* Booklibrary Webservice Class
* @package Booklibrary
* @copyright 2005 Gerd Saurer http://booklibrary.mamboforge.net
* @license http://www.gnu.org/copyleft/gpl.html GNU Public License
* @version $Revision: 1.0 $
*/
class mosBooklibraryWS{

	/**
	 * Catching Informations from array - in the correct language
	 * @return array that contains all Output from getWSArray() including the
	 * possibility that user can input the information directly
	 */
	function getArray(){
		$help = mosBooklibraryWS::getWSArray();
		$help1 = array();
		array_push($help1, array(0, _BOOKLIBRARY_WS_NO, ""));
		return array_merge($help1, $help);
	}
	
	
	/**
	 * Catching WS Informations array
	 * @return array containing all possible WS and their settings
	 */
	function getWSArray(){
		$retVal = array();
		array_push($retVal, array(1, _BOOKLIBRARY_AMAZON_COM, "com"));
		array_push($retVal, array(2, _BOOKLIBRARY_AMAZON_UK, "uk"));
		array_push($retVal, array(3, _BOOKLIBRARY_AMAZON_DE, "de"));
		array_push($retVal, array(4, _BOOKLIBRARY_AMAZON_JP, "jp"));
		array_push($retVal, array(5, _BOOKLIBRARY_AMAZON_FR, "fr"));
		array_push($retVal, array(6, _BOOKLIBRARY_AMAZON_CA, "ca"));
		return $retVal;
	}
	
	
	/**
	 * feching the information depending on the informations already in the
	 * $book parameter if parameter is set to insert informations on your own
	 * nothing is done, 
	 * @param booklibrary.class.php $book the all informations that are already
	 * known of this book - $informationFrom must be set at least
	 * @return booklibrary.class.php including all informations that should be
	 * added by webservices
	 */
	function fetchInfos($book){
		if(intval($book->informationFrom) != 0 ){
			//Amazon WS
			return mosBooklibraryWS::fetchAmazonInfos($book);
		} else {
			//information are laready provided by the user
			return $book;
		}
	}

	/**
	 * fechs the information from a webservice depending on the $informationFrom
	 * variable set in the $book
	 * @param booklibrary.class.php $book the all informations that are already
	 * known of this book - $informationFrom must be set at least
	 * @return booklibrary.class.php including all informations that should be
	 * added by webservices
	 * @global string $booklibrary_configuration
	 * @todo check if Release Date works!!
	 * @todo check if Edition Works
	 */
	function fetchAmazonInfos($book){
		global $booklibrary_configuration;
		
		$client = new soapclient('http://soap.amazon.com/onca/soap2', 
									false, 
									$booklibrary_configuration['proxy']['host'], 
									$booklibrary_configuration['proxy']['port'], 
									$booklibrary_configuration['proxy']['user'], 
									$booklibrary_configuration['proxy']['pwd']);
		$client->xml_encoding = "UTF-8";
		$client->useHTTPPersistentConnection();
		$param_ws = mosBooklibraryWS::getWsParamById($book->informationFrom);
		$param = array ('asin' => $book->isbn, 
						'page' => '1', 
						'mode' => 'books', 
						'tag' => $booklibrary_configuration['ws']['amazon']['tag'], 
						'type' => 'heavy', 
						'devtag' => $booklibrary_configuration['ws']['amazon']['devtag'], 
						'locale' => $param_ws);

		$params = array ('AsinSearchRequest' => new soapval('AsinSearchRequest', 
															'AsinRequest', 
															$param, 
															false, 
															'http://soap.amazon.com'));
		$result = $client-> call('AsinSearchRequest', 
								$params, 
								'http://soap.amazon.com', 
								'http://soap.amazon.com');
								
		if ($client->fault) {
			return "No object!";
		} else {
			$err = $client->getError();
			if ($err) {
				$retVal = $err;
				if(count($booklibrary_configuration['proxy']['host']) > 0){				
					$retVal = $retVal . "</br>Porxy Settings activated!";
				}
				return $retVal;
			} else {
				
				$result = $result["Details"]["0"];
				
				if(array_key_exists('Status', $result)){
					return $result["Status"];
				}
				
				$book->title = $result["ProductName"];
				$book->imageURL = $result["ImageUrlMedium"];
				$book->URL = $result["Url"];
				if(array_key_exists('Manufacturer', $result)){				
					$book->manufacturer = $result["Manufacturer"];
				}
				$book->authors = "";
				foreach ($result["Authors"] as $author){
					if(strlen($book->authors) > 0){
						$book->authors = $book->authors . " , " . $author;
					} else {
						$book->authors = $author;
					}
				}
				if(array_key_exists('Reviews', $result)){
					$book->rating = $result["Reviews"]["AvgCustomerRating"] * 2;
				}
				if(array_key_exists('ReleaseDate', $result)){
					$book->release_Date = $result["ReleaseDate"];
				}
				$book->edition = $result["Media"];
				if(array_key_exists('OurPrice', $result)){
					$book->price = $result["OurPrice"];
				}				
				return $book;
			}
		}
	}
	
	/**
	 * Get the name of the WS by the id
	 * @param int $id the id of the WS-Name that should be returned
	 * @return string the name of the WS or null if it can't be found
	 */	
	function getWsNameById($id){	
		$services = mosBooklibraryWS::getArray();
		for($i=0, $n=count($services); $i < $n; $i++){
			if(intval($services[$i][0]) == intval($id)){
				return $services[$i][1];
			}		
		}	
		return null;		
	}

	/**
	 * Get the parameter of the WS by the id
	 * @param int $id the id of the WS-pram that should be returned
	 * @return string the parameter of the WS or null if it can't be found
	 */		
	function getWsParamById($id){
		$services = mosBooklibraryWS::getArray();
		for($i=0, $n=count($services); $i < $n; $i++){
			if(intval($services[$i][0]) == intval($id)){
				return $services[$i][2];
			}		
		}	
		return null;	
	}
}
?>