<?php
/**
* Show Jobs shows job postings from the Jobline component.
* @package Mambo Open Source
* @Copyright (C) 2005 Olle Johansson
* @ All rights reserved
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
**/

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );


if ( !defined( '_OJ_SHOWJOBS_MODULE' ) ) {
	define( '_OJ_SHOWJOBS_MODULE', 1 );

	function modShowJobs( &$params ) {
		global $mosConfig_offset, $database;

        // Sanity check on column field, needs to be at least 1.
		$columns = $params->get( 'columns' );
		if ( !$columns ) {
			$columns = 1;
		}

		$count = intval( $params->get( 'count' ) );

        // Set up what to order by
		$ascordesc = ( $params->get( 'sortreverse' ) ) ? "DESC" : "ASC";
		switch( $params->get( 'sortby' ) ) {
			case "date": $orderby = "created"; break;
			case "title": $orderby = "title"; break;
			case "hits": $orderby = "hits"; break;
			default: $orderby = "ordering";
		}

		$query = "SELECT id, title, hits, description"
			. "\nFROM #__jl_jobposting"
			. "\nWHERE state = 1"
			. "\nORDER BY $orderby $ascordesc LIMIT $count";
		$database->setQuery( $query );
		$rows = $database->loadObjectList();
		$rowcount = count( $rows );

		$tablerows = ceil( $rowcount / $columns );

        // cycle through the returned rows displaying them in a table
        // with links to the content item
        // escaping in and out of php is now permitted
?>
<?php echo $params->get( 'pretext' ); ?>
<table cellpadding="0" cellspacing="0" border="0" width="100%">
<tr>
<?php for ( $j = 0, $i = 0; $j < $columns; $j++ ) { ?>
<?php $start = $j * $tablerows; ?>
<td valign="top">

<table cellpadding="1" cellspacing="1" border="0">
<?php for ( $i = $start, $k = 0; $i < $rowcount && $k < $tablerows; $i++, $k++ ) { ?>
<?php $row = $rows[$i]; ?>
	<tr>
		<td valign="top"><?php echo $params->get( 'preitem' ); ?></td>
		<td>
          <a href="<?php echo sefRelToAbs( "index.php?option=com_jobline&amp;task=view&amp;id=$row->id" ); ?>"><?php echo $row->title ?></a>
		  <?php if ( $params->get( 'showhits') ) { echo "($row->hits)"; } ?>
		  <?php if ( $params->get( 'showdescr') ) { echo "<br />$row->description"; } ?>
          <?php echo $params->get( 'postitem' ); ?>
        </td>
	</tr>
<?php
}
?>
</table>

</td>
<?php } ?>
</tr>
</table>

<?php echo $params->get( 'posttext' ); ?>

<?php

	}
}

// get params definitions
#$params =& new mosParameters( $menu->params );

$params->def( 'count', 5 );
$params->def( 'showhits', 0 );
$params->def( 'showdescr', 0 );
$params->def( 'sortreverse', 0 );
$params->def( 'sortby', 'title' );
$params->def( 'preitem', '' );
$params->def( 'postitem', '' );
$params->def( 'pretext', '' );
$params->def( 'posttext', '' );
$params->def( 'columns', 1 );

// Call the function to show the jobs.
 modShowJobs( $params );

?>