<?php
/**
* OpenSEF for Joomla!
* @copyright (c) 2005 The OpenSEF Project (www.opensef.org)
* @copyright (c) 2004-2005 Xaneon Development (www.xaneon.com)
* @license GPL http://www.gnu.org/copyleft/gpl.html
*/

require_once( 'Savant2/Plugin.php' );

class Savant2_Plugin_Joomla extends Savant2_Plugin {

  function plugin( $funcName, $params = array() )
  {
    switch ($funcName) {
      case 'publishToggle':
        if (count( $params ) < 4) $params[] = false;
        list($rowNo, $fieldName, $currentValue, $invert) = $params;
        return $this->publishToggle( $rowNo, $fieldName, $currentValue, $invert );
      case 'accessToggle':
        list($rowNo, $fieldName, $currentValue) = $params;
        return $this->accessToggle( $rowNo, $fieldName, $currentValue );
      case 'reorderButtons':
        list($rowNo, $direction) = $params;
        return $this->reorderButtons( $rowNo, $direction );
    }
  }

  function reorderButtons( $rowNo, $direction ) {
    $title = ($direction == 'up' ? _T( 'MOVE_UP' ) : _T( 'MOVE_DOWN' ));
    ?>
      <a href="#reorder" onClick="return listItemTask('cb<?php echo $rowNo ?>','order<?php echo $direction ?>')" title="<?php echo $title ?>"><img
        src="images/<?php echo $direction ?>arrow.png" width="12" height="12" border="0" alt="<?php echo $title ?>"></a>
    <?php
  }

  function publishToggle( $rowNo, $fieldName, $currentValue, $invert = false ) {
    if ((!$invert && $currentValue == '1') || ($invert && $currentValue == '0')) {
      $action = $fieldName . ',' . (!$invert ? '0' : '1');
    ?>
      <?php if ($fieldName): ?><a href="#" onclick="return listItemTask('cb<?php echo $rowNo ?>', 'set<?php echo $action ?>');"><?php endif; ?><img
        alt="<?php echo _T( 'PUBLISHED' ) ?>" src="images/tick.png"
        width="12" height="12" border="0" /><?php if ($fieldName): ?></a><?php endif; ?>
    <?php
    }
    else {
      $action = $fieldName . ',' . (!$invert ? '1' : '0');
    ?>
      <?php if ($fieldName): ?><a href="#" onclick="return listItemTask('cb<?php echo $rowNo ?>', 'set<?php echo $action ?>');"><?php endif; ?><img
        alt="<?php echo _T( 'UNPUBLISHED' ) ?>" src="images/publish_x.png"
        width="12" height="12" border="0" /><?php if ($fieldName): ?></a><?php endif; ?>
    <?php
    }
  }

  function accessToggle( $rowNo, $fieldName, $currentValue ) {
    switch ($currentValue) {
      case 0: // Public
        $title = _T( 'PUBLIC' );
        $action = 'set' . $fieldName . ',1';
        $color = 'green';
        break;
      case 1: // Registered
        $title = _T( 'REGISTERED' );
        $action = 'set' . $fieldName . ',2';   
        $color = 'red';
        break;
      case 2: // Special
        $title = _T( 'SPECIAL' );
        $action = 'set' . $fieldName . ',0'; 
        $color = 'black';
        break;
    }
    if (!is_null( $fieldName )) {
      $result = "<a href=\"javascript: void(0);\"" .
        " onclick=\"return listItemTask('cb$rowNo','$action')\"";
    }
    else {
      $result = '<span';
    }
    $result .= " style=\"color: $color;\">$title";
    $result .= (!is_null( $fieldName ) ? '</a>' : '</span>');
    return $result;
  }
}

?>