<?php
/**
* @version $Id: mod_frontpage_thumbnails.php,v 1.2 2005/07/12 12:49:21 martin Exp $
* @package Mambo_4.5.1
* @copyright (C) 2000 - 2004 Miro International Pty Ltd
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* Mambo is Free Software
*/

/** ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );


global $mosConfig_offset, $mosConfig_live_site, $mainframe;
if (!function_exists("fptn_thumb_size"))
{
function fptn_thumb_size($file, $wdth, $hgth, &$image, &$xtra, $class, $aspect){
  global $mosConfig_absolute_path, $mosConfig_live_site;
		if($class!='') $xtra .= ' class="'.$class.'"';
  // Find the extension of the file
  $ext = substr(strrchr(basename($mosConfig_absolute_path.$file), '.'), 1);
  $thumb = str_replace('.'.$ext, '_thumb.'.$ext, $file);
  $image = '';
  $image_path = $mosConfig_absolute_path.$thumb;
  $image_site = $mosConfig_live_site.$thumb;
  $found = false;
//	print "<br />$file, $image_path, $wdth, $hgth";
  if (file_exists($image_path))
  {
    $size = '';
		$wx = $hy = 0;
    if (function_exists( 'getimagesize' ))
    {
      $size = @getimagesize( $image_path );
      if (is_array( $size ))
      {
        $wx = $size[0];
        $hy = $size[1];
        $size = 'width="'.$wx.'" height="'.$hy.'"';
      }
    }
    if ($wx == $wdth && $hy == $hgth)
    {
      $found = true;
      $image= '<img border="1" src="'.$image_site.'" '.$size.$xtra.' />';
    }
  }

  if (!$found)
  {
    $size = '';
		$wx = $hy = 0;
    $size = @getimagesize( $mosConfig_absolute_path.$file );
    if (is_array( $size ))
    {
      $wx = $size[0];
      $hy = $size[1];
    }
		//print "<br />$wx, $hy, $wdth, $hgth";
		fptn_calcsize($wx, $hy, $wdth, $hgth, $aspect);
		//print "<br />$wx, $hy, $wdth, $hgth";
    switch ($ext)
    {
      case 'jpg':
      case 'jpeg':
      case 'png':
        fptn_thumbit($mosConfig_absolute_path.$file,$image_path,$ext,$wdth,$hgth);
				$size = 'width="'.$wdth.'" height="'.$hgth.'"';
        $image= '<img border="1" src="'.$image_site.'" '.$size.$xtra.' />';
        break;

			case 'gif':
        if (function_exists("imagegif")) {
					fptn_thumbit($mosConfig_absolute_path.$file,$image_path,$ext,$wdth,$hgth);
					$size = 'width="'.$wdth.'" height="'.$hgth.'"';
					$image= '<img src="'.$image_site.'" '.$size.$xtra.' />';
					break;
        }
				
			default:
				$size = 'width="'.$wdth.'" height="'.$hgth.'"';
        $image= '<img src="'.$mosConfig_live_site.$file.'" '.$size.$xtra.' />';
        break;
    }
  }
}

function fptn_thumbIt ($file, $thumb, $ext, &$new_width, &$new_height) {

  $img_info = getimagesize ( $file );
  $orig_width = $img_info[0];
  $orig_height = $img_info[1];
	if($orig_width<$new_width || $orig_height<$new_height){
		$new_width = $orig_width;
		$new_height = $orig_height;
	}
switch ($ext) {
  case 'jpg':
  case 'jpeg':
    $im  = imagecreatefromjpeg($file);
    $tim = imagecreatetruecolor ($new_width, $new_height);
    fptn_ImageCopyResampleBicubic($tim, $im, 0,0,0,0, $new_width, $new_height, $orig_width, $orig_height);
    imagedestroy($im);

    imagejpeg($tim, $thumb, 75);
    imagedestroy($tim);
    break;

  case 'png':
    $im  = imagecreatefrompng($file);
    $tim = imagecreatetruecolor ($new_width, $new_height);
    fptn_ImageCopyResampleBicubic($tim, $im, 0,0,0,0, $new_width, $new_height, $orig_width, $orig_height);
    imagedestroy($im);

    imagepng($tim, $thumb, 75);
    imagedestroy($tim);
    break;

	case 'gif':
		if (function_exists("imagegif")) {
			$im  = imagecreatefromgif($file);
			$tim = imagecreatetruecolor ($new_width, $new_height);
			fptn_ImageCopyResampleBicubic($tim, $im, 0,0,0,0, $new_width, $new_height, $orig_width, $orig_height);
			imagedestroy($im);

			imagegif($tim, $thumb, 75);
			imagedestroy($tim);
    }
    break;

  default:
    break;
}
}

function fptn_ImageCopyResampleBicubic (&$dst_img, &$src_img, $dst_x, $dst_y, $src_x, $src_y, $dst_w, $dst_h, $src_w, $src_h) {
	if($dst_w==$src_w && $dst_h==$src_h){
		$dst_img = $src_img;
		return;
	}
  ImagePaletteCopy ($dst_img, $src_img);
  $rX = $src_w / $dst_w;
  $rY = $src_h / $dst_h;
  $w = 0;
  for ($y = $dst_y; $y < $dst_h; $y++) {
    $ow = $w; $w = round(($y + 1) * $rY);
    $t = 0;
    for ($x = $dst_x; $x < $dst_w; $x++) {
      $r = $g = $b = 0; $a = 0;
      $ot = $t; $t = round(($x + 1) * $rX);
      for ($u = 0; $u < ($w - $ow); $u++) {
        for ($p = 0; $p < ($t - $ot); $p++) {
          $c = ImageColorsForIndex ($src_img, ImageColorAt ($src_img, $ot + $p, $ow + $u));
          $r += $c['red'];
          $g += $c['green'];
          $b += $c['blue'];
          $a++;
        }
      }
			if(!$a) $a = 1;
      ImageSetPixel ($dst_img, $x, $y, ImageColorClosest ($dst_img, $r / $a, $g / $a, $b / $a));
    }
  }
}

function fptn_calcsize($srcx, $srcy, &$forcedwidth, &$forcedheight, $aspect) {
	if ($forcedwidth > $srcx)  $forcedwidth = $srcx;
	if ($forcedheight > $srcy) $forcedheight = $srcy;
        if ( $forcedwidth <=0 && $forcedheight > 0) {
		$forcedwidth = round(($forcedheight * $srcx) / $srcy);
	}else if ( $forcedheight <=0 && $forcedwidth > 0) {
		$forcedheight = round(($forcedwidth * $srcy) / $srcx);
	}else if ( $forcedwidth/$srcx>1 && $forcedheight/$srcy>1) {
		//May not make an image larger!
		$forcedwidth = $srcx;
		$forcedheight = $srcy;
	}
	if ($aspect)
	{	
		if  ( $forcedwidth/$srcx<1 && $forcedwidth/$srcx <  $forcedheight/$srcy) {
			$forcedheight = round(($srcy * $forcedwidth) /$srcx);
		}
		else if ( $forcedheight/$srcy<1 && $aspect) {
			$forcedwidth = round(($forcedheight * $srcx) /$srcy);
		}
	}
}

function fptn_limittext($txt,$limit)
{
    $len=strlen($txt);
    if($len <= $limit)
        return $txt;
    else
    {
        $txt = substr($txt,0,$limit);
        $pos = strrpos($txt," ");
        if($pos >0)
	{
	    
            $txt = substr($txt,0,$pos);
	    if (($tpos =strrpos($txt,"<")) >  strrpos($txt,">") && $tpos>0)
	    {
		  $txt = substr($txt,0,$tpos-1);
	  
	    }

	}
        return $txt . "...";
    }
}

}
$count = intval( $params->get( 'count', 5 ) );
$skip = intval( $params->get( 'skip', 0 ) );
$columns = intval( $params->get( 'columns', 1 ) );
$direction = intval( $params->get( 'direction', 1 ) );
$fulllink = $params->get( 'fulllink','' );

$moduleclass_sfx = $params->get( 'moduleclass_sfx' );

$thumb_width = intval( $params->get( 'thumb_width', 32 ) );
$thumb_height = intval( $params->get( 'thumb_height', 32 ) );
$section = intval( $params->get( 'section', -1 ) );
$aspect = intval( $params->get( 'aspect', 0 ) );
$css_suffix =  $params->get( 'css_suffix', '' ) ;
$limit = intval( $params->get( 'limit', 0 ) );

$thumb_embed = intval( $params->get( 'thumb_embed', 0 ) );
$thumb_disable = intval( $params->get( 'thumb_disable', 0 ) );
$strip_tags = intval( $params->get( 'strip_tags', 0 ) );
$allowed_tags =  "<br><i>"; 


$now = date( "Y-m-d H:i:s", time()+$mosConfig_offset*60*60 );

// query records
$query = "SELECT a.*, cc.image AS image"
	. "\n FROM #__content AS a"
	. "\n INNER JOIN #__content_frontpage AS f ON f.content_id = a.id"
	. "\n INNER JOIN #__categories AS cc ON cc.id = a.catid"
	. "\n WHERE a.state = '1'"
	. "\n AND ( publish_up = '0000-00-00 00:00:00' OR publish_up <= '$now'  )"
	. "\n AND ( publish_down = '0000-00-00 00:00:00' OR publish_down >= '$now' )"
	. "\n ORDER BY f.ordering"
	. "\nlimit $skip," . $count
	;

$database->setQuery( $query );
$rows = $database->loadObjectList();


// Output
echo '<table border="0" cellspacing="0" cellpadding="0" class="frontpage_thumbnail_main' . $css_suffix . '">';
$col = 0;
$pwidth = intval(100/$columns);
//
//process intro text
//
$rc = count($rows);
for ( $r = 0; $r < $rc; $r++) {

	$rows[$r]->introtext= preg_replace("/{[^}]*}/","",$rows[$r]->introtext);
	if($strip_tags == 1)
	{
        	$rows[$r]->introtext = strip_tags($rows[$r]->introtext,$allowed_tags);
	}
  	if($limit > 0)
	{
        	$rows[$r]->introtext = fptn_limittext($rows[$r]->introtext,$limit);
	}
}
if ($thumb_embed == 1 && $thumb_disable != 1)
{
   echo '<table border="0" cellspacing="0" cellpadding="0" class="frontpage_thumbnail_main' . $css_suffix . '">';

   foreach ( $rows as $row ) {
	if ($col==0)	echo '<tr>';
	echo '<td valign="top" width="' . $pwidth . '%">';
	echo '<table class="frontpage_thumbnail" width="100%" border="0" cellspacing="0" cellpadding="0"><tr><td valign="top" class="title">';
    echo '<a href="'. sefRelToAbs( 'index.php?option=com_content&amp;task=view&amp;id=' . $row->id ) .'">'. $row->title . '</a></td></tr>';
    echo '<tr><td valign="top" class="frontpage_thumbnail_column">';
    echo '<p>';
    echo '<a href="'. sefRelToAbs( 'index.php?option=com_content&amp;task=view&amp;id=' . $row->id ) .'">';

   	if ($row->images != "")
   	{

   		$img = "/images/stories/" . strtok($row->images,"|\r\n");
   		$class="";
		$extra = 'style="float: left; margin-left: 0.5em; margin-right: 0.5em;" alt=""';
   	
   		fptn_thumb_size($img, $thumb_width, $thumb_height, $image, $extra, $class, $aspect);

   		echo  $image ;

    }
    else if ($row->image !="")
    {
    	echo '<img border="1" src="/images/stories/' . $row->image . '" width="' . $thumb_width . '" height="' . $thumb_height .'" style="float: left; margin-left: 0.5em; margin-right: 0.5em;" alt="" />';
    	//echo '<img border="1" src="/images/stories/' . $row->image . '" width="' . $thumb_width . '" height="' . $thumb_height .'" style="" alt="" />';

    }
    echo '</a>';
  
    echo $row->introtext;
    echo '</p>';
 	if ($fulllink !="")
	{
		echo '<a href="'. sefRelToAbs( 'index.php?option=com_content&amp;task=view&amp;id=' . $row->id ) .'">'. $fulllink . '</a>' ;

	}
	echo "</td></tr></table>";
	echo "</td>";
	$col = ($col + 1) % $columns;
	if ($col ==0 ) echo "</tr>";
  }
  if ($col !=0) echo "</tr>";

  echo '</table>';
}
else if ($direction == 0)
{
   echo '<table border="0" cellspacing="0" cellpadding="0" class="frontpage_thumbnail_main' . $css_suffix . '">';

   foreach ( $rows as $row ) {
	if ($col==0)	echo '<tr width="100%">';
	echo '<td width="' . $pwidth . '%">';
	echo '<table class="frontpage_thumbnail' . $css_suffix . '" width="100%" border="0" cellspacing="0" cellpadding="0"><tr>';
	if($thumb_disable != 1)
    	{
           echo '<td valign="top" class="frontpage_thumbnail_column' . $css_suffix . '">';
           echo '<a href="'. sefRelToAbs( 'index.php?option=com_content&amp;task=view&amp;id=' . $row->id ) .'">';
   
	   if ($row->images != "")
	   {
		
		$img = "/images/stories/" . strtok($row->images,"|\r\n");
		$class="";
		$extra ="";
		fptn_thumb_size($img, $thumb_width, $thumb_height, $image, $extra, $class, $aspect);
		
		echo  $image ;

	   }
	   else if ($row->image !="")
	   {
		echo '<img border="1" src="/images/stories/' . $row->image . '" width="' . $thumb_width . '" height="' . $thumb_height .'">';
	   }
	   echo '</a></td>';

	}
	echo '<td valign="top" class="frontpage_thumbnail_column' . $css_suffix . '">';
	echo '<a href="'. sefRelToAbs( 'index.php?option=com_content&amp;task=view&amp;id=' . $row->id ) .'">'. $row->title . '</a><br />'. $row->introtext ;
	if ($fulllink !="")
	{
		echo '<br /><a href="'. sefRelToAbs( 'index.php?option=com_content&amp;task=view&amp;id=' . $row->id ) .'">'. $fulllink . '</a>' ;

	}
	echo "</td></tr></table>";
	echo "</td>";
	$col = ($col + 1) % $columns;
	if ($col ==0 ) echo "</tr>";
  }
  if ($col !=0) echo "</tr>";

  echo '</table>';
}
else
{

 echo '<table border="0" cellspacing="0" cellpadding="0" class="frontpage_thumbnail_main' . $css_suffix . '">';

   foreach ( $rows as $row ) {
	if ($col==0)	echo '<tr width="100%">';
	echo '<td valign="top" width="' . $pwidth . '%">';
	echo '<table class="frontpage_thumbnail" width="0" border="0" cellspacing="0" cellpadding="0"><tr><td valign="top" class="frontpage_thumbnail_column">';


	echo '<a href="'. sefRelToAbs( 'index.php?option=com_content&amp;task=view&amp;id=' . $row->id ) .'">'. $row->title . '</a></td></tr>';
	echo  '<tr class="frontpage_thumbnail_row' . $css_suffix . '">';

	if($thumb_disable != 1)
    	{
           echo '<td valign="top" class="frontpage_thumbnail_column' . $css_suffix . '">';
       	   echo '<a href="'. sefRelToAbs( 'index.php?option=com_content&amp;task=view&amp;id=' . $row->id ) .'">';

 	   if ($row->images != "")
	   {
		
		$img = "/images/stories/" . strtok($row->images,"|\r\n");
		$class="";
		$extra="";
		fptn_thumb_size($img, $thumb_width, $thumb_height, $image, $extra, $class, $aspect);
		
		echo  $image ;

	   }
	   else if ($row->image !="")
	   {
		echo '<img border="1" src="/images/stories/' . $row->image . '" width="' . $thumb_width . '" height="' . $thumb_height .'">';
	   }
	   echo '</a></td>';
        }

	echo '</tr><tr class="frontpage_thumbnail_row' . $css_suffix . '"><td valign="top"class="frontpage_thumbnail_column' . $css_suffix . '">';
	echo $row->introtext ;
	if ($fulllink !="")
	{
		echo '<br /><a href="'. sefRelToAbs( 'index.php?option=com_content&amp;task=view&amp;id=' . $row->id ) .'">'. $fulllink . '</a>' ;

	}
	echo "</td></tr></table>";
	echo "</td>";
	$col = ($col + 1) % $columns;
	if ($col ==0 ) echo "</tr>";
  }
  if ($col !=0) echo "</tr>";

  echo '</table>';

}


?>
