<?php

/* **************************************************************************
EstateAgent - a Mambo/Joomla Component

File:					estategent.php
Copyright: 			2004 - 2006 by Darko Selesi
Homepage:	  	http://www.bits-dont-bite.net
Version: 			1.0.1 Stable                       
Created with: 	Eclipse 3.1.0 (http://www.eclipse.org)
						RedHat/Fedora Core4 Linux (http://fedora.redhat.com)
License: 			GNU/GPL http://www.gnu.org/copyleft/gpl.html
*************************************************************************** */

# Don't allow direct linking
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

require_once( $mainframe->getPath( 'front_html' ) );
require($mosConfig_absolute_path."/administrator/components/com_estateagent/class.estateagent.php");
require($mosConfig_absolute_path."/administrator/components/com_estateagent/configuration.php");
if(file_exists($mosConfig_absolute_path."/components/com_estateagent/user.estateagent.php")) {
	include($mosConfig_absolute_path."/components/com_estateagent/user.estateagent.php");
}

// Get the right languagefile if it exists
if (file_exists($mosConfig_absolute_path.'/components/com_estateagent/languages/'.$mosConfig_lang.'.php')) {
	include($mosConfig_absolute_path.'/components/com_estateagent/languages/'.$mosConfig_lang.'.php');
}else {
   	include($mosConfig_absolute_path.'/components/com_estateagent/languages/english.php');
}

// check session-handling
session_start();
if(!session_is_registered("eac1")) session_register("eac1");
if(!session_is_registered("eac2")) session_register("eac2");
if(!session_is_registered("sres")) session_register("sres");

$option 			= mosGetParam( $_REQUEST, 'option', 'com_estateagent' );
$act 				= mosGetParam( $_REQUEST, 'act', 'cat' );
$task 			= mosGetParam( $_REQUEST, 'task', ' ' );
$id 				= intval(mosGetParam( $_REQUEST, 'id', 0 ));
$cid    			= mosGetParam( $_REQUEST, 'cid', array(0) );
$uid				= intval(mosGetParam( $_REQUEST, 'uid', 0 ));
$limit 			= intval(mosGetParam($_REQUEST, 'limit', $ea_perpage));
$limitstart		= intval(mosGetParam($_REQUEST, 'limitstart', 0));
$sc 				= mosGetParam( $_REQUEST, 'sc', 'n' );

if (!is_array( $cid )) {
   	$cid = array(0);
}

// Editor usertype check
$access = new stdClass();
#$access->canEdit     	= $acl->acl_check( 'action', 'edit', 'users', $my->usertype, 'components', 'all' );
$access->canEditOwn 	= $acl->acl_check( 'action', 'edit', 'users', $my->usertype, 'components', 'own' );
#$access->canPublish 	= $acl->acl_check( 'action', 'publish', 'users', $my->usertype, 'components', 'all' );

// Check if EstateAgent is offline
if ($ea_offline == 1) {
    require($mosConfig_absolute_path."/components/com_estateagent/offline.php");
}else {

    function EAHeader($act,$task,$pageNav) {
    	global $mainframe,$my,$id,$mosConfig_absolute_path,$mosConfig_live_site,$ea_f_srch,$ea_l_srch,$ea_d_srch,$ea_mtf,$ea_allowsubmission;
    	    	
    	// STOP!!! You may NOT remove this lines!
    	echo "<!-- -------------------------------------------------------- -->\n";
    	echo "<!-- EstateAgent - a Joomla component -->\n";
    	echo "<!-- &copy; 2004 - 2006 Darko Selesi, released under GPL. -->\n";
		echo "<!-- for more information visit http://www.bits-dont-bite.net -->\n";
    	echo "<!-- or contact me by email: info [at] bits-dont-bite.net -->\n";
    	echo "<!-- -------------------------------------------------------- -->\n";
    	// ------------------------------------------------------------------------------------
		if($ea_mtf > 0 && $act == "object" && $task == "showEO"){
			$mlink = emailToFriendLink( $id, $ea_mtf );
			$col =  " colspan=\"2\"";
		}	
		else{
			$mlink = ""; $col = "";
		}
		echo "<table class='contentpaneopen' width='100%' cellpadding='4' cellspacing='4' border='0' align='center'>";
    	echo "<tr><td class=\"contentheading\" width=\"95%\">" . _EA_TITLE . "</td>".$mlink."</tr>";
    	echo "<tr><td align=\"left\"".$col.">";
    	echo "<a href='".sefRelToAbs("index.php?option=com_estateagent&act=cat&task=0")."'>"._EA_TOPMENU."</a>";    	
	    	    
	    // show categories pathway
		if(($act == "cat" && $task != "") || $act == "object") {
			
			if(isset($_SESSION['eac2']['id']) && $_SESSION['eac2']['id'] != ""){
				echo "&nbsp;<img src='".$mosConfig_live_site."/images/M_images/arrow.png' border='0'>&nbsp;<a href='".sefRelToAbs("index.php?option=com_estateagent&act=cat&task=showCE&id=".$_SESSION['eac1']['id'])."'>".$_SESSION['eac1']['name'] . "</a>";
			
				if($act == "object") echo "&nbsp;<img src='".$mosConfig_live_site."/images/M_images/arrow.png' border='0'>&nbsp;<a href='".sefRelToAbs("index.php?option=com_estateagent&act=cat&task=showCE&id=".$_SESSION['eac2']['id'])."&sc=y'>".$_SESSION['eac2']['name']."</a>"; 
				else echo "&nbsp;<img src='".$mosConfig_live_site."/images/M_images/arrow.png' border='0'>&nbsp;".$_SESSION['eac2']['name'];
			
			}
			elseif(isset($_SESSION['eac1']['id']) && $_SESSION['eac1']['id'] != ""){
			
				if($act == "object") echo "&nbsp;<img src='".$mosConfig_live_site."/images/M_images/arrow.png' border='0'>&nbsp;<a href='".sefRelToAbs("index.php?option=com_estateagent&act=cat&task=showCE&id=".$_SESSION['eac1']['id'])."'>".$_SESSION['eac1']['name']."</a>";	
				else echo "&nbsp;<img src='".$mosConfig_live_site."/images/M_images/arrow.png' border='0'>&nbsp;".$_SESSION['eac1']['name'];
			
			}
			else{
				if($act == "object" && isset($_SESSION['sres'])) echo "&nbsp;<img src='".$mosConfig_live_site."/images/M_images/arrow.png' border='0'>&nbsp;<a href='".sefRelToAbs("index.php?option=com_estateagent&act=easearch&task=showEASR&limit=".$pageNav->limit."&limitstart=".$pageNav->limitstart)."'>"._EA_SRCH_BTRESLTS."</a>";	
				#else echo "&nbsp;<img src='".$mosConfig_live_site."/images/M_images/arrow.png' border='0'>&nbsp;<a href='".sefRelToAbs("index.php?option=com_estateagent")."'>Back</a>";	
			}
		}
		
		if($ea_f_srch || $ea_l_srch || $ea_d_srch){
			if(($act == "easearch" && $task == "showEASR") || ($act == "object" && isset($_SESSION['sres']))){	
				echo " | <a href='".sefRelToAbs("index.php?option=com_estateagent&act=easearch")."'>"._EA_NEWSEARCH."</a>";
			}
			else{
				echo " | <a href='".sefRelToAbs("index.php?option=com_estateagent&act=easearch")."&Itemid=0'>"._EA_FASTSEARCH."</a>";
			}
		}
		
		if(file_exists($mosConfig_absolute_path."/components/com_estateagent/user.estateagent.php") && $my->id && $ea_allowsubmission == 1) {
			echo " ||| <a href='".sefRelToAbs("index.php?option=com_estateagent&act=eaadmin")."'>Administration</a>";
		}
		echo "</td></tr><tr><td".$col.">";
	    return;
    }

    function EAFooter() {
		global $mosConfig_live_site, $ea_footer, $ea_version; 
   		
		echo "</td></tr></table><br />";
		switch($ea_footer) {			
			case "2":
				echo "<div style='text-align:center;'><a href='http://www.bits-dont-bite.net/' target='_blank' style='filter: alpha(opacity=5);' onmouseover='if( this.filters) { this.filters.alpha.opacity=100; }' onmouseout='if( this.filters) { this.filters.alpha.opacity=50; }'>
						<img style='-moz-opacity: 0.5;' onmouseover='this.style.MozOpacity=1.0;' onmouseout='this.style.MozOpacity = 0.5;' src='".$mosConfig_live_site."/components/com_estateagent/pictures/gui/ealogo_small.png' border='0' title='powered by EstateAgent " . $ea_version . "'></a></div>";
    		break;
			case "1":
				echo "<div style='text-align:center; font-size: 8px; color:orange'>::powered by <a href='http://www.bits-dont-bite.net/' target='_blank'><span style='font-size: 8px; font-weigth:bold'>EstateAgent " . $ea_version . "</span></a>::</div>";
    		break;
			default:
				echo "";
			break;
		}
		return;
    }

    // Get local date (and time)
    $today =  mosCurrentDate( $format="%Y-%m-%d" );
	
	switch( $act ) {
			
		case "object":		
	
			switch($task){		
	
				case "coupon": // generate PDF, if supported by EA-version 					
  					pdfCoupon($option,$act,$task);  					
  					break;  						
				case "mail":				
					sendMail($option,$act,$task,$gid);
					break;
				case "mtfform":
					mailToFriend($option,$act,$task,$id,0);
					break;
				case "sendmtf":
					mailToFriend($option,$act,$task,$id,1);
					break;
				case "showEO":	// show estate object
				default:
					showEstateObject($option,$act,$task,$id,$gid,$today,$limitstart,$limit);
					break;	
			}		
		break;
		
		case "easearch":
			switch($task) {			
				case "showEASR":    			
    				showEASearchResult($option,$act,$task,$limit,$limitstart,$today);
    				break;
    			default:	
    				showSearchForm($option,$act,$task,$today);
    				break;    
    		}
    	break;		
    	
		case "eaadmin":    		
    		
			if(file_exists($mosConfig_absolute_path."/components/com_estateagent/user.estateagent.php")) {
								
				switch($task) {    			
    				case "new":
    				case "edit":
    					editMyEAObject($option,$act,$task,$id,$cid,$limit,$limitstart);
    					break;    			
    				case "save":
    					saveMyEAObject($option,$act,$task,$cid,$limit,$limitstart);
    					break;    					
    				case "publish":
    				case "unpublish":
    					publishMyEAObject($option,$act,$task,$cid,$limit,$limitstart);
    					break;    				
    				case "remove":
    					removeMyEAObject($option,$act,$task,$cid,$limit,$limitstart);
    				break;    			    			
    				default:
    					showEACPanel($option,$act,$task,$limit,$limitstart);    			
    					break;	    			
    			}
		}    		
    	break;    	
    	default:
    	case "cat":			
			switch($task) {			
				case "showCE": // show entries of a single category
					showCategoryEntries($option,$act,$task,$id,$gid,$today,$limit,$limitstart);
					break;			
				default: // show categories overview 
            		showCategoriesOverview($option,$act,$task,$id,$gid,$today,$limit,$limitstart);
            	    break;            						 
			}		
			break;
    }

EAFooter();

}

// category functions ---------------------
function showCategoriesOverview($option,$act,$task,$id,$gid,$today,$limit,$limitstart){
	global $mainframe, $mosConfig_mbf_content, $mosConfig_lang, $mosConfig_absolute_path, $my, $database;
	global $ea_show_scats, $ea_cat_entries, $ea_fpstyle, $ea_hotfp, $ea_hotfpa;
	global $ea_shortinfo, $ea_picpath, $ea_tbwidth, $ea_currency, $ea_hot_color, $ea_nformat;
	
	$noauth = !$mainframe->getCfg( 'shownoauth' );
				
	// clear category sessions 
    $_SESSION['eac1'] = ""; 
  	$_SESSION['eac2'] = "";
    
    $query = "SELECT count(id) FROM #__estateagent_categories"
    			. "\n WHERE" 
				. "\n ("
				. "\n ((publish_up >= '0000-00-00' AND publish_up <= '$today') AND publish_down >= '$today')"
       			. "\n OR ((publish_up >= '0000-00-00' AND publish_up <= '$today' ) AND (publish_down = '0000-00-00' OR publish_down >= '$today'))"
       			. "\n OR (publish_up = '0000-00-00' AND publish_down = '0000-00-00')"
       			. "\n )"
				. " AND publish = 1 AND access <= $gid";
				
    $database->setQuery($query);
    $total = $database->loadResult();

    require_once 'includes/pageNavigation.php';
    $pageNav = new mosPageNav($total, $limitstart, $limit);
	
	// get maincategories
	$query = "SELECT * FROM #__estateagent_categories " 
				. "\n WHERE parent=$id AND access<=$gid"
				. "\n AND" 
				. "\n ("
				. "\n ((publish_up >= '0000-00-00' AND publish_up <= '$today') AND publish_down >= '$today')"
       			. "\n OR ((publish_up >= '0000-00-00' AND publish_up <= '$today' ) AND (publish_down = '0000-00-00' OR publish_down >= '$today'))"
       			. "\n OR (publish_up = '0000-00-00' AND publish_down = '0000-00-00')"
       			. "\n )"
				. " AND publish=1 ORDER BY ordering ASC";
    $database->setQuery($query);
    $cats = $database->loadObjectList();
    
    // check entries in every category
    $entries = array(); $x=0;
    foreach($cats as $c){
    	$query = "SELECT count(*) FROM #__estateagent" 
			. "\n WHERE cat = $c->id"
			. "\n AND ("
			. "\n ((publish_up >= '0000-00-00' AND publish_up <= '$today') AND publish_down >= '$today')"
       		. "\n OR ((publish_up >= '0000-00-00' AND publish_up <= '$today' ) AND (publish_down = '0000-00-00' OR publish_down >= '$today'))"
       		. "\n OR (publish_up = '0000-00-00' AND publish_down = '0000-00-00')"
       		. "\n )"
			. " AND access <= $gid AND publish=1";
	   	$database->setQuery($query);	
    	$entries[$x] = $database->loadResult();
    	$x++;
    }    	    	    	   	    	    
                
    // get subcategories and check for entries   
    $sentries = array();
    if($id == 0){
    	$scats = array();$x=0;
    	foreach($cats as $c){ 
    		$sc = new EACategory($database);
			$sc->load($c->id);
			$scats[$x] = $sc->getSubcategories();			
    		
    		$sentries[$x]=array();$y=0;
    		foreach($scats[$x] as $s){
    			$query = "SELECT count(*) FROM #__estateagent" 
					. "\n WHERE cat = $s->id"
					. "\n AND ("
					. "\n ((publish_up >= '0000-00-00' AND publish_up <= '$today') AND publish_down >= '$today')"
       				. "\n OR ((publish_up >= '0000-00-00' AND publish_up <= '$today' ) AND (publish_down = '0000-00-00' OR publish_down >= '$today'))"
       				. "\n OR (publish_up = '0000-00-00' AND publish_down = '0000-00-00')"
       				. "\n )"
					. "\n AND access <= $gid AND publish=1";
	    		$database->setQuery($query);	
    			$sentries[$x][$y] = $database->loadResult();
    			$entries[$x] += $sentries[$x][$y];
    			$y++;
    		}   		    		    		
    	$x++;
    	}   	    	    	   
    }
    else{
    	$scats=0;
    }    	   
    
	$hot = array();
	if($ea_hotfp==1 || $ea_hotfp==3){
		// get hot offers if avalaible
		$query = "SELECT id, obj_id, type, title, description, rent, price, country, state, town, district FROM #__estateagent WHERE ("
    	   		. "\n ((publish_up >= '0000-00-00' AND publish_up <= '$today') AND publish_down >= '$today')"
       			. "\n OR ((publish_up >= '0000-00-00' AND publish_up <= '$today' ) AND (publish_down = '0000-00-00' OR publish_down >= '$today'))"
       			. "\n OR (publish_up = '0000-00-00' AND publish_down = '0000-00-00')"
       			. "\n )"
				. "\n  AND hot=1 AND access<=$gid AND publish=1 ORDER BY created DESC LIMIT 0,$ea_hotfpa";
		$database->setQuery($query);
    	$hot = $database->loadObjectList();
		
		// get object categories
		foreach($hot as $h){
			$ocat = new EACategory($database);
			$ocat->load($hot);
		}

		// initialize session vars for EA pathway        
    	/* if($sc == "n") {
       		$_SESSION['eac1'] = array("id" => $cat->id, "name" => $cat->name); 
  			$_SESSION['eac2'] = "";
  		}
    	else{
       		if($_SESSION['eac1'] == "") {
				$mcat = "";
				$query = "SELECT * FROM #__estateagent_categories WHERE id = $cat->parent";
				$database->setQuery($query);
				$database->loadObject($mcat);

				$_SESSION['eac1'] = array("id" => $mcat->id, "name" => $mcat->name);
			}
			$_SESSION['eac2'] = array("id" => $cat->id, "name" => $cat->name);	
    	}	*/ 
	}	

    $params['catid'] 			= $id;
    $params['entries'] 		= $ea_cat_entries;
	$params['subcats']		= $ea_show_scats;
    $params['fpstyle'] 		= $ea_fpstyle;	
    $params['shortinfo'] 	= explode(",",$ea_shortinfo);
	$params['picpath']		= $ea_picpath;
	$params['tbwidth']		= $ea_tbwidth;
	$params['currency']	= $ea_currency;
	$params['hotcolor']		= $ea_hot_color;
	$params['sc']				= $sc;		
	if($ea_nformat == 0){
		$params['sep1'] 	= ".";
		$params['sep2'] 	= ",";
	}
	else{
		$params['sep1'] 	= ",";
		$params['sep2'] 	= ".";
	}	              
    HTML_frontend_estateagent::showCatOverview($act,$task,$cats,$scats,$entries,$sentries,$hot,$pageNav,$params);
    	
}
							
function showCategoryEntries($option,$act,$task,$id,$gid,$today,$limit,$limitstart){
	global $mosConfig_mbf_content, $mosConfig_lang, $database,$my;
	global $sc,$ea_nformat,$ea_show_scats,$ea_mcat_fullview,$ea_cat_entries,$ea_shortinfo,$ea_hot_pos,$ea_tbwidth,
			$ea_currency,$ea_picpath,$ea_hot_color;
	
	// load category
	$cat = new EACategory($database);
    $cat->load($id);
        
    // get subcategories and check for entries
    $scats = $cat->getSubcategories($cat->id, $gid);				
        
    // get entries for each subcategory	
    $sc_entries=array();$parent=array();$y=0;
    foreach($scats as $s){
    	$query = "SELECT count(*) FROM #__estateagent" 
					. "\n WHERE cat = $s->id"
					. "\n AND ("
					. "\n ((publish_up >= '0000-00-00' AND publish_up <= '$today') AND publish_down >= '$today')"
       				. "\n OR ((publish_up >= '0000-00-00' AND publish_up <= '$today' ) AND (publish_down = '0000-00-00' OR publish_down >= '$today'))"
       				. "\n OR (publish_up = '0000-00-00' AND publish_down = '0000-00-00')"
       				. "\n )"
					. "\n AND access <= $gid AND publish=1";
	  	$database->setQuery($query);	
    	$sc_entries[$y] = $database->loadResult();
    	$parent[$y] = $s->id; // needed a few lines later, if $ea_mcat_fullview == 1
		$y++;
    }    	
	
	// initialize session vars for EA pathway        
    if($sc == "n") {
       	$_SESSION['eac1'] = array("id" => $cat->id, "name" => $cat->name); 
  		$_SESSION['eac2'] = "";
  	}
    else{
       	if($_SESSION['eac1'] == "") {
			$mcat = "";
			$query = "SELECT * FROM #__estateagent_categories WHERE id = $cat->parent";
			$database->setQuery($query);
			$database->loadObject($mcat);

			$_SESSION['eac1'] = array("id" => $mcat->id, "name" => $mcat->name);
		}
		$_SESSION['eac2'] = array("id" => $cat->id, "name" => $cat->name);	
    } 

	// select categorie objects
	$catIDs = "cat=$id";
	if($ea_mcat_fullview == 1 && count($parent)>0){
		$catIDs = " (cat=$id OR cat IN(";
		$catIDs .= implode(",",$parent) . "))";
	}
	// count matching categorie objects (if $ea_mcat_fullview, then count recursive)
	$query  = "SELECT count(id) FROM #__estateagent WHERE ".$catIDs." AND ("
				. "\n ((publish_up >= '0000-00-00' AND publish_up <= '$today') AND publish_down >= '$today')"
       			. "\n OR ((publish_up >= '0000-00-00' AND publish_up <= '$today' ) AND (publish_down = '0000-00-00' OR publish_down >= '$today'))"
       			. "\n OR (publish_up = '0000-00-00' AND publish_down = '0000-00-00')"
       			. "\n )"
				. "\n  AND access<=$gid AND publish=1";
    $database->setQuery($query);
    $total = $database->loadResult();
        		
    require_once 'includes/pageNavigation.php';
    $pageNav = new mosPageNav($total, $limitstart, $limit);
                
    // select hot offer objects	
	$query = "SELECT id, obj_id, type, title, description, rent, price, country, state, town, district FROM #__estateagent WHERE cat=".$id." AND ("
    	   		. "\n ((publish_up >= '0000-00-00' AND publish_up <= '$today') AND publish_down >= '$today')"
       			. "\n OR ((publish_up >= '0000-00-00' AND publish_up <= '$today' ) AND (publish_down = '0000-00-00' OR publish_down >= '$today'))"
       			. "\n OR (publish_up = '0000-00-00' AND publish_down = '0000-00-00')"
       			. "\n )"
				. "\n  AND hot=1 AND access<=$gid AND publish=1 ORDER BY id DESC LIMIT $limitstart,$limit";      
	$database->setQuery($query);
    $hot = $database->loadObjectList();
   
    // select regular objects
    $query = "SELECT id, obj_id, type, title, description, rent, price, country, state, town, district FROM #__estateagent WHERE ".$catIDs." AND ("
				. "\n ((publish_up >= '0000-00-00' AND publish_up <= '$today') AND publish_down >= '$today')"
       			. "\n OR ((publish_up >= '0000-00-00' AND publish_up <= '$today' ) AND (publish_down = '0000-00-00' OR publish_down >= '$today'))"
       			. "\n OR (publish_up = '0000-00-00' AND publish_down = '0000-00-00')"
       			. "\n )"
				. "\n AND hot=0 AND access<=$gid AND publish=1 ORDER BY id DESC LIMIT $limitstart,$limit";        
	$database->setQuery($query);
    $regular = $database->loadObjectList();
	#echo $query;
	
	// parameters	
	$params['catid'] 			= $id;
	$params['scats'] 		= $ea_show_scats;
	$params['entries']  		= $ea_cat_entries;
	$params['shortinfo'] 	= explode(",",$ea_shortinfo);
	$params['hotpos']		= $ea_hot_pos;
	$params['picpath']		= $ea_picpath;
	$params['tbwidth']		= $ea_tbwidth;
	$params['currency']	= $ea_currency;
	$params['hotcolor']		= $ea_hot_color;
	$params['sc']				= $sc;		
	if($ea_nformat == 0){
		$params['sep1'] 	= ".";
		$params['sep2'] 	= ",";
	}
	else{
		$params['sep1'] 	= ",";
		$params['sep2'] 	= ".";
	}	
					
	HTML_frontend_estateagent::show_CatEntries($act,$task,$id,$scats,$sc_entries,$hot,$regular,$today,$pageNav,$params);
}

// object functions --------------------------
function pdfCoupon($act,$task){  // feature will be implemented in a future release
	global $database;
  				  				
  	$file =	$mosConfig_absolute_path."/components/com_estateagent/pdf_expose.php";
	if(file_exists($file)) include($file);
					
	$uagent = new mosSession( $database );
	$uagent->load($my->id);
	$browser = $uagent->mosGetBrowser($_SERVER['HTTP_USER_AGENT']);
	if( $browser == strchr($browser,"MS Internet Explorer")) exit();		
	
}

function showEstateObject($option,$act,$task,$id,$gid,$today,$limitstart,$limit){
	global $mainframe,$mosConfig_mbf_content,$mosConfig_lang,$database,$mosConfig_sitename,$mosConfig_absolute_path,$mosConfig_live_site,$my;
	global $ea_fulllocation,$ea_map24,$ea_map24_lid,$ea_map24_type,$ea_map24_dlg,$ea_map24_tlogo,$ea_map24_dinfo,$ea_map24_dimg;
	global $ea_nformat,$ea_measure,$ea_currency,$ea_mtgcalc,$ea_picpath,$ea_tbwidth,$ea_gl_pup;
	
	$obj = new EAObject($database);
	$obj->load($id);
	
	if($gid >= $obj->access) {

		// object hitcounter
		$obj->count_hits();		
		// load images		
		$gl = $obj->loadGallery($obj->id,1);		
		// load all other files (EA supports .pdf, .doc, .xls, .ppt, .avi, .mpeg, .mov ) - for evaluation only!
		$fl = $obj->loadFiles(null,1);
					
		// select users (agents) contact information
		$sql = "SELECT * FROM #__contact_details WHERE user_id = $obj->created_by"
			. " AND published = 1 AND access <= $gid";
		$database->setQuery($sql);
		$ct = null;
		$database->loadObject($ct); 
		
		// PDF expose support available?
		
		if(file_exists($mosConfig_absolute_path.'/components/com_estateagent/includes/pdf_expose.php')) {						
			$params['pdf'] ='<table width="100%" border="0" cellspacing="1" cellpadding="1">
    				<tr><td colspan="2" style="text-align:right"><img src="images/M_images/arrow.png" alt="" border="0">&nbsp;
    				<a href="#" onClick="window.open(\'index2.php?option=com_estateagent&act=object&task=coupon&id='.$obj->id.'\',\''.$mosConfig_sitename.'\',\'top=10,left=10,width=600,height=510,
    				resizable=no,status=no,toolbar=no,scrollbars=yes,titlebar=no,menubar=no,directories=no,location=no\')">'._EA_OBJ_DOWNLOAD_EXPOSE.'</a></td></tr>				
    				</table>';
		}
		else $params['pdf']="";		
		
		// MTGCalculator avalaible?
		if(($obj->type==2 || $obj->type==4) && $ea_mtgcalc && file_exists($mosConfig_absolute_path.'/components/com_estateagent/includes/mtgcalculator.php')) {	
			$tmpl = $mainframe->getTemplate();
			$params['mtg'] = " ( <a href=\"#\" onclick=\"javascript:window.open('".$mosConfig_live_site."/components/com_estateagent/includes/mtgcalculator.php?price=".number_format($obj->price,0,"","")."&tmpl=".$tmpl."&uid=-1','EACalculator','top=10,left=10,width=500,height=365,toolbar=no,scrollbars=yes')\">"._EA_MTGCALC."</a> )";
		}
		else $params['mtg'] = "";

		// if MAP24 support available, generate link for estate object...					
		if($ea_fulllocation == 1 && $ea_map24 == 1){
			$obj->map24link = check_map24_sup($ea_map24_lid,$ea_map24_type,
				$obj->street." ".$obj->streetnr,$obj->pcode,
				$obj->town,$obj->country,$ea_map24_tlogo,$mosConfig_sitename,
				$ea_map24_dlg,$ea_map24_dinfo,$ea_map24_dimg	);
		}
		else $obj->map24link = "";	
		// replace country ISO code with country name
		$obj->country = $obj->country_ISOtoName($obj->country);

		$pageNav = "";				
		if(isset($_SESSION['sres'])){
			require_once 'includes/pageNavigation.php';
    		$pageNav = new mosPageNav(count($_SESSION['sres']), $limitstart, $limit);
		}		
		if($ea_nformat == 0){
			$params['sep1'] 	= ".";
			$params['sep2'] 	= ",";
		}
		else{
			$params['sep1'] 	= ",";
			$params['sep2'] 	= ".";
		}		
		$params['measure'] 	= $ea_measure;
		$params['currency'] 	= $ea_currency;
		$params['picpath'] 		= $ea_picpath;
		$params['tbwidth'] 		= $ea_tbwidth;
		$params['glpup'] 		= $ea_gl_pup;
		$params['fulllocation'] = $ea_fulllocation;
					
		HTML_frontend_estateagent::show_Object($act,$task,$obj,$ct,$gl,$fl,$pageNav,$params );
	}
	else{
			$msg = _EA_OBJ_TYPE_NOACCESS;
			mosRedirect(sefRelToAbs("index.php?option=com_estateagent&act=cat&id=".$obj->cat), $msg);
	}
}

function sendMail($option,$act,$task,$gid){
	global $mosConfig_live_site, $database;

    $query="SELECT name, email_to FROM #__contact_details WHERE user_id = " . $_POST['owner'] . " AND published = 1 AND access <= $gid";
    $database->setQuery($query);
	$row = null;
	$database->loadObject($row);
       			
    $ctf_name = strip_tags($_POST['ctf_name']);
   	$ctf_fon  = strip_tags($_POST['ctf_fon']);
    $ctf_fax  = strip_tags($_POST['ctf_fax']);
    $ctf_mail = strip_tags($_POST['ctf_mail']);
    $ctf_subject = strip_tags($_POST['ctf_subject']);
   	$ctf_msg = strip_tags($_POST['ctf_message']);
		
	$header="From: " . $ctf_mail . "\n";
	$mail_body .= _EA_CTF_MAIL1;
	$mail_body .= _EA_CTF_MAIL2 . date("d.m.Y") . " / " . date("H:i") . _EA_CTF_MAIL3;
	$mail_body .= _EA_CTF_MAIL4;
	$mail_body .= _EA_CTF_NAME . ": " . $ctf_name . "\n";
	$mail_body .= _EA_CTF_MAIL . ": " . $ctf_mail . "\n";
	$mail_body .= _EA_CTF_FON . ": " . $ctf_fon . "\n";
	$mail_body .= _EA_CTF_FAX . ": " . $ctf_fax . "\n";
	$mail_body .= _EA_CTF_INSPECT . ": " . $ctf_inspect . "\n";
	$mail_body .= _EA_CTF_MESSAGE . ": " . $ctf_msg . "\n\n";

	if(mail($row->email_to,$ctf_subject,$mail_body,$header)) 	$msg = _EA_CTF_MSUCCESS;
	else $msg = _EA_CTF_MNOSUCCESS;
	
    mosRedirect(sefRelToAbs("index.php?option=com_estateagent&act=object&task=showEO&id=".$_POST['id']), $msg);   			
    
}
function mailToFriend($option,$act,$task,$id,$send ) {
	global $database, $my, $mainframe, $ea_footer;
    global $mosConfig_live_site, $mosConfig_sitename;
    global $mosConfig_mailfrom, $mosConfig_fromname;
  
	if($send == 0){ // show mailform

		$obj = new mosContent( $database );
    	$obj->load( $id );
  
    	if ( $obj->id === null || $obj->access > $my->gid ) {
    		mosNotAuth();
        	return;
    	} else {
    		$query = "SELECT template FROM #__templates_menu"
        				. "\n WHERE client_id = 0"
        				. "\n AND menuid = 0";
	        $database->setQuery( $query );
    	    $tmpl = $database->loadResult();
        
			$ea_footer = 0; // do not show EA footer in popup window
	
			HTML_frontend_estateagent::show_mtfForm( $obj->id, $obj->title, $tmpl );
      	}
	}
	else{ // send email to friend

		$validate = mosGetParam( $_POST, mosHash( 'validate' ), 0 );
      	if (!$validate) {
        	// probably a spoofing attack
          	echo _NOT_AUTH;
          	return;
      	}
  
      	$oid				= mosGetParam( $_POST, 'id', '0' );
      	$email          	= mosGetParam( $_POST, 'email', '' );
      	$sendername        	= mosGetParam( $_POST, 'sendername', '' );
      	$senderemail	    = mosGetParam( $_POST, 'senderemail', '' );
      	$subject_default    = _EA_ETF_INFO .' ' . $sendername;
      	$subject 			= mosGetParam( $_POST, 'subject', $subject_default );
  				
      	if ($oid < 1 || !$email || !$senderemail || ( check_email( $email ) == false ) || (check_email( $senderemail ) == false)) {
        	echo "<script> alert('"._EA_ETF_ERR_NOEMAIL."'); window.history.go(-1);</script>";
      	}
  
      	$query = "SELECT template FROM #__templates_menu"
      				. "\n WHERE client_id = 0"
      				. "\n AND menuid = 0";
      	$database->setQuery( $query );
      	$tmpl = $database->loadResult();
        	
      	$link = sefRelToAbs( $mosConfig_live_site .'/index.php?option=com_estateagent&act=object&task=showEO&id='. $oid );
       	$msg = sprintf( _EA_ETF_MSG, $sendername, $senderemail, $mosConfig_sitename, $link );
       	mosMail( $senderemail, $sendername, $email, $subject, $msg );
  
      	HTML_frontend_estateagent::emailTFSent( $email, $tmpl );
	}
}

// search functions ---------------------------
function showSearchForm($option,$act,$task,$today){
	global $database,$gid,$ea_f_srch,$ea_l_srch,$ea_d_srch,$ea_loc_srchtype,$ea_measure,$ea_currency;
	
	if($ea_f_srch || $ea_l_srch || $ea_d_srch){
    	
		$map = 0;
    	$countries=array();$countrynames=array();$states=array();$towns=array();$districts=array();
		$countrieslist=array();$countrynameslist=array();$stateslist=array();$townslist=array();$districtslist=array();					 					 
    	$param["option_text"] = "";
		$sp=array();$pageNav = "";
				
    	// get main- and subcategories and generate selectlist
    	$query = "SELECT * FROM #__estateagent_categories"
					. "\n WHERE"
					. " ("
					. "\n ((publish_up >= '0000-00-00' AND publish_up <= '$today') AND publish_down >= '$today')"
       				. "\n OR ((publish_up >= '0000-00-00' AND publish_up <= '$today' ) AND (publish_down = '0000-00-00' OR publish_down >= '$today'))"
       				. "\n OR (publish_up = '0000-00-00' AND publish_down = '0000-00-00')"
       				. "\n )"
					. "\n AND parent = '0' AND access<=$gid AND publish='1' ORDER BY ordering";
		$database->setQuery($query);
    	$cats = $database->loadObjectList();
	 				
		$select_cat = "<select class=\"inputbox\" name=\"src_cat\" id=\"src_cat\" size=\"1\">";
    	$select_cat .= "<option value=\"A\">" . _EA_CAT_ALL . "</option>";
    	foreach($cats as $cat) {
    		$select_cat .= "<option value=\"" . $cat->id . "\">&nbsp;";
    		$select_cat .= $cat->name . "</option>";
	
			// let`s look for subcategories and show them
			$cat->sc = new EACategory($database);
			$scats = $cat->sc->getSubcategories($cat->id, $gid);
						
			foreach($scats as $scat) {
				$select_cat .= "<option value=\"" . $scat->id . "\">&nbsp;";
    			$select_cat .= "&nbsp;'--> " . $scat->name . "</option>";				
			}	
		}		
    	$select_cat .= "</select>&nbsp;<!--span style=\"color:red; font-weight:bold\">*</span-->";
    	
		if($ea_l_srch){
    	
    		$param["option_text"] = _EA_NO_OPTION;
    	
			// get location map
    		$map = getMap($today);
    	
			// generate countries array 
        	$x=0;
        	foreach($map as $m){
        		$countries[$x] = $m->country;
				$countrynames[$x] = EAObject::country_ISOtoName($m->country);
				$x++;        	
        	}
        	$countries = implode("#", array_unique($countries));
        	$countries = explode("#",$countries);
			$countrynames = implode("#", array_unique($countrynames));
        	$countrynames = explode("#",$countrynames);
    				
    		// generate array states
        	for($state=0;$state<count($map);$state++){
        		$row =& $map[$state];
        		for($country=0;$country<count($countries);$country++) {
        			if($row->country == $countries[$country]) $states[$country][$state] = $row->state;
        			else continue;
        		}
        	}
        	for($country=0;$country<count($countries);$country++){
        		$states[$country] = implode("#", array_unique($states[$country]));
        		$states[$country] = explode("#", $states[$country]);
        	}
    				
    		// Generate array of Towns ---------------
        	for($town=0;$town<count($map);$town++){
        		$row =& $map[$town];
        		for($country=0;$country<count($countries);$country++) {
        			for($state=0;$state<count($states[$country]);$state++) {
        				if($row->state == $states[$country][$state]) $towns[$country][$state][$town] = $row->town;
        				else continue;
        			}
        		}
        	}
        	for($country=0;$country<count($countries);$country++) {
        		for($state=0;$state<count($states[$country]);$state++) {
        			$towns[$country][$state] = implode("#", array_unique($towns[$country][$state]));
        				$towns[$country][$state] = explode("#", $towns[$country][$state]);
        		}
        	}
    				
    		// Generate array of Districts ---------------
        	for($district=0;$district<count($map);$district++){
        		$row =& $map[$district];
        		for($country=0;$country<count($countries);$country++) {
        			for($state=0;$state<count($states[$country]);$state++) {
        				for($town=0;$town<count($towns[$country][$state]);$town++) {
        					if($row->town == $towns[$country][$state][$town]) $districts[$country][$state][$town][$district] = $row->district;
        					else continue;
        				}
        			}
        		}
        	}
        	for($country=0;$country<count($countries);$country++) {
        		for($state=0;$state<count($states[$country]);$state++) {
        			for($town=0;$town<count($towns[$country][$state]);$town++) {
        				$districts[$country][$state][$town] = implode("#", array_unique($districts[$country][$state][$town]));
        				$districts[$country][$state][$town] = explode("#", $districts[$country][$state][$town]);
        			}
        		}
        	}
    	
			if($ea_loc_srchtype){	
			
				$param["option_text"] = _EA_NOT_SELECTED;
				
        		foreach($map as $m){
        			$countrieslist[]		= $m->country;
					$countrynameslist[]= EAObject::country_ISOtoName($m->country);
					$stateslist[]			= $m->state;
					$townslist[]			= $m->town;
					$districtslist[]			= $m->district;	
					$x++;
        		}
        		$countrieslist			= implode("#", array_unique($countrieslist));
        		$countrieslist 		= explode("#",$countrieslist);
				$countrynameslist	= implode("#", array_unique($countrynameslist));
        		$countrynameslist	= explode("#",$countrynameslist);
				$stateslist				= implode("#", array_unique($stateslist));
				$stateslist				= explode("#", $stateslist);
				$townslist				= implode("#", array_unique($townslist));
				$townslist				= explode("#", $townslist);
		 		$districtslist			= implode("#", array_unique($districtslist));
				$districtslist			= explode("#", $districtslist);			
			}
    	}
	
    	if($ea_d_srch){
    					
    		$dws[] = mosHTML::makeOption( '0', _EA_NO_OPTION );
    		$dws[] = mosHTML::makeOption( '1', _EA_SRCH_FOR_DWSPACE_1.$ea_measure );
    		$dws[] = mosHTML::makeOption( '2', _EA_SRCH_FOR_DWSPACE_2.$ea_measure );
    		$dws[] = mosHTML::makeOption( '3', _EA_SRCH_FOR_DWSPACE_3.$ea_measure );
    		$dws[] = mosHTML::makeOption( '4', _EA_SRCH_FOR_DWSPACE_4.$ea_measure );
    		$dws[] = mosHTML::makeOption( '5', _EA_SRCH_FOR_DWSPACE_5.$ea_measure );
    		$dws[] = mosHTML::makeOption( '6', _EA_SRCH_FOR_DWSPACE_6.$ea_measure );
    		$dws[] = mosHTML::makeOption( '7', _EA_SRCH_FOR_DWSPACE_7.$ea_measure );
    		$sp[0] = mosHTML::selectList( $dws, 'space', 'class="inputbox" size="1"', 'value', 'text', 0 );
			    
	 		$yblt[] = mosHTML::makeOption( '0', _EA_NO_OPTION );
    		$yblt[] = mosHTML::makeOption( '1', _EA_SRCH_YOBUILT_1 );
    		$yblt[] = mosHTML::makeOption( '2', _EA_SRCH_YOBUILT_2 );
    		$yblt[] = mosHTML::makeOption( '3', _EA_SRCH_YOBUILT_3 );
    		$yblt[] = mosHTML::makeOption( '4', _EA_SRCH_YOBUILT_4 );
    		$yblt[] = mosHTML::makeOption( '5', _EA_SRCH_YOBUILT_5 );
    		$yblt[] = mosHTML::makeOption( '6', _EA_SRCH_YOBUILT_6 );
    		$yblt[] = mosHTML::makeOption( '7', _EA_SRCH_YOBUILT_7 );
    		$sp[1] = mosHTML::selectList( $yblt, 'yobuilt', 'class="inputbox" size="1"', 'value', 'text', 0 );
			
			$srm[] = mosHTML::makeOption( '0', _EA_NO_OPTION );
    		$srm[] = mosHTML::makeOption( '1', _EA_SRCH_FOR_ROOMS_1 );
    		$srm[] = mosHTML::makeOption( '2', _EA_SRCH_FOR_ROOMS_2 );
    		$srm[] = mosHTML::makeOption( '3', _EA_SRCH_FOR_ROOMS_3 );
    		$srm[] = mosHTML::makeOption( '4', _EA_SRCH_FOR_ROOMS_4 );
    		$srm[] = mosHTML::makeOption( '5', _EA_SRCH_FOR_ROOMS_5 );
     		$srm[] = mosHTML::makeOption( '6', _EA_SRCH_FOR_ROOMS_6 );
     		$srm[] = mosHTML::makeOption( '7', _EA_SRCH_FOR_ROOMS_7 );
     		$sp[2] = mosHTML::selectList( $srm, 'rooms', 'class="inputbox" size="1"', 'value', 'text', 0 );
    		$sp[3] = mosHTML::selectList( $srm, 'bedrooms', 'class="inputbox" size="1"', 'value', 'text', 0 );
				
			$sp[4] = mosEAHTML::checkbox( "atb[]", 'class="inputbox"', 'ufloor', '', 0, 0 );
			$sp[5] = mosEAHTML::checkbox( "atb[]", 'class="inputbox"', 'fireside', '', 0, 0 );
			$sp[6] = mosEAHTML::checkbox( "atb[]", 'class="inputbox"', 'aircondition', '', 0, 0 );
			$sp[7] = mosEAHTML::checkbox( "atb[]", 'class="inputbox"', 'lift', '', 0, 0 );
			$sp[8] = mosEAHTML::checkbox( "atb[]", 'class="inputbox"', 'handicap', '', 0, 0 );
			$sp[9] = mosEAHTML::checkbox( "atb[]", 'class="inputbox"', 'tv', '', 0, 0 );
			$sp[10] = mosEAHTML::checkbox( "atb[]", 'class="inputbox"', 'dsl', '', 0, 0 );
			$sp[11] = mosEAHTML::checkbox( "atb[]", 'class="inputbox"', 'pool', '', 0, 0 );
			$sp[12] = mosEAHTML::checkbox( "atb[]", 'class="inputbox"', 'garden', '', 0, 0 );
			$sp[13] = mosEAHTML::checkbox( "atb[]", 'class="inputbox"', 'garage', '', 0, 0 );
			$sp[14] = mosEAHTML::checkbox( "atb[]", 'class="inputbox"', 'parkarea', '', 0, 0 );

		}
    	
		$sort1[] = mosHTML::makeOption( '', _EA_NO_OPTION );
		$sort1[] = mosHTML::makeOption( 'ORDER BY rent', _EA_OBJ_RENT );
    	$sort1[] = mosHTML::makeOption( 'ORDER BY price', _EA_OBJ_PRICE );
    	$sort1[] = mosHTML::makeOption( 'ORDER BY space', _EA_OBJ_DWSPACE );
    	$sort1[] = mosHTML::makeOption( 'ORDER BY rooms', _EA_OBJ_ROOMNR );
		$sort1[] = mosHTML::makeOption( 'ORDER BY bedrooms', _EA_OBJ_BEDROOMS );
    	$sort1[] = mosHTML::makeOption( 'ORDER BY yobuilt', _EA_OBJ_YOBUILT );
    	$sp[15] = mosHTML::selectList( $sort1, 'sort', 'class="inputbox" size="1"', 'value', 'text', "" );
				    
	  	$sort2[] = mosHTML::makeOption( 'ASC', _EA_SRCH_ASC );
    	$sort2[] = mosHTML::makeOption( 'DESC', _EA_SRCH_DESC );
    	$sp[16] = mosHTML::selectList( $sort2, 'sort1', 'class="inputbox" size="1"', 'value', 'text', "ASC" );
    	
		$param["fs"] = $ea_f_srch;
		$param["ls"] = $ea_l_srch;
		$param["searchtype"] = $ea_loc_srchtype;
		$param["ds"] = $ea_d_srch;
		$param["measure"] = $ea_measure;
		$param["currency"] = $ea_currency;
		
    	HTML_frontend_estateagent::easearchform($act,$task,$map,$select_cat,
    				$countries,$countrynames,$states,$towns,$districts,$countrieslist,$countrynameslist,$stateslist,$townslist,$districtslist,$sp,$param);
    	}
		else{
			$msg = _EA_SRCH_DISABLED;
			mosRedirect(sefRelToAbs("index.php?option=com_estateagent"), $msg);   			
    	}
}

function showEASearchResult($option,$act,$task,$limit,$limitstart,$today){
	global $database, $gid, $mosConfig_offset;
	global $ea_f_srch, $ea_l_srch, $ea_d_srch, $ea_picpath, $ea_tbwidth, $ea_nformat, $ea_measure, $ea_currency, $ea_shortinfo;
									
    if(!empty($_POST)) {
		session_unregister("eac1");
		session_unregister("eac2");
		
		$sort = (!empty($_POST["sort"]))? $_POST["sort"] . " " . $_POST["sort1"]  : "";
		
		if(empty($_POST['searchstring'])){	
			$_POST["minrent"] = (isset($_POST["minrent"]))? strip_tags($_POST["minrent"]) : null;
    		$_POST["maxrent"] = (isset($_POST["maxrent"]))? strip_tags($_POST["maxrent"]) : null;				            								                		
    		$_POST["minprice"] = (isset($_POST["minprice"]))? strip_tags($_POST["minprice"]) : null;
    		$_POST["maxprice"] = (isset($_POST["maxprice"]))? strip_tags($_POST["maxprice"]) : null;
			$special = (isset($_POST["atb"])? $_POST["atb"] : null );
					
    		// convert associative array in numeric array
    		$form = array_values($_POST);
					
			#$x=0;
			#for($x=0;$x<count($form);$x++){
			#	echo $x . " = " . $form[$x] . "<br />";
			#}
										
        	// Generate SQL string
        	// step 1 - analyse setting of category
        	$cat = $form[0];
			$where = ($cat == "A")? "" : " cat=$cat AND ";					
			
			// Step 2 - analyse the location search and add part of querystring
			if(!$ea_f_srch && $ea_l_srch) {
				$result = location_srch_query($form[1],$form[2],$form[3],$form[4]);
				if($result != "") $where .= $result . " AND ";
			}
			else if($ea_f_srch && $ea_l_srch) {
				$result = location_srch_query($form[2],$form[3],$form[4],$form[5]);
				if($result != "") $where .= $result . " AND ";
			}
            
        	// Step 3 - analyse object-attributes search settings and add part of querystring
        	if($ea_l_srch && $ea_d_srch) {               			
        		$result = extended_srch_query($form[6],$form[7],$form[8],$form[9],$form[10],$form[11],$form[12],$form[13],$special);                		
        		if($result != "") $where .= $result . " AND ";
        	}
        	elseif($ea_l_srch == '0' && $ea_d_srch == '1'){
        		$result = extended_srch_query($form[2],$form[3],$form[4],$form[5],$form[6],$form[7],$form[8],$form[9],$special);
        		if($result != "") $where .= $result . " AND ";
        	}
      	}
		else{
			$searchstring =	strip_tags(trim($_POST['searchstring']));
			$where = " (obj_id LIKE '%$searchstring%'" .
            				" OR description LIKE '$searchstring%') AND ";
		}
				
		$query  = "SELECT id FROM #__estateagent WHERE " . $where . "("
				. "\n ((publish_up >= '0000-00-00' AND publish_up <= '$today') AND publish_down >= '$today')"
       			. "\n OR ((publish_up >= '0000-00-00' AND publish_up <= '$today' ) AND (publish_down = '0000-00-00' OR publish_down >= '$today'))"
       			. "\n OR (publish_up = '0000-00-00' AND publish_down = '0000-00-00')"
				. "\n )"
       			. "\n AND access<=$gid AND publish='1'";				
		$database->setQuery($query);
		$total = $database->loadObjectList();
		#echo $query . "<br /><br />";		
		
		require_once 'includes/pageNavigation.php';
       	$pageNav = new mosPageNav(count($total), $limitstart, $limit);
				
		$query  = "SELECT * FROM #__estateagent WHERE " . $where . "("
				. "\n ((publish_up >= '0000-00-00' AND publish_up <= '$today') AND publish_down >= '$today')"
       			. "\n OR ((publish_up >= '0000-00-00' AND publish_up <= '$today' ) AND (publish_down = '0000-00-00' OR publish_down >= '$today'))"
       			. "\n OR (publish_up = '0000-00-00' AND publish_down = '0000-00-00')"
				. "\n )"
       			. "\n AND access<=$gid AND publish='1' " .  $sort . " LIMIT " .$limitstart.",".$limit;
		$database->setQuery($query);
       	$results = $database->loadObjectList();
       	#echo $query;
		
	}
    else{	
        	$where = ""; $x=0;
           	foreach($_SESSION['sres'] as $ids){
           		if($x==0) $where .= " id=".$ids;
               	else $where .= " OR id=".$ids;
               	$x++;
            }                   		
                    	                    	
           	$query  = "SELECT id FROM #__estateagent WHERE ".$where;
           	$database->setQuery($query);
           	$total = $database->loadObjectList();
           	                    	
           	require_once 'includes/pageNavigation.php';
        	$pageNav = new mosPageNav(count($total), $limitstart, $limit);
                    	
            $query  = "SELECT * FROM #__estateagent WHERE ".$where." LIMIT ".$limitstart.",".$limit;
            $database->setQuery($query);
            $results = $database->loadObjectList();
        }
                    			 					 					 	
		// variable for saving searchresults in a session				 	
		if($total){
			$x=0; $_SESSION['sres'] = array();
			foreach($total as $o){                 	    
           		$_SESSION['sres'][$x] = $o->id;                	    
        		$x++;
        	}
		}		
		if($ea_nformat == 0){
			$params['sep1'] 	= ".";
			$params['sep2'] 	= ",";
		}
		else{
			$params['sep1'] 	= ",";
			$params['sep2'] 	= ".";
		}		
		$params['picpath']		= $ea_picpath;
		$params['tbwidth']		= $ea_tbwidth;
		$params['measure'] 	= $ea_measure;
		$params['currency']	= $ea_currency;
		$params['shortinfo']	= explode(",",$ea_shortinfo);
			                 	
        HTML_frontend_estateagent::show_result($option,$act,$task,$results,$pageNav,$limitstart, $limit, $params);
	
}
?>
