<?php
/**
 * OpenSEF for Joomla!
 * @copyright (c) 2005 The OpenSEF Project (www.opensef.org)
 * @copyright (c) 2004-2005 Xaneon Development (www.xaneon.com)
 * @license GPL http://www.gnu.org/copyleft/gpl.html
 *
 * The Auto-Mapper is responsible for creating human-friendly addresses
 * for content items. In other words, this is where the 'magic' happens,
 * turning index.php?option=com_content&task=view&id=6&Itemid=2 into
 * /news/latest/example_news_item_1.html when the original URL is
 * accessed for the first time.
 *
 * This is also an obvious candidate for site-specific customization by
 * the site developer/administrator, should they wish to implement URLs
 * that significantly differ from what's achievable with OpenSEF's
 * configuration settings. Overriding the auto-mapper means creating an
 * OpenSEF extension and subclassing the sefAutoMapper class.
 *
 * NOTE: this code is one of the likeliest places to experience a high
 * proportion of bugs in special circumstances, as of beta 2.
 */

/** Ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct access to this location is not allowed.' );

/** */
@define( '_SEF_AUTOMAPPER', 'sefAutoMapper' );

class sefAutoMapper extends sefObject {
  var $replace = null;

  /*
   * @param object $db the database connection object
   * @param object $config an instance of mosSEFConfig
   * @param object $site an instance of mosSEFSite
   */
  function sefAutoMapper( &$db, &$config, &$site ) {
    $this->sefObject( $db, $config, $site );
    $this->replace = array(
      ' / ' => '/',
      ' ' => (!empty( $this->config->encode_space_char ) ?
        $this->config->encode_space_char : '_'),
    );
  }

  /*
   * This could be considered the only public interface of this class.
   * It takes an internal Joomla URL as a parameter, attempts to
   * auto-map it, stores the result in the URL database, and returns
   * the row object.
   *
   * Note that if the auto-mapping didn't succeed (as currently
   * happens with e.g. blogcategories) an URL alias record is still
   * created, but with the Published field set to false.
   *
   * @param string $url the internal Joomla URL to auto-map
   * @return mosSEFAlias the newly created URL alias record
   */
  function map( $url ) {
  	$title = $this->getContentPath( $url );
    $alias =& new mosSEFAlias( $this->db );
    $alias->site_id = $this->site->id;
    $alias->published = ($title ? '1' : '0');
    $alias->valid = '1';
    $alias->external = $title;
    if (eregi("mosmsg=", $url)) {
    	return $url;
    }
    $alias->internal = $url;
    $alias->hits = 0; // Auto-redirect will cause a hit...
    $alias->check();
    if (!$alias->store( false )) {
      // TODO: insert failed, should not happen. Are SQL tables missing?
      die( "DEBUG: row->store() failed!" );
    }
    return $alias;
  }

  /*
   * Given a content item, returns the encoded form of its title or
   * title alias (as determined by the configuration) suitable for use
   * in a URL alias.
   *
   * @param mixed $item the content item's ID or a mosContent instance
   * @return string the encoded title or title alias
   */
  function getContentURL( $item ) {
  	if (is_numeric( $item )) {
      $id = $item;
      $item =& new mosContent( $this->db );
      $item->load( $id );
    }
    $title_field = $this->config->content_title_field;
    $title = ($title_field == 'title_alias' && $item->title_alias ?
      $item->title_alias : $item->title );
      /*
    $spec_chars_d = array($this->config->spec_chars_d);
    $spec_chars = array($this->config->spec_chars);
    foreach ($spec_chars_d as $i => $spec_char)
    {
      $title=str_replace($spec_char, $spec_chars[$i], $title);
    }  */
    return $this->encode( $title );
  }

  /*
   * Given a section, returns the encoded form of its name or
   * title (as determined by the configuration) suitable for use
   * in a URL alias.
   *
   * @param mixed $item the section's ID or a mosSection instance
   * @return string the encoded section name or title
   */
  function getSectionURL( $item ) {
    if (is_numeric( $item )) {
      $id = $item;
      $item =& new mosSection( $this->db );
      $item->load( $id );
    }
    $title_field = $this->config->section_title_field;
    $title = ($title_field == 'name' && $item->name ?
      $item->name : $item->title);
    return $this->encode( $title );
  }

  /*
   * Given a category, returns the encoded form of its name or
   * title (as determined by the configuration) suitable for use
   * in a URL alias.
   *
   * @param mixed $item the section's ID or a mosCategory instance
   * @return string the encoded category name or title
   */
  function getCategoryURL( $item ) {
    if (is_numeric( $item )) {
      $id = $item;
      $item =& new mosCategory( $this->db );
      $item->load( $id );
    }
    $title_field = $this->config->category_title_field;
    $title = ($title_field == 'name' && $item->name ?
      $item->name : $item->title);
    return $this->encode( $title );
  }

  /*
   * Attempts to convert an internal Joomla URL to a friendly URL
   * alias. This is the very meat of the matter.
   *
   * @param string $str an internal Joomla URL (index.php?option=com_...)
   * @return string|null a friendly URL or null if auto-mapping failed
   */
  function getContentPath( $str ) {
  	global $database;
    parse_str( $str, $info );

    $title_field = $this->config->content_title_field;
    $path_type = $this->config->content_path_type;
    $page_format = $this->config->content_page_format;
    if ($page_format == '') $page_format = '%s_%d';
    $page_suffix = $this->config->encode_page_suffix;

    $path = array();
    
    if ( $info['index_php?option'] == 'com_weblinks') {;
    	if ($this->config->use_alias_links) {
    		$path[] = $this->config->alias_links;
    	}	 
    	$suffix = '/';
    	if (isset($info['catid']) && !$info['id']) {
          $path[] = $this->getCategoryURL( $info['catid'] );
        }
		if (isset($info['catid']) && isset( $info['id'] ) ) {
			$path[] = $this->getCategoryURL( $info['catid'] );
			$path[] = $this->getWebLinkURL( $info['id'] );
			$suffix = $page_suffix;
			$info['task'] = '';
		}
    }
    if ( $info['index_php?option'] == 'com_newsfeeds') {;
    	if ($this->config->use_alias_newsfeeds) {
    		$path[] = $this->config->alias_newsfeeds;
    	}	 
    	$suffix = '/';
    	if (isset($info['catid'])) {
          $path[] = $this->getCategoryURL( $info['catid'] );
        }
		if (isset( $info['feedid'] ) ) {
			$catid = $this->getNewsfeedsCatURL( $info['feedid'] );
			$path[] = $this->getCategoryURL( $catid );
			$path[] = $this->getNewsfeedsURL( $info['feedid'] );
			$suffix = $page_suffix;
			$info['task'] = '';
		}
    }
    if ( $info['index_php?option'] == 'com_contact') {;
    	if ($this->config->use_alias_contact) {
    		$path[] = $this->config->alias_contact;
    	}	 
    	$suffix = '/';
    	if (isset($info['catid'])) {
          $path[] = $this->getCategoryURL( $info['catid'] );
        }
		if (isset( $info['contact_id'] ) ) {
			$catid = $this->getContactCatURL( $info['contact_id'] );
			$path[] = $this->getCategoryURL( $catid );
			$path[] = $this->getContactURL( $info['contact_id'] );
			$suffix = $page_suffix;
			$info['task'] = '';
		}
    }
    if ( $info['index_php?option'] == 'com_wrapper') {;
    	if ($this->config->use_alias_wrapper) {
    		$path[] = $this->config->alias_wrapper;
    	}
    	$suffix = '/';
    	if (isset( $info['Itemid'] ) ) {	 
     		$database->setQuery("SELECT name FROM #__menu WHERE id=".$info['Itemid']);
			$path[] = $database->loadResult();
			$suffix = $page_suffix;
			$info['task'] = '';
    	}
    }
    

    switch ($info['task']) {
    	
      case 'view':
        $item =& new mosContent( $this->db );
        $item->load( $info['id'] );
        if ($path_type == 'full' || $path_type == 'section')
          $path[] = $this->getSectionURL( $item->sectionid );
        if ($path_type == 'full' || $path_type == 'category')
          $path[] = $this->getCategoryURL( $item->catid );

        $title = $this->getContentURL( $item );

        if (isset( $info['limit'] ) && isset( $info['limitstart'] )) {
          $page = $info['limitstart'];
          if (!is_numeric( $page ))
            return null;
          $page = (int)$page + 1;
          if ($page > 1) {
            $title = str_replace( array( '%s', '%d' ), array( $title, $page ), $page_format );
          }
          else {
            // TODO: should be able to set alias direction to outgoing only?
          }
        }

        $path[] = $title;
        $suffix = $page_suffix;

        break;

      // index.php?option=com_content&task=section&id=3&Itemid=40
      case 'section':
      	if ($info['id']) {
          $path[] = $this->getSectionURL( $info['id'] );
		if (isset( $info['limit'] ) && isset( $info['limitstart'] )) {
			if ($info['limitstart'] > 0){
				$path[] = $info['limit'];
				$path[] = $info['limitstart'];
			}
		}
          $suffix = '/';
        }
        break;
        // index.php?option=com_content&task=blogsection&id=0&Itemid=39  
        case 'blogsection':
        if ($info['id']) {
          $path[] = $this->getSectionURL( $info['id'] );
		
		if (isset( $info['limit'] ) && isset( $info['limitstart'] )) {
			if ($info['limitstart'] > 0){
				$path[] = $info['limit'];
				$path[] = $info['limitstart'];
			}
			$suffix = '/';
		  }
          $suffix = '/';
        }
        break;
        // index.php?option=com_content&task=category&sectionid=3&id=7&Ite...
      	case 'category':
      	if ($info['id']) {
          $cat =& new mosCategory( $this->db );
          $cat->load( $info['id'] );
          if ($path_type == 'full' && $cat->section)
          $path[] = $this->getSectionURL( $cat->section );
          $path[] = $this->getCategoryURL( $cat );
          if (isset( $info['limit'] ) && isset( $info['limitstart'] )) {
			if ($info['limitstart'] > 0){
				$path[] = $info['limit'];
				$path[] = $info['limitstart'];
			}
		  }
		  $suffix = '/';
        }
        break;
        // index.php?option=com_content&task=blogcategory&id=0&Itemid=39  
        case 'blogcategory': 
        if ($info['id']) {
          $cat =& new mosCategory( $this->db );
          $cat->load( $info['id'] );
          if ($path_type == 'full' && $cat->section)
          $path[] = $this->getSectionURL( $cat->section );
          $path[] = $this->getCategoryURL( $cat );
          if (isset( $info['count'] ) && isset( $info['intro'] )) {
			if ($info['count'] > 0){
				$path[] = $info['count'];
				$path[] = $info['intro'];
			}
		}
          $suffix = '/';
        }
        break;
        // index.php?option=com_content&task=archivesection&id=3...
        case 'archivesection':
       	if ($info['id']) {
          $path[] = $this->getSectionURL( $info['id'] );
		  $suffix = '/';
        }
        break;
        // index.php?option=com_content&task=archivecategory&year=2006&month=11&module=1...
        case 'archivecategory':
        if (isset( $info['year'] ) && isset( $info['month'] )) {
			if ($info['year'] > 0){
				$path[] = $info['year'];
				$path[] = $info['month'];
				$path[] = $info['module'];
			}
		  $suffix = '/';
        }
        break;
             
      default:
        break;
    }

    if (count( $path ) > 0) {
      //$url = $this->site->base_url;
      $url = '';
      foreach ($path as $item) {
        if ($item != '')
          $url .= '/' . $this->encode( $item );
      }
      if (!empty( $suffix ))
        $url .= $suffix;
      $url = str_replace( '//', '/', $url ); // Just in case...
      return $url;
    }

    return null;
  }
   /*
   * Given a content item, returns the encoded form of its title or
   * title alias (as determined by the configuration) suitable for use
   * in a URL alias.
   *
   * @param mixed $item the content item's ID or a mosContent instance
   * @return string the encoded title or title alias
   */
  function getWebLinkURL( $item ) {
  	if (is_numeric( $item )) {
      $id = $item;
      $item =& new getWeblink( $this->db );
      $item->load( $id );
    }
    $title = ($title_field == 'title' && $item->title ?
      $item->title : $item->title );
    return $this->encode( $title );
  }
   /*
   * Given a content item, returns the encoded form of its title or
   * title alias (as determined by the configuration) suitable for use
   * in a URL alias.
   *
   * @param mixed $item the content item's ID or a mosContent instance
   * @return string the encoded title or title alias
   */
  function getContactURL( $item ) {
  	if (is_numeric( $item )) {
      $id = $item;
      $item =& new getContact( $this->db );
      $item->load( $id );
    }
    $title = ($title_field == 'name' && $item->name ?
      $item->name : $item->name );
    return $this->encode( $title );
  }
  function getContactCatURL( $item ) {
  	if (is_numeric( $item )) {
      $id = $item;
      $item =& new getContact( $this->db );
      $item->load( $id );
    }
    $catid = $item->catid;
    return $catid;
  }
   /*
   * Given a content item, returns the encoded form of its title or
   * title alias (as determined by the configuration) suitable for use
   * in a URL alias.
   *
   * @param mixed $item the content item's ID or a mosContent instance
   * @return string the encoded title or title alias
   */
  function getNewsfeedsURL( $item ) {
  	if (is_numeric( $item )) {
      $id = $item;
      $item =& new getNewsfeeds( $this->db );
      $item->load( $id );
    }
    $title = ($title_field == 'name' && $item->name ?
      $item->name : $item->name );
    return $this->encode( $title );
  }
  function getNewsfeedsCatURL( $item ) {
  	if (is_numeric( $item )) {
      $id = $item;
      $item =& new getNewsfeeds( $this->db );
      $item->load( $id );
    }
    $catid = $item->catid;
    return $catid;
  }

  /*
   * Converts e.g. "H�ll� �v�r���� ��kk��set!" => "Hello Everyone AakkOoset!"
   * Credits go to jennings@trad.uji.es for the original version of
   * this incredibly useful little function!
   * For more information see http://php.net/manual/en/function.str-replace.php
   */
  function unaccent( $text ) {
    // Get the HTML entities table into an array
    $trans = get_html_translation_table( HTML_ENTITIES );
    $search = array();
    $replace = array();
    // Go through the entity mappings one-by-one
    foreach ($trans as $literal => $entity) {
      // Make sure we don't process any other characters such as fractions,
      // quotes etc:
      if (ord( $literal ) >= 192) {
        // Get the accented form of the letter
        $search[] = $literal;
        // Get e.g. 'E' from string '&Eaccute'
        $replace[] = $entity[1];
      }
    }
    return str_replace( $search, $replace, $text );
  }
  

  /*
   * One-way conversion of a string (such as a document title) to a
   * URL. In the default auto-mapper this process is irreversible,
   * that is, the URL can't be turned back into the document title.
   * However, one can also conceive of a 'naive' implementation that
   * would replace this code with a simple call to PHP's urlencode,
   * such as is done (by necessity) with components supporting
   * the Joomla Advanced SEF API.
   */
  function encode( $string ) {
    // Trim off any leading or trailing spaces
    $string = trim( $string );

    // Replace characters according to user-defined rules
    $string = str_replace(
      array_keys( $this->replace ),
      array_values( $this->replace ),
      $string );

    // Strip off any banned entities such !?# etc.
    if (!empty( $this->config->encode_strip_chars )) {
      $invalid = str_split( $this->config->encode_strip_chars, 1 );
      $string = str_replace( $invalid, '', $string );
    }
    if (is_array( $this->config->spec_chars_d) && is_array( $this->config->spec_chars) ) {
    	$spec_chars_d = $this->config->spec_chars_d;
   		$spec_chars = $this->config->spec_chars;
   	    foreach ($spec_chars_d as $i => $spec_char)
    	{
      		$string = str_replace($spec_char, $spec_chars[$i], $string);
    	}  
    }
    // Convert e.g. "H�ll� �v�r����" to "Hello Everyone"
    $string = sefAutoMapper::unaccent( $string );

    // Make the text lowercase, unless the configuration says otherwise.
    if (!empty( $this->config->encode_lowercase ))
      $string = strtolower( $string );

    return $string;
  }



}

?>