<?php

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );
/**
* Booklibrary Lend Class
* Holds all Information about a lend entry
* @package Booklibrary
* @copyright 2005 Gerd Saurer http://booklibrary.mamboforge.net
* @license http://www.gnu.org/copyleft/gpl.html GNU Public License
* @version $Revision: 1.0 $
*/
class mosBooklibrary_lend_request extends mosDBTable {
	/** @var int Primary key */
	var $id = null;
	/** @var int the book id this lend is assosiated with*/
	var $fk_bookid=null;	
	/** @var int the user id of the user who lend this book can also be null if $user_name is set*/
	var $fk_userid=null;
	/** @var datetime since when this book is lend out*/
	var $lend_from=null;
	/** @var datetime when the book should be returned*/
	var $lend_until=null;
	/** @var datetime when the book realy was/is returned*/
	var $lend_request=null;
	/** @var boolean */
	var $checked_out=null;
	/** @var time */
	var $checked_out_time=null;
	/** @var string the user who lend this book if it's no user of the database*/
	var $user_name=null;
	/** @var string the e-amil adress user who lend this book if it's no user of the database*/
	var $user_email=null;
	/** @var string the e-amil adress user who lend this book if it's no user of the database*/
	var $user_mailing=null;
	/** @var string the e-amil adress user who lend this book if it's no user of the database*/
	var $status=0;
	
	/**
	* @param database A database connector object
	*/
	function mosBookLibrary_lend_request( &$db ) {
		$this->mosDBTable( '#__booklibrary_lend_request', 'id', $db );
	}
	
	// overloaded check function
	function check() {
		
		// check if book is already led out
		$this->_db->setQuery( "SELECT fk_lendid FROM #__booklibrary "
			. "\nWHERE id='$this->fk_bookid' AND fk_lendid = null"
		);						
		$xid = intval( $this->_db->loadResult() );
		if ($xid) {
			$this->_error = _BOOK_LEND_OUT;
			return false;
		}
		return true;
	}
	
		
	/**
	 * @return array - name: The sting of the User the book is lend to - email: The email adress of the user
	 */
	function getLendTo(){
		$retVal['name'] = null;
		$retVal['email'] = null;
		if($this->fk_userid != null && $this->fk_userid != 0){
			$this->_db->setQuery( "SELECT name, email from #__users where id=$this->fk_userid");
			$help = $this->_db->loadRow();
			$retVal['name'] = $help[0];
			$retVal['email'] = $help[1];
		}
		else{
			$retVal['name'] = &$user_name;
			$retVal['email'] = &$user_email;
		}
		return $retVal;
	}
	
	//status codes
	//0: just inserted
	//1: accapted
	//2: not accapted
	
	function accept(){
		if($this->id == null){
			return "Method called on an non instant object";
		}
		$this->checkout($my->id);
		
		//create new lend dataset
		$lend = new mosBookLibrary_lend($this->_db);
		$book = new mosBookLibrary($this->_db);
		$book->checkout($my->id);
		$book->load($this->fk_bookid);
		if($book->fk_lendid != 0){
			return "Book already lend out!!";
		}
		$lend->lend_from = date("Y-m-d H:i:s");
		$lend->fk_bookid=$this->fk_bookid;
		$lend->userid=$this->userid;
		$lend->until=$this->until;
		$lend->user_name=$this->user_name;
		$lend->user_email=$this->user_email;
		$lend->user_mailing=$this->user_mailing;
		
		$lend->lend_from = date("Y-m-d H:i:s");
		$lend->lend_until = $this->lend_until;		
		
		if (!$lend->check($lend)) {
			return $lend->getError();
		}
		if (!$lend->store()) {
			return $lend->getError();
		}

		$lend->checkin();
		//update book with lend id		
		$book->fk_lendid = $lend->id;
		if (!$book->store()) {
			return $book->getError();
		}
		$book->checkin();
		
		$this->status = 1;

		if (!$this->store()) {
			return $this->getError();
		}
		$this->checkin();
		return null;
	}
	
	function decline(){
		if($this->id == null){
			return "Method called on an non instant object";
		}
		$this->status = 2;
		if (!$this->store()) {
			return $this->getError();
		}
		return null;
	}
	
	function toXML(& $xmlDoc){
		
		//create and append name element 
		$retVal = & $xmlDoc->createElement("lendrequest"); 
		
		$fk_userid = & $xmlDoc->createElement("fk_userid");
		$fk_userid->appendChild($xmlDoc->createTextNode($this->fk_userid));
		$retVal->appendChild(& $fk_userid);
		
		$lend_from = & $xmlDoc->createElement("lend_from");
		$lend_from->appendChild($xmlDoc->createTextNode($this->lend_from));
		$retVal->appendChild(& $lend_from);
		
		$lend_until = & $xmlDoc->createElement("lend_until");
		$lend_until->appendChild($xmlDoc->createTextNode($this->lend_until));
		$retVal->appendChild(& $lend_until);
		
		$lend_request = & $xmlDoc->createElement("lend_retquest");
		$lend_request->appendChild($xmlDoc->createTextNode($this->lend_request));
		$retVal->appendChild(& $lend_request);
		
		$user_name = & $xmlDoc->createElement("user_name");
		$user_name->appendChild($xmlDoc->createTextNode($this->user_name));
		$retVal->appendChild(& $user_name);
		
		$user_email = & $xmlDoc->createElement("user_email");
		$user_email->appendChild($xmlDoc->createTextNode($this->user_email));
		$retVal->appendChild(& $user_email);
		
		$user_mailing = & $xmlDoc->createElement("user_mailing");
		$user_mailing->appendChild($xmlDoc->createTextNode($this->user_mailing));
		$retVal->appendChild(& $user_mailing);
		
		$status = & $xmlDoc->createElement("status");
		$status->appendChild($xmlDoc->createTextNode($this->status));
		$retVal->appendChild(& $status);
		
		return $retVal;
	}
}
?>
