<?php
/*
package    : VirtueUpload
version    : 1.0.0 STABLE
author     : Tobias Kuhn - eaxs.de
Homepage   : http://www.eaxs.de
copyright  : Copyright (C) 2006 Tobias Kuhn - eaxs.de
license    : http://www.gnu.org/copyleft/gpl.html

* VirtueUpload is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
*/

// no direct access
defined( '_VALID_MOS' ) or die( 'Restricted access' );

require_once( $mainframe->getPath( 'admin_html' ) );
require_once($mosConfig_absolute_path .'/administrator/components/com_virtueupload/admin.virtueupload.cfg.php');
$id = mosGetParam( $_REQUEST, 'id');
$cid = mosGetParam( $_POST, 'cid', array(0) );
if (!is_array( $cid )) {
	$cid = array(0);
}


switch ($task) {

  default:
    list_uploads();
    break;

  case 'delete':
    delete_file($cid);
    break;

  case 'details':
    show_details($id);
    break;

  case 'settings':
    show_cfg();
    break;

  case 'save':
    mosCache::cleanCache( 'com_virtueupload' );
    save_cfg();
    break;

  case 'cancel':
    mosCache::cleanCache( 'com_virtueupload' );
    mosRedirect("index2.php?option=com_virtueupload");
    break;

  case 'banlist':
    show_banlist();
    break;

  case 'unban':
    unban_user($cid);
    break;

}

/*==============================================================================
* Author    : Tobias Kuhn
* Function  : list_uploads
* Parameter : -
* Return    : log entrys for HTML output
==============================================================================*/
function list_uploads() {
  global $database, $mosConfig_absolute_path, $mainframe, $mosConfig_list_limit;
  require_once( $GLOBALS['mosConfig_absolute_path'] . '/administrator/includes/pageNavigation.php' );
  $limit 		= $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', $mosConfig_list_limit );
  $limitstart 	= $mainframe->getUserStateFromRequest( "view{$option}limitstart", 'limitstart', 0 );

  $query = "SELECT COUNT(*)"
         . "\n FROM #__virtueuploads";
         $database->setQuery( $query );
	     $total = $database->loadResult();

  $pageNav = new mosPageNav( $total, $limitstart, $limit );

  $query = "SELECT id, file_name, file_size, order_id, upload_by, link, ip, comment, date, cdate"
         . "\n FROM #__virtueuploads"
         . "\n ORDER BY date DESC LIMIT $pageNav->limitstart, $pageNav->limit";
         $database->setQuery($query);
         $rows = $database->loadObjectList();

  html_virtueupload::list_uploads($rows, $pageNav);
}
/*==============================================================================
* Author    : Tobias Kuhn
* Function  : delete_file
* Parameter : selected files/log entrys
* Return    : -
==============================================================================*/
function delete_file (&$cid) {
  global $database, $mosConfig_absolute_path;

  $total = count( $cid );
  $cids = implode( ',', $cid );

  if ( $total < 1) {
  echo "<script> alert('VULANG_LOG_NOSELECT'); window.history.go(-1);</script>\n";
  exit;
  }
  $query = "SELECT link, file_name"
         . "\n FROM #__virtueuploads"
         . "\n WHERE id IN ( $cids )";
         $database->setQuery($query);
         $rows = $database->loadObjectList();

  for ($i=0, $n=count( $rows ); $i < $n; $i++) {
       $row  = &$rows[$i];
       $file = $mosConfig_absolute_path."/".$row->link."/".$row->file_name;
       @unlink($file);
  }
  $query = "DELETE FROM #__virtueuploads"
	     . "\n WHERE id IN ( $cids )";
	     $database->setQuery( $query );
         $database->query();

  $msg = $total . VULANG_LOG_DELSUCCESS;
  mosRedirect( 'index2.php?option=com_virtueupload', $msg);

}
/*==============================================================================
* Author    : Tobias Kuhn
* Function  : show_details
* Parameter : selected file/log entry
* Return    : Comment for HTML output
==============================================================================*/
function show_details ($id) {
  global $database;

  $query = "SELECT *"
         . "\n FROM #__virtueuploads"
         . "\n WHERE id = $id";
         $database->setQuery($query);
         $details = $database->loadObjectList();

  html_virtueupload::show_details($details);
}
/*==============================================================================
* Author    : Tobias Kuhn
* Function  : show_cfg
* Parameter : -
* Return    : Virtuemart shopper-groups for HTML output
==============================================================================*/
function show_cfg () {
  global $database, $mosConfig_absolute_path, $mosConfig_live_site;

  $query = "SELECT shopper_group_id,shopper_group_name,#__vm_shopper_group.vendor_id,vendor_name"
         . "\n FROM #__vm_shopper_group, #__vm_vendor"
         . "\n WHERE #__vm_shopper_group.vendor_id = #__vm_vendor.vendor_id";
         $database->setQuery($query);
         $rows = $database->loadObjectList();

  $langdir = opendir($mosConfig_absolute_path.'/administrator/components/com_virtueupload/language');
  html_virtueupload::show_cfg($rows, $langdir);
}
/*==============================================================================
* Author    : Tobias Kuhn
* Function  : save_cfg
* Parameter : -
* Return    : -
==============================================================================*/
function save_cfg () {
  global $mosConfig_absolute_path;
  $maxsize = $_POST['CFG_maxsize']*1024;
  $path = $mosConfig_absolute_path."/administrator/components/com_virtueupload/admin.virtueupload.cfg.php";
  $cfg_array = array (
               "VU_CFG_LANGUAGE"        =>  $_POST['CFG_language'],
               "VU_CFG_UPLOADENABLED"   =>  $_POST['CFG_enableupload'],
               "VU_CFG_UPLOADROOT"      =>  $_POST['CFG_uploadroot'],
               "VU_CFG_COMMENTENABLED"  =>  $_POST['CFG_enablecomment'],
               "VU_CFG_ACCESSLEVEL"     =>  $_POST['CFG_accesslevel'],
               "VU_CFG_EXTENSIONS"      =>  $_POST['CFG_extensions'],
               "VU_CFG_MAXSIZE"         =>  $maxsize,
               "VU_CFG_ADMINMAIL"       =>  $_POST['CFG_adminmail'],
               "VU_CFG_RETRIEVEENABLED" =>  $_POST['CFG_enableretrieve'],
               "VU_CFG_BANUSER"         =>  $_POST['CFG_banuser'],
               "VU_CFG_FILERENAME"      =>  $_POST['CFG_filerename']
               );
  $cfg = "
  <?php
  /*
  package    : VirtueUpload
  version    : 1.0.0 STABLE
  author     : Tobias Kuhn - eaxs.de
  Homepage   : http://www.eaxs.de
  copyright  : Copyright (C) 2006 Tobias Kuhn - eaxs.de
  license    : http://www.gnu.org/copyleft/gpl.html
  */
  defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );\n\n\n";

  while (list($key, $value) = each($cfg_array)) {
    $cfg .= "define('".$key."', '".$value."');\n";
  }
  $cfg .= "?>";

  if ($fp = fopen($path, "w")) {
	fputs($fp, $cfg, strlen($cfg));
	fclose ($fp);
    mosRedirect("index2.php?option=com_virtueupload&task=show_cfg", VULANG_CFG_CFGSAVED);
  }
  else {
    mosRedirect("index2.php?option=com_virtueupload&task=show_cfg", VULANG_CFG_CFGERR);
  }
}
/*==============================================================================
* Author    : Tobias Kuhn
* Function  : retrieve_id
* Parameter : upload date, ip-address
* Return    : user name
==============================================================================*/
function retrieve_user($cdate, $ip) {
  global $database;

  $query = "SELECT cdate"
         . "\n FROM  #__vm_orders";
         $database->setQuery($query);
         $order_dates = $database->loadObjectList();

  for ($i=0, $n=count( $order_dates ); $i < $n; $i++) {
     $order_date = &$order_dates[$i];
     $diff       = $cdate - $order_date->cdate;
     $newcdate   = $cdate - $diff;

     $query = "SELECT user_id"
            . "\n FROM #__vm_orders"
            . "\n WHERE cdate = '$newcdate'"
            . "\n AND ip_address = '$ip'"
            . "\n ORDER BY user_id DESC LIMIT 1";
            $database->setQuery($query);
            $user_id = $database->loadResult();
  }
  $query = "SELECT last_name"
         . "\n FROM #__vm_user_info"
         . "\n WHERE user_id = '$user_id'";
         $database->setQuery($query);
         $user_name = $database->loadResult();

  return $user_name;
}
/*==============================================================================
* Author    : Tobias Kuhn
* Function  : show_banlist
* Parameter : -
* Return    : -
==============================================================================*/
function show_banlist() {
  global $database, $mosConfig_absolute_path, $mainframe, $mosConfig_list_limit;
  require_once( $GLOBALS['mosConfig_absolute_path'] . '/administrator/includes/pageNavigation.php' );
  $limit 		= $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', $mosConfig_list_limit );
  $limitstart 	= $mainframe->getUserStateFromRequest( "view{$option}limitstart", 'limitstart', 0 );

  $query = "SELECT COUNT(*)"
         . "\n FROM #__virtueuploads_ban";
         $database->setQuery( $query );
	     $total = $database->loadResult();

  $pageNav = new mosPageNav( $total, $limitstart, $limit );

  $query = "SELECT *"
         . "\n FROM #__virtueuploads_ban"
         . "\n ORDER BY ban_id DESC";
         $database->setQuery($query);
         $bans = $database->loadObjectList();

  html_virtueupload::show_banlist($bans, $pageNav);
}
/*==============================================================================
* Author    : Tobias Kuhn
* Function  : delete_file
* Parameter : selected ban entrys
* Return    : -
==============================================================================*/
function unban_user (&$cid) {
  global $database, $mosConfig_absolute_path;

  $total = count( $cid );
  $cids = implode( ',', $cid );

  if ( $total < 1) {
  echo "<script> alert('LANG_VMUPL_NOSELECT'); window.history.go(-1);</script>\n";
  exit;
  }
  $query = "SELECT *"
         . "\n FROM #__virtueuploads_ban"
         . "\n WHERE ban_id IN ( $cids )";
         $database->setQuery($query);
         $rows = $database->loadObjectList();

  for ($i=0, $n=count( $rows ); $i < $n; $i++) {
       $row  = &$rows[$i];
       $file = $mosConfig_absolute_path."/".$row->link."/".$row->file_name;
       @unlink($file);
  }
  $query = "DELETE FROM #__virtueuploads_ban"
	     . "\n WHERE ban_id IN ( $cids )";
	     $database->setQuery( $query );
         $database->query();

  $msg = $total . VULANG_BAN_UNBANSUCCESS;
  mosRedirect( 'index2.php?option=com_virtueupload&task=banlist', $msg);

}
?>

