<?php
/**
 * OpenSEF for Joomla!
 * @copyright (c) 2006 The OpenSEF Project (www.opensef.org)
 * @copyright (c) 2004-2005 Xaneon Development (www.xaneon.com)
 * @license GPL http://www.gnu.org/copyleft/gpl.html
 *
 *
 *
 */

/** Ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct access to this location is not allowed.' );

// Third-party developers can use the following flag to test whether
// OpenSEF is installed and activated.
if (defined( '_OPENSEF' )) return;
define( '_OPENSEF', 1 );
define( '_OPENSEF_VERSION', '2.0.0-RC4' );

// Check whether Extensions is enabled. The following is a very
// efficient way to check for this: we simply test that Extensions's
// SEF cache file exists and that it's of a non-zero size. If one of
// these conditions is not satisfied, Extensions is disabled.

$sefAdminPath = $mosConfig_absolute_path . '/administrator/components/com_sef';
$sefConfigFile = $sefAdminPath . '/cache.config.php';

$sefEnabled = (file_exists( $sefConfigFile ) && filesize( $sefConfigFile ) > 0);
if ($sefEnabled && $_SERVER['REQUEST_METHOD'] == 'POST' && !empty( $_POST['option'] ))
  	$sefEnabled = !($_POST['option'] == 'login' || 
  	$_POST['option'] == 'login' || 
  	$_POST['option'] == 'com_registration' ||
	$_POST['option'] == 'com_phpshop' ||
	$_POST['option'] == 'com_virtuemart' || 
	$_POST['option'] == 'com_comprofiler' || 
	$_POST['option'] == 'com_cbelogin' ||
	$_POST['option'] == 'com_cblogin' ||
	$_POST['option'] == 'com_cbloginrc2' ||
	$_POST['option'] == 'com_smf_registration' );  
  
if (defined( '_ADMIN_OFFLINE' )) {
	
	if (!empty( $mosConfig_sef )) {

    // Joomla!'s SEF option is enabled but Extensions is disabled; revert
    // to using Joomla!'s standard SEF URLs (e.g. /content/view/1/2/)
    require_once( $mosConfig_absolute_path . '/includes/sef.php' );

  }
  else {

    // Joomla!'s SEF option is turned off; revert to Joomla!'s original-style
    // URLs (e.g. index.php?option=content&task=view&id=1&Itemid=2)
    // We define a dummy sefRelToAbs that actually doesn't do anything.
    function sefRelToAbs( $string ) { return $string;  }

  }
  return;
	
}
if (!$sefEnabled) {

  // Check whether Search Engine Friendly URLs have been enabled in Joomla!'s
  // Global Configuration. This setting is found under the SEO tab.
  if (!empty( $mosConfig_sef )) {

    // Joomla!'s SEF option is enabled but Extensions is disabled; revert
    // to using Joomla!'s standard SEF URLs (e.g. /content/view/1/2/)
    require_once( $mosConfig_absolute_path . '/includes/sef.php' );

  }
  else {

    // Joomla!'s SEF option is turned off; revert to Joomla!'s original-style
    // URLs (e.g. index.php?option=content&task=view&id=1&Itemid=2)
    // We define a dummy sefRelToAbs that actually doesn't do anything.
    function sefRelToAbs( $string ) { return $string;  }

  }

  return; // Skip the rest of this file.
}

unset( $sefEnabled ); // Obviously, we're on.

// Joomla!'s SEF option and Extensions are both enabled; we're good to
// go! Include all necessary code for Extensions to handle incoming
// URL requests.

require_once( $sefAdminPath . '/sef.class.php' );

$sefConfig =& new mosSEFConfig( $database, false );
//$sefConfig->debug = '1';
if (!empty( $sefConfig->debug_for_ip )) {
  if ($sefConfig->debug_for_ip == $_SERVER['REMOTE_ADDR'])
    $sefConfig->debug = '1';
}

// Include any XE 3rd-party extensions. This interface is still
// experimental and subject to change, but this will allow an easy
// way of overriding most of XE's, and some of Joomla!'s, functionality.
if (!empty( $sefConfig->use_core_ext )) {
  $sefExtPath = $sefAdminPath . '/extensions';
  $sefExtPattern = '^core\\.[\\w\\d]+\\.php$';
  foreach (mosReadDirectory( $sefExtPath, $sefExtPattern  ) as $sefExtFile)
    @include_once( $sefExtPath . '/' . $sefExtFile );
  unset( $sefExtFile, $sefExtPath, $sefExtPattern );
}

// Load core functions *after* any core extensions in order to allow
// for 3PD to override pretty much all our functionality:
require_once( 'sef.functions.php' );

if (!empty( $sefConfig->use_multisite )) {
  $sefSite =& mosSEFSite::lookup(
    $_SERVER['HTTP_HOST'], $_SERVER['REQUEST_URI'] );
}

if (!isset( $sefSite )) {
  $sefSite =& mosSEFSite::getDefault();
  // For any undefined site aliases (wildcard DNS?), redirect browser
  // to the default site
  //if (!empty( $sefConfig->use_canonical_sites )) {
    /*if (strpos( $mosConfig_live_site, '://' . $_SERVER['HTTP_HOST'] ) === false) {
      die( 'Host=' . $_SERVER['HTTP_HOST'] );
      header();
    }*/
  //}
}

// Enforce site-wide security rules and policies.
if (!empty( $sefConfig->enable_security )) {
  define( '_OPENSEF_SECURITY', 1 );
  // TODO: security won't be implemented until beta3 or beta4.
  $sefSecurityHandler =& sefLoadSecurityHandler( $database, $sefConfig, $sefSite );
  unset( $sefClassName, $sefSecurity );
}

// Override Joomla! configuration globals from the site configuration
if (!empty( $sefConfig->use_multisite ) && !$sefSite->isDefault()) {
  include( 'configuration.php' );
  $sefSite->overrideGlobals();
}

// Display offline page and end processing if the site is offline
if (!empty( $mosConfig_offline )) {
  die( include( 'offline.php' ) );
}

if (!empty( $sefConfig->enable_sef ) || 1) {
  define( '_OPENSEF_ENABLED', 1 );

  $sefResolver =& sefLoadResolver( $database, $sefConfig, $sefSite );

  if (!empty( $sefConfig->use_automap )) {
    $sefAutoMapper =& sefLoadAutoMapper(
      $database, $sefConfig, $sefSite );
    $sefResolver->setAutoMapper( $sefAutoMapper );
  }

  // TODO: recursive handling per configuration directives.
  $sefURL = $_SERVER['REQUEST_URI'];
   
  if (1) {
    $sefResolver->resolve( $sefURL );
  }

  if (!empty( $sefConfig->debug )) {
    //@print_r( $_GET );
    foreach ($sefResolver->getLog() as $sefLog)
      @print_r( $sefLog . '<br />' );
    unset( $sefLog );
  }

  unset( $sefClassName, $sefResolver, $sefAutoMapper, $sefURL );

}

// If XE (com_sef) is called directly from the frontend (can't think of a
// reason why somebody would do this), let's show a short product blurb in
// place of the pathway. This is AFAIK pretty much the only thing we can do
// in the frontend since sef.php was require_once'd already at the beginning
// of Joomla!'s index.php and thus won't get a chance to be called again when
// mosMainBody() is invoked in the template. C'est la vie.
if (!empty( $option ) && $option == 'com_sef') {

  function sefHandleFrontendRequest( $s ) {
    $pattern = '#(<span class="pathway">).*(</span>)#';
    $text = 'SEF powered by OpenSEF ' . _OPENSEF_VERSION . ' for Joomla!';
    $link = 'http://www.open-sef.org/';
    $banner = '<a href="' . $link . '" target="_blank">' . $text . '</a>';
    return preg_replace( $pattern, '\\1' . $banner . '\\2', $s );
  }
  ob_start( 'sefHandleFrontendRequest' );
  return;

}

?>